/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5251;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.text.BookTextParser;
import vazkii.patchouli.client.book.text.TextLayouter;
import vazkii.patchouli.client.book.text.Word;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;

public class BookTextRenderer {
    private final Book book;
    private final List<Word> words;
    private final float scale;

    public BookTextRenderer(GuiBook gui, class_2561 text, int x, int y) {
        this(gui, text, x, y, 116, 9, gui.book.textColor);
    }

    public BookTextRenderer(GuiBook gui, class_2561 text, int x, int y, int width, int lineHeight, int baseColor) {
        this.book = gui.book;
        Object text1 = this.book.i18n && text instanceof class_2585 ? new class_2585(class_1074.method_4662((String)((class_2585)text).method_10993(), (Object[])new Object[0])) : text;
        class_2583 baseStyle = this.book.getFontStyle().method_27703(class_5251.method_27717((int)baseColor));
        BookTextParser parser = new BookTextParser(gui, this.book, x, y, width, lineHeight, baseStyle);
        PatchouliConfig.TextOverflowMode overflowMode = this.book.overflowMode;
        if (overflowMode == null) {
            overflowMode = PatchouliConfig.get().overflowMode().get();
        }
        TextLayouter layouter = new TextLayouter(gui, x, y, lineHeight, width, overflowMode);
        layouter.layout(class_310.method_1551().field_1772, parser.parse((class_2561)text1));
        this.scale = layouter.getScale();
        this.words = layouter.getWords();
    }

    private double rescale(double in, double origin) {
        return origin + (in - origin) / (double)this.scale;
    }

    public void render(class_4587 ms, int mouseX, int mouseY) {
        if (!this.words.isEmpty()) {
            class_327 font = class_310.method_1551().field_1772;
            class_2583 style = this.book.getFontStyle();
            Word first = this.words.get(0);
            ms.method_22903();
            ms.method_22904((double)first.x, (double)first.y, 0.0);
            ms.method_22905(this.scale, this.scale, 1.0f);
            ms.method_22904((double)(-first.x), (double)(-first.y), 0.0);
            int scaledX = (int)this.rescale(mouseX, first.x);
            int scaledY = (int)this.rescale(mouseY, first.y);
            this.words.forEach(word -> word.render(ms, font, style, scaledX, scaledY));
            ms.method_22909();
        }
    }

    public boolean click(double mouseX, double mouseY, int mouseButton) {
        if (!this.words.isEmpty()) {
            Word first = this.words.get(0);
            double scaledX = this.rescale(mouseX, first.x);
            double scaledY = this.rescale(mouseY, first.y);
            for (Word word : this.words) {
                if (!word.click(scaledX, scaledY, mouseButton)) continue;
                return true;
            }
        }
        return false;
    }
}

