/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.page;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Function;
import net.minecraft.class_1074;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_898;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.page.abstr.PageWithText;
import vazkii.patchouli.common.util.EntityUtil;

public class PageEntity
extends PageWithText {
    @SerializedName(value="entity")
    public String entityId;
    float scale = 1.0f;
    @SerializedName(value="offset")
    float extraOffset = 0.0f;
    String name;
    boolean rotate = true;
    @SerializedName(value="default_rotation")
    float defaultRotation = -45.0f;
    transient boolean errored;
    transient class_1297 entity;
    transient Function<class_1937, class_1297> creator;
    transient float renderScale;
    transient float offset;

    @Override
    public void build(BookEntry entry, BookContentsBuilder builder, int pageNum) {
        super.build(entry, builder, pageNum);
        this.creator = EntityUtil.loadEntity(this.entityId);
    }

    @Override
    public void onDisplayed(GuiBookEntry parent, int left, int top) {
        super.onDisplayed(parent, left, top);
        this.loadEntity((class_1937)parent.getMinecraft().field_1687);
    }

    @Override
    public int getTextHeight() {
        return 115;
    }

    @Override
    public void render(class_4587 ms, int mouseX, int mouseY, float pticks) {
        int x = 5;
        int y = 7;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiBook.drawFromTexture(ms, this.book, x, y, 405, 149, 106, 106);
        if (this.name == null || this.name.isEmpty()) {
            if (this.entity != null) {
                this.parent.drawCenteredStringNoShadow(ms, this.entity.method_5477().method_30937(), 58, 0, this.book.headerColor);
            }
        } else {
            this.parent.drawCenteredStringNoShadow(ms, this.name, 58, 0, this.book.headerColor);
        }
        if (this.errored) {
            this.fontRenderer.method_1720(ms, class_1074.method_4662((String)"patchouli.gui.lexicon.loading_error", (Object[])new Object[0]), 58.0f, 60.0f, 0xFF0000);
        }
        if (this.entity != null) {
            float rotation = this.rotate ? ClientTicker.total : this.defaultRotation;
            PageEntity.renderEntity(ms, this.entity, (class_1937)this.parent.getMinecraft().field_1687, 58.0f, 60.0f, rotation, this.renderScale, this.offset);
        }
        super.render(ms, mouseX, mouseY, pticks);
    }

    public static void renderEntity(class_4587 ms, class_1297 entity, class_1937 world, float x, float y, float rotation, float renderScale, float offset) {
        entity.field_6002 = world;
        ms.method_22903();
        ms.method_22904((double)x, (double)y, 50.0);
        ms.method_22905(renderScale, renderScale, renderScale);
        ms.method_22904(0.0, (double)offset, 0.0);
        ms.method_22907(class_1160.field_20707.method_23214(180.0f));
        ms.method_22907(class_1160.field_20705.method_23214(rotation));
        class_898 erd = class_310.method_1551().method_1561();
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        erd.method_3948(false);
        erd.method_3954(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, ms, (class_4597)immediate, 0xF000F0);
        erd.method_3948(true);
        immediate.method_22993();
        ms.method_22909();
    }

    private void loadEntity(class_1937 world) {
        if (!(this.errored || this.entity != null && this.entity.method_5805())) {
            try {
                this.entity = this.creator.apply(world);
                float width = this.entity.method_17681();
                float height = this.entity.method_17682();
                float entitySize = Math.max(1.0f, Math.max(width, height));
                this.renderScale = 100.0f / entitySize * 0.8f * this.scale;
                this.offset = Math.max(height, entitySize) * 0.5f + this.extraOffset;
            }
            catch (Exception e) {
                this.errored = true;
                PatchouliAPI.LOGGER.error("Failed to load entity", (Throwable)e);
            }
        }
    }
}

