/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.config.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.config.widgets.RowOfWidgets;
import dlovin.inventoryhud.config.widgets.TextField;
import dlovin.inventoryhud.config.widgets.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6382;

public class CustomOptionList
extends class_350 {
    private static final int ITEM_HEIGHT = 30;
    private final List<RowOfWidgets> rows = new ArrayList<RowOfWidgets>();
    private final class_437 parent;
    private int maxHeight;
    private int scroll = 0;
    private double tmp_scroll = 0.0;
    private boolean isDragging = false;
    private final class_2960 SCROLL = new class_2960("inventoryhud", "textures/gui/scroll.png");

    public CustomOptionList(class_310 minecraft, class_437 screen) {
        this(minecraft, screen, 55);
    }

    public CustomOptionList(class_310 minecraft, class_437 screen, int top) {
        super(minecraft, screen.field_22789, screen.field_22790, top, screen.field_22790, 30);
        this.parent = screen;
    }

    public void addWidget(Widget widget, int row) {
        if (this.maxHeight < (row + 1) * 30 + 10) {
            this.maxHeight = (row + 1) * 30 + 10;
        }
        widget.y = this.field_19085 + 10 + 30 * row + widget.y - this.scroll;
        if (this.rows.stream().anyMatch(r -> r.index == row)) {
            this.rows.stream().filter(r -> r.index == row).findFirst().get().addWidget(widget);
        } else {
            this.rows.add(new RowOfWidgets(row, widget));
        }
    }

    public void insertWidget(Widget widget, int row) {
        int lastRowIndex = 0;
        for (RowOfWidgets r2 : this.rows) {
            if (r2.index <= lastRowIndex) continue;
            lastRowIndex = r2.index;
        }
        this.maxHeight = (lastRowIndex + 2) * 30 + 10;
        widget.y = this.field_19085 + 10 + 30 * row + widget.y - this.scroll;
        this.rows.stream().filter(r -> r.index >= row).forEach(r -> {
            ++r.index;
            for (Widget w : r.widgetList) {
                w.y += 30;
            }
        });
        this.rows.add(new RowOfWidgets(row, widget));
    }

    public void removeRowWith(Widget widget) {
        int index = 0;
        for (RowOfWidgets row : this.rows) {
            if (!row.widgetList.contains((Object)widget)) continue;
            index = row.index;
            break;
        }
        this.removeRow(index);
    }

    public void removeRow(int index) {
        boolean removed = false;
        Iterator<RowOfWidgets> iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            RowOfWidgets item = iterator.next();
            if (item.index != index) continue;
            iterator.remove();
            removed = true;
            break;
        }
        if (!removed) {
            return;
        }
        for (RowOfWidgets row : this.rows) {
            if (row.index <= index) continue;
            --row.index;
            for (Widget w : row.widgetList) {
                w.y -= 30;
            }
        }
        this.maxHeight -= 30;
        int diff = this.maxHeight - (this.field_19086 - this.field_19085);
        if (diff < 0) {
            double tmp = this.scroll;
            this.scroll = 0;
            this.adjustWidgetsPos(tmp);
        } else {
            this.method_25401(0.0, 0.0, 0.0);
        }
    }

    public List<Widget> getWidgets() {
        ArrayList<Widget> tmp = new ArrayList<Widget>();
        for (RowOfWidgets row : this.rows) {
            tmp.addAll(row.widgetList);
        }
        return tmp;
    }

    public int rowsCount() {
        return this.rows.size();
    }

    private double scroll(double amount) {
        double tmp = (int)(amount * 5.0);
        int diff = this.maxHeight - (this.field_19086 - this.field_19085);
        this.scroll = (int)((double)this.scroll - tmp);
        if (this.scroll < 0) {
            tmp += (double)this.scroll;
            this.scroll = 0;
        } else if (this.scroll > diff) {
            tmp += (double)(this.scroll - diff);
            this.scroll = diff;
        }
        return tmp;
    }

    private void adjustWidgetsPos(double amount) {
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                if (w instanceof TextField && ((TextField)w).isFocused()) {
                    ((TextField)w).setFocused2(false);
                }
                w.y = (int)((double)w.y + amount);
            }
        }
    }

    public boolean method_25401(double p_231043_1_, double p_231043_3_, double scrollAmount) {
        if (this.maxHeight > this.field_19086 - this.field_19085) {
            this.adjustWidgetsPos(this.scroll(scrollAmount));
        }
        return true;
    }

    public boolean method_25403(double p_231045_1_, double p_231045_3_, int p_231045_5_, double p_231045_6_, double p_231045_8_) {
        if (this.isDragging) {
            int height = this.field_19086 - this.field_19085;
            double scale = (double)height / (double)this.maxHeight;
            this.tmp_scroll += p_231045_8_ / scale;
            int tmp = (int)this.tmp_scroll;
            this.tmp_scroll -= (double)tmp;
            int diff = this.maxHeight - (this.field_19086 - this.field_19085);
            this.scroll += tmp;
            if (this.scroll < 0) {
                tmp -= this.scroll;
                this.scroll = 0;
            } else if (this.scroll > diff) {
                tmp -= this.scroll - diff;
                this.scroll = diff;
            }
            this.adjustWidgetsPos(-tmp);
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseBtn) {
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        if (this.maxHeight > this.field_19086 - this.field_19085 && mouseBtn == 0) {
            int pos = this.field_22742 > 309 ? this.field_22742 / 2 + 150 : this.field_22742 - 9;
            int height = this.field_19086 - this.field_19085;
            double scale = (double)height / (double)this.maxHeight;
            int yPos = this.field_19085 + (int)((double)this.scroll * scale);
            if (this.isOver(mouseX, mouseY, pos + 1, pos + 8, yPos + 1, yPos + (height = (int)((double)height * scale)) - 1)) {
                this.isDragging = true;
            }
        }
        ArrayList<Runnable> clicks = new ArrayList<Runnable>();
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                if (!w.hovered && !(w instanceof TextField)) continue;
                clicks.add(() -> w.method_25402(mouseX, mouseY, mouseBtn));
            }
        }
        clicks.forEach(Runnable::run);
        return false;
    }

    public boolean method_25406(double p_231048_1_, double p_231048_3_, int p_231048_5_) {
        this.isDragging = false;
        return false;
    }

    public boolean method_25400(char character, int keyCode) {
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                if (!(w instanceof TextField) || !((TextField)w).isFocused()) continue;
                w.method_25400(character, keyCode);
                return true;
            }
        }
        return false;
    }

    public boolean method_25404(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                if (!(w instanceof TextField) || !((TextField)w).isFocused()) continue;
                w.method_25404(p_231046_1_, p_231046_2_, p_231046_3_);
                return true;
            }
        }
        super.method_25404(p_231046_1_, p_231046_2_, p_231046_3_);
        return false;
    }

    private void renderScrollBG(class_4587 mat, int xPos, int height) {
        CustomOptionList.method_25293((class_4587)mat, (int)xPos, (int)this.field_19085, (int)3, (int)3, (float)0.0f, (float)0.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.method_25293((class_4587)mat, (int)(xPos + 6), (int)this.field_19085, (int)3, (int)3, (float)13.0f, (float)0.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.method_25293((class_4587)mat, (int)xPos, (int)(this.field_19086 - 3), (int)3, (int)3, (float)0.0f, (float)13.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.method_25293((class_4587)mat, (int)(xPos + 6), (int)(this.field_19086 - 3), (int)3, (int)3, (float)13.0f, (float)13.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.method_25293((class_4587)mat, (int)(xPos + 3), (int)this.field_19085, (int)3, (int)3, (float)3.0f, (float)0.0f, (int)10, (int)3, (int)32, (int)32);
        CustomOptionList.method_25293((class_4587)mat, (int)(xPos + 6), (int)(this.field_19085 + 3), (int)3, (int)(height - 6), (float)13.0f, (float)3.0f, (int)3, (int)10, (int)32, (int)32);
        CustomOptionList.method_25293((class_4587)mat, (int)(xPos + 3), (int)(this.field_19086 - 3), (int)3, (int)3, (float)3.0f, (float)13.0f, (int)10, (int)3, (int)32, (int)32);
        CustomOptionList.method_25293((class_4587)mat, (int)xPos, (int)(this.field_19085 + 3), (int)3, (int)(height - 6), (float)0.0f, (float)3.0f, (int)3, (int)10, (int)32, (int)32);
        CustomOptionList.method_25293((class_4587)mat, (int)(xPos + 3), (int)(this.field_19085 + 3), (int)3, (int)(height - 6), (float)3.0f, (float)3.0f, (int)10, (int)10, (int)32, (int)32);
    }

    private void renderScroll(class_4587 mat, int xPos, int height, int pos) {
        CustomOptionList.method_25293((class_4587)mat, (int)xPos, (int)pos, (int)3, (int)3, (float)16.0f, (float)0.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.method_25293((class_4587)mat, (int)(xPos + 6), (int)pos, (int)3, (int)3, (float)29.0f, (float)0.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.method_25293((class_4587)mat, (int)xPos, (int)(-3 + height + pos), (int)3, (int)3, (float)16.0f, (float)13.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.method_25293((class_4587)mat, (int)(xPos + 6), (int)(-3 + height + pos), (int)3, (int)3, (float)29.0f, (float)13.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.method_25293((class_4587)mat, (int)(xPos + 3), (int)pos, (int)3, (int)3, (float)19.0f, (float)0.0f, (int)10, (int)3, (int)32, (int)32);
        CustomOptionList.method_25293((class_4587)mat, (int)(xPos + 6), (int)(3 + pos), (int)3, (int)Math.max(height - 6, 0), (float)29.0f, (float)3.0f, (int)3, (int)10, (int)32, (int)32);
        CustomOptionList.method_25293((class_4587)mat, (int)(xPos + 3), (int)(-3 + height + pos), (int)3, (int)3, (float)19.0f, (float)13.0f, (int)10, (int)3, (int)32, (int)32);
        CustomOptionList.method_25293((class_4587)mat, (int)xPos, (int)(3 + pos), (int)3, (int)Math.max(height - 6, 0), (float)16.0f, (float)3.0f, (int)3, (int)10, (int)32, (int)32);
        CustomOptionList.method_25293((class_4587)mat, (int)(xPos + 3), (int)(3 + pos), (int)3, (int)Math.max(height - 6, 0), (float)19.0f, (float)3.0f, (int)10, (int)10, (int)32, (int)32);
    }

    private boolean isOver(double p_231047_1_, double p_231047_3_, int min_x, int max_x, int min_y, int max_y) {
        return p_231047_3_ >= (double)min_y && p_231047_3_ <= (double)max_y && p_231047_1_ >= (double)min_x && p_231047_1_ <= (double)max_x;
    }

    protected void method_25311(class_4587 stack, int x, int y, int mouseX, int mouseY, float pTicks) {
        if (this.maxHeight > this.field_19086 - this.field_19085) {
            int pos = this.field_22742 > 309 ? this.field_22742 / 2 + 150 : this.field_22742 - 9;
            RenderSystem.setShaderTexture((int)0, (class_2960)this.SCROLL);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            int height = this.field_19086 - this.field_19085;
            this.renderScrollBG(stack, pos, height);
            double scale = (double)height / (double)this.maxHeight;
            height = (int)((double)height * scale);
            int yPos = this.field_19085 + (int)((double)this.scroll * scale);
            RenderSystem.setShaderColor((float)0.8f, (float)0.8f, (float)0.8f, (float)1.0f);
            if (this.isOver(mouseX, mouseY, pos + 1, pos + 8, yPos + 1, yPos + height - 1) && this.isDragging) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            this.renderScroll(stack, pos, height, yPos);
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                w.method_25394(stack, mouseX, mouseY, pTicks);
            }
        }
    }

    public void renderTooltips(class_4587 mat, int x, int y) {
        if (x < this.field_19088 || x > this.field_19087 || y < this.field_19085 || y > this.field_19086) {
            return;
        }
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                w.renderTooltip(mat, x, y);
            }
        }
    }

    public void method_37020(class_6382 builder) {
    }
}

