/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.gui.ArmorRenderer;
import dlovin.inventoryhud.gui.BlockArmorRenderer;
import dlovin.inventoryhud.gui.EachArmorRenderer;
import dlovin.inventoryhud.gui.HorizontalMiniPotionRenderer;
import dlovin.inventoryhud.gui.HorizontalPotionRenderer;
import dlovin.inventoryhud.gui.HotBarArmorRenderer;
import dlovin.inventoryhud.gui.PotionRenderer;
import dlovin.inventoryhud.gui.TrinketRenderer;
import dlovin.inventoryhud.gui.VerticalMiniPotionRenderer;
import dlovin.inventoryhud.gui.VerticalPotionRenderer;
import dlovin.inventoryhud.utils.EachItem;
import dlovin.inventoryhud.utils.TrinketSlot;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.class_1041;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_757;
import net.minecraft.class_918;

public class InventoryHUDGui {
    private final class_310 mc = class_310.method_1551();
    private final class_918 ir = this.mc.method_1480();
    private final class_327 tr;
    private static final class_2960 INVBG = new class_2960("inventoryhud", "textures/gui/inv_bg.png");
    public WidgetAligns InvAligns;
    public int invX;
    public int invY;
    public boolean invMini;
    public boolean invVert;
    public float invAlpha;
    public boolean invHideBG;
    public boolean invAnimated;
    public boolean withDebug;
    public ArmorRenderer armorRenderer;
    public PotionRenderer potionRenderer;
    public TrinketRenderer trinketRenderer;

    public InventoryHUDGui() {
        this.tr = this.mc.field_1772;
        this.initializeConfigValues();
        WidgetAligns ArmAligns = new WidgetAligns(InventoryHUD.getConfig().getArmHal(), InventoryHUD.getConfig().getArmVal());
        int armX = InventoryHUD.getConfig().getArmX();
        int armY = InventoryHUD.getConfig().getArmY();
        this.armorRenderer = !InventoryHUD.getConfig().getMoveAll() ? new EachArmorRenderer(this.mc) : (ArmAligns.HorAlign == WidgetAligns.HAlign.MIDDLE && ArmAligns.VertAlign == WidgetAligns.VAlign.BOTTOM && armY <= 90 && Math.abs(armX) <= 90 ? new HotBarArmorRenderer(this.mc) : new BlockArmorRenderer(this.mc));
        if (InventoryHUD.isTrinketMod) {
            this.trinketRenderer = new TrinketRenderer(this.mc);
        }
        this.setupArmorRenderer();
        this.potionRenderer = InventoryHUD.getConfig().isPotHor() ? (InventoryHUD.getConfig().getPotMini() ? new HorizontalMiniPotionRenderer(this.mc) : new HorizontalPotionRenderer(this.mc)) : (InventoryHUD.getConfig().getPotMini() ? new VerticalMiniPotionRenderer(this.mc) : new VerticalPotionRenderer(this.mc));
        this.setupPotionRenderer();
        System.out.println("InvGUI Initialized");
    }

    private void initializeConfigValues() {
        this.invX = InventoryHUD.getConfig().getInvX();
        this.invY = InventoryHUD.getConfig().getInvY();
        this.InvAligns = new WidgetAligns(InventoryHUD.getConfig().getInvHal(), InventoryHUD.getConfig().getInvVal());
        this.invMini = InventoryHUD.getConfig().getInvMini();
        this.invVert = InventoryHUD.getConfig().getInvVert();
        this.invAlpha = (float)InventoryHUD.getConfig().getInvAlpha() / 100.0f;
        this.invHideBG = InventoryHUD.getConfig().isInvHideBG();
        this.invAnimated = InventoryHUD.getConfig().isInvAnimated();
        this.withDebug = InventoryHUD.getConfig().isInvWithDebug();
    }

    private void setupArmorRenderer() {
        this.armorRenderer.armX = InventoryHUD.getConfig().getArmX();
        this.armorRenderer.armY = InventoryHUD.getConfig().getArmY();
        this.armorRenderer.ArmAligns = new WidgetAligns(InventoryHUD.getConfig().getArmHal(), InventoryHUD.getConfig().getArmVal());
        this.armorRenderer.armAbove = InventoryHUD.getConfig().getArmAbove();
        this.armorRenderer.armScale = (float)InventoryHUD.getConfig().getArmScale() * 0.01f;
        this.armorRenderer.showArmor = InventoryHUD.getConfig().isShowArmor();
        this.armorRenderer.showMain = InventoryHUD.getConfig().isShowMain();
        this.armorRenderer.showOff = InventoryHUD.getConfig().isShowOff();
        this.armorRenderer.showArrows = InventoryHUD.getConfig().isShowArrows();
        this.armorRenderer.showInv = InventoryHUD.getConfig().isShowInv();
        this.armorRenderer.showEmpty = InventoryHUD.getConfig().isShowEmpty();
        this.armorRenderer.showCount = InventoryHUD.getConfig().isShowCount();
        this.armorRenderer.armView = InventoryHUD.getConfig().getArmView();
        this.armorRenderer.armBars = InventoryHUD.getConfig().getArmBars();
        this.armorRenderer.withDebug = InventoryHUD.getConfig().isArmWithDebug();
        this.armorRenderer.showArrowsWithoutWeapon = InventoryHUD.getConfig().isShowArrowsWithoutWeapon();
        if (InventoryHUD.isTrinketMod) {
            this.trinketRenderer.armAbove = InventoryHUD.getConfig().getArmAbove();
            this.trinketRenderer.armScale = (float)InventoryHUD.getConfig().getArmScale() * 0.01f;
            this.trinketRenderer.showEmpty = InventoryHUD.getConfig().isShowEmpty();
            this.trinketRenderer.showCount = InventoryHUD.getConfig().isShowCount();
            this.trinketRenderer.armView = InventoryHUD.getConfig().getArmView();
            this.trinketRenderer.armBars = InventoryHUD.getConfig().getArmBars();
        }
        this.armorRenderer.items[0] = new EachItem(InventoryHUD.getConfig().getHelmX(), InventoryHUD.getConfig().getHelmY(), new WidgetAligns(InventoryHUD.getConfig().getHelmHal(), InventoryHUD.getConfig().getHelmVal()));
        this.armorRenderer.items[1] = new EachItem(InventoryHUD.getConfig().getChestX(), InventoryHUD.getConfig().getChestY(), new WidgetAligns(InventoryHUD.getConfig().getChestHal(), InventoryHUD.getConfig().getChestVal()));
        this.armorRenderer.items[2] = new EachItem(InventoryHUD.getConfig().getLegX(), InventoryHUD.getConfig().getLegY(), new WidgetAligns(InventoryHUD.getConfig().getLegHal(), InventoryHUD.getConfig().getLegVal()));
        this.armorRenderer.items[3] = new EachItem(InventoryHUD.getConfig().getBootsX(), InventoryHUD.getConfig().getBootsY(), new WidgetAligns(InventoryHUD.getConfig().getBootsHal(), InventoryHUD.getConfig().getBootsVal()));
        this.armorRenderer.items[4] = new EachItem(InventoryHUD.getConfig().getOffX(), InventoryHUD.getConfig().getOffY(), new WidgetAligns(InventoryHUD.getConfig().getOffHal(), InventoryHUD.getConfig().getOffVal()));
        this.armorRenderer.items[5] = new EachItem(InventoryHUD.getConfig().getMainX(), InventoryHUD.getConfig().getMainY(), new WidgetAligns(InventoryHUD.getConfig().getMainHal(), InventoryHUD.getConfig().getMainVal()));
        this.armorRenderer.items[6] = new EachItem(InventoryHUD.getConfig().getInvIconX(), InventoryHUD.getConfig().getInvIconY(), new WidgetAligns(InventoryHUD.getConfig().getInvIconHal(), InventoryHUD.getConfig().getInvIconVal()));
        this.armorRenderer.items[7] = new EachItem(InventoryHUD.getConfig().getArrX(), InventoryHUD.getConfig().getArrY(), new WidgetAligns(InventoryHUD.getConfig().getArrHal(), InventoryHUD.getConfig().getArrVal()));
        this.changeArmorOffset();
    }

    private void setupPotionRenderer() {
        this.potionRenderer.potX = InventoryHUD.getConfig().getPotX();
        this.potionRenderer.potY = InventoryHUD.getConfig().getPotY();
        this.potionRenderer.PotAligns = new WidgetAligns(InventoryHUD.getConfig().getPotHal(), InventoryHUD.getConfig().getPotVal());
        this.potionRenderer.potMini = InventoryHUD.getConfig().getPotMini();
        this.potionRenderer.potGap = InventoryHUD.getConfig().getPotGap();
        this.potionRenderer.barDuration = InventoryHUD.getConfig().getBarDuration() * 20;
        this.potionRenderer.PotPosChanged();
        switch (this.potionRenderer.PotAligns.VertAlign) {
            case TOP: {
                this.potionRenderer.potVert = 1;
                break;
            }
            case CENTER: {
                if (this.potionRenderer.potY - 12 < this.mc.method_22683().method_4502() / 2) {
                    this.potionRenderer.potVert = -1;
                    break;
                }
                this.potionRenderer.potVert = 1;
                break;
            }
            case BOTTOM: {
                this.potionRenderer.potVert = -1;
            }
        }
        this.potionRenderer.potAlpha = (float)InventoryHUD.getConfig().getPotAlpha() / 100.0f;
        this.potionRenderer.showHidden = InventoryHUD.getConfig().isShowHiddenEffects();
        this.potionRenderer.potionLevels = InventoryHUD.getConfig().isPotionLevels();
        this.potionRenderer.withDebug = InventoryHUD.getConfig().isPotWithDebug();
    }

    public void render(float tickDelta) {
        class_1041 mainWindow = this.mc.method_22683();
        int width = mainWindow.method_4486();
        int height = mainWindow.method_4502();
        if (InventoryHUD.PotHUD && (!this.mc.field_1690.field_1866 || this.potionRenderer.withDebug)) {
            RenderSystem.setShader(class_757::method_34542);
            this.potionRenderer.render(new class_4587(), width, height);
        }
        if (InventoryHUD.ArmHUD && (!this.mc.field_1690.field_1866 || this.armorRenderer.withDebug)) {
            RenderSystem.setShader(class_757::method_34542);
            this.armorRenderer.render(new class_4587(), width, height);
            if (InventoryHUD.isTrinketMod && this.hasTrinkets()) {
                this.trinketRenderer.render(new class_4587(), width, height);
            }
        }
        if (this.mc.field_1755 instanceof class_465) {
            return;
        }
        if (InventoryHUD.InvHUD && (!this.mc.field_1690.field_1866 || this.withDebug)) {
            RenderSystem.setShader(class_757::method_34542);
            this.renderInventory(new class_4587(), width, height, tickDelta);
        }
    }

    private void renderInventory(class_4587 mat, int width, int height, float partialTicks) {
        int iMax = this.invVert ? 3 : 9;
        int jMax = this.invVert ? 9 : 3;
        float scale = this.invMini ? 0.75f : 1.0f;
        int px = this.getX(width, (int)((float)(iMax * 18 - 2) * scale), this.invX, this.InvAligns.HorAlign);
        int py = this.getY(height, (int)((float)(jMax * 18 - 2) * scale), this.invY, this.InvAligns.VertAlign);
        ArrayList<Runnable> items = new ArrayList<Runnable>();
        for (int i = 0; i < iMax; ++i) {
            for (int j = 0; j < jMax; ++j) {
                int index = this.invVert ? (3 - i) * 9 + j : i + (j + 1) * 9;
                class_1799 item = (class_1799)this.mc.field_1724.method_31548().field_7547.get(index);
                class_4587 matr = RenderSystem.getModelViewStack();
                if (item.method_7960()) continue;
                int finalI = i;
                int finalJ = j;
                items.add(() -> {
                    float f = (float)item.method_7965() - partialTicks;
                    matr.method_22903();
                    matr.method_22904((double)px, (double)py, -201.0);
                    matr.method_22905(scale, scale, 1.0f);
                    if (this.invAnimated && f > 0.0f) {
                        matr.method_22903();
                        float f1 = 1.0f + f / 5.0f;
                        matr.method_22904((double)(finalI * 18 + 12), (double)(finalJ * 18 + 12), 0.0);
                        matr.method_22905((f1 + 1.0f) / 2.0f, (f1 + 1.0f) / 2.0f, 1.0f);
                        matr.method_22904((double)(-(finalI * 18 + 12)), (double)(-(finalJ * 18 + 12)), 0.0);
                    }
                    RenderSystem.applyModelViewMatrix();
                    this.ir.method_4023(item, finalI * 18, finalJ * 18);
                    if (this.invAnimated && f > 0.0f) {
                        matr.method_22909();
                    }
                    this.ir.method_4022(this.tr, item, finalI * 18, finalJ * 18, null);
                    matr.method_22909();
                    RenderSystem.applyModelViewMatrix();
                });
            }
        }
        if (!items.isEmpty() || !this.invHideBG && this.invAlpha > 0.0f) {
            mat.method_22903();
            mat.method_22904((double)px, (double)py, -255.0);
            mat.method_22905(scale, scale, 1.0f);
            if (this.invAlpha > 0.0f) {
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.invAlpha);
                RenderSystem.setShaderTexture((int)0, (class_2960)INVBG);
                class_332.method_25293((class_4587)mat, (int)-8, (int)-8, (int)(iMax * 18 + 14), (int)(jMax * 18 + 14), (float)0.0f, (float)(jMax == 3 ? 0.0f : 68.0f), (int)(iMax * 18 + 14), (int)(jMax * 18 + 14), (int)256, (int)256);
                RenderSystem.disableBlend();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            items.forEach(Runnable::run);
            mat.method_22909();
        }
    }

    private int getX(int width, int itemWidth, int x, WidgetAligns.HAlign hal) {
        int result;
        switch (hal) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case LEFT: {
                int n = x;
                break;
            }
            case MIDDLE: {
                int n = width / 2 - itemWidth / 2 - x;
                break;
            }
            case RIGHT: {
                int n = result = width - x;
            }
        }
        if (result < 0) {
            result = 0;
        } else if (result > width - itemWidth) {
            result = width - itemWidth;
        }
        return result;
    }

    private int getY(int height, int itemHeight, int y, WidgetAligns.VAlign val) {
        int result;
        switch (val) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case TOP: {
                int n = y;
                break;
            }
            case CENTER: {
                int n = height / 2 - itemHeight / 2 - y;
                break;
            }
            case BOTTOM: {
                int n = result = height - y;
            }
        }
        if (result < 0) {
            result = 0;
        } else if (result > height - itemHeight) {
            result = height - itemHeight;
        }
        return result;
    }

    public void changeArmorOffset() {
        if (this.armorRenderer instanceof BlockArmorRenderer) {
            ((BlockArmorRenderer)this.armorRenderer).changeOffset();
        }
    }

    public void changeMoveAll(Boolean bd) {
        WidgetAligns ArmAligns = new WidgetAligns(InventoryHUD.getConfig().getArmHal(), InventoryHUD.getConfig().getArmVal());
        int armX = InventoryHUD.getConfig().getArmX();
        int armY = InventoryHUD.getConfig().getArmY();
        this.armorRenderer = bd == false ? new EachArmorRenderer(this.mc) : (ArmAligns.HorAlign == WidgetAligns.HAlign.MIDDLE && ArmAligns.VertAlign == WidgetAligns.VAlign.BOTTOM && armY <= 90 && Math.abs(armX) <= 90 ? new HotBarArmorRenderer(this.mc) : new BlockArmorRenderer(this.mc));
        this.setupArmorRenderer();
    }

    public void changeArmorPos(WidgetAligns armal, int ax, int ay) {
        if (armal.HorAlign == WidgetAligns.HAlign.MIDDLE && armal.VertAlign == WidgetAligns.VAlign.BOTTOM && (float)ay <= 70.0f * this.armorRenderer.armScale + 5.0f && Math.abs(ax) <= 90) {
            if (!(this.armorRenderer instanceof HotBarArmorRenderer)) {
                this.armorRenderer = new HotBarArmorRenderer(this.mc);
                this.setupArmorRenderer();
            }
        } else if (this.armorRenderer instanceof HotBarArmorRenderer) {
            this.armorRenderer = new BlockArmorRenderer(this.mc);
            this.setupArmorRenderer();
        }
        this.armorRenderer.ArmAligns = armal;
        this.armorRenderer.armY = ay;
        this.armorRenderer.armX = ax;
        if (this.armorRenderer instanceof BlockArmorRenderer) {
            ((BlockArmorRenderer)this.armorRenderer).changeOffset();
        }
    }

    public void changePotionMini(boolean mini) {
        this.changePotion(mini, InventoryHUD.getConfig().isPotHor());
        this.setupPotionRenderer();
    }

    public void changePotionHor(boolean hor) {
        this.changePotion(InventoryHUD.getConfig().getPotMini(), hor);
    }

    private void changePotion(boolean mini, boolean hor) {
        this.potionRenderer = hor ? (mini ? new HorizontalMiniPotionRenderer(this.mc) : new HorizontalPotionRenderer(this.mc)) : (mini ? new VerticalMiniPotionRenderer(this.mc) : new VerticalPotionRenderer(this.mc));
        this.setupPotionRenderer();
    }

    public void resetBlackList() {
        this.potionRenderer.resetBlacklist();
    }

    public void disableTrinkets() {
        this.trinketRenderer.slots = null;
    }

    public HashMap<String, TrinketSlot> getTrinkets() {
        return this.trinketRenderer.slots();
    }

    public boolean hasTrinkets() {
        return !this.trinketRenderer.isEmpty();
    }
}

