/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.registry;

import java.util.function.Supplier;
import net.darkhax.bookshelf.api.ClientServices;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.block.IBindRenderLayer;
import net.darkhax.bookshelf.api.block.IItemBlockProvider;
import net.darkhax.bookshelf.api.commands.ICommandBuilder;
import net.darkhax.bookshelf.api.data.recipes.IRecipeSerializer;
import net.darkhax.bookshelf.api.registry.ClassRegistryEntries;
import net.darkhax.bookshelf.api.registry.IOwnedRegistryEntries;
import net.darkhax.bookshelf.api.registry.RecipeTypeEntries;
import net.darkhax.bookshelf.api.registry.RegistryEntries;
import net.darkhax.bookshelf.api.registry.VillagerTradeEntries;
import net.darkhax.bookshelf.mixin.item.AccessorItem;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1535;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3302;
import net.minecraft.class_3414;
import net.minecraft.class_3448;
import net.minecraft.class_3611;
import net.minecraft.class_3852;
import net.minecraft.class_3917;

public class RegistryDataProvider {
    private final String ownerId;
    public final IOwnedRegistryEntries<class_2248> blocks = new RegistryEntries<class_2248>(this::getOwner, class_2378.field_25105);
    public final IOwnedRegistryEntries<class_3611> fluids = new RegistryEntries<class_3611>(this::getOwner, class_2378.field_25103);
    public final IOwnedRegistryEntries<class_1792> items = new RegistryEntries<class_1792>(this::getOwner, class_2378.field_25108);
    public final IOwnedRegistryEntries<class_1291> mobEffects = new RegistryEntries<class_1291>(this::getOwner, class_2378.field_25104);
    public final IOwnedRegistryEntries<class_3414> sounds = new RegistryEntries<class_3414>(this::getOwner, class_2378.field_25102);
    public final IOwnedRegistryEntries<class_1842> potions = new RegistryEntries<class_1842>(this::getOwner, class_2378.field_25109);
    public final IOwnedRegistryEntries<class_1887> enchantments = new RegistryEntries<class_1887>(this::getOwner, class_2378.field_25106);
    public final IOwnedRegistryEntries<class_1299<?>> entities = new RegistryEntries(this::getOwner, class_2378.field_25107);
    public final IOwnedRegistryEntries<class_2591<?>> blockEntities = new RegistryEntries(this::getOwner, class_2378.field_25073);
    public final IOwnedRegistryEntries<class_2396<?>> particleTypes = new RegistryEntries(this::getOwner, class_2378.field_25070);
    public final IOwnedRegistryEntries<class_3917<?>> menus = new RegistryEntries(this::getOwner, class_2378.field_25083);
    public final IOwnedRegistryEntries<IRecipeSerializer<?>> recipeSerializers = new RegistryEntries(this::getOwner, class_2378.field_25085);
    public final IOwnedRegistryEntries<class_1535> paintings = new RegistryEntries<class_1535>(this::getOwner, class_2378.field_25074);
    public final IOwnedRegistryEntries<class_1320> attributes = new RegistryEntries<class_1320>(this::getOwner, class_2378.field_25086);
    public final IOwnedRegistryEntries<class_3448<?>> stats = new RegistryEntries(this::getOwner, class_2378.field_25087);
    public final IOwnedRegistryEntries<class_3852> villagerProfessions = new RegistryEntries<class_3852>(this::getOwner, class_2378.field_25089);
    @Deprecated
    public final IOwnedRegistryEntries<class_3917<?>> menuTypes = this.menus;
    public final RecipeTypeEntries recipeTypes = new RecipeTypeEntries(this::getOwner);
    public final ClassRegistryEntries<class_2314> commandArguments = new ClassRegistryEntries(this::getOwner, "Command Argument");
    public final IOwnedRegistryEntries<ICommandBuilder> commands = new RegistryEntries<ICommandBuilder>(this::getOwner, "Command");
    public final VillagerTradeEntries trades = new VillagerTradeEntries();
    public final IOwnedRegistryEntries<class_3302> resourceListeners = new RegistryEntries<class_3302>(this::getOwner, "Resource Listener");
    public final IOwnedRegistryEntries<class_3302> dataListeners = new RegistryEntries<class_3302>(this::getOwner, "Data Listener");

    public RegistryDataProvider(String ownerId) {
        this.ownerId = ownerId;
    }

    public final RegistryDataProvider withCreativeTab(Supplier<? extends class_1935> iconProvider) {
        return this.withCreativeTab(iconProvider, "creative_tab");
    }

    public final RegistryDataProvider withCreativeTab(Supplier<? extends class_1935> iconProvider, String id) {
        return this.withCreativeTab(Services.CONSTRUCTS.creativeTab(this.ownerId, id).setIcon(iconProvider).build());
    }

    public final RegistryDataProvider withCreativeTab(class_1761 tab) {
        this.items.addRegistryListener((id, item) -> {
            if (item instanceof AccessorItem) {
                AccessorItem accessor = (AccessorItem)item;
                accessor.bookshelf$setCreativeTab(tab);
            }
        });
        return this;
    }

    public final RegistryDataProvider bindBlockRenderLayers() {
        if (Services.PLATFORM.isPhysicalClient()) {
            this.blocks.addRegistryListener((id, block) -> {
                if (block instanceof IBindRenderLayer) {
                    IBindRenderLayer binder = (IBindRenderLayer)block;
                    ClientServices.CLIENT.setRenderType((class_2248)block, binder.getRenderLayerToBind());
                }
            });
        }
        return this;
    }

    public final RegistryDataProvider withAutoItemBlocks() {
        this.blocks.addInsertListener((id, block) -> this.items.add(() -> {
            if (block instanceof IItemBlockProvider) {
                IItemBlockProvider provider = (IItemBlockProvider)((Object)block);
                return provider.createItemBlock((class_2248)block.get());
            }
            return IItemBlockProvider.DEFAULT.createItemBlock((class_2248)block.get());
        }, (class_2960)id));
        return this;
    }

    public String getOwner() {
        return this.ownerId;
    }
}

