/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.data.recipes.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.data.recipes.IRecipeSerializer;
import net.minecraft.class_1263;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class ShapelessDurabilityRecipe
extends class_1867 {
    public static final Serializer SERIALIZER = new Serializer();
    private final int damageAmount;

    public ShapelessDurabilityRecipe(class_2960 recipeId, String group, class_1799 result, class_2371<class_1856> ingredients, int damageAmount) {
        super(recipeId, group, result, ingredients);
        this.damageAmount = damageAmount;
    }

    public class_2371<class_1799> getRemainingItems(class_1715 inv) {
        class_2371 keptItems = super.method_8111((class_1263)inv);
        return Services.INVENTORY_HELPER.keepDamageableItems(inv, (class_2371<class_1799>)keptItems, this.damageAmount);
    }

    public class_1865<?> method_8119() {
        return SERIALIZER.getWrapper();
    }

    public static class Serializer
    extends IRecipeSerializer<ShapelessDurabilityRecipe> {
        @Override
        public ShapelessDurabilityRecipe fromJson(class_2960 recipeId, JsonObject json) {
            String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            class_2371<class_1856> inputs = Serializer.readIngredients(class_3518.method_15261((JsonObject)json, (String)"ingredients"));
            class_1799 output = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"));
            int damageAmount = class_3518.method_15282((JsonObject)json, (String)"damageAmount", (int)1);
            if (inputs.isEmpty()) {
                throw new JsonSyntaxException("No ingredients were found for the recipe!");
            }
            if (inputs.size() > 9) {
                throw new JsonSyntaxException("Too many ingredients. Maximum is 9 but " + inputs.size() + " were given.");
            }
            if (output.method_7960()) {
                throw new JsonSyntaxException("The output of the recipe must not be empty!");
            }
            return new ShapelessDurabilityRecipe(recipeId, group, output, inputs, damageAmount);
        }

        @Override
        public ShapelessDurabilityRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            String group = buffer.method_10800(Short.MAX_VALUE);
            int inputCount = buffer.method_10816();
            class_2371 inputs = class_2371.method_10213((int)inputCount, (Object)class_1856.field_9017);
            for (int i = 0; i < inputCount; ++i) {
                inputs.set(i, (Object)class_1856.method_8086((class_2540)buffer));
            }
            class_1799 output = buffer.method_10819();
            int damageAmount = buffer.method_10816();
            return new ShapelessDurabilityRecipe(recipeId, group, output, (class_2371<class_1856>)inputs, damageAmount);
        }

        @Override
        public void toNetwork(class_2540 buffer, ShapelessDurabilityRecipe toWrite) {
            buffer.method_10814(toWrite.method_8112());
            buffer.method_10804(toWrite.method_8117().size());
            for (class_1856 ingredient : toWrite.method_8117()) {
                ingredient.method_8088(buffer);
            }
            buffer.method_10793(toWrite.method_8110());
            buffer.method_10804(toWrite.damageAmount);
        }

        private static class_2371<class_1856> readIngredients(JsonArray json) {
            class_2371 ingredients = class_2371.method_10211();
            for (JsonElement element : json) {
                class_1856 ingredient = class_1856.method_8102((JsonElement)element);
                if (ingredient.method_8103()) continue;
                ingredients.add((Object)ingredient);
            }
            return ingredients;
        }
    }
}

