/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcda.config;

import chronosacaria.mcda.items.ArmorSets;
import chronosacaria.mcda.items.itemhelpers.ItemSettingsHelper;
import chronosacaria.mcda.items.itemhelpers.SpawnHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="mcda_loot_tables")
public class McdaLootTablesConfig
implements ConfigData {
    @Comment(value="Choose whether to use tiered loot system. Default = false")
    public LinkedHashMap<ItemSettingsHelper, Boolean> enableTieredLootTables = new LinkedHashMap();
    @Comment(value="Default, non-tiered armour spawn rates.")
    public EnumMap<SpawnHelper, Float> armorSpawnRates = new EnumMap(SpawnHelper.class);
    @Comment(value="Chests for tiered spawning.")
    public LinkedHashMap<ItemSettingsHelper, ArrayList<String>> commonLootTables = new LinkedHashMap();
    public LinkedHashMap<ItemSettingsHelper, ArrayList<String>> uncommonLootTables = new LinkedHashMap();
    public LinkedHashMap<ItemSettingsHelper, ArrayList<String>> rareLootTables = new LinkedHashMap();
    public LinkedHashMap<ItemSettingsHelper, ArrayList<String>> epicLootTables = new LinkedHashMap();
    @Comment(value="Tiered armour spawn rates.")
    public LinkedHashMap<ArmorSets, Float> armorLootTableSpawnRates = new LinkedHashMap();

    public McdaLootTablesConfig() {
        this.armorSpawnRates.put(SpawnHelper.GHOSTLY, Float.valueOf(0.05f));
        this.armorSpawnRates.put(SpawnHelper.GHOST_KINDLER, Float.valueOf(0.01f));
        this.armorSpawnRates.put(SpawnHelper.GRIM, Float.valueOf(0.05f));
        this.armorSpawnRates.put(SpawnHelper.DARK, Float.valueOf(0.1f));
        this.armorSpawnRates.put(SpawnHelper.ROYAL, Float.valueOf(0.05f));
        this.armorSpawnRates.put(SpawnHelper.TITAN, Float.valueOf(0.025f));
        this.armorSpawnRates.put(SpawnHelper.THIEF, Float.valueOf(0.1f));
        this.armorSpawnRates.put(SpawnHelper.PLATE, Float.valueOf(0.05f));
        this.armorSpawnRates.put(SpawnHelper.FULL_METAL, Float.valueOf(0.01f));
        this.armorSpawnRates.put(SpawnHelper.SNOW, Float.valueOf(0.03f));
        this.armorSpawnRates.put(SpawnHelper.WOLF, Float.valueOf(0.05f));
        this.armorSpawnRates.put(SpawnHelper.FOX, Float.valueOf(0.01f));
        this.armorSpawnRates.put(SpawnHelper.REINFORCED, Float.valueOf(0.05f));
        this.armorSpawnRates.put(SpawnHelper.STALWART, Float.valueOf(0.01f));
        this.armorSpawnRates.put(SpawnHelper.SCALE, Float.valueOf(0.05f));
        this.armorSpawnRates.put(SpawnHelper.MERCENARY, Float.valueOf(0.05f));
        this.armorSpawnRates.put(SpawnHelper.SPELUNKER, Float.valueOf(0.05f));
        this.armorSpawnRates.put(SpawnHelper.CAVE_CRAWLER, Float.valueOf(0.01f));
        this.armorSpawnRates.put(SpawnHelper.HERO, Float.valueOf(0.1f));
        this.armorSpawnRates.put(SpawnHelper.GILDED, Float.valueOf(0.1f));
        this.armorSpawnRates.put(SpawnHelper.TELEPORTATION, Float.valueOf(0.1f));
        this.armorSpawnRates.put(SpawnHelper.UNSTABLE, Float.valueOf(0.01f));
        this.armorSpawnRates.put(SpawnHelper.MYSTERY, Float.valueOf(0.05f));
        this.armorSpawnRates.put(SpawnHelper.VANGUARD, Float.valueOf(0.05f));
        for (ItemSettingsHelper itemSettingsHelper : ItemSettingsHelper.values()) {
            this.enableTieredLootTables.put(ItemSettingsHelper.ENABLE_TIERED_LOOT_TABLES, false);
        }
        for (ItemSettingsHelper itemSettingsHelper : ItemSettingsHelper.values()) {
            this.commonLootTables.put(ItemSettingsHelper.COMMON_LOOT_TABLES, Lists.newArrayList((Object[])new String[]{"minecraft:chests/abandoned_mineshaft", "minecraft:chests/shipwreck_supply", "minecraft:chests/shipwreck_treasure", "minecraft:chests/desert_pyramid", "minecraft:chests/village/village_weaponsmith"}));
        }
        for (ItemSettingsHelper itemSettingsHelper : ItemSettingsHelper.values()) {
            this.uncommonLootTables.put(ItemSettingsHelper.UNCOMMON_LOOT_TABLES, Lists.newArrayList((Object[])new String[]{"minecraft:chests/jungle_temple", "minecraft:chests/nether_bridge", "minecraft:chests/bastion_bridge", "minecraft:chests/bastion_other", "minecraft:chests/bastion_treasure", "minecraft:chests/ruined_portal"}));
        }
        for (ItemSettingsHelper itemSettingsHelper : ItemSettingsHelper.values()) {
            this.rareLootTables.put(ItemSettingsHelper.RARE_LOOT_TABLES, Lists.newArrayList((Object[])new String[]{"minecraft:chests/underwater_ruin_small", "minecraft:chests/underwater_ruin_big", "minecraft:chests/simple_dungeon", "minecraft:chests/igloo_chest", "minecraft:chests/pillager_outpost"}));
        }
        for (ItemSettingsHelper itemSettingsHelper : ItemSettingsHelper.values()) {
            this.epicLootTables.put(ItemSettingsHelper.EPIC_LOOT_TABLES, Lists.newArrayList((Object[])new String[]{"minecraft:chests/stronghold_corridor", "minecraft:chests/stronghold_crossing", "minecraft:chests/stronghold_library", "minecraft:chests/end_city_treasure"}));
        }
        for (Enum enum_ : ArmorSets.values()) {
            this.armorLootTableSpawnRates.put((ArmorSets)enum_, Float.valueOf(0.1f));
        }
        this.armorLootTableSpawnRates.replace(ArmorSets.SPLENDID, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.BEEHIVE, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.HERO, Float.valueOf(0.01f));
        this.armorLootTableSpawnRates.replace(ArmorSets.RUGGED_CLIMBING_GEAR, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.TITAN, Float.valueOf(0.01f));
        this.armorLootTableSpawnRates.replace(ArmorSets.ROYAL, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.OPULENT, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.GILDED, Float.valueOf(0.01f));
        this.armorLootTableSpawnRates.replace(ArmorSets.TROUBADOUR, Float.valueOf(0.0f));
        this.armorLootTableSpawnRates.replace(ArmorSets.EMBER, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.VERDANT, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.GHOST_KINDLER, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.WITHER, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.GOURDIAN, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.CURIOUS, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.ARCHER, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.RENEGADE, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.HUNGRY_HORROR, Float.valueOf(0.01f));
        this.armorLootTableSpawnRates.replace(ArmorSets.RED_MYSTERY, Float.valueOf(0.0f));
        this.armorLootTableSpawnRates.replace(ArmorSets.MYSTERY, Float.valueOf(0.0f));
        this.armorLootTableSpawnRates.replace(ArmorSets.GREEN_MYSTERY, Float.valueOf(0.0f));
        this.armorLootTableSpawnRates.replace(ArmorSets.BLUE_MYSTERY, Float.valueOf(0.0f));
        this.armorLootTableSpawnRates.replace(ArmorSets.PURPLE_MYSTERY, Float.valueOf(0.0f));
        this.armorLootTableSpawnRates.replace(ArmorSets.SHADOW_WALKER, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.FROST_BITE, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.GOLDEN_PIGLIN, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.FULL_METAL, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.CAULDRON, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.STALWART_MAIL, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.HIGHLAND, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.STURDY_SHULKER, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.FROST, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.SOULDANCER, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.CAVE_CRAWLER, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.GLOW_SQUID, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.UNSTABLE, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.SPIDER, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.NIMBLE_TURTLE, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.BLACK_WOLF, Float.valueOf(0.05f));
        this.armorLootTableSpawnRates.replace(ArmorSets.FOX, Float.valueOf(0.01f));
        this.armorLootTableSpawnRates.replace(ArmorSets.ARCTIC_FOX, Float.valueOf(0.01f));
    }
}

