/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcda.mixin;

import chronosacaria.mcda.Mcda;
import chronosacaria.mcda.api.AOEHelper;
import chronosacaria.mcda.api.CleanlinessHelper;
import chronosacaria.mcda.api.ProjectileEffectHelper;
import chronosacaria.mcda.effects.ArmorEffectID;
import chronosacaria.mcda.effects.ArmorEffects;
import chronosacaria.mcda.effects.EnchantmentEffects;
import chronosacaria.mcda.enchants.EnchantID;
import chronosacaria.mcda.items.ArmorSets;
import java.util.EnumMap;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_4081;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    EnumMap<ArmorEffectID, Boolean> ARMOR_CONFIG;
    EnumMap<EnchantID, Boolean> ENCHANT_CONFIG;

    @Shadow
    protected abstract int method_23329(float var1, float var2);

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
        this.ARMOR_CONFIG = Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect;
        this.ENCHANT_CONFIG = Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableEnchantment;
    }

    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), argsOnly=true)
    public float mcda$damageModifiers(float amount, class_1282 source) {
        class_1799 mainHandStack;
        class_1297 class_12972;
        if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.LEADER_OF_THE_PACK).booleanValue()) {
            amount *= ArmorEffects.leaderOfThePackEffect(source);
        }
        class_1309 target = (class_1309)this;
        if (source == class_1282.field_5854 && this.ENCHANT_CONFIG.get((Object)EnchantID.FIRE_FOCUS).booleanValue()) {
            amount *= EnchantmentEffects.applyFireFocusDamage(target);
        }
        if (source.method_5527() && this.ENCHANT_CONFIG.get((Object)EnchantID.POISON_FOCUS).booleanValue()) {
            amount *= EnchantmentEffects.applyPoisonFocusDamage(target);
        }
        if (!((class_12972 = source.method_5529()) instanceof class_1309)) {
            return amount;
        }
        class_1309 livingEntity = (class_1309)class_12972;
        if (amount != 0.0f && !(mainHandStack = livingEntity.method_6047()).method_7960()) {
            if (!source.method_5533()) {
                if (this.ARMOR_CONFIG.get((Object)ArmorEffectID.ARCTIC_FOX_HIGH_GROUND).booleanValue()) {
                    amount *= ArmorEffects.arcticFoxesHighGround(livingEntity);
                }
                if (this.ARMOR_CONFIG.get((Object)ArmorEffectID.GILDED_HERO).booleanValue()) {
                    amount += ArmorEffects.gildedHeroDamageBuff(livingEntity, target);
                }
            } else if (source.method_5526() instanceof class_1665 && this.ARMOR_CONFIG.get((Object)ArmorEffectID.ARCHERS_PROWESS).booleanValue()) {
                amount *= ArmorEffects.archersProwessDamageBuff(livingEntity);
            }
        }
        return amount;
    }

    @Inject(method={"applyDamage(Lnet/minecraft/entity/damage/DamageSource;F)V"}, at={@At(value="HEAD")})
    public void mcda$applyDamage(class_1282 source, float amount, CallbackInfo info) {
        class_1799 mainHandStack;
        class_1309 target = (class_1309)this;
        class_1297 class_12972 = source.method_5529();
        if (!(class_12972 instanceof class_1309)) {
            return;
        }
        class_1309 livingEntity = (class_1309)class_12972;
        if (amount != 0.0f && !(mainHandStack = livingEntity.method_6047()).method_7960()) {
            if (this.ARMOR_CONFIG.get((Object)ArmorEffectID.TITAN_SHROUD_EFFECTS).booleanValue()) {
                ArmorEffects.applyTitanShroudStatuses(livingEntity, target);
            }
            if (this.ARMOR_CONFIG.get((Object)ArmorEffectID.FROST_BITE_EFFECT).booleanValue()) {
                ArmorEffects.applyFrostBiteStatus(livingEntity, target);
            }
            if (this.ARMOR_CONFIG.get((Object)ArmorEffectID.GHOST_KINDLING).booleanValue()) {
                ArmorEffects.applyGhostKindlingEffect(livingEntity, target);
            }
            if (!source.method_5533() && this.ARMOR_CONFIG.get((Object)ArmorEffectID.SPLENDID_ATTACK).booleanValue()) {
                ArmorEffects.applySplendidAoEAttackEffect(livingEntity, target);
            }
        }
    }

    @Inject(method={"applyMovementEffects"}, at={@At(value="HEAD")})
    protected void mcda$movementEffects(class_2338 blockPos, CallbackInfo ci) {
        LivingEntityMixin livingEntityMixin = this;
        if (!(livingEntityMixin instanceof class_1657)) {
            return;
        }
        class_1657 playerEntity = (class_1657)livingEntityMixin;
        class_1937 world = playerEntity.method_5770();
        if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableEnchantment.get((Object)EnchantID.FIRE_TRAIL).booleanValue()) {
            EnchantmentEffects.applyFireTrail(playerEntity, blockPos);
        }
        if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.GHOST_KINDLER_TRAIL).booleanValue() && world.method_8510() % 3L == 0L) {
            ArmorEffects.ghostKindlerTrail(playerEntity, blockPos);
        }
    }

    @Inject(method={"consumeItem"}, at={@At(value="HEAD")})
    public void mcda$consumeItem(CallbackInfo ci) {
        LivingEntityMixin livingEntityMixin = this;
        if (!(livingEntityMixin instanceof class_1657)) {
            return;
        }
        class_1657 playerEntity = (class_1657)livingEntityMixin;
        if (!playerEntity.method_5805()) {
            return;
        }
        if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableEnchantment.get((Object)EnchantID.FOOD_RESERVES).booleanValue()) {
            EnchantmentEffects.applyFoodReserves(playerEntity);
        }
        if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableEnchantment.get((Object)EnchantID.POTION_BARRIER).booleanValue()) {
            EnchantmentEffects.applyPotionBarrier(playerEntity);
        }
        if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableEnchantment.get((Object)EnchantID.SURPRISE_GIFT).booleanValue()) {
            EnchantmentEffects.applySurpriseGift(playerEntity);
        }
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    public void mcda$damageAtHead(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657) {
            class_1657 playerEntity = (class_1657)livingEntityMixin;
            if (source.method_5529() instanceof class_1309) {
                if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableEnchantment.get((Object)EnchantID.HEAL_ALLIES).booleanValue()) {
                    AOEHelper.healNearbyAllies((class_1309)playerEntity, amount);
                }
                if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.WITHERED).booleanValue()) {
                    ArmorEffects.applyWithered(playerEntity, (class_1309)source.method_5529());
                }
                if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.SHULKER_LIKE).booleanValue()) {
                    ProjectileEffectHelper.fireShulkerBulletAtNearbyEnemy((class_1309)playerEntity);
                }
            }
            if (amount > 0.0f) {
                if ((source.method_5529() instanceof class_1309 || source.method_5533()) && Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.SOULDANCER_GRACE).booleanValue() && ArmorEffects.souldancerGraceEffect(playerEntity)) {
                    cir.cancel();
                }
                if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.NIMBLE_TURTLE_EFFECTS).booleanValue()) {
                    ArmorEffects.applyNimbleTurtleEffects(playerEntity);
                }
            }
        }
        if ((livingEntityMixin = this) instanceof class_1309) {
            class_1297 class_12972;
            class_1309 livingEntity = (class_1309)livingEntityMixin;
            if (amount > 0.0f && (class_12972 = source.method_5529()) instanceof class_1309) {
                class_1309 attackingEntity = (class_1309)class_12972;
                if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.BUZZY_HIVE).booleanValue()) {
                    ArmorEffects.buzzyHiveEffect(livingEntity);
                }
                if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.CAULDRONS_OVERFLOW).booleanValue()) {
                    ArmorEffects.applyCauldronsOverflow(livingEntity);
                }
                if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableEnchantment.get((Object)EnchantID.CHILLING).booleanValue()) {
                    EnchantmentEffects.applyChilling(livingEntity, attackingEntity);
                }
            }
        }
    }

    @Inject(method={"damage"}, at={@At(value="TAIL")})
    public void mcda$damageAtTail(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntityMixin livingEntityMixin = this;
        if (!(livingEntityMixin instanceof class_1657)) {
            return;
        }
        class_1657 playerEntity = (class_1657)livingEntityMixin;
        class_1297 class_12972 = source.method_5529();
        if (!(class_12972 instanceof class_1309)) {
            return;
        }
        class_1309 attacker = (class_1309)class_12972;
        if (amount != 0.0f && Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.CURIOUS_TELEPORTATION).booleanValue()) {
            ArmorEffects.applyCuriousTeleportationEffect(playerEntity, attacker);
        }
    }

    @Inject(method={"handleFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    public void mcda$fallDamage(float fallDistance, float damageMultiplier, class_1282 damageSource, CallbackInfoReturnable<Boolean> cir) {
        if (!Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.NO_FALL_DAMAGE).booleanValue()) {
            return;
        }
        LivingEntityMixin livingEntityMixin = this;
        if (!(livingEntityMixin instanceof class_1657)) {
            return;
        }
        class_1657 playerEntity = (class_1657)livingEntityMixin;
        if (playerEntity.method_5805()) {
            int i;
            if (playerEntity == null) {
                return;
            }
            if ((CleanlinessHelper.hasArmorSet((class_1309)playerEntity, ArmorSets.SHADOW_WALKER) || ArmorEffects.ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.MYSTERY)) == ArmorEffectID.NO_FALL_DAMAGE || ArmorEffects.GREEN_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.GREEN_MYSTERY)) == ArmorEffectID.NO_FALL_DAMAGE) && (i = this.method_23329(fallDistance, damageMultiplier)) > 0) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"isClimbing"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcda$climbingEffects(CallbackInfoReturnable<Boolean> cir) {
        LivingEntityMixin livingEntityMixin = this;
        if (!(livingEntityMixin instanceof class_1657)) {
            return;
        }
        class_1657 playerEntity = (class_1657)livingEntityMixin;
        if (playerEntity.method_5805()) {
            if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.SPIDER_CLIMBING).booleanValue() && ArmorEffects.spiderClimbing(playerEntity)) {
                cir.setReturnValue((Object)true);
            }
            if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.RUGGED_CLIMBING).booleanValue() && ArmorEffects.ruggedClimbing(playerEntity)) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"jump"}, at={@At(value="HEAD")})
    public void mcda$onJumpEffects(CallbackInfo ci) {
        LivingEntityMixin livingEntityMixin = this;
        if (!(livingEntityMixin instanceof class_3222)) {
            return;
        }
        class_3222 playerEntity = (class_3222)livingEntityMixin;
        if (playerEntity != null) {
            if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.EMBER_JUMP).booleanValue()) {
                ArmorEffects.applyEmberJumpEffect((class_1309)playerEntity);
            }
            if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.TELEPORTATION_ROBES_EFFECT).booleanValue()) {
                ArmorEffects.teleportationRobeTeleport(playerEntity);
            }
            if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.UNSTABLE_ROBES_EFFECT).booleanValue()) {
                ArmorEffects.unstableRobeTeleport(playerEntity);
            }
        }
    }

    @Inject(method={"onDeath"}, at={@At(value="HEAD")})
    public void mdca$onDeathEffects(class_1282 source, CallbackInfo ci) {
        class_1297 class_12972 = source.method_5529();
        if (!(class_12972 instanceof class_1309)) {
            return;
        }
        class_1309 user = (class_1309)class_12972;
        if (user != null && Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.GOURDIANS_HATRED).booleanValue()) {
            ArmorEffects.applyGourdiansHatredStatus(user);
        }
    }

    @Inject(method={"swingHand(Lnet/minecraft/util/Hand;)V"}, at={@At(value="HEAD")})
    public void mcda$swingHandEffects(class_1268 hand, CallbackInfo ci) {
        LivingEntityMixin livingEntityMixin = this;
        if (!(livingEntityMixin instanceof class_1657)) {
            return;
        }
        class_1657 playerEntity = (class_1657)livingEntityMixin;
        if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.FOX_POUNCING).booleanValue()) {
            ArmorEffects.foxPouncing(playerEntity);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void mcda$livingEntTick(CallbackInfo ci) {
        class_1309 livingEntity;
        class_1657 playerEntity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657 && (playerEntity = (class_1657)livingEntityMixin).method_5805()) {
            if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.FLUID_FREEZING).booleanValue()) {
                ArmorEffects.applyFluidFreezing(playerEntity);
            }
            if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.INVISIBILITY).booleanValue()) {
                ArmorEffects.applyThiefInvisibilityTick(playerEntity);
            }
            if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.SYLVAN_PRESENCE).booleanValue()) {
                ArmorEffects.applySylvanPresence((class_1309)playerEntity);
            }
        }
        if ((livingEntityMixin = this) instanceof class_1309 && (livingEntity = (class_1309)livingEntityMixin).method_5805() && Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableEnchantment.get((Object)EnchantID.LUCKY_EXPLORER).booleanValue()) {
            EnchantmentEffects.applyLuckyExplorer(livingEntity);
        }
    }

    @Inject(method={"tryUseTotem"}, at={@At(value="HEAD")}, cancellable=true)
    public void mcda$tryTotem(class_1282 damageSource, CallbackInfoReturnable<Boolean> cir) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657) {
            class_1657 playerEntity = (class_1657)livingEntityMixin;
            if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableEnchantment.get((Object)EnchantID.DEATH_BARTER).booleanValue() && !damageSource.method_5538() && EnchantmentEffects.deathBarterEffect(playerEntity)) {
                cir.setReturnValue((Object)true);
            }
        }
        if ((livingEntityMixin = this) instanceof class_1309) {
            class_1309 livingEntity = (class_1309)livingEntityMixin;
            if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.GILDED_HERO).booleanValue() && !damageSource.method_5538() && ArmorEffects.gildedGloryTotemEffect(livingEntity)) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @ModifyVariable(method={"takeKnockback"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private double mcda$knockbackEffects(double strength) {
        class_1309 livingEntity = (class_1309)this;
        if (this.method_5805() && this.method_5715() && (CleanlinessHelper.hasArmorSet(livingEntity, ArmorSets.STALWART_MAIL) || ArmorEffects.ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect(livingEntity, ArmorSets.MYSTERY)) == ArmorEffectID.STALWART_BULWARK || ArmorEffects.RED_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect(livingEntity, ArmorSets.RED_MYSTERY)) == ArmorEffectID.STALWART_BULWARK)) {
            return strength * 0.0;
        }
        return strength;
    }

    @ModifyVariable(method={"addStatusEffect(Lnet/minecraft/entity/effect/StatusEffectInstance;Lnet/minecraft/entity/Entity;)Z"}, at=@At(value="HEAD"), argsOnly=true)
    private class_1293 mcda$modifyStatusEffect(class_1293 statusEffectInstance) {
        class_1309 livingEntity = (class_1309)this;
        if (livingEntity instanceof class_3222) {
            class_1291 statusEffectType = statusEffectInstance.method_5579();
            if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.SHULKER_LIKE).booleanValue() && (CleanlinessHelper.hasArmorSet(livingEntity, ArmorSets.STURDY_SHULKER) || ArmorEffects.ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect(livingEntity, ArmorSets.MYSTERY)) == ArmorEffectID.SHULKER_LIKE || ArmorEffects.PURPLE_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect(livingEntity, ArmorSets.PURPLE_MYSTERY)) == ArmorEffectID.SHULKER_LIKE) && statusEffectType == class_1294.field_5902) {
                return new class_1293(class_1294.field_5902, 0);
            }
            if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.TROUBADOURS_CHARISMA).booleanValue() && CleanlinessHelper.hasArmorSet(livingEntity, ArmorSets.TROUBADOUR)) {
                int interceptedDuration = statusEffectInstance.method_5584();
                int newDuration = statusEffectInstance.method_5584();
                if (statusEffectType.method_5573()) {
                    newDuration *= 2;
                }
                if (statusEffectType.method_18792() == class_4081.field_18272) {
                    newDuration /= 2;
                }
                if (newDuration != interceptedDuration) {
                    return new class_1293(statusEffectType, newDuration, statusEffectInstance.method_5578(), statusEffectInstance.method_5591(), statusEffectInstance.method_5581(), statusEffectInstance.method_5592());
                }
            }
        }
        return statusEffectInstance;
    }
}

