/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcda.registry;

import chronosacaria.mcda.Mcda;
import chronosacaria.mcda.items.ArmorSets;
import chronosacaria.mcda.items.ItemID;
import chronosacaria.mcda.items.itemhelpers.DropHelper;
import chronosacaria.mcda.items.itemhelpers.ItemSettingsHelper;
import chronosacaria.mcda.items.itemhelpers.SpawnHelper;
import chronosacaria.mcda.registry.ArmorsRegistry;
import chronosacaria.mcda.registry.ItemsRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.fabricmc.fabric.api.loot.v1.FabricLootPoolBuilder;
import net.fabricmc.fabric.api.loot.v1.event.LootTableLoadingCallback;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import net.minecraft.class_40;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_77;
import net.minecraft.class_79;

public class LootRegistry {
    public static final Collection<class_2960> BASTION_LOOT_TABLES = Set.of(class_39.field_24048, class_39.field_24049, class_39.field_24047, class_39.field_24046);
    public static final Collection<class_2960> PIGLIN_TRADING_LOOT_TABLES = Collections.singletonList(class_39.field_22402);
    public static final Collection<class_2960> NETHER_FORTRESS_LOOT_TABLES = Collections.singletonList(class_39.field_615);
    public static final Collection<class_2960> PILLAGER_TOWER_LOOT_TABLES = Set.of(class_39.field_16593, class_39.field_484);
    public static final Collection<class_2960> VILLAGE_SMITH_LOOT_TABLES = List.of(class_39.field_17107, class_39.field_434);
    public static final Collection<class_2960> SUNKEN_SHIP_LOOT_TABLES = List.of(class_39.field_665, class_39.field_880);
    public static final Collection<class_2960> MINESHAFT_LOOT_TABLES = Collections.singletonList(class_39.field_472);
    public static final Collection<class_2960> HERO_OF_THE_VILLAGE_LOOT_TABLES = Collections.singletonList(class_39.field_19062);
    public static final Collection<class_2960> STRONGHOLD_LOOT_TABLES = List.of(class_39.field_842, class_39.field_800, class_39.field_683);
    public static final ArrayList<String> COMMON_LOOT_TABLES = new ArrayList(Mcda.CONFIG.mcdaLootTablesConfig.commonLootTables.get((Object)ItemSettingsHelper.COMMON_LOOT_TABLES));
    public static final ArrayList<String> UNCOMMON_LOOT_TABLES = new ArrayList(Mcda.CONFIG.mcdaLootTablesConfig.uncommonLootTables.get((Object)ItemSettingsHelper.UNCOMMON_LOOT_TABLES));
    public static final ArrayList<String> RARE_LOOT_TABLES = new ArrayList(Mcda.CONFIG.mcdaLootTablesConfig.rareLootTables.get((Object)ItemSettingsHelper.RARE_LOOT_TABLES));
    public static final ArrayList<String> EPIC_LOOT_TABLES = new ArrayList(Mcda.CONFIG.mcdaLootTablesConfig.epicLootTables.get((Object)ItemSettingsHelper.EPIC_LOOT_TABLES));

    public static void init() {
        LootTableLoadingCallback.EVENT.register((resourceManager, lootManager, id, supplier, setter) -> {
            FabricLootPoolBuilder poolBuilder;
            if (!id.method_12836().equals("minecraft")) {
                return;
            }
            switch (id.method_12832()) {
                case "entities/phantom": {
                    poolBuilder = FabricLootPoolBuilder.builder();
                    LootRegistry.addItemDrop(poolBuilder, ItemsRegistry.items.get((Object)ItemID.PHANTOM_BONES), Mcda.CONFIG.mcdaItemDropsConfig.maxDropAmounts.get((Object)DropHelper.PHANTOM_BONES).intValue(), 0.35f);
                    supplier.pool((class_55.class_56)poolBuilder);
                    poolBuilder = FabricLootPoolBuilder.builder();
                    LootRegistry.addItemDrop(poolBuilder, ItemsRegistry.items.get((Object)ItemID.PHANTOM_SKIN), Mcda.CONFIG.mcdaItemDropsConfig.maxDropAmounts.get((Object)DropHelper.PHANTOM_SKIN).intValue(), 0.2f);
                    supplier.pool((class_55.class_56)poolBuilder);
                    break;
                }
                case "entities/ocelot": {
                    poolBuilder = FabricLootPoolBuilder.builder();
                    LootRegistry.addItemDrop(poolBuilder, ItemsRegistry.items.get((Object)ItemID.OCELOT_PELT), Mcda.CONFIG.mcdaItemDropsConfig.maxDropAmounts.get((Object)DropHelper.OCELOT_PELT).intValue(), 0.35f);
                    supplier.pool((class_55.class_56)poolBuilder);
                    poolBuilder = FabricLootPoolBuilder.builder();
                    LootRegistry.addItemDrop(poolBuilder, ItemsRegistry.items.get((Object)ItemID.OCELOT_PELT_BLACK), Mcda.CONFIG.mcdaItemDropsConfig.maxDropAmounts.get((Object)DropHelper.BLACK_OCELOT_PELT).intValue(), 0.2f);
                    supplier.pool((class_55.class_56)poolBuilder);
                    break;
                }
                case "entities/skeleton": {
                    poolBuilder = FabricLootPoolBuilder.builder();
                    LootRegistry.addItemDrop(poolBuilder, class_1802.field_8398, Mcda.CONFIG.mcdaItemDropsConfig.maxDropAmounts.get((Object)DropHelper.SKELETON_SKULL).intValue(), 0.2f);
                    supplier.pool((class_55.class_56)poolBuilder);
                    break;
                }
                case "entities/wolf": {
                    poolBuilder = FabricLootPoolBuilder.builder();
                    LootRegistry.addItemDrop(poolBuilder, ItemsRegistry.items.get((Object)ItemID.WOLF_PELT), Mcda.CONFIG.mcdaItemDropsConfig.maxDropAmounts.get((Object)DropHelper.WOLF_PELT).intValue(), 0.25f);
                    supplier.pool((class_55.class_56)poolBuilder);
                    poolBuilder = FabricLootPoolBuilder.builder();
                    LootRegistry.addItemDrop(poolBuilder, ItemsRegistry.items.get((Object)ItemID.WOLF_PELT_BLACK), Mcda.CONFIG.mcdaItemDropsConfig.maxDropAmounts.get((Object)DropHelper.BLACK_WOLF_PELT).intValue(), 0.08f);
                    supplier.pool((class_55.class_56)poolBuilder);
                    break;
                }
                case "entities/fox": {
                    poolBuilder = FabricLootPoolBuilder.builder();
                    LootRegistry.addItemDrop(poolBuilder, ItemsRegistry.items.get((Object)ItemID.FOX_PELT), Mcda.CONFIG.mcdaItemDropsConfig.maxDropAmounts.get((Object)DropHelper.FOX_PELT).intValue(), 0.25f);
                    supplier.pool((class_55.class_56)poolBuilder);
                    poolBuilder = FabricLootPoolBuilder.builder();
                    LootRegistry.addItemDrop(poolBuilder, ItemsRegistry.items.get((Object)ItemID.FOX_PELT_ARCTIC), Mcda.CONFIG.mcdaItemDropsConfig.maxDropAmounts.get((Object)DropHelper.ARCTIC_FOX_PELT).intValue(), 0.1f);
                    supplier.pool((class_55.class_56)poolBuilder);
                    break;
                }
                case "entities/evoker": {
                    poolBuilder = FabricLootPoolBuilder.builder();
                    LootRegistry.addItemDrop(poolBuilder, ArmorsRegistry.armorItems.get((Object)ArmorSets.EVOCATION).get(class_1304.field_6169), Mcda.CONFIG.mcdaItemDropsConfig.maxDropAmounts.get((Object)DropHelper.EVOCATION_ROBE).intValue(), 0.2f);
                    supplier.pool((class_55.class_56)poolBuilder);
                    poolBuilder = FabricLootPoolBuilder.builder();
                    LootRegistry.addItemDrop(poolBuilder, ArmorsRegistry.armorItems.get((Object)ArmorSets.EVOCATION).get(class_1304.field_6174), Mcda.CONFIG.mcdaItemDropsConfig.maxDropAmounts.get((Object)DropHelper.EVOCATION_ROBE).intValue(), 0.2f);
                    supplier.pool((class_55.class_56)poolBuilder);
                    poolBuilder = FabricLootPoolBuilder.builder();
                    LootRegistry.addItemDrop(poolBuilder, ArmorsRegistry.armorItems.get((Object)ArmorSets.EVOCATION).get(class_1304.field_6172), Mcda.CONFIG.mcdaItemDropsConfig.maxDropAmounts.get((Object)DropHelper.EVOCATION_ROBE).intValue(), 0.2f);
                    supplier.pool((class_55.class_56)poolBuilder);
                    break;
                }
                case "entities/goat": {
                    poolBuilder = FabricLootPoolBuilder.builder();
                    LootRegistry.addItemDrop(poolBuilder, ItemsRegistry.items.get((Object)ItemID.GOAT_PELT), Mcda.CONFIG.mcdaItemDropsConfig.maxDropAmounts.get((Object)DropHelper.GOAT_PELT).intValue(), 0.5f);
                    supplier.pool((class_55.class_56)poolBuilder);
                    break;
                }
                case "blocks/blue_ice": {
                    poolBuilder = FabricLootPoolBuilder.builder();
                    LootRegistry.addItemDrop(poolBuilder, ItemsRegistry.items.get((Object)ItemID.FROST_CRYSTAL), Mcda.CONFIG.mcdaItemDropsConfig.maxDropAmounts.get((Object)DropHelper.FROST_CRYSTAL).intValue(), 0.2f);
                    supplier.pool((class_55.class_56)poolBuilder);
                }
            }
            if (Mcda.CONFIG.mcdaLootTablesConfig.enableTieredLootTables.get((Object)ItemSettingsHelper.ENABLE_TIERED_LOOT_TABLES).booleanValue()) {
                for (String commonLootTable : COMMON_LOOT_TABLES) {
                    if (!commonLootTable.equals(id.toString())) continue;
                    poolBuilder = FabricLootPoolBuilder.builder();
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.BATTLE, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.BATTLE).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.BEENEST, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.BEENEST).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.CLIMBING_GEAR, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.CLIMBING_GEAR).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.EVOCATION, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.EVOCATION).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.GHOSTLY, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.GHOSTLY).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.HUNTER, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.HUNTER).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.SCALE_MAIL, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.SCALE_MAIL).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.SNOW, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.SNOW).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.SOUL_ROBE, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.SOUL_ROBE).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.SPELUNKER, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.SPELUNKER).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.SQUID, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.SQUID).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.VANGUARD, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.VANGUARD).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.WOLF, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.WOLF).floatValue());
                    supplier.pool((class_55.class_56)poolBuilder);
                }
                for (String uncommonLootTable : UNCOMMON_LOOT_TABLES) {
                    if (!uncommonLootTable.equals(id.toString())) continue;
                    poolBuilder = FabricLootPoolBuilder.builder();
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.CHAMPION, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.CHAMPION).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.EMERALD, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.EMERALD).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.ENTERTAINER, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.ENTERTAINER).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.GOAT, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.GOAT).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.GRIM, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.GRIM).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.GUARDS, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.GUARDS).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.MERCENARY, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.MERCENARY).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.OCELOT, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.OCELOT).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.PHANTOM, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.PHANTOM).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.PIGLIN, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.PIGLIN).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.PLATE, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.PLATE).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.REINFORCED_MAIL, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.REINFORCED_MAIL).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.SWEET_TOOTH, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.SWEET_TOOTH).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.TELEPORTATION, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.TELEPORTATION).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.THIEF, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.THIEF).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.TURTLE, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.TURTLE).floatValue());
                    supplier.pool((class_55.class_56)poolBuilder);
                }
                for (String rareLootTable : RARE_LOOT_TABLES) {
                    if (!rareLootTable.equals(id.toString())) continue;
                    poolBuilder = FabricLootPoolBuilder.builder();
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.SPLENDID, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.SPLENDID).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.BEEHIVE, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.BEEHIVE).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.RUGGED_CLIMBING_GEAR, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.RUGGED_CLIMBING_GEAR).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.DARK, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.DARK).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.TROUBADOUR, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.TROUBADOUR).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.EMBER, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.EMBER).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.VERDANT, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.VERDANT).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.GHOST_KINDLER, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.GHOST_KINDLER).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.WITHER, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.WITHER).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.ARCHER, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.ARCHER).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.LIVING_VINES, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.LIVING_VINES).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.SPROUT, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.SPROUT).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.RENEGADE, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.RENEGADE).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.GOLDEN_PIGLIN, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.GOLDEN_PIGLIN).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.STALWART_MAIL, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.STALWART_MAIL).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.HIGHLAND, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.HIGHLAND).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.FROST, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.FROST).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.SOULDANCER, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.SOULDANCER).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.CAVE_CRAWLER, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.CAVE_CRAWLER).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.GLOW_SQUID, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.GLOW_SQUID).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.SPIDER, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.SPIDER).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.BLACK_WOLF, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.BLACK_WOLF).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.FOX, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.FOX).floatValue());
                    supplier.pool((class_55.class_56)poolBuilder);
                }
                for (String epicLootTable : EPIC_LOOT_TABLES) {
                    if (!epicLootTable.equals(id.toString())) continue;
                    poolBuilder = FabricLootPoolBuilder.builder();
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.HERO, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.HERO).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.TITAN, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.TITAN).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.ROYAL, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.ROYAL).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.GILDED, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.GILDED).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.OPULENT, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.OPULENT).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.GOURDIAN, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.GOURDIAN).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.CURIOUS, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.CURIOUS).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.HUNGRY_HORROR, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.HUNGRY_HORROR).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.RED_MYSTERY, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.RED_MYSTERY).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.MYSTERY, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.MYSTERY).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.BLUE_MYSTERY, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.BLUE_MYSTERY).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.GREEN_MYSTERY, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.GREEN_MYSTERY).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.PURPLE_MYSTERY, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.PURPLE_MYSTERY).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.SHADOW_WALKER, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.SHADOW_WALKER).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.FROST_BITE, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.FROST_BITE).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.FULL_METAL, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.FULL_METAL).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.CAULDRON, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.CAULDRON).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.SHULKER, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.SHULKER).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.STURDY_SHULKER, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.STURDY_SHULKER).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.UNSTABLE, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.UNSTABLE).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.NIMBLE_TURTLE, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.NIMBLE_TURTLE).floatValue());
                    LootRegistry.addArmorSet(poolBuilder, ArmorSets.ARCTIC_FOX, Mcda.CONFIG.mcdaLootTablesConfig.armorLootTableSpawnRates.get((Object)ArmorSets.ARCTIC_FOX).floatValue());
                    supplier.pool((class_55.class_56)poolBuilder);
                }
            } else if (BASTION_LOOT_TABLES.contains(id)) {
                poolBuilder = FabricLootPoolBuilder.builder();
                LootRegistry.addArmorSet(poolBuilder, ArmorSets.GHOSTLY, Mcda.CONFIG.mcdaLootTablesConfig.armorSpawnRates.get((Object)SpawnHelper.GHOSTLY).floatValue());
                LootRegistry.addArmorSet(poolBuilder, ArmorSets.GHOST_KINDLER, Mcda.CONFIG.mcdaLootTablesConfig.armorSpawnRates.get((Object)SpawnHelper.GHOST_KINDLER).floatValue());
                LootRegistry.addMysteryArmorSets(poolBuilder, Mcda.CONFIG.mcdaLootTablesConfig.armorSpawnRates.get((Object)SpawnHelper.MYSTERY).floatValue());
                supplier.pool((class_55.class_56)poolBuilder);
            } else if (PIGLIN_TRADING_LOOT_TABLES.contains(id)) {
                poolBuilder = FabricLootPoolBuilder.builder();
                LootRegistry.addItemDrop(poolBuilder, ItemsRegistry.items.get((Object)ItemID.GEMSTONE_WHITE), 1, 0.01f);
                LootRegistry.addItemDrop(poolBuilder, ItemsRegistry.items.get((Object)ItemID.GEMSTONE_RED), 1, 0.01f);
                LootRegistry.addItemDrop(poolBuilder, ItemsRegistry.items.get((Object)ItemID.GEMSTONE_GREEN), 1, 0.01f);
                LootRegistry.addItemDrop(poolBuilder, ItemsRegistry.items.get((Object)ItemID.GEMSTONE_BLUE), 1, 0.01f);
                LootRegistry.addItemDrop(poolBuilder, ItemsRegistry.items.get((Object)ItemID.GEMSTONE_PURPLE), 1, 0.01f);
                supplier.pool((class_55.class_56)poolBuilder);
            } else if (NETHER_FORTRESS_LOOT_TABLES.contains(id)) {
                poolBuilder = FabricLootPoolBuilder.builder();
                LootRegistry.addArmorSet(poolBuilder, ArmorSets.GRIM, Mcda.CONFIG.mcdaLootTablesConfig.armorSpawnRates.get((Object)SpawnHelper.GRIM).floatValue());
                LootRegistry.addArmorSet(poolBuilder, ArmorSets.VANGUARD, Mcda.CONFIG.mcdaLootTablesConfig.armorSpawnRates.get((Object)SpawnHelper.VANGUARD).floatValue());
                LootRegistry.addMysteryArmorSets(poolBuilder, Mcda.CONFIG.mcdaLootTablesConfig.armorSpawnRates.get((Object)SpawnHelper.MYSTERY).floatValue());
                supplier.pool((class_55.class_56)poolBuilder);
            } else if (PILLAGER_TOWER_LOOT_TABLES.contains(id)) {
                poolBuilder = FabricLootPoolBuilder.builder();
                LootRegistry.addArmorSet(poolBuilder, ArmorSets.DARK, Mcda.CONFIG.mcdaLootTablesConfig.armorSpawnRates.get((Object)SpawnHelper.DARK).floatValue());
                LootRegistry.addArmorSet(poolBuilder, ArmorSets.THIEF, Mcda.CONFIG.mcdaLootTablesConfig.armorSpawnRates.get((Object)SpawnHelper.THIEF).floatValue());
                LootRegistry.addArmorSet(poolBuilder, ArmorSets.ROYAL, Mcda.CONFIG.mcdaLootTablesConfig.armorSpawnRates.get((Object)SpawnHelper.ROYAL).floatValue());
                LootRegistry.addArmorSet(poolBuilder, ArmorSets.TITAN, Mcda.CONFIG.mcdaLootTablesConfig.armorSpawnRates.get((Object)SpawnHelper.TITAN).floatValue());
                supplier.pool((class_55.class_56)poolBuilder);
            } else if (VILLAGE_SMITH_LOOT_TABLES.contains(id)) {
                poolBuilder = FabricLootPoolBuilder.builder();
                LootRegistry.addArmorSet(poolBuilder, ArmorSets.PLATE, Mcda.CONFIG.mcdaLootTablesConfig.armorSpawnRates.get((Object)SpawnHelper.PLATE).floatValue());
                LootRegistry.addArmorSet(poolBuilder, ArmorSets.FULL_METAL, Mcda.CONFIG.mcdaLootTablesConfig.armorSpawnRates.get((Object)SpawnHelper.FULL_METAL).floatValue());
                LootRegistry.addArmorSet(poolBuilder, ArmorSets.SNOW, Mcda.CONFIG.mcdaLootTablesConfig.armorSpawnRates.get((Object)SpawnHelper.SNOW).floatValue());
                LootRegistry.addArmorSet(poolBuilder, ArmorSets.WOLF, Mcda.CONFIG.mcdaLootTablesConfig.armorSpawnRates.get((Object)SpawnHelper.WOLF).floatValue());
                LootRegistry.addArmorSet(poolBuilder, ArmorSets.FOX, Mcda.CONFIG.mcdaLootTablesConfig.armorSpawnRates.get((Object)SpawnHelper.FOX).floatValue());
                LootRegistry.addArmorSet(poolBuilder, ArmorSets.REINFORCED_MAIL, Mcda.CONFIG.mcdaLootTablesConfig.armorSpawnRates.get((Object)SpawnHelper.REINFORCED).floatValue());
                LootRegistry.addArmorSet(poolBuilder, ArmorSets.STALWART_MAIL, Mcda.CONFIG.mcdaLootTablesConfig.armorSpawnRates.get((Object)SpawnHelper.STALWART).floatValue());
                supplier.pool((class_55.class_56)poolBuilder);
            } else if (SUNKEN_SHIP_LOOT_TABLES.contains(id)) {
                poolBuilder = FabricLootPoolBuilder.builder();
                LootRegistry.addArmorSet(poolBuilder, ArmorSets.SCALE_MAIL, Mcda.CONFIG.mcdaLootTablesConfig.armorSpawnRates.get((Object)SpawnHelper.SCALE).floatValue());
                LootRegistry.addArmorSet(poolBuilder, ArmorSets.MERCENARY, Mcda.CONFIG.mcdaLootTablesConfig.armorSpawnRates.get((Object)SpawnHelper.MERCENARY).floatValue());
                LootRegistry.addMysteryArmorSets(poolBuilder, 0.05f);
                supplier.pool((class_55.class_56)poolBuilder);
            } else if (MINESHAFT_LOOT_TABLES.contains(id)) {
                poolBuilder = FabricLootPoolBuilder.builder();
                LootRegistry.addArmorSet(poolBuilder, ArmorSets.SPELUNKER, Mcda.CONFIG.mcdaLootTablesConfig.armorSpawnRates.get((Object)SpawnHelper.SPELUNKER).floatValue());
                LootRegistry.addArmorSet(poolBuilder, ArmorSets.CAVE_CRAWLER, Mcda.CONFIG.mcdaLootTablesConfig.armorSpawnRates.get((Object)SpawnHelper.CAVE_CRAWLER).floatValue());
                LootRegistry.addMysteryArmorSets(poolBuilder, 0.05f);
                supplier.pool((class_55.class_56)poolBuilder);
            } else if (HERO_OF_THE_VILLAGE_LOOT_TABLES.contains(id)) {
                poolBuilder = FabricLootPoolBuilder.builder();
                LootRegistry.addArmorSet(poolBuilder, ArmorSets.HERO, Mcda.CONFIG.mcdaLootTablesConfig.armorSpawnRates.get((Object)SpawnHelper.HERO).floatValue());
                LootRegistry.addArmorSet(poolBuilder, ArmorSets.GILDED, Mcda.CONFIG.mcdaLootTablesConfig.armorSpawnRates.get((Object)SpawnHelper.GILDED).floatValue());
                supplier.pool((class_55.class_56)poolBuilder);
            } else if (STRONGHOLD_LOOT_TABLES.contains(id)) {
                poolBuilder = FabricLootPoolBuilder.builder();
                LootRegistry.addArmorSet(poolBuilder, ArmorSets.TELEPORTATION, Mcda.CONFIG.mcdaLootTablesConfig.armorSpawnRates.get((Object)SpawnHelper.TELEPORTATION).floatValue());
                LootRegistry.addArmorSet(poolBuilder, ArmorSets.UNSTABLE, Mcda.CONFIG.mcdaLootTablesConfig.armorSpawnRates.get((Object)SpawnHelper.UNSTABLE).floatValue());
                supplier.pool((class_55.class_56)poolBuilder);
            }
        });
    }

    public static void addMysteryArmorSets(FabricLootPoolBuilder poolBuilder, float p) {
        LootRegistry.addArmorSet(poolBuilder, ArmorSets.MYSTERY, p);
        LootRegistry.addArmorSet(poolBuilder, ArmorSets.BLUE_MYSTERY, p);
        LootRegistry.addArmorSet(poolBuilder, ArmorSets.GREEN_MYSTERY, p);
        LootRegistry.addArmorSet(poolBuilder, ArmorSets.PURPLE_MYSTERY, p);
        LootRegistry.addArmorSet(poolBuilder, ArmorSets.RED_MYSTERY, p);
    }

    public static void addArmorSet(FabricLootPoolBuilder poolBuilder, ArmorSets set, float p) {
        ArmorsRegistry.armorItems.get((Object)set).values().forEach(item -> {
            poolBuilder.rolls((class_5658)class_40.method_273((int)1, (float)p));
            poolBuilder.with((class_79.class_80)class_77.method_411((class_1935)item));
        });
    }

    public static void addItemDrop(FabricLootPoolBuilder poolBuilder, class_1792 item, int n, float p) {
        poolBuilder.rolls((class_5658)class_40.method_273((int)n, (float)p));
        poolBuilder.withEntry(class_77.method_411((class_1935)item).method_419());
    }
}

