/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.impl.builders;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.DropdownBoxEntry;
import me.shedaniel.clothconfig2.impl.builders.FieldBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_918;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class DropdownMenuBuilder<T>
extends FieldBuilder<T, DropdownBoxEntry<T>, DropdownMenuBuilder<T>> {
    protected DropdownBoxEntry.SelectionTopCellElement<T> topCellElement;
    protected DropdownBoxEntry.SelectionCellCreator<T> cellCreator;
    protected Function<T, Optional<class_2561[]>> tooltipSupplier = str -> Optional.empty();
    protected Consumer<T> saveConsumer = null;
    protected Iterable<T> selections = Collections.emptyList();
    protected boolean suggestionMode = true;

    public DropdownMenuBuilder(class_2561 resetButtonKey, class_2561 fieldNameKey, DropdownBoxEntry.SelectionTopCellElement<T> topCellElement, DropdownBoxEntry.SelectionCellCreator<T> cellCreator) {
        super(resetButtonKey, fieldNameKey);
        this.topCellElement = Objects.requireNonNull(topCellElement);
        this.cellCreator = Objects.requireNonNull(cellCreator);
    }

    public DropdownMenuBuilder<T> setSelections(Iterable<T> selections) {
        this.selections = selections;
        return this;
    }

    public DropdownMenuBuilder<T> setDefaultValue(Supplier<T> defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public DropdownMenuBuilder<T> setDefaultValue(T defaultValue) {
        this.defaultValue = () -> Objects.requireNonNull(defaultValue);
        return this;
    }

    public DropdownMenuBuilder<T> setSaveConsumer(Consumer<T> saveConsumer) {
        this.saveConsumer = saveConsumer;
        return this;
    }

    public DropdownMenuBuilder<T> setTooltipSupplier(Supplier<Optional<class_2561[]>> tooltipSupplier) {
        this.tooltipSupplier = str -> (Optional)tooltipSupplier.get();
        return this;
    }

    public DropdownMenuBuilder<T> setTooltipSupplier(Function<T, Optional<class_2561[]>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    public DropdownMenuBuilder<T> setTooltip(Optional<class_2561[]> tooltip) {
        this.tooltipSupplier = str -> tooltip;
        return this;
    }

    public DropdownMenuBuilder<T> setTooltip(class_2561 ... tooltip) {
        this.tooltipSupplier = str -> Optional.ofNullable(tooltip);
        return this;
    }

    public DropdownMenuBuilder<T> requireRestart() {
        this.requireRestart(true);
        return this;
    }

    public DropdownMenuBuilder<T> setErrorSupplier(Function<T, Optional<class_2561>> errorSupplier) {
        this.errorSupplier = errorSupplier;
        return this;
    }

    public DropdownMenuBuilder<T> setSuggestionMode(boolean suggestionMode) {
        this.suggestionMode = suggestionMode;
        return this;
    }

    public boolean isSuggestionMode() {
        return this.suggestionMode;
    }

    @Override
    @NotNull
    public DropdownBoxEntry<T> build() {
        DropdownBoxEntry<T> entry = new DropdownBoxEntry<T>(this.getFieldNameKey(), this.getResetButtonKey(), null, this.isRequireRestart(), this.defaultValue, this.saveConsumer, this.selections, this.topCellElement, this.cellCreator);
        entry.setTooltipSupplier(() -> this.tooltipSupplier.apply(entry.getValue()));
        if (this.errorSupplier != null) {
            entry.setErrorSupplier(() -> (Optional)this.errorSupplier.apply(entry.getValue()));
        }
        entry.setSuggestionMode(this.suggestionMode);
        return this.finishBuilding(entry);
    }

    public static class CellCreatorBuilder {
        public static <T> DropdownBoxEntry.SelectionCellCreator<T> of() {
            return new DropdownBoxEntry.DefaultSelectionCellCreator();
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> of(Function<T, class_2561> toTextFunction) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(toTextFunction);
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> ofWidth(final int cellWidth) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(){

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }
            };
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> ofWidth(final int cellWidth, Function<T, class_2561> toTextFunction) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(toTextFunction){

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }
            };
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> ofCellCount(final int maxItems) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(){

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> ofCellCount(final int maxItems, Function<T, class_2561> toTextFunction) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(toTextFunction){

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> of(final int cellWidth, final int maxItems) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(){

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> of(final int cellWidth, final int maxItems, Function<T, class_2561> toTextFunction) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(toTextFunction){

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> of(final int cellHeight, final int cellWidth, final int maxItems) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(){

                @Override
                public int getCellHeight() {
                    return cellHeight;
                }

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> of(final int cellHeight, final int cellWidth, final int maxItems, Function<T, class_2561> toTextFunction) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(toTextFunction){

                @Override
                public int getCellHeight() {
                    return cellHeight;
                }

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static DropdownBoxEntry.SelectionCellCreator<class_2960> ofItemIdentifier() {
            return CellCreatorBuilder.ofItemIdentifier(20, 146, 7);
        }

        public static DropdownBoxEntry.SelectionCellCreator<class_2960> ofItemIdentifier(int maxItems) {
            return CellCreatorBuilder.ofItemIdentifier(20, 146, maxItems);
        }

        public static DropdownBoxEntry.SelectionCellCreator<class_2960> ofItemIdentifier(final int cellHeight, final int cellWidth, final int maxItems) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<class_2960>(){

                @Override
                public DropdownBoxEntry.SelectionCellElement<class_2960> create(class_2960 selection) {
                    final class_1799 s = new class_1799((class_1935)class_2378.field_11142.method_10223(selection));
                    return new DropdownBoxEntry.DefaultSelectionCellElement<class_2960>(selection, this.toTextFunction){

                        @Override
                        public void render(class_4587 matrices, int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                            boolean b;
                            this.rendering = true;
                            this.x = x;
                            this.y = y;
                            this.width = width;
                            this.height = height;
                            boolean bl = b = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
                            if (b) {
                                CellCreatorBuilder.1.method_25294((class_4587)matrices, (int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + height - 1), (int)-15132391);
                            }
                            class_310.method_1551().field_1772.method_27517(matrices, ((class_2561)this.toTextFunction.apply((class_2960)this.r)).method_30937(), (float)(x + 6 + 18), (float)(y + 6), b ? 0xFFFFFF : 0x888888);
                            class_918 itemRenderer = class_310.method_1551().method_1480();
                            itemRenderer.method_4010(s, x + 4, y + 2);
                        }
                    };
                }

                @Override
                public int getCellHeight() {
                    return cellHeight;
                }

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static DropdownBoxEntry.SelectionCellCreator<class_2960> ofBlockIdentifier() {
            return CellCreatorBuilder.ofBlockIdentifier(20, 146, 7);
        }

        public static DropdownBoxEntry.SelectionCellCreator<class_2960> ofBlockIdentifier(int maxItems) {
            return CellCreatorBuilder.ofBlockIdentifier(20, 146, maxItems);
        }

        public static DropdownBoxEntry.SelectionCellCreator<class_2960> ofBlockIdentifier(final int cellHeight, final int cellWidth, final int maxItems) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<class_2960>(){

                @Override
                public DropdownBoxEntry.SelectionCellElement<class_2960> create(class_2960 selection) {
                    final class_1799 s = new class_1799((class_1935)class_2378.field_11146.method_10223(selection));
                    return new DropdownBoxEntry.DefaultSelectionCellElement<class_2960>(selection, this.toTextFunction){

                        @Override
                        public void render(class_4587 matrices, int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                            boolean b;
                            this.rendering = true;
                            this.x = x;
                            this.y = y;
                            this.width = width;
                            this.height = height;
                            boolean bl = b = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
                            if (b) {
                                1.method_25294((class_4587)matrices, (int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + height - 1), (int)-15132391);
                            }
                            class_310.method_1551().field_1772.method_27517(matrices, ((class_2561)this.toTextFunction.apply((class_2960)this.r)).method_30937(), (float)(x + 6 + 18), (float)(y + 6), b ? 0xFFFFFF : 0x888888);
                            class_918 itemRenderer = class_310.method_1551().method_1480();
                            itemRenderer.method_4010(s, x + 4, y + 2);
                        }
                    };
                }

                @Override
                public int getCellHeight() {
                    return cellHeight;
                }

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static DropdownBoxEntry.SelectionCellCreator<class_1792> ofItemObject() {
            return CellCreatorBuilder.ofItemObject(20, 146, 7);
        }

        public static DropdownBoxEntry.SelectionCellCreator<class_1792> ofItemObject(int maxItems) {
            return CellCreatorBuilder.ofItemObject(20, 146, maxItems);
        }

        public static DropdownBoxEntry.SelectionCellCreator<class_1792> ofItemObject(final int cellHeight, final int cellWidth, final int maxItems) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<class_1792>(i -> new class_2585(class_2378.field_11142.method_10221(i).toString())){

                @Override
                public DropdownBoxEntry.SelectionCellElement<class_1792> create(class_1792 selection) {
                    final class_1799 s = new class_1799((class_1935)selection);
                    return new DropdownBoxEntry.DefaultSelectionCellElement<class_1792>(selection, this.toTextFunction){

                        @Override
                        public void render(class_4587 matrices, int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                            boolean b;
                            this.rendering = true;
                            this.x = x;
                            this.y = y;
                            this.width = width;
                            this.height = height;
                            boolean bl = b = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
                            if (b) {
                                CellCreatorBuilder.1.method_25294((class_4587)matrices, (int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + height - 1), (int)-15132391);
                            }
                            class_310.method_1551().field_1772.method_27517(matrices, ((class_2561)this.toTextFunction.apply((class_1792)this.r)).method_30937(), (float)(x + 6 + 18), (float)(y + 6), b ? 0xFFFFFF : 0x888888);
                            class_918 itemRenderer = class_310.method_1551().method_1480();
                            itemRenderer.method_4010(s, x + 4, y + 2);
                        }
                    };
                }

                @Override
                public int getCellHeight() {
                    return cellHeight;
                }

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static DropdownBoxEntry.SelectionCellCreator<class_2248> ofBlockObject() {
            return CellCreatorBuilder.ofBlockObject(20, 146, 7);
        }

        public static DropdownBoxEntry.SelectionCellCreator<class_2248> ofBlockObject(int maxItems) {
            return CellCreatorBuilder.ofBlockObject(20, 146, maxItems);
        }

        public static DropdownBoxEntry.SelectionCellCreator<class_2248> ofBlockObject(final int cellHeight, final int cellWidth, final int maxItems) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<class_2248>(i -> new class_2585(class_2378.field_11146.method_10221(i).toString())){

                @Override
                public DropdownBoxEntry.SelectionCellElement<class_2248> create(class_2248 selection) {
                    final class_1799 s = new class_1799((class_1935)selection);
                    return new DropdownBoxEntry.DefaultSelectionCellElement<class_2248>(selection, this.toTextFunction){

                        @Override
                        public void render(class_4587 matrices, int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                            boolean b;
                            this.rendering = true;
                            this.x = x;
                            this.y = y;
                            this.width = width;
                            this.height = height;
                            boolean bl = b = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
                            if (b) {
                                CellCreatorBuilder.1.method_25294((class_4587)matrices, (int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + height - 1), (int)-15132391);
                            }
                            class_310.method_1551().field_1772.method_27517(matrices, ((class_2561)this.toTextFunction.apply((class_2248)this.r)).method_30937(), (float)(x + 6 + 18), (float)(y + 6), b ? 0xFFFFFF : 0x888888);
                            class_918 itemRenderer = class_310.method_1551().method_1480();
                            itemRenderer.method_4010(s, x + 4, y + 2);
                        }
                    };
                }

                @Override
                public int getCellHeight() {
                    return cellHeight;
                }

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }
    }

    public static class TopCellElementBuilder {
        public static final Function<String, class_2960> IDENTIFIER_FUNCTION = str -> {
            try {
                return new class_2960(str);
            }
            catch (NumberFormatException e) {
                return null;
            }
        };
        public static final Function<String, class_2960> ITEM_IDENTIFIER_FUNCTION = str -> {
            try {
                class_2960 identifier = new class_2960(str);
                if (class_2378.field_11142.method_17966(identifier).isPresent()) {
                    return identifier;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        };
        public static final Function<String, class_2960> BLOCK_IDENTIFIER_FUNCTION = str -> {
            try {
                class_2960 identifier = new class_2960(str);
                if (class_2378.field_11146.method_17966(identifier).isPresent()) {
                    return identifier;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        };
        public static final Function<String, class_1792> ITEM_FUNCTION = str -> {
            try {
                return class_2378.field_11142.method_17966(new class_2960(str)).orElse(null);
            }
            catch (Exception exception) {
                return null;
            }
        };
        public static final Function<String, class_2248> BLOCK_FUNCTION = str -> {
            try {
                return class_2378.field_11146.method_17966(new class_2960(str)).orElse(null);
            }
            catch (Exception exception) {
                return null;
            }
        };
        private static final class_1799 BARRIER = new class_1799((class_1935)class_1802.field_8077);

        public static <T> DropdownBoxEntry.SelectionTopCellElement<T> of(T value, Function<String, T> toObjectFunction) {
            return TopCellElementBuilder.of(value, toObjectFunction, t -> new class_2585(t.toString()));
        }

        public static <T> DropdownBoxEntry.SelectionTopCellElement<T> of(T value, Function<String, T> toObjectFunction, Function<T, class_2561> toTextFunction) {
            return new DropdownBoxEntry.DefaultSelectionTopCellElement<T>(value, toObjectFunction, toTextFunction);
        }

        public static DropdownBoxEntry.SelectionTopCellElement<class_2960> ofItemIdentifier(class_1792 item) {
            return new DropdownBoxEntry.DefaultSelectionTopCellElement<class_2960>(class_2378.field_11142.method_10221((Object)item), ITEM_IDENTIFIER_FUNCTION, identifier -> new class_2585(identifier.toString())){

                @Override
                public void render(class_4587 matrices, int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                    this.textFieldWidget.field_22760 = x + 4;
                    this.textFieldWidget.field_22761 = y + 6;
                    this.textFieldWidget.method_25358(width - 4 - 20);
                    this.textFieldWidget.method_1888(this.getParent().isEditable());
                    this.textFieldWidget.method_1868(this.getPreferredTextColor());
                    this.textFieldWidget.method_25394(matrices, mouseX, mouseY, delta);
                    class_918 itemRenderer = class_310.method_1551().method_1480();
                    class_1799 stack = this.hasConfigError() ? BARRIER : new class_1799((class_1935)class_2378.field_11142.method_10223((class_2960)this.getValue()));
                    itemRenderer.method_4010(stack, x + width - 18, y + 2);
                }
            };
        }

        public static DropdownBoxEntry.SelectionTopCellElement<class_2960> ofBlockIdentifier(class_2248 block) {
            return new DropdownBoxEntry.DefaultSelectionTopCellElement<class_2960>(class_2378.field_11146.method_10221((Object)block), BLOCK_IDENTIFIER_FUNCTION, identifier -> new class_2585(identifier.toString())){

                @Override
                public void render(class_4587 matrices, int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                    this.textFieldWidget.field_22760 = x + 4;
                    this.textFieldWidget.field_22761 = y + 6;
                    this.textFieldWidget.method_25358(width - 4 - 20);
                    this.textFieldWidget.method_1888(this.getParent().isEditable());
                    this.textFieldWidget.method_1868(this.getPreferredTextColor());
                    this.textFieldWidget.method_25394(matrices, mouseX, mouseY, delta);
                    class_918 itemRenderer = class_310.method_1551().method_1480();
                    class_1799 stack = this.hasConfigError() ? BARRIER : new class_1799((class_1935)class_2378.field_11146.method_10223((class_2960)this.getValue()));
                    itemRenderer.method_4010(stack, x + width - 18, y + 2);
                }
            };
        }

        public static DropdownBoxEntry.SelectionTopCellElement<class_1792> ofItemObject(class_1792 item) {
            return new DropdownBoxEntry.DefaultSelectionTopCellElement<class_1792>(item, ITEM_FUNCTION, i -> new class_2585(class_2378.field_11142.method_10221(i).toString())){

                @Override
                public void render(class_4587 matrices, int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                    this.textFieldWidget.field_22760 = x + 4;
                    this.textFieldWidget.field_22761 = y + 6;
                    this.textFieldWidget.method_25358(width - 4 - 20);
                    this.textFieldWidget.method_1888(this.getParent().isEditable());
                    this.textFieldWidget.method_1868(this.getPreferredTextColor());
                    this.textFieldWidget.method_25394(matrices, mouseX, mouseY, delta);
                    class_918 itemRenderer = class_310.method_1551().method_1480();
                    class_1799 stack = this.hasConfigError() ? BARRIER : new class_1799((class_1935)this.getValue());
                    itemRenderer.method_4010(stack, x + width - 18, y + 2);
                }
            };
        }

        public static DropdownBoxEntry.SelectionTopCellElement<class_2248> ofBlockObject(class_2248 block) {
            return new DropdownBoxEntry.DefaultSelectionTopCellElement<class_2248>(block, BLOCK_FUNCTION, i -> new class_2585(class_2378.field_11146.method_10221(i).toString())){

                @Override
                public void render(class_4587 matrices, int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                    this.textFieldWidget.field_22760 = x + 4;
                    this.textFieldWidget.field_22761 = y + 6;
                    this.textFieldWidget.method_25358(width - 4 - 20);
                    this.textFieldWidget.method_1888(this.getParent().isEditable());
                    this.textFieldWidget.method_1868(this.getPreferredTextColor());
                    this.textFieldWidget.method_25394(matrices, mouseX, mouseY, delta);
                    class_918 itemRenderer = class_310.method_1551().method_1480();
                    class_1799 stack = this.hasConfigError() ? BARRIER : new class_1799((class_1935)this.getValue());
                    itemRenderer.method_4010(stack, x + width - 18, y + 2);
                }
            };
        }
    }
}

