/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import net.minecraft.class_2487;

public class SettingsManager {
    private final ITravelersBackpackInventory inv;
    private byte[] craftingSettings;
    private byte[] toolSlotsSettings;
    public static final byte CRAFTING = 0;
    public static final byte TOOL_SLOTS = 1;
    public static final int HAS_CRAFTING_GRID = 0;
    public static final int SHOW_CRAFTING_GRID = 1;
    public static final int SHIFT_CLICK_TO_BACKPACK = 2;
    public static final int SHOW_TOOL_SLOTS = 0;
    public static final String CRAFTING_SETTINGS = "CraftingSettings";
    public static final String TOOL_SLOTS_SETTINGS = "ToolSlotsSettings";

    public SettingsManager(ITravelersBackpackInventory inv) {
        this.craftingSettings = new byte[]{(byte)(TravelersBackpackConfig.getConfig().backpackSettings.craftingUpgradeByDefault ? 1 : 0), 0, 1};
        this.toolSlotsSettings = new byte[]{0};
        this.inv = inv;
    }

    public boolean hasCraftingGrid() {
        return this.getByte((byte)0, 0) == 1;
    }

    public boolean shiftClickToBackpack() {
        return this.getByte((byte)0, 2) == 1;
    }

    public boolean showCraftingGrid() {
        return this.getByte((byte)0, 1) == 1;
    }

    public boolean showToolSlots() {
        return this.getByte((byte)1, 0) == 1;
    }

    public byte getByte(byte dataArray, int place) {
        if (dataArray == 0) {
            return this.craftingSettings[place];
        }
        if (dataArray == 1) {
            return this.toolSlotsSettings[place];
        }
        return 0;
    }

    public void set(byte selectedDataArray, int place, byte value) {
        byte[] dataArray = new byte[]{};
        if (selectedDataArray == 0) {
            dataArray = this.craftingSettings;
        }
        if (selectedDataArray == 1) {
            dataArray = this.toolSlotsSettings;
        }
        dataArray[place] = value;
        this.markDirty();
    }

    public void writeSettings(class_2487 compound) {
        compound.method_10570(CRAFTING_SETTINGS, this.craftingSettings);
        compound.method_10570(TOOL_SLOTS_SETTINGS, this.toolSlotsSettings);
    }

    public void readSettings(class_2487 compound) {
        byte[] byArray;
        byte[] byArray2;
        if (compound.method_10545(CRAFTING_SETTINGS)) {
            if (compound.method_10547(CRAFTING_SETTINGS).length == 3) {
                byArray2 = compound.method_10547(CRAFTING_SETTINGS);
            } else {
                byte[] byArray3 = new byte[3];
                byArray3[0] = 1;
                byArray3[1] = 0;
                byArray2 = byArray3;
                byArray3[2] = 1;
            }
        } else {
            byte[] byArray4 = new byte[3];
            byArray4[0] = (byte)(TravelersBackpackConfig.getConfig().backpackSettings.craftingUpgradeByDefault ? 1 : 0);
            byArray4[1] = 0;
            byArray2 = byArray4;
            byArray4[2] = 1;
        }
        this.craftingSettings = byArray2;
        if (compound.method_10545(TOOL_SLOTS_SETTINGS)) {
            byArray = compound.method_10547(TOOL_SLOTS_SETTINGS);
        } else {
            byte[] byArray5 = new byte[1];
            byArray = byArray5;
            byArray5[0] = 0;
        }
        this.toolSlotsSettings = byArray;
    }

    public void markDirty() {
        if (this.inv.getScreenID() != 3) {
            this.inv.markDataDirty(10);
        } else {
            this.inv.method_5431();
        }
    }

    public void loadDefaults() {
        this.craftingSettings = new byte[]{(byte)(TravelersBackpackConfig.getConfig().backpackSettings.craftingUpgradeByDefault ? 1 : 0), 0, 1};
        this.toolSlotsSettings = new byte[]{0};
        this.markDirty();
    }
}

