/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.doubledoors.forge.events;

import com.natamus.collective_common_forge.functions.WorldFunctions;
import com.natamus.doubledoors_common_forge.events.DoorEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ForgeDoorEvent {
    @SubscribeEvent
    public void onNeighbourNotice(BlockEvent.NeighborNotifyEvent e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getWorld());
        if (level == null) {
            return;
        }
        DoorEvent.onNeighbourNotice(level, e.getPos(), e.getState(), e.getNotifiedSides(), e.getForceRedstoneUpdate());
    }

    @SubscribeEvent
    public void onDoorClick(PlayerInteractEvent.RightClickBlock e) {
        if (!DoorEvent.onDoorClick(e.getWorld(), e.getPlayer(), e.getHand(), e.getPos(), e.getHitVec())) {
            e.setCancellationResult(InteractionResult.SUCCESS);
            e.setCanceled(true);
        }
    }
}

