/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.doubledoors_common_forge.util;

import com.natamus.collective_common_forge.functions.BlockPosFunctions;
import com.natamus.doubledoors_common_forge.config.ConfigHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WeightedPressurePlateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;

public class Util {
    public static boolean isDoorBlock(BlockState blockstate) {
        Block block = blockstate.m_60734_();
        return block instanceof DoorBlock && ConfigHandler.enableDoors || block instanceof TrapDoorBlock && ConfigHandler.enableTrapdoors || block instanceof FenceGateBlock && ConfigHandler.enableFenceGates;
    }

    public static boolean isPressureBlock(BlockState blockstate) {
        Block block = blockstate.m_60734_();
        if (block instanceof WeightedPressurePlateBlock) {
            return (Integer)blockstate.m_61143_((Property)BlockStateProperties.f_61426_) > 0;
        }
        if (block instanceof PressurePlateBlock || block instanceof ButtonBlock) {
            return (Boolean)blockstate.m_61143_((Property)BlockStateProperties.f_61448_);
        }
        return false;
    }

    public static boolean processDoor(Player player, Level level, BlockPos pos, BlockState state, Boolean isopen, boolean playsound) {
        List<BlockPos> postoopen;
        Block block = state.m_60734_();
        if (block instanceof DoorBlock && ((DoubleBlockHalf)state.m_61143_((Property)DoorBlock.f_52730_)).equals((Object)DoubleBlockHalf.UPPER)) {
            pos = pos.m_7495_().m_7949_();
            state = level.m_8055_(pos);
        }
        if (isopen == null) {
            isopen = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_) == false;
        }
        int yoffset = 0;
        if (!(block instanceof DoorBlock)) {
            yoffset = 1;
        }
        if ((postoopen = Util.recursivelyOpenDoors(new ArrayList<BlockPos>(Arrays.asList(pos.m_7949_())), new ArrayList<BlockPos>(), level, pos, pos, block, yoffset)).size() <= 1) {
            return false;
        }
        for (BlockPos toopen : postoopen) {
            BlockState ostate = level.m_8055_(toopen);
            Block oblock = ostate.m_60734_();
            if (block instanceof DoorBlock) {
                if (!ConfigHandler.enableDoors) continue;
                DoorBlock door = (DoorBlock)oblock;
                if (playsound) {
                    level.m_5594_(null, pos, isopen != false ? SoundEvents.f_12627_ : SoundEvents.f_12626_, SoundSource.BLOCKS, 1.0f, level.m_5822_().nextFloat() * 0.1f + 0.9f);
                    playsound = false;
                }
                level.m_7731_(toopen, (BlockState)ostate.m_61124_((Property)DoorBlock.f_52727_, (Comparable)isopen), 10);
                continue;
            }
            if (block instanceof TrapDoorBlock) {
                if (!ConfigHandler.enableTrapdoors) continue;
                if (playsound) {
                    if (isopen.booleanValue()) {
                        int i = ostate.m_60767_() == Material.f_76279_ ? 1037 : 1007;
                        level.m_5898_(null, i, pos, 0);
                    } else {
                        int j = ostate.m_60767_() == Material.f_76279_ ? 1036 : 1013;
                        level.m_5898_(null, j, pos, 0);
                    }
                    playsound = false;
                }
                level.m_7731_(toopen, (BlockState)ostate.m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)isopen), 10);
                continue;
            }
            if (!(block instanceof FenceGateBlock) || !ConfigHandler.enableFenceGates) continue;
            if (playsound) {
                level.m_5594_(null, pos, isopen != false ? SoundEvents.f_11873_ : SoundEvents.f_11872_, SoundSource.BLOCKS, 1.0f, level.m_5822_().nextFloat() * 0.1f + 0.9f);
                playsound = false;
            }
            level.m_7731_(toopen, (BlockState)ostate.m_61124_((Property)DoorBlock.f_52727_, (Comparable)isopen), 10);
        }
        if (player != null) {
            player.m_6674_(InteractionHand.MAIN_HAND);
        }
        return postoopen.size() > 1;
    }

    private static List<BlockPos> recursivelyOpenDoors(List<BlockPos> postoopen, List<BlockPos> ignoreoopen, Level level, BlockPos originalpos, BlockPos pos, Block block, int yoffset) {
        Iterator blocksaround = BlockPos.m_121886_((int)(pos.m_123341_() - 1), (int)(pos.m_123342_() - yoffset), (int)(pos.m_123343_() - 1), (int)(pos.m_123341_() + 1), (int)(pos.m_123342_() + yoffset), (int)(pos.m_123343_() + 1)).iterator();
        while (blocksaround.hasNext()) {
            BlockPos bpa = (BlockPos)blocksaround.next();
            if (postoopen.contains(bpa) || !BlockPosFunctions.withinDistance((BlockPos)originalpos, (BlockPos)bpa, (int)ConfigHandler.recursiveOpeningMaxBlocksDistance).booleanValue()) continue;
            BlockState ostate = level.m_8055_(bpa);
            Block oblock = ostate.m_60734_();
            if (Util.isDoorBlock(ostate) && oblock.m_49954_().equals(block.m_49954_())) {
                postoopen.add(bpa.m_7949_());
                if (!ConfigHandler.enableRecursiveOpening) continue;
                Util.recursivelyOpenDoors(postoopen, ignoreoopen, level, originalpos, bpa, block, yoffset);
                continue;
            }
            ignoreoopen.add(bpa.m_7949_());
        }
        return postoopen;
    }
}

