/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.libraryferret.worldgen.structures;

import com.google.common.collect.Lists;
import com.jtorleonstudios.libraryferret.LibraryFerret;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.class_1311;
import net.minecraft.class_1923;
import net.minecraft.class_1973;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3037;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3542;
import net.minecraft.class_3777;
import net.minecraft.class_3778;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_3812;
import net.minecraft.class_5312;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import net.minecraft.class_5742;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6621;
import net.minecraft.class_6622;
import net.minecraft.class_6626;
import net.minecraft.class_6834;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7061;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;

public abstract class AwesomeStructure
extends class_3195<class_3812> {
    public AwesomeStructure(int size, int distanceMaxFromCenter, BiFunction<class_6834.class_6835<class_3812>, class_2902.class_2903, Boolean> canGenerate) {
        this((class_6834.class_6835<class_3812> ctx, class_2902.class_2903 height) -> ctx.comp_309().method_33943(0), class_2902.class_2903.field_13194, true, size, distanceMaxFromCenter, canGenerate);
    }

    public AwesomeStructure(BiFunction<class_6834.class_6835<class_3812>, class_2902.class_2903, class_2338> initialPosition, class_2902.class_2903 heightmapType, boolean useHeightMapDuringPlacement, int size, int distanceMaxFromCenter, BiFunction<class_6834.class_6835<class_3812>, class_2902.class_2903, Boolean> canGenerate) {
        this(initialPosition, heightmapType, useHeightMapDuringPlacement, distanceMaxFromCenter, AwesomeStructure.getDefaultConfigurationCodec(size), canGenerate);
    }

    private AwesomeStructure(BiFunction<class_6834.class_6835<class_3812>, class_2902.class_2903, class_2338> initialPosition, class_2902.class_2903 heightmapType, boolean useHeightMapDuringPlacement, int distanceMaxFromCenter, Codec<class_3812> configCodec, BiFunction<class_6834.class_6835<class_3812>, class_2902.class_2903, Boolean> canGenerate) {
        super(configCodec, ctx -> (Boolean)canGenerate.apply(ctx, heightmapType) != false ? AwesomeStructure.createPiecesGenerator((class_6834.class_6835<class_3812>)ctx, (class_2338)initialPosition.apply(ctx, heightmapType), heightmapType, useHeightMapDuringPlacement, distanceMaxFromCenter) : Optional.empty(), class_6621.field_34938);
        this.field_24863 = AwesomeStructure.getDefaultStructureCodec(this, configCodec);
    }

    public static Optional<class_6622<class_3812>> createPiecesGenerator(class_6834.class_6835<class_3812> context, class_2338 initialPosition, class_2902.class_2903 heightmapType, boolean useHeightMapDuringPlacement, int distanceMax) {
        return AwesomeStructure.addPieces(context, class_3790::new, initialPosition, false, heightmapType, useHeightMapDuringPlacement, distanceMax);
    }

    public static Codec<class_3812> getDefaultConfigurationCodec(int size) {
        return RecordCodecBuilder.create(instance -> instance.group((App)class_3785.field_24954.fieldOf("start_pool").forGetter(class_3812::method_27223), (App)Codec.intRange((int)0, (int)(size + 1)).fieldOf("size").forGetter(class_3812::method_27222)).apply((Applicative)instance, class_3812::new));
    }

    public static Codec<class_5312<class_3812, class_3195<class_3812>>> getDefaultStructureCodec(AwesomeStructure feature, Codec<class_3812> configCodec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)configCodec.fieldOf("config").forGetter(configuredStructureFeature -> (class_3812)configuredStructureFeature.field_24836), (App)class_6895.method_40340((class_5321)class_2378.field_25114).fieldOf("biomes").forGetter(class_5312::method_40549), (App)Codec.BOOL.optionalFieldOf("adapt_noise", (Object)false).forGetter(configuredStructureFeature -> configuredStructureFeature.field_37144), (App)Codec.simpleMap((Codec)class_1311.field_24655, (Codec)class_7061.field_37198, (Keyable)class_3542.method_28142((class_3542[])class_1311.values())).fieldOf("spawn_overrides").forGetter(configuredStructureFeature -> configuredStructureFeature.field_37143)).apply((Applicative)instance, (featureConfig, biomeRegistryEntryList, useNoise, spawnsMap) -> {
            boolean isEnabledInConfiguration = feature.bindEnabledFromConfiguration(((class_3785)featureConfig.method_27223().comp_349()).method_16629().toString());
            if (!isEnabledInConfiguration) {
                LibraryFerret.LOGGER.info("structure disabled: " + ((class_3785)featureConfig.method_27223().comp_349()).method_16629().toString());
            }
            return new class_5312((class_3195)feature, (class_3037)featureConfig, (class_6885)(isEnabledInConfiguration ? biomeRegistryEntryList : class_6885.method_40246((class_6880[])new class_6880[0])), useNoise.booleanValue(), spawnsMap);
        }));
    }

    public static boolean isValidStructureBiome(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_6834.class_6835<class_3812> ctx, int biomeRange) {
        if (!(ctx.comp_307() instanceof class_1973)) {
            class_1923 chunkPos = ctx.comp_309();
            for (int curChunkX = chunkPos.field_9181 - biomeRange; curChunkX <= chunkPos.field_9181 + biomeRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.field_9180 - biomeRange; curChunkZ <= chunkPos.field_9180 + biomeRange; ++curChunkZ) {
                    if (ctx.comp_312().test(ctx.comp_306().method_16359(curChunkX << 2, 16, curChunkZ << 2))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isEmptyFluidState(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_6834.class_6835<class_3812> ctx, @NotNull class_2338 position, class_5539 heightLimitView, class_2902.class_2903 heightmapType) {
        return ctx.comp_306().method_26261(position.method_10263(), position.method_10260(), heightLimitView).method_32892(ctx.comp_306().method_18028(position.method_10263(), position.method_10260(), heightmapType, heightLimitView)).method_26227().method_15769();
    }

    public static Optional<class_6622<class_3812>> addPieces(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_6834.class_6835<class_3812> context, class_3778.class_3779 pieceFactory, class_2338 pos, boolean modifyBoundingBox, class_2902.class_2903 heightmapType, boolean useHeightMapDuringPlacement, int distanceMax) {
        class_2919 chunkRandom = new class_2919((class_5819)new class_5820(0L));
        chunkRandom.method_12663(context.comp_308(), context.comp_309().field_9181, context.comp_309().field_9180);
        class_5455 dynamicRegistryManager = context.comp_314();
        class_3812 structurePoolFeatureConfig = (class_3812)context.comp_310();
        class_2794 chunkGenerator = context.comp_306();
        class_3485 structureManager = context.comp_313();
        class_5539 heightLimitView = context.comp_311();
        Predicate predicate = context.comp_312();
        class_3195.method_28664();
        class_2378 registry = dynamicRegistryManager.method_30530(class_2378.field_25917);
        class_2470 blockRotation = class_2470.method_16548((Random)chunkRandom);
        class_3784 structurePoolElement = ((class_3785)structurePoolFeatureConfig.method_27223().comp_349()).method_16631((Random)chunkRandom);
        if (structurePoolElement == class_3777.field_16663) {
            return Optional.empty();
        }
        class_3790 poolStructurePiece = pieceFactory.create(structureManager, structurePoolElement, pos, structurePoolElement.method_19308(), blockRotation, structurePoolElement.method_16628(structureManager, pos, blockRotation));
        class_3341 blockBox = poolStructurePiece.method_14935();
        int i = (blockBox.method_35418() + blockBox.method_35415()) / 2;
        int j = (blockBox.method_35420() + blockBox.method_35417()) / 2;
        int k = useHeightMapDuringPlacement ? pos.method_10264() + chunkGenerator.method_20402(i, j, heightmapType, heightLimitView) : pos.method_10264();
        int l = blockBox.method_35416() + poolStructurePiece.method_16646();
        if (!predicate.test(chunkGenerator.method_16359(class_5742.method_33100((int)i), class_5742.method_33100((int)k), class_5742.method_33100((int)j)))) {
            return Optional.empty();
        }
        poolStructurePiece.method_14922(0, k - l, 0);
        return Optional.of((structurePiecesCollector, context1) -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolStructurePiece);
            if (structurePoolFeatureConfig.method_27222() > 0) {
                class_3778.class_4182 structurePoolGenerator = new class_3778.class_4182(registry, structurePoolFeatureConfig.method_27222(), pieceFactory, chunkGenerator, structureManager, (List)list, (Random)chunkRandom);
                structurePoolGenerator.field_18706.addLast(new class_3778.class_4181(poolStructurePiece, new MutableObject((Object)class_259.method_1072((class_265)class_259.method_1078((class_238)new class_238((double)(i - distanceMax), (double)(k - distanceMax), (double)(j - distanceMax), (double)(i + distanceMax + 1), (double)(k + distanceMax + 1), (double)(j + distanceMax + 1))), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)blockBox)), (class_247)class_247.field_16886)), 0));
                while (!structurePoolGenerator.field_18706.isEmpty()) {
                    class_3778.class_4181 shapedPoolStructurePiece = (class_3778.class_4181)structurePoolGenerator.field_18706.removeFirst();
                    structurePoolGenerator.method_19306(shapedPoolStructurePiece.field_18696, shapedPoolStructurePiece.field_18697, shapedPoolStructurePiece.field_18699, modifyBoundingBox, heightLimitView);
                }
                list.forEach(arg_0 -> ((class_6626)structurePiecesCollector).method_35462(arg_0));
            }
        });
    }

    public abstract boolean bindEnabledFromConfiguration(String var1);
}

