/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import net.coderbot.iris.compat.sodium.AllowedSodiumVersion;

public class SodiumVersionCheck {
    private static final ImmutableList<AllowedSodiumVersion> ALLOWED_SODIUM_VERSIONS = ImmutableList.of((Object)AllowedSodiumVersion.exact("0.4.1+build.15", "https://modrinth.com/mod/sodium/version/mc1.18.2-0.4.1"), (Object)AllowedSodiumVersion.prefix("0.4.1+replaymod"));

    public static String getDownloadLink() {
        return (String)ALLOWED_SODIUM_VERSIONS.stream().map(AllowedSodiumVersion::getDownloadLink).filter(Optional::isPresent).findFirst().get().get();
    }

    public static boolean isAllowedVersion(String string) {
        for (AllowedSodiumVersion allowedSodiumVersion : ALLOWED_SODIUM_VERSIONS) {
            if (!allowedSodiumVersion.matches(string)) continue;
            return true;
        }
        return false;
    }
}

