/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform.transformer;

import io.github.douira.glsl_transformer.ast.node.Identifier;
import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.declaration.TypeAndInitDeclaration;
import io.github.douira.glsl_transformer.ast.node.external_declaration.DeclarationExternalDeclaration;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.StorageQualifier;
import io.github.douira.glsl_transformer.ast.node.type.specifier.BuiltinNumericTypeSpecifier;
import io.github.douira.glsl_transformer.ast.node.type.specifier.TypeSpecifier;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.transform.ASTInjectionPoint;
import io.github.douira.glsl_transformer.ast.transform.ASTParser;
import io.github.douira.glsl_transformer.util.Type;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.pipeline.transform.parameter.SodiumParameters;
import net.coderbot.iris.pipeline.transform.transformer.CommonTransformer;

public class SodiumTransformer {
    public static void transform(ASTParser aSTParser, TranslationUnit translationUnit, Root root, SodiumParameters sodiumParameters) {
        CommonTransformer.transform(aSTParser, translationUnit, root, sodiumParameters, false);
        SodiumTransformer.replaceMidTexCoord(aSTParser, translationUnit, root, sodiumParameters.textureScale);
        root.replaceExpressionMatches(aSTParser, CommonTransformer.glTextureMatrix0, "mat4(1.0)");
        root.rename("gl_ProjectionMatrix", "iris_ProjectionMatrix");
        if (sodiumParameters.type.glShaderType == ShaderType.VERTEX) {
            if (sodiumParameters.inputs.hasTex()) {
                root.replaceReferenceExpressions(aSTParser, "gl_MultiTexCoord0", "vec4(_vert_tex_diffuse_coord, 0.0, 1.0)");
            } else {
                root.replaceReferenceExpressions(aSTParser, "gl_MultiTexCoord0", "vec4(0.0, 0.0, 0.0, 1.0)");
            }
            if (sodiumParameters.inputs.hasLight()) {
                translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "uniform mat4 iris_LightmapTextureMatrix;");
                root.replaceExpressionMatches(aSTParser, CommonTransformer.glTextureMatrix1, "iris_LightmapTextureMatrix");
                root.replaceReferenceExpressions(aSTParser, "gl_MultiTexCoord1", "vec4(_vert_tex_light_coord, 0, 1)");
                root.replaceReferenceExpressions(aSTParser, "gl_MultiTexCoord2", "vec4(_vert_tex_light_coord, 0, 1)");
            } else {
                root.replaceReferenceExpressions(aSTParser, "gl_MultiTexCoord1", "vec4(0.0, 0.0, 0.0, 1.0)");
            }
            CommonTransformer.replaceGlMultiTexCoordBounded(aSTParser, root, 2, 7);
        }
        if (sodiumParameters.inputs.hasColor()) {
            root.rename("gl_Color", "_vert_color");
        } else {
            root.replaceReferenceExpressions(aSTParser, "gl_Color", "vec4(1.0)");
        }
        if (sodiumParameters.type.glShaderType == ShaderType.VERTEX) {
            if (sodiumParameters.inputs.hasNormal()) {
                root.rename("gl_Normal", "iris_Normal");
                translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "in vec3 iris_Normal;");
            } else {
                root.replaceReferenceExpressions(aSTParser, "gl_Normal", "vec3(0.0, 0.0, 1.0)");
            }
        }
        root.replaceReferenceExpressions(aSTParser, "gl_NormalMatrix", "iris_NormalMatrix");
        translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "uniform mat3 iris_NormalMatrix;");
        translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "uniform mat4 iris_ModelViewMatrixInverse;");
        translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "uniform mat4 iris_ProjectionMatrixInverse;");
        root.rename("gl_ModelViewMatrix", "iris_ModelViewMatrix");
        root.rename("gl_ModelViewMatrixInverse", "iris_ModelViewMatrixInverse");
        root.rename("gl_ProjectionMatrixInverse", "iris_ProjectionMatrixInverse");
        if (sodiumParameters.type.glShaderType == ShaderType.VERTEX) {
            if (root.identifierIndex.has("ftransform")) {
                translationUnit.parseAndInjectNodes(aSTParser, ASTInjectionPoint.BEFORE_FUNCTIONS, new String[]{"vec4 ftransform() { return gl_ModelViewProjectionMatrix * gl_Vertex; }"});
            }
            translationUnit.parseAndInjectNodes(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, new String[]{"uniform mat4 iris_ProjectionMatrix;", "uniform mat4 iris_ModelViewMatrix;", "uniform vec3 u_RegionOffset;", "vec4 getVertexPosition() { return vec4(u_RegionOffset + Chunks[_draw_id].offset.xyz + _vert_position, 1.0); }"});
            root.replaceReferenceExpressions(aSTParser, "gl_Vertex", "getVertexPosition()");
            SodiumTransformer.injectVertInit(aSTParser, translationUnit, root, sodiumParameters);
        } else {
            translationUnit.parseAndInjectNodes(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, new String[]{"uniform mat4 iris_ModelViewMatrix;", "uniform mat4 iris_ProjectionMatrix;"});
        }
        root.replaceReferenceExpressions(aSTParser, "gl_ModelViewProjectionMatrix", "(iris_ProjectionMatrix * iris_ModelViewMatrix)");
        CommonTransformer.applyIntelHd4000Workaround(root);
    }

    public static void injectVertInit(ASTParser aSTParser, TranslationUnit translationUnit, Root root, SodiumParameters sodiumParameters) {
        translationUnit.parseAndInjectNodes(aSTParser, ASTInjectionPoint.BEFORE_FUNCTIONS, new String[]{"vec3 _vert_position;", "vec2 _vert_tex_diffuse_coord;", "ivec2 _vert_tex_light_coord;", "vec4 _vert_color;", "uint _draw_id;", "void _vert_init() {_vert_position = (a_PosId.xyz * " + sodiumParameters.positionScale + " + " + sodiumParameters.positionOffset + ");_vert_tex_diffuse_coord = (a_TexCoord * " + sodiumParameters.textureScale + ");_vert_tex_light_coord = a_LightCoord;_vert_color = a_Color;_draw_id = uint(a_PosId.w); }", "struct DrawParameters { vec4 offset; };", "layout(std140) uniform ubo_DrawParameters {DrawParameters Chunks[256]; };"});
        CommonTransformer.addIfNotExists(root, aSTParser, translationUnit, "a_PosId", Type.F32VEC4, StorageQualifier.StorageType.IN);
        CommonTransformer.addIfNotExists(root, aSTParser, translationUnit, "a_TexCoord", Type.F32VEC2, StorageQualifier.StorageType.IN);
        CommonTransformer.addIfNotExists(root, aSTParser, translationUnit, "a_Color", Type.F32VEC4, StorageQualifier.StorageType.IN);
        CommonTransformer.addIfNotExists(root, aSTParser, translationUnit, "a_LightCoord", Type.I32VEC2, StorageQualifier.StorageType.IN);
        translationUnit.prependMainFunctionBody(aSTParser, "_vert_init();");
    }

    public static void replaceMidTexCoord(ASTParser aSTParser, TranslationUnit translationUnit, Root root, float f) {
        Type type = Type.BOOL;
        for (Identifier identifier : root.identifierIndex.get("mc_midTexCoord")) {
            TypeSpecifier typeSpecifier;
            DeclarationExternalDeclaration declarationExternalDeclaration;
            TypeAndInitDeclaration typeAndInitDeclaration = (TypeAndInitDeclaration)identifier.getAncestor(2, 0, TypeAndInitDeclaration.class::isInstance);
            if (typeAndInitDeclaration == null || (declarationExternalDeclaration = (DeclarationExternalDeclaration)typeAndInitDeclaration.getAncestor(1, 0, DeclarationExternalDeclaration.class::isInstance)) == null || !((typeSpecifier = typeAndInitDeclaration.getType().getTypeSpecifier()) instanceof BuiltinNumericTypeSpecifier)) continue;
            BuiltinNumericTypeSpecifier builtinNumericTypeSpecifier = (BuiltinNumericTypeSpecifier)typeSpecifier;
            type = builtinNumericTypeSpecifier.type;
            declarationExternalDeclaration.detachAndDelete();
            typeAndInitDeclaration.detachAndDelete();
            identifier.detachAndDelete();
            break;
        }
        root.replaceReferenceExpressions(aSTParser, "mc_midTexCoord", "iris_MidTex");
        switch (type) {
            case BOOL: {
                return;
            }
            case FLOAT32: {
                translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "float iris_MidTex = (mc_midTexCoord.x * " + f + ").x;");
                break;
            }
            case F32VEC2: {
                translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "vec2 iris_MidTex = (mc_midTexCoord.xy * " + f + ").xy;");
                break;
            }
            case F32VEC3: {
                translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "vec3 iris_MidTex = vec3(mc_midTexCoord.xy * " + f + ", 0.0);");
                break;
            }
            case F32VEC4: {
                translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "vec4 iris_MidTex = vec4(mc_midTexCoord.xy * " + f + ", 0.0, 1.0);");
                break;
            }
            default: {
                throw new IllegalStateException("Somehow got a midTexCoord that is *above* 4 dimensions???");
            }
        }
        translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "in vec2 mc_midTexCoord;");
    }
}

