/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shadows;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.coderbot.iris.features.FeatureFlags;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.image.GlImage;
import net.coderbot.iris.gl.program.ComputeProgram;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.gl.sampler.SamplerHolder;
import net.coderbot.iris.gl.texture.TextureAccess;
import net.coderbot.iris.pipeline.ShaderPrinter;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.TransformPatcher;
import net.coderbot.iris.postprocess.FullScreenQuadRenderer;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.samplers.IrisImages;
import net.coderbot.iris.samplers.IrisSamplers;
import net.coderbot.iris.shaderpack.ComputeSource;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.ProgramDirectives;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.uniforms.custom.CustomUniforms;
import net.minecraft.class_276;
import net.minecraft.class_310;

public class ShadowCompositeRenderer {
    private final ShadowRenderTargets renderTargets;
    private final ImmutableList<Pass> passes;
    private final TextureAccess noiseTexture;
    private final FrameUpdateNotifier updateNotifier;
    private final Object2ObjectMap<String, TextureAccess> customTextureIds;
    private final ImmutableSet<Integer> flippedAtLeastOnceFinal;
    private final CustomUniforms customUniforms;
    private final Object2ObjectMap<String, TextureAccess> irisCustomTextures;
    private final WorldRenderingPipeline pipeline;
    private final Set<GlImage> irisCustomImages;

    public ShadowCompositeRenderer(WorldRenderingPipeline worldRenderingPipeline, PackDirectives packDirectives, ProgramSource[] programSourceArray, ComputeSource[][] computeSourceArray, ShadowRenderTargets shadowRenderTargets, TextureAccess textureAccess, FrameUpdateNotifier frameUpdateNotifier, Object2ObjectMap<String, TextureAccess> object2ObjectMap, Set<GlImage> set, ImmutableMap<Integer, Boolean> immutableMap, Object2ObjectMap<String, TextureAccess> object2ObjectMap2, CustomUniforms customUniforms) {
        this.pipeline = worldRenderingPipeline;
        this.noiseTexture = textureAccess;
        this.updateNotifier = frameUpdateNotifier;
        this.renderTargets = shadowRenderTargets;
        this.customTextureIds = object2ObjectMap;
        this.irisCustomTextures = object2ObjectMap2;
        this.irisCustomImages = set;
        this.customUniforms = customUniforms;
        PackRenderTargetDirectives packRenderTargetDirectives = packDirectives.getRenderTargetDirectives();
        Map<Integer, PackRenderTargetDirectives.RenderTargetSettings> map = packRenderTargetDirectives.getRenderTargetSettings();
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableSet.Builder builder2 = new ImmutableSet.Builder();
        immutableMap.forEach((n, bl) -> {
            if (bl.booleanValue()) {
                shadowRenderTargets.flip((int)n);
            }
        });
        int n2 = programSourceArray.length;
        for (int i = 0; i < n2; ++i) {
            int[] nArray;
            Pass pass;
            ProgramSource programSource = programSourceArray[i];
            ImmutableSet<Integer> immutableSet = shadowRenderTargets.snapshot();
            ImmutableSet immutableSet2 = builder2.build();
            if (programSource == null || !programSource.isValid()) {
                if (computeSourceArray[i] == null) continue;
                pass = new ComputeOnlyPass();
                ((ComputeOnlyPass)pass).computes = this.createComputes(computeSourceArray[i], immutableSet, (ImmutableSet<Integer>)immutableSet2, shadowRenderTargets);
                builder.add((Object)pass);
                continue;
            }
            pass = new Pass();
            ProgramDirectives programDirectives = programSource.getDirectives();
            pass.program = this.createProgram(programSource, immutableSet, (ImmutableSet<Integer>)immutableSet2, shadowRenderTargets);
            pass.computes = this.createComputes(computeSourceArray[i], immutableSet, (ImmutableSet<Integer>)immutableSet2, shadowRenderTargets);
            if (programSource.getDirectives().hasUnknownDrawBuffers()) {
                int[] nArray2 = new int[2];
                nArray2[0] = 0;
                nArray = nArray2;
                nArray2[1] = 1;
            } else {
                nArray = programSource.getDirectives().getDrawBuffers();
            }
            int[] nArray3 = nArray;
            GlFramebuffer glFramebuffer = shadowRenderTargets.createColorFramebuffer(immutableSet, nArray3);
            pass.stageReadsFromAlt = immutableSet;
            pass.framebuffer = glFramebuffer;
            pass.viewportScale = programDirectives.getViewportScale();
            pass.mipmappedBuffers = programDirectives.getMipmappedBuffers();
            pass.flippedAtLeastOnce = immutableSet2;
            builder.add((Object)pass);
            ImmutableMap<Integer, Boolean> immutableMap2 = programDirectives.getExplicitFlips();
            for (int n3 : nArray3) {
                if (immutableMap2.get((Object)n3) == Boolean.FALSE) continue;
                shadowRenderTargets.flip(n3);
                builder2.add((Object)n3);
            }
            immutableMap2.forEach((n, bl) -> {
                if (bl.booleanValue()) {
                    shadowRenderTargets.flip((int)n);
                    builder2.add(n);
                }
            });
        }
        this.passes = builder.build();
        this.flippedAtLeastOnceFinal = builder2.build();
        GlStateManager._glBindFramebuffer((int)36008, (int)0);
    }

    public ImmutableSet<Integer> getFlippedAtLeastOnceFinal() {
        return this.flippedAtLeastOnceFinal;
    }

    public void renderAll() {
        RenderSystem.disableBlend();
        FullScreenQuadRenderer.INSTANCE.begin();
        for (Pass pass : this.passes) {
            boolean bl = false;
            for (ComputeProgram computeProgram : pass.computes) {
                if (computeProgram == null) continue;
                bl = true;
                computeProgram.use();
                this.customUniforms.push(computeProgram);
                class_276 class_2762 = class_310.method_1551().method_1522();
                computeProgram.dispatch(class_2762.field_1482, class_2762.field_1481);
            }
            if (bl) {
                IrisRenderSystem.memoryBarrier(8232);
            }
            Program.unbind();
            if (pass instanceof ComputeOnlyPass) continue;
            if (!pass.mipmappedBuffers.isEmpty()) {
                RenderSystem.activeTexture((int)33984);
                UnmodifiableIterator unmodifiableIterator = pass.mipmappedBuffers.iterator();
                while (unmodifiableIterator.hasNext()) {
                    int n = (Integer)unmodifiableIterator.next();
                    ShadowCompositeRenderer.setupMipmapping(this.renderTargets.get(n), pass.stageReadsFromAlt.contains((Object)n));
                }
            }
            float f = (float)this.renderTargets.getResolution() * pass.viewportScale;
            float f2 = (float)this.renderTargets.getResolution() * pass.viewportScale;
            RenderSystem.viewport((int)0, (int)0, (int)((int)f), (int)((int)f2));
            pass.framebuffer.bind();
            pass.program.use();
            this.customUniforms.push(pass.program);
            FullScreenQuadRenderer.INSTANCE.renderQuad();
        }
        FullScreenQuadRenderer.INSTANCE.end();
        ProgramUniforms.clearActiveUniforms();
        GlStateManager._glUseProgram((int)0);
        for (int i = 0; i < this.renderTargets.getRenderTargetCount(); ++i) {
            if (this.renderTargets.get(i) == null) continue;
            ShadowCompositeRenderer.resetRenderTarget(this.renderTargets.get(i));
        }
        RenderSystem.activeTexture((int)33984);
    }

    private static void setupMipmapping(RenderTarget renderTarget, boolean bl) {
        int n = bl ? renderTarget.getAltTexture() : renderTarget.getMainTexture();
        IrisRenderSystem.generateMipmaps(n, 3553);
        IrisRenderSystem.texParameteri(n, 3553, 10241, renderTarget.getInternalFormat().getPixelFormat().isInteger() ? 9984 : 9987);
    }

    private static void resetRenderTarget(RenderTarget renderTarget) {
        int n = 9729;
        if (renderTarget.getInternalFormat().getPixelFormat().isInteger()) {
            n = 9728;
        }
        IrisRenderSystem.texParameteri(renderTarget.getMainTexture(), 3553, 10241, n);
        IrisRenderSystem.texParameteri(renderTarget.getAltTexture(), 3553, 10241, n);
    }

    private Program createProgram(ProgramSource programSource, ImmutableSet<Integer> immutableSet, ImmutableSet<Integer> immutableSet2, ShadowRenderTargets shadowRenderTargets) {
        ProgramBuilder programBuilder;
        Map<PatchShaderType, String> map = TransformPatcher.patchComposite(programSource.getVertexSource().orElseThrow(NullPointerException::new), programSource.getGeometrySource().orElse(null), programSource.getFragmentSource().orElseThrow(NullPointerException::new), TextureStage.SHADOWCOMP, this.pipeline.getTextureMap());
        String string = map.get((Object)PatchShaderType.VERTEX);
        String string2 = map.get((Object)PatchShaderType.GEOMETRY);
        String string3 = map.get((Object)PatchShaderType.FRAGMENT);
        ShaderPrinter.printProgram(programSource.getName()).addSources(map).print();
        Objects.requireNonNull(immutableSet);
        try {
            programBuilder = ProgramBuilder.begin(programSource.getName(), string, string2, string3, IrisSamplers.COMPOSITE_RESERVED_TEXTURE_UNITS);
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("Shader compilation failed for shadow composite " + programSource.getName() + "!", runtimeException);
        }
        ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(programBuilder, this.customTextureIds, immutableSet2);
        CommonUniforms.addDynamicUniforms(programBuilder, FogMode.OFF);
        this.customUniforms.assignTo(programBuilder);
        IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.noiseTexture);
        IrisSamplers.addCustomTextures(customTextureSamplerInterceptor, this.irisCustomTextures);
        IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, shadowRenderTargets, immutableSet, this.pipeline.hasFeature(FeatureFlags.SEPARATE_HARDWARE_SAMPLERS));
        IrisImages.addShadowColorImages(programBuilder, shadowRenderTargets, immutableSet);
        IrisImages.addCustomImages(programBuilder, this.irisCustomImages);
        IrisSamplers.addCustomImages(programBuilder, this.irisCustomImages);
        Program program = programBuilder.build();
        this.customUniforms.mapholderToPass(programBuilder, program);
        return program;
    }

    private ComputeProgram[] createComputes(ComputeSource[] computeSourceArray, ImmutableSet<Integer> immutableSet, ImmutableSet<Integer> immutableSet2, ShadowRenderTargets shadowRenderTargets) {
        ComputeProgram[] computeProgramArray = new ComputeProgram[computeSourceArray.length];
        for (int i = 0; i < computeProgramArray.length; ++i) {
            ProgramBuilder programBuilder;
            Object object;
            ComputeSource computeSource = computeSourceArray[i];
            if (computeSource == null || !computeSource.getSource().isPresent()) continue;
            Objects.requireNonNull(immutableSet);
            try {
                object = TransformPatcher.patchCompute(computeSource.getSource().orElse(null), TextureStage.SHADOWCOMP, this.pipeline.getTextureMap());
                ShaderPrinter.printProgram(computeSource.getName()).addSource(PatchShaderType.COMPUTE, (String)object).print();
                programBuilder = ProgramBuilder.beginCompute(computeSource.getName(), (String)object, IrisSamplers.COMPOSITE_RESERVED_TEXTURE_UNITS);
            }
            catch (RuntimeException runtimeException) {
                throw new RuntimeException("Shader compilation failed for shadowcomp compute " + computeSource.getName() + "!", runtimeException);
            }
            object = ProgramSamplers.customTextureSamplerInterceptor(programBuilder, this.customTextureIds, immutableSet2);
            CommonUniforms.addDynamicUniforms(programBuilder, FogMode.OFF);
            this.customUniforms.assignTo(programBuilder);
            IrisSamplers.addNoiseSampler((SamplerHolder)object, this.noiseTexture);
            IrisSamplers.addCustomTextures((SamplerHolder)object, this.irisCustomTextures);
            IrisSamplers.addShadowSamplers((SamplerHolder)object, shadowRenderTargets, immutableSet, this.pipeline.hasFeature(FeatureFlags.SEPARATE_HARDWARE_SAMPLERS));
            IrisImages.addShadowColorImages(programBuilder, shadowRenderTargets, immutableSet);
            IrisImages.addCustomImages(programBuilder, this.irisCustomImages);
            IrisSamplers.addCustomImages(programBuilder, this.irisCustomImages);
            computeProgramArray[i] = programBuilder.buildCompute();
            this.customUniforms.mapholderToPass(programBuilder, computeProgramArray[i]);
            computeProgramArray[i].setWorkGroupInfo(computeSource.getWorkGroupRelative(), computeSource.getWorkGroups());
        }
        return computeProgramArray;
    }

    public void destroy() {
        for (Pass pass : this.passes) {
            pass.destroy();
        }
    }

    private static class ComputeOnlyPass
    extends Pass {
        private ComputeOnlyPass() {
        }

        @Override
        protected void destroy() {
            for (ComputeProgram computeProgram : this.computes) {
                if (computeProgram == null) continue;
                computeProgram.destroy();
            }
        }
    }

    private static class Pass {
        Program program;
        GlFramebuffer framebuffer;
        ImmutableSet<Integer> flippedAtLeastOnce;
        ImmutableSet<Integer> stageReadsFromAlt;
        ImmutableSet<Integer> mipmappedBuffers;
        float viewportScale;
        ComputeProgram[] computes;

        private Pass() {
        }

        protected void destroy() {
            this.program.destroy();
            for (ComputeProgram computeProgram : this.computes) {
                if (computeProgram == null) continue;
                computeProgram.destroy();
            }
        }
    }
}

