/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.vendored.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import net.coderbot.iris.vendored.joml.AxisAngle4d;
import net.coderbot.iris.vendored.joml.AxisAngle4f;
import net.coderbot.iris.vendored.joml.Math;
import net.coderbot.iris.vendored.joml.Matrix3f;
import net.coderbot.iris.vendored.joml.Matrix3fc;
import net.coderbot.iris.vendored.joml.Matrix4d;
import net.coderbot.iris.vendored.joml.Matrix4f;
import net.coderbot.iris.vendored.joml.Matrix4fc;
import net.coderbot.iris.vendored.joml.Matrix4x3d;
import net.coderbot.iris.vendored.joml.Matrix4x3fc;
import net.coderbot.iris.vendored.joml.MemUtil;
import net.coderbot.iris.vendored.joml.Quaterniond;
import net.coderbot.iris.vendored.joml.Quaterniondc;
import net.coderbot.iris.vendored.joml.Quaternionf;
import net.coderbot.iris.vendored.joml.Quaternionfc;
import net.coderbot.iris.vendored.joml.Runtime;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vendored.joml.Vector3fc;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.coderbot.iris.vendored.joml.Vector4fc;

public class Matrix4x3f
implements Externalizable,
Cloneable,
Matrix4x3fc {
    private static final long serialVersionUID = 1L;
    float m00;
    float m01;
    float m02;
    float m10;
    float m11;
    float m12;
    float m20;
    float m21;
    float m22;
    float m30;
    float m31;
    float m32;
    int properties;

    public Matrix4x3f() {
        this.m00 = 1.0f;
        this.m11 = 1.0f;
        this.m22 = 1.0f;
        this.properties = 28;
    }

    public Matrix4x3f(Matrix3fc matrix3fc) {
        this.set(matrix3fc);
    }

    public Matrix4x3f(Matrix4x3fc matrix4x3fc) {
        this.set(matrix4x3fc);
    }

    public Matrix4x3f(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.m00 = f;
        this.m01 = f2;
        this.m02 = f3;
        this.m10 = f4;
        this.m11 = f5;
        this.m12 = f6;
        this.m20 = f7;
        this.m21 = f8;
        this.m22 = f9;
        this.m30 = f10;
        this.m31 = f11;
        this.m32 = f12;
        this.determineProperties();
    }

    public Matrix4x3f(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, floatBuffer.position(), floatBuffer);
        this.determineProperties();
    }

    public Matrix4x3f(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, Vector3fc vector3fc4) {
        this.set(vector3fc, vector3fc2, vector3fc3, vector3fc4).determineProperties();
    }

    public Matrix4x3f assume(int n) {
        this.properties = n;
        return this;
    }

    public Matrix4x3f determineProperties() {
        int n = 0;
        if (this.m00 == 1.0f && this.m01 == 0.0f && this.m02 == 0.0f && this.m10 == 0.0f && this.m11 == 1.0f && this.m12 == 0.0f && this.m20 == 0.0f && this.m21 == 0.0f && this.m22 == 1.0f) {
            n |= 0x18;
            if (this.m30 == 0.0f && this.m31 == 0.0f && this.m32 == 0.0f) {
                n |= 4;
            }
        }
        this.properties = n;
        return this;
    }

    @Override
    public int properties() {
        return this.properties;
    }

    @Override
    public float m00() {
        return this.m00;
    }

    @Override
    public float m01() {
        return this.m01;
    }

    @Override
    public float m02() {
        return this.m02;
    }

    @Override
    public float m10() {
        return this.m10;
    }

    @Override
    public float m11() {
        return this.m11;
    }

    @Override
    public float m12() {
        return this.m12;
    }

    @Override
    public float m20() {
        return this.m20;
    }

    @Override
    public float m21() {
        return this.m21;
    }

    @Override
    public float m22() {
        return this.m22;
    }

    @Override
    public float m30() {
        return this.m30;
    }

    @Override
    public float m31() {
        return this.m31;
    }

    @Override
    public float m32() {
        return this.m32;
    }

    public Matrix4x3f m00(float f) {
        this.m00 = f;
        this.properties &= 0xFFFFFFEF;
        if (f != 1.0f) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3f m01(float f) {
        this.m01 = f;
        this.properties &= 0xFFFFFFEF;
        if (f != 0.0f) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3f m02(float f) {
        this.m02 = f;
        this.properties &= 0xFFFFFFEF;
        if (f != 0.0f) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3f m10(float f) {
        this.m10 = f;
        this.properties &= 0xFFFFFFEF;
        if (f != 0.0f) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3f m11(float f) {
        this.m11 = f;
        this.properties &= 0xFFFFFFEF;
        if (f != 1.0f) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3f m12(float f) {
        this.m12 = f;
        this.properties &= 0xFFFFFFEF;
        if (f != 0.0f) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3f m20(float f) {
        this.m20 = f;
        this.properties &= 0xFFFFFFEF;
        if (f != 0.0f) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3f m21(float f) {
        this.m21 = f;
        this.properties &= 0xFFFFFFEF;
        if (f != 0.0f) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3f m22(float f) {
        this.m22 = f;
        this.properties &= 0xFFFFFFEF;
        if (f != 1.0f) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3f m30(float f) {
        this.m30 = f;
        if (f != 0.0f) {
            this.properties &= 0xFFFFFFFB;
        }
        return this;
    }

    public Matrix4x3f m31(float f) {
        this.m31 = f;
        if (f != 0.0f) {
            this.properties &= 0xFFFFFFFB;
        }
        return this;
    }

    public Matrix4x3f m32(float f) {
        this.m32 = f;
        if (f != 0.0f) {
            this.properties &= 0xFFFFFFFB;
        }
        return this;
    }

    Matrix4x3f _properties(int n) {
        this.properties = n;
        return this;
    }

    Matrix4x3f _m00(float f) {
        this.m00 = f;
        return this;
    }

    Matrix4x3f _m01(float f) {
        this.m01 = f;
        return this;
    }

    Matrix4x3f _m02(float f) {
        this.m02 = f;
        return this;
    }

    Matrix4x3f _m10(float f) {
        this.m10 = f;
        return this;
    }

    Matrix4x3f _m11(float f) {
        this.m11 = f;
        return this;
    }

    Matrix4x3f _m12(float f) {
        this.m12 = f;
        return this;
    }

    Matrix4x3f _m20(float f) {
        this.m20 = f;
        return this;
    }

    Matrix4x3f _m21(float f) {
        this.m21 = f;
        return this;
    }

    Matrix4x3f _m22(float f) {
        this.m22 = f;
        return this;
    }

    Matrix4x3f _m30(float f) {
        this.m30 = f;
        return this;
    }

    Matrix4x3f _m31(float f) {
        this.m31 = f;
        return this;
    }

    Matrix4x3f _m32(float f) {
        this.m32 = f;
        return this;
    }

    public Matrix4x3f identity() {
        if ((this.properties & 4) != 0) {
            return this;
        }
        MemUtil.INSTANCE.identity(this);
        this.properties = 28;
        return this;
    }

    public Matrix4x3f set(Matrix4x3fc matrix4x3fc) {
        this.m00 = matrix4x3fc.m00();
        this.m01 = matrix4x3fc.m01();
        this.m02 = matrix4x3fc.m02();
        this.m10 = matrix4x3fc.m10();
        this.m11 = matrix4x3fc.m11();
        this.m12 = matrix4x3fc.m12();
        this.m20 = matrix4x3fc.m20();
        this.m21 = matrix4x3fc.m21();
        this.m22 = matrix4x3fc.m22();
        this.m30 = matrix4x3fc.m30();
        this.m31 = matrix4x3fc.m31();
        this.m32 = matrix4x3fc.m32();
        this.properties = matrix4x3fc.properties();
        return this;
    }

    public Matrix4x3f set(Matrix4fc matrix4fc) {
        this.m00 = matrix4fc.m00();
        this.m01 = matrix4fc.m01();
        this.m02 = matrix4fc.m02();
        this.m10 = matrix4fc.m10();
        this.m11 = matrix4fc.m11();
        this.m12 = matrix4fc.m12();
        this.m20 = matrix4fc.m20();
        this.m21 = matrix4fc.m21();
        this.m22 = matrix4fc.m22();
        this.m30 = matrix4fc.m30();
        this.m31 = matrix4fc.m31();
        this.m32 = matrix4fc.m32();
        this.properties = matrix4fc.properties() & 0x1C;
        return this;
    }

    @Override
    public Matrix4f get(Matrix4f matrix4f) {
        return matrix4f.set4x3(this);
    }

    @Override
    public Matrix4d get(Matrix4d matrix4d) {
        return matrix4d.set4x3(this);
    }

    public Matrix4x3f set(Matrix3fc matrix3fc) {
        this.m00 = matrix3fc.m00();
        this.m01 = matrix3fc.m01();
        this.m02 = matrix3fc.m02();
        this.m10 = matrix3fc.m10();
        this.m11 = matrix3fc.m11();
        this.m12 = matrix3fc.m12();
        this.m20 = matrix3fc.m20();
        this.m21 = matrix3fc.m21();
        this.m22 = matrix3fc.m22();
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        return this.determineProperties();
    }

    public Matrix4x3f set(AxisAngle4f axisAngle4f) {
        float f = axisAngle4f.x;
        float f2 = axisAngle4f.y;
        float f3 = axisAngle4f.z;
        float f4 = axisAngle4f.angle;
        float f5 = Math.sqrt(f * f + f2 * f2 + f3 * f3);
        f5 = 1.0f / f5;
        f *= f5;
        f2 *= f5;
        f3 *= f5;
        float f6 = Math.sin(f4);
        float f7 = Math.cosFromSin(f6, f4);
        float f8 = 1.0f - f7;
        this.m00 = f7 + f * f * f8;
        this.m11 = f7 + f2 * f2 * f8;
        this.m22 = f7 + f3 * f3 * f8;
        float f9 = f * f2 * f8;
        float f10 = f3 * f6;
        this.m10 = f9 - f10;
        this.m01 = f9 + f10;
        f9 = f * f3 * f8;
        f10 = f2 * f6;
        this.m20 = f9 + f10;
        this.m02 = f9 - f10;
        f9 = f2 * f3 * f8;
        f10 = f * f6;
        this.m21 = f9 - f10;
        this.m12 = f9 + f10;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f set(AxisAngle4d axisAngle4d) {
        double d = axisAngle4d.x;
        double d2 = axisAngle4d.y;
        double d3 = axisAngle4d.z;
        double d4 = axisAngle4d.angle;
        double d5 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        d5 = 1.0 / d5;
        d *= d5;
        d2 *= d5;
        d3 *= d5;
        double d6 = Math.sin(d4);
        double d7 = Math.cosFromSin(d6, d4);
        double d8 = 1.0 - d7;
        this.m00 = (float)(d7 + d * d * d8);
        this.m11 = (float)(d7 + d2 * d2 * d8);
        this.m22 = (float)(d7 + d3 * d3 * d8);
        double d9 = d * d2 * d8;
        double d10 = d3 * d6;
        this.m10 = (float)(d9 - d10);
        this.m01 = (float)(d9 + d10);
        d9 = d * d3 * d8;
        d10 = d2 * d6;
        this.m20 = (float)(d9 + d10);
        this.m02 = (float)(d9 - d10);
        d9 = d2 * d3 * d8;
        d10 = d * d6;
        this.m21 = (float)(d9 - d10);
        this.m12 = (float)(d9 + d10);
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f set(Quaternionfc quaternionfc) {
        return this.rotation(quaternionfc);
    }

    public Matrix4x3f set(Quaterniondc quaterniondc) {
        double d = quaterniondc.w() * quaterniondc.w();
        double d2 = quaterniondc.x() * quaterniondc.x();
        double d3 = quaterniondc.y() * quaterniondc.y();
        double d4 = quaterniondc.z() * quaterniondc.z();
        double d5 = quaterniondc.z() * quaterniondc.w();
        double d6 = quaterniondc.x() * quaterniondc.y();
        double d7 = quaterniondc.x() * quaterniondc.z();
        double d8 = quaterniondc.y() * quaterniondc.w();
        double d9 = quaterniondc.y() * quaterniondc.z();
        double d10 = quaterniondc.x() * quaterniondc.w();
        this.m00 = (float)(d + d2 - d4 - d3);
        this.m01 = (float)(d6 + d5 + d5 + d6);
        this.m02 = (float)(d7 - d8 + d7 - d8);
        this.m10 = (float)(-d5 + d6 - d5 + d6);
        this.m11 = (float)(d3 - d4 + d - d2);
        this.m12 = (float)(d9 + d9 + d10 + d10);
        this.m20 = (float)(d8 + d7 + d7 + d8);
        this.m21 = (float)(d9 + d9 - d10 - d10);
        this.m22 = (float)(d4 - d3 - d2 + d);
        this.properties = 16;
        return this;
    }

    public Matrix4x3f set(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, Vector3fc vector3fc4) {
        this.m00 = vector3fc.x();
        this.m01 = vector3fc.y();
        this.m02 = vector3fc.z();
        this.m10 = vector3fc2.x();
        this.m11 = vector3fc2.y();
        this.m12 = vector3fc2.z();
        this.m20 = vector3fc3.x();
        this.m21 = vector3fc3.y();
        this.m22 = vector3fc3.z();
        this.m30 = vector3fc4.x();
        this.m31 = vector3fc4.y();
        this.m32 = vector3fc4.z();
        return this.determineProperties();
    }

    public Matrix4x3f set3x3(Matrix4x3fc matrix4x3fc) {
        this.m00 = matrix4x3fc.m00();
        this.m01 = matrix4x3fc.m01();
        this.m02 = matrix4x3fc.m02();
        this.m10 = matrix4x3fc.m10();
        this.m11 = matrix4x3fc.m11();
        this.m12 = matrix4x3fc.m12();
        this.m20 = matrix4x3fc.m20();
        this.m21 = matrix4x3fc.m21();
        this.m22 = matrix4x3fc.m22();
        this.properties &= matrix4x3fc.properties();
        return this;
    }

    public Matrix4x3f mul(Matrix4x3fc matrix4x3fc) {
        return this.mul(matrix4x3fc, this);
    }

    @Override
    public Matrix4x3f mul(Matrix4x3fc matrix4x3fc, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.set(matrix4x3fc);
        }
        if ((matrix4x3fc.properties() & 4) != 0) {
            return matrix4x3f.set(this);
        }
        if ((this.properties & 8) != 0) {
            return this.mulTranslation(matrix4x3fc, matrix4x3f);
        }
        return this.mulGeneric(matrix4x3fc, matrix4x3f);
    }

    private Matrix4x3f mulGeneric(Matrix4x3fc matrix4x3fc, Matrix4x3f matrix4x3f) {
        float f = this.m00;
        float f2 = this.m01;
        float f3 = this.m02;
        float f4 = this.m10;
        float f5 = this.m11;
        float f6 = this.m12;
        float f7 = this.m20;
        float f8 = this.m21;
        float f9 = this.m22;
        float f10 = matrix4x3fc.m00();
        float f11 = matrix4x3fc.m01();
        float f12 = matrix4x3fc.m02();
        float f13 = matrix4x3fc.m10();
        float f14 = matrix4x3fc.m11();
        float f15 = matrix4x3fc.m12();
        float f16 = matrix4x3fc.m20();
        float f17 = matrix4x3fc.m21();
        float f18 = matrix4x3fc.m22();
        float f19 = matrix4x3fc.m30();
        float f20 = matrix4x3fc.m31();
        float f21 = matrix4x3fc.m32();
        return matrix4x3f._m00(Math.fma(f, f10, Math.fma(f4, f11, f7 * f12)))._m01(Math.fma(f2, f10, Math.fma(f5, f11, f8 * f12)))._m02(Math.fma(f3, f10, Math.fma(f6, f11, f9 * f12)))._m10(Math.fma(f, f13, Math.fma(f4, f14, f7 * f15)))._m11(Math.fma(f2, f13, Math.fma(f5, f14, f8 * f15)))._m12(Math.fma(f3, f13, Math.fma(f6, f14, f9 * f15)))._m20(Math.fma(f, f16, Math.fma(f4, f17, f7 * f18)))._m21(Math.fma(f2, f16, Math.fma(f5, f17, f8 * f18)))._m22(Math.fma(f3, f16, Math.fma(f6, f17, f9 * f18)))._m30(Math.fma(f, f19, Math.fma(f4, f20, Math.fma(f7, f21, this.m30))))._m31(Math.fma(f2, f19, Math.fma(f5, f20, Math.fma(f8, f21, this.m31))))._m32(Math.fma(f3, f19, Math.fma(f6, f20, Math.fma(f9, f21, this.m32))))._properties(this.properties & matrix4x3fc.properties() & 0x10);
    }

    @Override
    public Matrix4x3f mulTranslation(Matrix4x3fc matrix4x3fc, Matrix4x3f matrix4x3f) {
        return matrix4x3f._m00(matrix4x3fc.m00())._m01(matrix4x3fc.m01())._m02(matrix4x3fc.m02())._m10(matrix4x3fc.m10())._m11(matrix4x3fc.m11())._m12(matrix4x3fc.m12())._m20(matrix4x3fc.m20())._m21(matrix4x3fc.m21())._m22(matrix4x3fc.m22())._m30(matrix4x3fc.m30() + this.m30)._m31(matrix4x3fc.m31() + this.m31)._m32(matrix4x3fc.m32() + this.m32)._properties(matrix4x3fc.properties() & 0x10);
    }

    public Matrix4x3f mulOrtho(Matrix4x3fc matrix4x3fc) {
        return this.mulOrtho(matrix4x3fc, this);
    }

    @Override
    public Matrix4x3f mulOrtho(Matrix4x3fc matrix4x3fc, Matrix4x3f matrix4x3f) {
        float f = this.m00 * matrix4x3fc.m00();
        float f2 = this.m11 * matrix4x3fc.m01();
        float f3 = this.m22 * matrix4x3fc.m02();
        float f4 = this.m00 * matrix4x3fc.m10();
        float f5 = this.m11 * matrix4x3fc.m11();
        float f6 = this.m22 * matrix4x3fc.m12();
        float f7 = this.m00 * matrix4x3fc.m20();
        float f8 = this.m11 * matrix4x3fc.m21();
        float f9 = this.m22 * matrix4x3fc.m22();
        float f10 = this.m00 * matrix4x3fc.m30() + this.m30;
        float f11 = this.m11 * matrix4x3fc.m31() + this.m31;
        float f12 = this.m22 * matrix4x3fc.m32() + this.m32;
        matrix4x3f.m00 = f;
        matrix4x3f.m01 = f2;
        matrix4x3f.m02 = f3;
        matrix4x3f.m10 = f4;
        matrix4x3f.m11 = f5;
        matrix4x3f.m12 = f6;
        matrix4x3f.m20 = f7;
        matrix4x3f.m21 = f8;
        matrix4x3f.m22 = f9;
        matrix4x3f.m30 = f10;
        matrix4x3f.m31 = f11;
        matrix4x3f.m32 = f12;
        matrix4x3f.properties = this.properties & matrix4x3fc.properties() & 0x10;
        return matrix4x3f;
    }

    public Matrix4x3f fma(Matrix4x3fc matrix4x3fc, float f) {
        return this.fma(matrix4x3fc, f, this);
    }

    @Override
    public Matrix4x3f fma(Matrix4x3fc matrix4x3fc, float f, Matrix4x3f matrix4x3f) {
        matrix4x3f._m00(Math.fma(matrix4x3fc.m00(), f, this.m00))._m01(Math.fma(matrix4x3fc.m01(), f, this.m01))._m02(Math.fma(matrix4x3fc.m02(), f, this.m02))._m10(Math.fma(matrix4x3fc.m10(), f, this.m10))._m11(Math.fma(matrix4x3fc.m11(), f, this.m11))._m12(Math.fma(matrix4x3fc.m12(), f, this.m12))._m20(Math.fma(matrix4x3fc.m20(), f, this.m20))._m21(Math.fma(matrix4x3fc.m21(), f, this.m21))._m22(Math.fma(matrix4x3fc.m22(), f, this.m22))._m30(Math.fma(matrix4x3fc.m30(), f, this.m30))._m31(Math.fma(matrix4x3fc.m31(), f, this.m31))._m32(Math.fma(matrix4x3fc.m32(), f, this.m32))._properties(0);
        return matrix4x3f;
    }

    public Matrix4x3f add(Matrix4x3fc matrix4x3fc) {
        return this.add(matrix4x3fc, this);
    }

    @Override
    public Matrix4x3f add(Matrix4x3fc matrix4x3fc, Matrix4x3f matrix4x3f) {
        matrix4x3f.m00 = this.m00 + matrix4x3fc.m00();
        matrix4x3f.m01 = this.m01 + matrix4x3fc.m01();
        matrix4x3f.m02 = this.m02 + matrix4x3fc.m02();
        matrix4x3f.m10 = this.m10 + matrix4x3fc.m10();
        matrix4x3f.m11 = this.m11 + matrix4x3fc.m11();
        matrix4x3f.m12 = this.m12 + matrix4x3fc.m12();
        matrix4x3f.m20 = this.m20 + matrix4x3fc.m20();
        matrix4x3f.m21 = this.m21 + matrix4x3fc.m21();
        matrix4x3f.m22 = this.m22 + matrix4x3fc.m22();
        matrix4x3f.m30 = this.m30 + matrix4x3fc.m30();
        matrix4x3f.m31 = this.m31 + matrix4x3fc.m31();
        matrix4x3f.m32 = this.m32 + matrix4x3fc.m32();
        matrix4x3f.properties = 0;
        return matrix4x3f;
    }

    public Matrix4x3f sub(Matrix4x3fc matrix4x3fc) {
        return this.sub(matrix4x3fc, this);
    }

    @Override
    public Matrix4x3f sub(Matrix4x3fc matrix4x3fc, Matrix4x3f matrix4x3f) {
        matrix4x3f.m00 = this.m00 - matrix4x3fc.m00();
        matrix4x3f.m01 = this.m01 - matrix4x3fc.m01();
        matrix4x3f.m02 = this.m02 - matrix4x3fc.m02();
        matrix4x3f.m10 = this.m10 - matrix4x3fc.m10();
        matrix4x3f.m11 = this.m11 - matrix4x3fc.m11();
        matrix4x3f.m12 = this.m12 - matrix4x3fc.m12();
        matrix4x3f.m20 = this.m20 - matrix4x3fc.m20();
        matrix4x3f.m21 = this.m21 - matrix4x3fc.m21();
        matrix4x3f.m22 = this.m22 - matrix4x3fc.m22();
        matrix4x3f.m30 = this.m30 - matrix4x3fc.m30();
        matrix4x3f.m31 = this.m31 - matrix4x3fc.m31();
        matrix4x3f.m32 = this.m32 - matrix4x3fc.m32();
        matrix4x3f.properties = 0;
        return matrix4x3f;
    }

    public Matrix4x3f mulComponentWise(Matrix4x3fc matrix4x3fc) {
        return this.mulComponentWise(matrix4x3fc, this);
    }

    @Override
    public Matrix4x3f mulComponentWise(Matrix4x3fc matrix4x3fc, Matrix4x3f matrix4x3f) {
        matrix4x3f.m00 = this.m00 * matrix4x3fc.m00();
        matrix4x3f.m01 = this.m01 * matrix4x3fc.m01();
        matrix4x3f.m02 = this.m02 * matrix4x3fc.m02();
        matrix4x3f.m10 = this.m10 * matrix4x3fc.m10();
        matrix4x3f.m11 = this.m11 * matrix4x3fc.m11();
        matrix4x3f.m12 = this.m12 * matrix4x3fc.m12();
        matrix4x3f.m20 = this.m20 * matrix4x3fc.m20();
        matrix4x3f.m21 = this.m21 * matrix4x3fc.m21();
        matrix4x3f.m22 = this.m22 * matrix4x3fc.m22();
        matrix4x3f.m30 = this.m30 * matrix4x3fc.m30();
        matrix4x3f.m31 = this.m31 * matrix4x3fc.m31();
        matrix4x3f.m32 = this.m32 * matrix4x3fc.m32();
        matrix4x3f.properties = 0;
        return matrix4x3f;
    }

    public Matrix4x3f set(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.m00 = f;
        this.m01 = f2;
        this.m02 = f3;
        this.m10 = f4;
        this.m11 = f5;
        this.m12 = f6;
        this.m20 = f7;
        this.m21 = f8;
        this.m22 = f9;
        this.m30 = f10;
        this.m31 = f11;
        this.m32 = f12;
        return this.determineProperties();
    }

    public Matrix4x3f set(float[] fArray, int n) {
        MemUtil.INSTANCE.copy(fArray, n, this);
        return this.determineProperties();
    }

    public Matrix4x3f set(float[] fArray) {
        return this.set(fArray, 0);
    }

    public Matrix4x3f set(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, floatBuffer.position(), floatBuffer);
        return this.determineProperties();
    }

    public Matrix4x3f set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this.determineProperties();
    }

    public Matrix4x3f set(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, n, floatBuffer);
        return this.determineProperties();
    }

    public Matrix4x3f set(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n, byteBuffer);
        return this.determineProperties();
    }

    @Override
    public float determinant() {
        return (this.m00 * this.m11 - this.m01 * this.m10) * this.m22 + (this.m02 * this.m10 - this.m00 * this.m12) * this.m21 + (this.m01 * this.m12 - this.m02 * this.m11) * this.m20;
    }

    @Override
    public Matrix4x3f invert(Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.identity();
        }
        if ((this.properties & 0x10) != 0) {
            return this.invertOrthonormal(matrix4x3f);
        }
        return this.invertGeneric(matrix4x3f);
    }

    private Matrix4x3f invertGeneric(Matrix4x3f matrix4x3f) {
        float f = this.m00 * this.m11;
        float f2 = this.m01 * this.m10;
        float f3 = this.m02 * this.m10;
        float f4 = this.m00 * this.m12;
        float f5 = this.m01 * this.m12;
        float f6 = this.m02 * this.m11;
        float f7 = 1.0f / ((f - f2) * this.m22 + (f3 - f4) * this.m21 + (f5 - f6) * this.m20);
        float f8 = this.m10 * this.m22;
        float f9 = this.m10 * this.m21;
        float f10 = this.m11 * this.m22;
        float f11 = this.m11 * this.m20;
        float f12 = this.m12 * this.m21;
        float f13 = this.m12 * this.m20;
        float f14 = this.m20 * this.m02;
        float f15 = this.m20 * this.m01;
        float f16 = this.m21 * this.m02;
        float f17 = this.m21 * this.m00;
        float f18 = this.m22 * this.m01;
        float f19 = this.m22 * this.m00;
        float f20 = (f10 - f12) * f7;
        float f21 = (f16 - f18) * f7;
        float f22 = (f5 - f6) * f7;
        float f23 = (f13 - f8) * f7;
        float f24 = (f19 - f14) * f7;
        float f25 = (f3 - f4) * f7;
        float f26 = (f9 - f11) * f7;
        float f27 = (f15 - f17) * f7;
        float f28 = (f - f2) * f7;
        float f29 = (f8 * this.m31 - f9 * this.m32 + f11 * this.m32 - f10 * this.m30 + f12 * this.m30 - f13 * this.m31) * f7;
        float f30 = (f14 * this.m31 - f15 * this.m32 + f17 * this.m32 - f16 * this.m30 + f18 * this.m30 - f19 * this.m31) * f7;
        float f31 = (f6 * this.m30 - f5 * this.m30 + f4 * this.m31 - f3 * this.m31 + f2 * this.m32 - f * this.m32) * f7;
        matrix4x3f.m00 = f20;
        matrix4x3f.m01 = f21;
        matrix4x3f.m02 = f22;
        matrix4x3f.m10 = f23;
        matrix4x3f.m11 = f24;
        matrix4x3f.m12 = f25;
        matrix4x3f.m20 = f26;
        matrix4x3f.m21 = f27;
        matrix4x3f.m22 = f28;
        matrix4x3f.m30 = f29;
        matrix4x3f.m31 = f30;
        matrix4x3f.m32 = f31;
        matrix4x3f.properties = 0;
        return matrix4x3f;
    }

    private Matrix4x3f invertOrthonormal(Matrix4x3f matrix4x3f) {
        float f = -(this.m00 * this.m30 + this.m01 * this.m31 + this.m02 * this.m32);
        float f2 = -(this.m10 * this.m30 + this.m11 * this.m31 + this.m12 * this.m32);
        float f3 = -(this.m20 * this.m30 + this.m21 * this.m31 + this.m22 * this.m32);
        float f4 = this.m01;
        float f5 = this.m02;
        float f6 = this.m12;
        matrix4x3f.m00 = this.m00;
        matrix4x3f.m01 = this.m10;
        matrix4x3f.m02 = this.m20;
        matrix4x3f.m10 = f4;
        matrix4x3f.m11 = this.m11;
        matrix4x3f.m12 = this.m21;
        matrix4x3f.m20 = f5;
        matrix4x3f.m21 = f6;
        matrix4x3f.m22 = this.m22;
        matrix4x3f.m30 = f;
        matrix4x3f.m31 = f2;
        matrix4x3f.m32 = f3;
        matrix4x3f.properties = 16;
        return matrix4x3f;
    }

    @Override
    public Matrix4f invert(Matrix4f matrix4f) {
        if ((this.properties & 4) != 0) {
            return matrix4f.identity();
        }
        if ((this.properties & 0x10) != 0) {
            return this.invertOrthonormal(matrix4f);
        }
        return this.invertGeneric(matrix4f);
    }

    private Matrix4f invertGeneric(Matrix4f matrix4f) {
        float f = this.m00 * this.m11;
        float f2 = this.m01 * this.m10;
        float f3 = this.m02 * this.m10;
        float f4 = this.m00 * this.m12;
        float f5 = this.m01 * this.m12;
        float f6 = this.m02 * this.m11;
        float f7 = 1.0f / ((f - f2) * this.m22 + (f3 - f4) * this.m21 + (f5 - f6) * this.m20);
        float f8 = this.m10 * this.m22;
        float f9 = this.m10 * this.m21;
        float f10 = this.m11 * this.m22;
        float f11 = this.m11 * this.m20;
        float f12 = this.m12 * this.m21;
        float f13 = this.m12 * this.m20;
        float f14 = this.m20 * this.m02;
        float f15 = this.m20 * this.m01;
        float f16 = this.m21 * this.m02;
        float f17 = this.m21 * this.m00;
        float f18 = this.m22 * this.m01;
        float f19 = this.m22 * this.m00;
        float f20 = (f10 - f12) * f7;
        float f21 = (f16 - f18) * f7;
        float f22 = (f5 - f6) * f7;
        float f23 = (f13 - f8) * f7;
        float f24 = (f19 - f14) * f7;
        float f25 = (f3 - f4) * f7;
        float f26 = (f9 - f11) * f7;
        float f27 = (f15 - f17) * f7;
        float f28 = (f - f2) * f7;
        float f29 = (f8 * this.m31 - f9 * this.m32 + f11 * this.m32 - f10 * this.m30 + f12 * this.m30 - f13 * this.m31) * f7;
        float f30 = (f14 * this.m31 - f15 * this.m32 + f17 * this.m32 - f16 * this.m30 + f18 * this.m30 - f19 * this.m31) * f7;
        float f31 = (f6 * this.m30 - f5 * this.m30 + f4 * this.m31 - f3 * this.m31 + f2 * this.m32 - f * this.m32) * f7;
        matrix4f.m00 = f20;
        matrix4f.m01 = f21;
        matrix4f.m02 = f22;
        matrix4f.m03 = 0.0f;
        matrix4f.m10 = f23;
        matrix4f.m11 = f24;
        matrix4f.m12 = f25;
        matrix4f.m13 = 0.0f;
        matrix4f.m20 = f26;
        matrix4f.m21 = f27;
        matrix4f.m22 = f28;
        matrix4f.m23 = 0.0f;
        matrix4f.m30 = f29;
        matrix4f.m31 = f30;
        matrix4f.m32 = f31;
        matrix4f.m33 = 0.0f;
        matrix4f.properties = 0;
        return matrix4f;
    }

    private Matrix4f invertOrthonormal(Matrix4f matrix4f) {
        float f = -(this.m00 * this.m30 + this.m01 * this.m31 + this.m02 * this.m32);
        float f2 = -(this.m10 * this.m30 + this.m11 * this.m31 + this.m12 * this.m32);
        float f3 = -(this.m20 * this.m30 + this.m21 * this.m31 + this.m22 * this.m32);
        float f4 = this.m01;
        float f5 = this.m02;
        float f6 = this.m12;
        matrix4f.m00 = this.m00;
        matrix4f.m01 = this.m10;
        matrix4f.m02 = this.m20;
        matrix4f.m03 = 0.0f;
        matrix4f.m10 = f4;
        matrix4f.m11 = this.m11;
        matrix4f.m12 = this.m21;
        matrix4f.m13 = 0.0f;
        matrix4f.m20 = f5;
        matrix4f.m21 = f6;
        matrix4f.m22 = this.m22;
        matrix4f.m23 = 0.0f;
        matrix4f.m30 = f;
        matrix4f.m31 = f2;
        matrix4f.m32 = f3;
        matrix4f.m33 = 0.0f;
        matrix4f.properties = 16;
        return matrix4f;
    }

    public Matrix4x3f invert() {
        return this.invert(this);
    }

    @Override
    public Matrix4x3f invertOrtho(Matrix4x3f matrix4x3f) {
        float f = 1.0f / this.m00;
        float f2 = 1.0f / this.m11;
        float f3 = 1.0f / this.m22;
        matrix4x3f.set(f, 0.0f, 0.0f, 0.0f, f2, 0.0f, 0.0f, 0.0f, f3, -this.m30 * f, -this.m31 * f2, -this.m32 * f3);
        matrix4x3f.properties = 0;
        return matrix4x3f;
    }

    public Matrix4x3f invertOrtho() {
        return this.invertOrtho(this);
    }

    public Matrix4x3f transpose3x3() {
        return this.transpose3x3(this);
    }

    @Override
    public Matrix4x3f transpose3x3(Matrix4x3f matrix4x3f) {
        float f = this.m00;
        float f2 = this.m10;
        float f3 = this.m20;
        float f4 = this.m01;
        float f5 = this.m11;
        float f6 = this.m21;
        float f7 = this.m02;
        float f8 = this.m12;
        float f9 = this.m22;
        matrix4x3f.m00 = f;
        matrix4x3f.m01 = f2;
        matrix4x3f.m02 = f3;
        matrix4x3f.m10 = f4;
        matrix4x3f.m11 = f5;
        matrix4x3f.m12 = f6;
        matrix4x3f.m20 = f7;
        matrix4x3f.m21 = f8;
        matrix4x3f.m22 = f9;
        matrix4x3f.properties = this.properties;
        return matrix4x3f;
    }

    @Override
    public Matrix3f transpose3x3(Matrix3f matrix3f) {
        matrix3f.m00(this.m00);
        matrix3f.m01(this.m10);
        matrix3f.m02(this.m20);
        matrix3f.m10(this.m01);
        matrix3f.m11(this.m11);
        matrix3f.m12(this.m21);
        matrix3f.m20(this.m02);
        matrix3f.m21(this.m12);
        matrix3f.m22(this.m22);
        return matrix3f;
    }

    public Matrix4x3f translation(float f, float f2, float f3) {
        if ((this.properties & 4) == 0) {
            MemUtil.INSTANCE.identity(this);
        }
        this.m30 = f;
        this.m31 = f2;
        this.m32 = f3;
        this.properties = 24;
        return this;
    }

    public Matrix4x3f translation(Vector3fc vector3fc) {
        return this.translation(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix4x3f setTranslation(float f, float f2, float f3) {
        this.m30 = f;
        this.m31 = f2;
        this.m32 = f3;
        this.properties &= 0xFFFFFFFB;
        return this;
    }

    public Matrix4x3f setTranslation(Vector3fc vector3fc) {
        return this.setTranslation(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    @Override
    public Vector3f getTranslation(Vector3f vector3f) {
        vector3f.x = this.m30;
        vector3f.y = this.m31;
        vector3f.z = this.m32;
        return vector3f;
    }

    @Override
    public Vector3f getScale(Vector3f vector3f) {
        vector3f.x = Math.sqrt(this.m00 * this.m00 + this.m01 * this.m01 + this.m02 * this.m02);
        vector3f.y = Math.sqrt(this.m10 * this.m10 + this.m11 * this.m11 + this.m12 * this.m12);
        vector3f.z = Math.sqrt(this.m20 * this.m20 + this.m21 * this.m21 + this.m22 * this.m22);
        return vector3f;
    }

    public String toString() {
        DecimalFormat decimalFormat = new DecimalFormat(" 0.000E0;-");
        String string = this.toString(decimalFormat);
        StringBuffer stringBuffer = new StringBuffer();
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == 'E') {
                n = i;
            } else {
                if (c == ' ' && n == i - 1) {
                    stringBuffer.append('+');
                    continue;
                }
                if (Character.isDigit(c) && n == i - 1) {
                    stringBuffer.append('+');
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String toString(NumberFormat numberFormat) {
        return Runtime.format(this.m00, numberFormat) + " " + Runtime.format(this.m10, numberFormat) + " " + Runtime.format(this.m20, numberFormat) + " " + Runtime.format(this.m30, numberFormat) + "\n" + Runtime.format(this.m01, numberFormat) + " " + Runtime.format(this.m11, numberFormat) + " " + Runtime.format(this.m21, numberFormat) + " " + Runtime.format(this.m31, numberFormat) + "\n" + Runtime.format(this.m02, numberFormat) + " " + Runtime.format(this.m12, numberFormat) + " " + Runtime.format(this.m22, numberFormat) + " " + Runtime.format(this.m32, numberFormat) + "\n";
    }

    @Override
    public Matrix4x3f get(Matrix4x3f matrix4x3f) {
        return matrix4x3f.set(this);
    }

    @Override
    public Matrix4x3d get(Matrix4x3d matrix4x3d) {
        return matrix4x3d.set(this);
    }

    @Override
    public AxisAngle4f getRotation(AxisAngle4f axisAngle4f) {
        return axisAngle4f.set(this);
    }

    @Override
    public AxisAngle4d getRotation(AxisAngle4d axisAngle4d) {
        return axisAngle4d.set(this);
    }

    @Override
    public Quaternionf getUnnormalizedRotation(Quaternionf quaternionf) {
        return quaternionf.setFromUnnormalized(this);
    }

    @Override
    public Quaternionf getNormalizedRotation(Quaternionf quaternionf) {
        return quaternionf.setFromNormalized(this);
    }

    @Override
    public Quaterniond getUnnormalizedRotation(Quaterniond quaterniond) {
        return quaterniond.setFromUnnormalized(this);
    }

    @Override
    public Quaterniond getNormalizedRotation(Quaterniond quaterniond) {
        return quaterniond.setFromNormalized(this);
    }

    @Override
    public FloatBuffer get(FloatBuffer floatBuffer) {
        return this.get(floatBuffer.position(), floatBuffer);
    }

    @Override
    public FloatBuffer get(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, n, floatBuffer);
        return floatBuffer;
    }

    @Override
    public ByteBuffer get(ByteBuffer byteBuffer) {
        return this.get(byteBuffer.position(), byteBuffer);
    }

    @Override
    public ByteBuffer get(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public float[] get(float[] fArray, int n) {
        MemUtil.INSTANCE.copy(this, fArray, n);
        return fArray;
    }

    @Override
    public float[] get(float[] fArray) {
        return this.get(fArray, 0);
    }

    @Override
    public float[] get4x4(float[] fArray, int n) {
        MemUtil.INSTANCE.copy4x4(this, fArray, n);
        return fArray;
    }

    @Override
    public float[] get4x4(float[] fArray) {
        return this.get4x4(fArray, 0);
    }

    @Override
    public FloatBuffer get4x4(FloatBuffer floatBuffer) {
        return this.get4x4(floatBuffer.position(), floatBuffer);
    }

    @Override
    public FloatBuffer get4x4(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put4x4(this, n, floatBuffer);
        return floatBuffer;
    }

    @Override
    public ByteBuffer get4x4(ByteBuffer byteBuffer) {
        return this.get4x4(byteBuffer.position(), byteBuffer);
    }

    @Override
    public ByteBuffer get4x4(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put4x4(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public FloatBuffer get3x4(FloatBuffer floatBuffer) {
        return this.get3x4(floatBuffer.position(), floatBuffer);
    }

    @Override
    public FloatBuffer get3x4(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put3x4(this, n, floatBuffer);
        return floatBuffer;
    }

    @Override
    public ByteBuffer get3x4(ByteBuffer byteBuffer) {
        return this.get3x4(byteBuffer.position(), byteBuffer);
    }

    @Override
    public ByteBuffer get3x4(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put3x4(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public FloatBuffer getTransposed(FloatBuffer floatBuffer) {
        return this.getTransposed(floatBuffer.position(), floatBuffer);
    }

    @Override
    public FloatBuffer getTransposed(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.putTransposed(this, n, floatBuffer);
        return floatBuffer;
    }

    @Override
    public ByteBuffer getTransposed(ByteBuffer byteBuffer) {
        return this.getTransposed(byteBuffer.position(), byteBuffer);
    }

    @Override
    public ByteBuffer getTransposed(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putTransposed(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public float[] getTransposed(float[] fArray, int n) {
        fArray[n + 0] = this.m00;
        fArray[n + 1] = this.m10;
        fArray[n + 2] = this.m20;
        fArray[n + 3] = this.m30;
        fArray[n + 4] = this.m01;
        fArray[n + 5] = this.m11;
        fArray[n + 6] = this.m21;
        fArray[n + 7] = this.m31;
        fArray[n + 8] = this.m02;
        fArray[n + 9] = this.m12;
        fArray[n + 10] = this.m22;
        fArray[n + 11] = this.m32;
        return fArray;
    }

    @Override
    public float[] getTransposed(float[] fArray) {
        return this.getTransposed(fArray, 0);
    }

    public Matrix4x3f zero() {
        MemUtil.INSTANCE.zero(this);
        this.properties = 0;
        return this;
    }

    public Matrix4x3f scaling(float f) {
        return this.scaling(f, f, f);
    }

    public Matrix4x3f scaling(float f, float f2, float f3) {
        if ((this.properties & 4) == 0) {
            MemUtil.INSTANCE.identity(this);
        }
        this.m00 = f;
        this.m11 = f2;
        this.m22 = f3;
        boolean bl = Math.absEqualsOne(f) && Math.absEqualsOne(f2) && Math.absEqualsOne(f3);
        this.properties = bl ? 16 : 0;
        return this;
    }

    public Matrix4x3f scaling(Vector3fc vector3fc) {
        return this.scaling(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix4x3f rotation(float f, Vector3fc vector3fc) {
        return this.rotation(f, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix4x3f rotation(AxisAngle4f axisAngle4f) {
        return this.rotation(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    public Matrix4x3f rotation(float f, float f2, float f3, float f4) {
        if (f3 == 0.0f && f4 == 0.0f && Math.absEqualsOne(f2)) {
            return this.rotationX(f2 * f);
        }
        if (f2 == 0.0f && f4 == 0.0f && Math.absEqualsOne(f3)) {
            return this.rotationY(f3 * f);
        }
        if (f2 == 0.0f && f3 == 0.0f && Math.absEqualsOne(f4)) {
            return this.rotationZ(f4 * f);
        }
        return this.rotationInternal(f, f2, f3, f4);
    }

    private Matrix4x3f rotationInternal(float f, float f2, float f3, float f4) {
        float f5 = Math.sin(f);
        float f6 = Math.cosFromSin(f5, f);
        float f7 = 1.0f - f6;
        float f8 = f2 * f3;
        float f9 = f2 * f4;
        float f10 = f3 * f4;
        this.m00 = f6 + f2 * f2 * f7;
        this.m01 = f8 * f7 + f4 * f5;
        this.m02 = f9 * f7 - f3 * f5;
        this.m10 = f8 * f7 - f4 * f5;
        this.m11 = f6 + f3 * f3 * f7;
        this.m12 = f10 * f7 + f2 * f5;
        this.m20 = f9 * f7 + f3 * f5;
        this.m21 = f10 * f7 - f2 * f5;
        this.m22 = f6 + f4 * f4 * f7;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f rotationX(float f) {
        float f2 = Math.sin(f);
        float f3 = Math.cosFromSin(f2, f);
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = f3;
        this.m12 = f2;
        this.m20 = 0.0f;
        this.m21 = -f2;
        this.m22 = f3;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f rotationY(float f) {
        float f2;
        float f3 = Math.sin(f);
        this.m00 = f2 = Math.cosFromSin(f3, f);
        this.m01 = 0.0f;
        this.m02 = -f3;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m20 = f3;
        this.m21 = 0.0f;
        this.m22 = f2;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f rotationZ(float f) {
        float f2;
        float f3 = Math.sin(f);
        this.m00 = f2 = Math.cosFromSin(f3, f);
        this.m01 = f3;
        this.m02 = 0.0f;
        this.m10 = -f3;
        this.m11 = f2;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f rotationXYZ(float f, float f2, float f3) {
        float f4 = Math.sin(f);
        float f5 = Math.cosFromSin(f4, f);
        float f6 = Math.sin(f2);
        float f7 = Math.cosFromSin(f6, f2);
        float f8 = Math.sin(f3);
        float f9 = Math.cosFromSin(f8, f3);
        float f10 = -f4;
        float f11 = -f6;
        float f12 = -f8;
        float f13 = f5;
        float f14 = f4;
        float f15 = f10;
        float f16 = f5;
        float f17 = f7;
        float f18 = f15 * f11;
        float f19 = f16 * f11;
        this.m20 = f6;
        this.m21 = f15 * f7;
        this.m22 = f16 * f7;
        this.m00 = f17 * f9;
        this.m01 = f18 * f9 + f13 * f8;
        this.m02 = f19 * f9 + f14 * f8;
        this.m10 = f17 * f12;
        this.m11 = f18 * f12 + f13 * f9;
        this.m12 = f19 * f12 + f14 * f9;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f rotationZYX(float f, float f2, float f3) {
        float f4 = Math.sin(f3);
        float f5 = Math.cosFromSin(f4, f3);
        float f6 = Math.sin(f2);
        float f7 = Math.cosFromSin(f6, f2);
        float f8 = Math.sin(f);
        float f9 = Math.cosFromSin(f8, f);
        float f10 = -f8;
        float f11 = -f6;
        float f12 = -f4;
        float f13 = f9;
        float f14 = f8;
        float f15 = f10;
        float f16 = f9;
        float f17 = f13 * f6;
        float f18 = f14 * f6;
        float f19 = f7;
        this.m00 = f13 * f7;
        this.m01 = f14 * f7;
        this.m02 = f11;
        this.m10 = f15 * f5 + f17 * f4;
        this.m11 = f16 * f5 + f18 * f4;
        this.m12 = f19 * f4;
        this.m20 = f15 * f12 + f17 * f5;
        this.m21 = f16 * f12 + f18 * f5;
        this.m22 = f19 * f5;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f rotationYXZ(float f, float f2, float f3) {
        float f4 = Math.sin(f2);
        float f5 = Math.cosFromSin(f4, f2);
        float f6 = Math.sin(f);
        float f7 = Math.cosFromSin(f6, f);
        float f8 = Math.sin(f3);
        float f9 = Math.cosFromSin(f8, f3);
        float f10 = -f6;
        float f11 = -f4;
        float f12 = -f8;
        float f13 = f7;
        float f14 = f10;
        float f15 = f6;
        float f16 = f7;
        float f17 = f15 * f4;
        float f18 = f5;
        float f19 = f16 * f4;
        this.m20 = f15 * f5;
        this.m21 = f11;
        this.m22 = f16 * f5;
        this.m00 = f13 * f9 + f17 * f8;
        this.m01 = f18 * f8;
        this.m02 = f14 * f9 + f19 * f8;
        this.m10 = f13 * f12 + f17 * f9;
        this.m11 = f18 * f9;
        this.m12 = f14 * f12 + f19 * f9;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f setRotationXYZ(float f, float f2, float f3) {
        float f4 = Math.sin(f);
        float f5 = Math.cosFromSin(f4, f);
        float f6 = Math.sin(f2);
        float f7 = Math.cosFromSin(f6, f2);
        float f8 = Math.sin(f3);
        float f9 = Math.cosFromSin(f8, f3);
        float f10 = -f4;
        float f11 = -f6;
        float f12 = -f8;
        float f13 = f5;
        float f14 = f4;
        float f15 = f10;
        float f16 = f5;
        float f17 = f7;
        float f18 = f15 * f11;
        float f19 = f16 * f11;
        this.m20 = f6;
        this.m21 = f15 * f7;
        this.m22 = f16 * f7;
        this.m00 = f17 * f9;
        this.m01 = f18 * f9 + f13 * f8;
        this.m02 = f19 * f9 + f14 * f8;
        this.m10 = f17 * f12;
        this.m11 = f18 * f12 + f13 * f9;
        this.m12 = f19 * f12 + f14 * f9;
        this.properties &= 0xFFFFFFF3;
        return this;
    }

    public Matrix4x3f setRotationZYX(float f, float f2, float f3) {
        float f4 = Math.sin(f3);
        float f5 = Math.cosFromSin(f4, f3);
        float f6 = Math.sin(f2);
        float f7 = Math.cosFromSin(f6, f2);
        float f8 = Math.sin(f);
        float f9 = Math.cosFromSin(f8, f);
        float f10 = -f8;
        float f11 = -f6;
        float f12 = -f4;
        float f13 = f9;
        float f14 = f8;
        float f15 = f10;
        float f16 = f9;
        float f17 = f13 * f6;
        float f18 = f14 * f6;
        float f19 = f7;
        this.m00 = f13 * f7;
        this.m01 = f14 * f7;
        this.m02 = f11;
        this.m10 = f15 * f5 + f17 * f4;
        this.m11 = f16 * f5 + f18 * f4;
        this.m12 = f19 * f4;
        this.m20 = f15 * f12 + f17 * f5;
        this.m21 = f16 * f12 + f18 * f5;
        this.m22 = f19 * f5;
        this.properties &= 0xFFFFFFF3;
        return this;
    }

    public Matrix4x3f setRotationYXZ(float f, float f2, float f3) {
        float f4 = Math.sin(f2);
        float f5 = Math.cosFromSin(f4, f2);
        float f6 = Math.sin(f);
        float f7 = Math.cosFromSin(f6, f);
        float f8 = Math.sin(f3);
        float f9 = Math.cosFromSin(f8, f3);
        float f10 = -f6;
        float f11 = -f4;
        float f12 = -f8;
        float f13 = f7;
        float f14 = f10;
        float f15 = f6;
        float f16 = f7;
        float f17 = f15 * f4;
        float f18 = f5;
        float f19 = f16 * f4;
        this.m20 = f15 * f5;
        this.m21 = f11;
        this.m22 = f16 * f5;
        this.m00 = f13 * f9 + f17 * f8;
        this.m01 = f18 * f8;
        this.m02 = f14 * f9 + f19 * f8;
        this.m10 = f13 * f12 + f17 * f9;
        this.m11 = f18 * f9;
        this.m12 = f14 * f12 + f19 * f9;
        this.properties &= 0xFFFFFFF3;
        return this;
    }

    public Matrix4x3f rotation(Quaternionfc quaternionfc) {
        float f = quaternionfc.w() * quaternionfc.w();
        float f2 = quaternionfc.x() * quaternionfc.x();
        float f3 = quaternionfc.y() * quaternionfc.y();
        float f4 = quaternionfc.z() * quaternionfc.z();
        float f5 = quaternionfc.z() * quaternionfc.w();
        float f6 = f5 + f5;
        float f7 = quaternionfc.x() * quaternionfc.y();
        float f8 = f7 + f7;
        float f9 = quaternionfc.x() * quaternionfc.z();
        float f10 = f9 + f9;
        float f11 = quaternionfc.y() * quaternionfc.w();
        float f12 = f11 + f11;
        float f13 = quaternionfc.y() * quaternionfc.z();
        float f14 = f13 + f13;
        float f15 = quaternionfc.x() * quaternionfc.w();
        float f16 = f15 + f15;
        this._m00(f + f2 - f4 - f3);
        this._m01(f8 + f6);
        this._m02(f10 - f12);
        this._m10(f8 - f6);
        this._m11(f3 - f4 + f - f2);
        this._m12(f14 + f16);
        this._m20(f12 + f10);
        this._m21(f14 - f16);
        this._m22(f4 - f3 - f2 + f);
        this._m30(0.0f);
        this._m31(0.0f);
        this._m32(0.0f);
        this.properties = 16;
        return this;
    }

    public Matrix4x3f translationRotateScale(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        float f11 = f4 + f4;
        float f12 = f5 + f5;
        float f13 = f6 + f6;
        float f14 = f11 * f4;
        float f15 = f12 * f5;
        float f16 = f13 * f6;
        float f17 = f11 * f5;
        float f18 = f11 * f6;
        float f19 = f11 * f7;
        float f20 = f12 * f6;
        float f21 = f12 * f7;
        float f22 = f13 * f7;
        this.m00 = f8 - (f15 + f16) * f8;
        this.m01 = (f17 + f22) * f8;
        this.m02 = (f18 - f21) * f8;
        this.m10 = (f17 - f22) * f9;
        this.m11 = f9 - (f16 + f14) * f9;
        this.m12 = (f20 + f19) * f9;
        this.m20 = (f18 + f21) * f10;
        this.m21 = (f20 - f19) * f10;
        this.m22 = f10 - (f15 + f14) * f10;
        this.m30 = f;
        this.m31 = f2;
        this.m32 = f3;
        this.properties = 0;
        return this;
    }

    public Matrix4x3f translationRotateScale(Vector3fc vector3fc, Quaternionfc quaternionfc, Vector3fc vector3fc2) {
        return this.translationRotateScale(vector3fc.x(), vector3fc.y(), vector3fc.z(), quaternionfc.x(), quaternionfc.y(), quaternionfc.z(), quaternionfc.w(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    public Matrix4x3f translationRotateScaleMul(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, Matrix4x3f matrix4x3f) {
        float f11 = f4 + f4;
        float f12 = f5 + f5;
        float f13 = f6 + f6;
        float f14 = f11 * f4;
        float f15 = f12 * f5;
        float f16 = f13 * f6;
        float f17 = f11 * f5;
        float f18 = f11 * f6;
        float f19 = f11 * f7;
        float f20 = f12 * f6;
        float f21 = f12 * f7;
        float f22 = f13 * f7;
        float f23 = f8 - (f15 + f16) * f8;
        float f24 = (f17 + f22) * f8;
        float f25 = (f18 - f21) * f8;
        float f26 = (f17 - f22) * f9;
        float f27 = f9 - (f16 + f14) * f9;
        float f28 = (f20 + f19) * f9;
        float f29 = (f18 + f21) * f10;
        float f30 = (f20 - f19) * f10;
        float f31 = f10 - (f15 + f14) * f10;
        float f32 = f23 * matrix4x3f.m00 + f26 * matrix4x3f.m01 + f29 * matrix4x3f.m02;
        float f33 = f24 * matrix4x3f.m00 + f27 * matrix4x3f.m01 + f30 * matrix4x3f.m02;
        this.m02 = f25 * matrix4x3f.m00 + f28 * matrix4x3f.m01 + f31 * matrix4x3f.m02;
        this.m00 = f32;
        this.m01 = f33;
        float f34 = f23 * matrix4x3f.m10 + f26 * matrix4x3f.m11 + f29 * matrix4x3f.m12;
        float f35 = f24 * matrix4x3f.m10 + f27 * matrix4x3f.m11 + f30 * matrix4x3f.m12;
        this.m12 = f25 * matrix4x3f.m10 + f28 * matrix4x3f.m11 + f31 * matrix4x3f.m12;
        this.m10 = f34;
        this.m11 = f35;
        float f36 = f23 * matrix4x3f.m20 + f26 * matrix4x3f.m21 + f29 * matrix4x3f.m22;
        float f37 = f24 * matrix4x3f.m20 + f27 * matrix4x3f.m21 + f30 * matrix4x3f.m22;
        this.m22 = f25 * matrix4x3f.m20 + f28 * matrix4x3f.m21 + f31 * matrix4x3f.m22;
        this.m20 = f36;
        this.m21 = f37;
        float f38 = f23 * matrix4x3f.m30 + f26 * matrix4x3f.m31 + f29 * matrix4x3f.m32 + f;
        float f39 = f24 * matrix4x3f.m30 + f27 * matrix4x3f.m31 + f30 * matrix4x3f.m32 + f2;
        this.m32 = f25 * matrix4x3f.m30 + f28 * matrix4x3f.m31 + f31 * matrix4x3f.m32 + f3;
        this.m30 = f38;
        this.m31 = f39;
        this.properties = 0;
        return this;
    }

    public Matrix4x3f translationRotateScaleMul(Vector3fc vector3fc, Quaternionfc quaternionfc, Vector3fc vector3fc2, Matrix4x3f matrix4x3f) {
        return this.translationRotateScaleMul(vector3fc.x(), vector3fc.y(), vector3fc.z(), quaternionfc.x(), quaternionfc.y(), quaternionfc.z(), quaternionfc.w(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), matrix4x3f);
    }

    public Matrix4x3f translationRotate(float f, float f2, float f3, Quaternionfc quaternionfc) {
        float f4 = quaternionfc.x() + quaternionfc.x();
        float f5 = quaternionfc.y() + quaternionfc.y();
        float f6 = quaternionfc.z() + quaternionfc.z();
        float f7 = f4 * quaternionfc.x();
        float f8 = f5 * quaternionfc.y();
        float f9 = f6 * quaternionfc.z();
        float f10 = f4 * quaternionfc.y();
        float f11 = f4 * quaternionfc.z();
        float f12 = f4 * quaternionfc.w();
        float f13 = f5 * quaternionfc.z();
        float f14 = f5 * quaternionfc.w();
        float f15 = f6 * quaternionfc.w();
        this.m00 = 1.0f - (f8 + f9);
        this.m01 = f10 + f15;
        this.m02 = f11 - f14;
        this.m10 = f10 - f15;
        this.m11 = 1.0f - (f9 + f7);
        this.m12 = f13 + f12;
        this.m20 = f11 + f14;
        this.m21 = f13 - f12;
        this.m22 = 1.0f - (f8 + f7);
        this.m30 = f;
        this.m31 = f2;
        this.m32 = f3;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f translationRotateMul(float f, float f2, float f3, Quaternionfc quaternionfc, Matrix4x3fc matrix4x3fc) {
        return this.translationRotateMul(f, f2, f3, quaternionfc.x(), quaternionfc.y(), quaternionfc.z(), quaternionfc.w(), matrix4x3fc);
    }

    public Matrix4x3f translationRotateMul(float f, float f2, float f3, float f4, float f5, float f6, float f7, Matrix4x3fc matrix4x3fc) {
        float f8 = f7 * f7;
        float f9 = f4 * f4;
        float f10 = f5 * f5;
        float f11 = f6 * f6;
        float f12 = f6 * f7;
        float f13 = f4 * f5;
        float f14 = f4 * f6;
        float f15 = f5 * f7;
        float f16 = f5 * f6;
        float f17 = f4 * f7;
        float f18 = f8 + f9 - f11 - f10;
        float f19 = f13 + f12 + f12 + f13;
        float f20 = f14 - f15 + f14 - f15;
        float f21 = -f12 + f13 - f12 + f13;
        float f22 = f10 - f11 + f8 - f9;
        float f23 = f16 + f16 + f17 + f17;
        float f24 = f15 + f14 + f14 + f15;
        float f25 = f16 + f16 - f17 - f17;
        float f26 = f11 - f10 - f9 + f8;
        this.m00 = f18 * matrix4x3fc.m00() + f21 * matrix4x3fc.m01() + f24 * matrix4x3fc.m02();
        this.m01 = f19 * matrix4x3fc.m00() + f22 * matrix4x3fc.m01() + f25 * matrix4x3fc.m02();
        this.m02 = f20 * matrix4x3fc.m00() + f23 * matrix4x3fc.m01() + f26 * matrix4x3fc.m02();
        this.m10 = f18 * matrix4x3fc.m10() + f21 * matrix4x3fc.m11() + f24 * matrix4x3fc.m12();
        this.m11 = f19 * matrix4x3fc.m10() + f22 * matrix4x3fc.m11() + f25 * matrix4x3fc.m12();
        this.m12 = f20 * matrix4x3fc.m10() + f23 * matrix4x3fc.m11() + f26 * matrix4x3fc.m12();
        this.m20 = f18 * matrix4x3fc.m20() + f21 * matrix4x3fc.m21() + f24 * matrix4x3fc.m22();
        this.m21 = f19 * matrix4x3fc.m20() + f22 * matrix4x3fc.m21() + f25 * matrix4x3fc.m22();
        this.m22 = f20 * matrix4x3fc.m20() + f23 * matrix4x3fc.m21() + f26 * matrix4x3fc.m22();
        this.m30 = f18 * matrix4x3fc.m30() + f21 * matrix4x3fc.m31() + f24 * matrix4x3fc.m32() + f;
        this.m31 = f19 * matrix4x3fc.m30() + f22 * matrix4x3fc.m31() + f25 * matrix4x3fc.m32() + f2;
        this.m32 = f20 * matrix4x3fc.m30() + f23 * matrix4x3fc.m31() + f26 * matrix4x3fc.m32() + f3;
        this.properties = 0;
        return this;
    }

    public Matrix4x3f set3x3(Matrix3fc matrix3fc) {
        if (matrix3fc instanceof Matrix3f) {
            MemUtil.INSTANCE.copy3x3((Matrix3f)matrix3fc, this);
        } else {
            this.set3x3Matrix3fc(matrix3fc);
        }
        this.properties = 0;
        return this;
    }

    private void set3x3Matrix3fc(Matrix3fc matrix3fc) {
        this.m00 = matrix3fc.m00();
        this.m01 = matrix3fc.m01();
        this.m02 = matrix3fc.m02();
        this.m10 = matrix3fc.m10();
        this.m11 = matrix3fc.m11();
        this.m12 = matrix3fc.m12();
        this.m20 = matrix3fc.m20();
        this.m21 = matrix3fc.m21();
        this.m22 = matrix3fc.m22();
    }

    @Override
    public Vector4f transform(Vector4f vector4f) {
        return vector4f.mul(this);
    }

    @Override
    public Vector4f transform(Vector4fc vector4fc, Vector4f vector4f) {
        return vector4fc.mul(this, vector4f);
    }

    @Override
    public Vector3f transformPosition(Vector3f vector3f) {
        vector3f.set(this.m00 * vector3f.x + this.m10 * vector3f.y + this.m20 * vector3f.z + this.m30, this.m01 * vector3f.x + this.m11 * vector3f.y + this.m21 * vector3f.z + this.m31, this.m02 * vector3f.x + this.m12 * vector3f.y + this.m22 * vector3f.z + this.m32);
        return vector3f;
    }

    @Override
    public Vector3f transformPosition(Vector3fc vector3fc, Vector3f vector3f) {
        vector3f.set(this.m00 * vector3fc.x() + this.m10 * vector3fc.y() + this.m20 * vector3fc.z() + this.m30, this.m01 * vector3fc.x() + this.m11 * vector3fc.y() + this.m21 * vector3fc.z() + this.m31, this.m02 * vector3fc.x() + this.m12 * vector3fc.y() + this.m22 * vector3fc.z() + this.m32);
        return vector3f;
    }

    @Override
    public Vector3f transformDirection(Vector3f vector3f) {
        vector3f.set(this.m00 * vector3f.x + this.m10 * vector3f.y + this.m20 * vector3f.z, this.m01 * vector3f.x + this.m11 * vector3f.y + this.m21 * vector3f.z, this.m02 * vector3f.x + this.m12 * vector3f.y + this.m22 * vector3f.z);
        return vector3f;
    }

    @Override
    public Vector3f transformDirection(Vector3fc vector3fc, Vector3f vector3f) {
        vector3f.set(this.m00 * vector3fc.x() + this.m10 * vector3fc.y() + this.m20 * vector3fc.z(), this.m01 * vector3fc.x() + this.m11 * vector3fc.y() + this.m21 * vector3fc.z(), this.m02 * vector3fc.x() + this.m12 * vector3fc.y() + this.m22 * vector3fc.z());
        return vector3f;
    }

    @Override
    public Matrix4x3f scale(Vector3fc vector3fc, Matrix4x3f matrix4x3f) {
        return this.scale(vector3fc.x(), vector3fc.y(), vector3fc.z(), matrix4x3f);
    }

    public Matrix4x3f scale(Vector3fc vector3fc) {
        return this.scale(vector3fc.x(), vector3fc.y(), vector3fc.z(), this);
    }

    @Override
    public Matrix4x3f scale(float f, Matrix4x3f matrix4x3f) {
        return this.scale(f, f, f, matrix4x3f);
    }

    public Matrix4x3f scale(float f) {
        return this.scale(f, f, f);
    }

    @Override
    public Matrix4x3f scaleXY(float f, float f2, Matrix4x3f matrix4x3f) {
        return this.scale(f, f2, 1.0f, matrix4x3f);
    }

    public Matrix4x3f scaleXY(float f, float f2) {
        return this.scale(f, f2, 1.0f);
    }

    @Override
    public Matrix4x3f scale(float f, float f2, float f3, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.scaling(f, f2, f3);
        }
        return this.scaleGeneric(f, f2, f3, matrix4x3f);
    }

    private Matrix4x3f scaleGeneric(float f, float f2, float f3, Matrix4x3f matrix4x3f) {
        matrix4x3f.m00 = this.m00 * f;
        matrix4x3f.m01 = this.m01 * f;
        matrix4x3f.m02 = this.m02 * f;
        matrix4x3f.m10 = this.m10 * f2;
        matrix4x3f.m11 = this.m11 * f2;
        matrix4x3f.m12 = this.m12 * f2;
        matrix4x3f.m20 = this.m20 * f3;
        matrix4x3f.m21 = this.m21 * f3;
        matrix4x3f.m22 = this.m22 * f3;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3f;
    }

    public Matrix4x3f scale(float f, float f2, float f3) {
        return this.scale(f, f2, f3, this);
    }

    @Override
    public Matrix4x3f scaleLocal(float f, float f2, float f3, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.scaling(f, f2, f3);
        }
        float f4 = f * this.m00;
        float f5 = f2 * this.m01;
        float f6 = f3 * this.m02;
        float f7 = f * this.m10;
        float f8 = f2 * this.m11;
        float f9 = f3 * this.m12;
        float f10 = f * this.m20;
        float f11 = f2 * this.m21;
        float f12 = f3 * this.m22;
        float f13 = f * this.m30;
        float f14 = f2 * this.m31;
        float f15 = f3 * this.m32;
        matrix4x3f.m00 = f4;
        matrix4x3f.m01 = f5;
        matrix4x3f.m02 = f6;
        matrix4x3f.m10 = f7;
        matrix4x3f.m11 = f8;
        matrix4x3f.m12 = f9;
        matrix4x3f.m20 = f10;
        matrix4x3f.m21 = f11;
        matrix4x3f.m22 = f12;
        matrix4x3f.m30 = f13;
        matrix4x3f.m31 = f14;
        matrix4x3f.m32 = f15;
        matrix4x3f.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3f;
    }

    @Override
    public Matrix4x3f scaleAround(float f, float f2, float f3, float f4, float f5, float f6, Matrix4x3f matrix4x3f) {
        float f7 = this.m00 * f4 + this.m10 * f5 + this.m20 * f6 + this.m30;
        float f8 = this.m01 * f4 + this.m11 * f5 + this.m21 * f6 + this.m31;
        float f9 = this.m02 * f4 + this.m12 * f5 + this.m22 * f6 + this.m32;
        boolean bl = Math.absEqualsOne(f) && Math.absEqualsOne(f2) && Math.absEqualsOne(f3);
        return matrix4x3f._m00(this.m00 * f)._m01(this.m01 * f)._m02(this.m02 * f)._m10(this.m10 * f2)._m11(this.m11 * f2)._m12(this.m12 * f2)._m20(this.m20 * f3)._m21(this.m21 * f3)._m22(this.m22 * f3)._m30(-matrix4x3f.m00 * f4 - matrix4x3f.m10 * f5 - matrix4x3f.m20 * f6 + f7)._m31(-matrix4x3f.m01 * f4 - matrix4x3f.m11 * f5 - matrix4x3f.m21 * f6 + f8)._m32(-matrix4x3f.m02 * f4 - matrix4x3f.m12 * f5 - matrix4x3f.m22 * f6 + f9)._properties(this.properties & ~(0xC | (bl ? 0 : 16)));
    }

    public Matrix4x3f scaleAround(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.scaleAround(f, f2, f3, f4, f5, f6, this);
    }

    public Matrix4x3f scaleAround(float f, float f2, float f3, float f4) {
        return this.scaleAround(f, f, f, f2, f3, f4, this);
    }

    @Override
    public Matrix4x3f scaleAround(float f, float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        return this.scaleAround(f, f, f, f2, f3, f4, matrix4x3f);
    }

    public Matrix4x3f scaleLocal(float f, float f2, float f3) {
        return this.scaleLocal(f, f2, f3, this);
    }

    @Override
    public Matrix4x3f rotateX(float f, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.rotationX(f);
        }
        if ((this.properties & 8) != 0) {
            float f2 = this.m30;
            float f3 = this.m31;
            float f4 = this.m32;
            return matrix4x3f.rotationX(f).setTranslation(f2, f3, f4);
        }
        return this.rotateXInternal(f, matrix4x3f);
    }

    private Matrix4x3f rotateXInternal(float f, Matrix4x3f matrix4x3f) {
        float f2;
        float f3 = Math.sin(f);
        float f4 = f2 = Math.cosFromSin(f3, f);
        float f5 = f3;
        float f6 = -f3;
        float f7 = f2;
        float f8 = this.m10 * f4 + this.m20 * f5;
        float f9 = this.m11 * f4 + this.m21 * f5;
        float f10 = this.m12 * f4 + this.m22 * f5;
        matrix4x3f.m20 = this.m10 * f6 + this.m20 * f7;
        matrix4x3f.m21 = this.m11 * f6 + this.m21 * f7;
        matrix4x3f.m22 = this.m12 * f6 + this.m22 * f7;
        matrix4x3f.m10 = f8;
        matrix4x3f.m11 = f9;
        matrix4x3f.m12 = f10;
        matrix4x3f.m00 = this.m00;
        matrix4x3f.m01 = this.m01;
        matrix4x3f.m02 = this.m02;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f rotateX(float f) {
        return this.rotateX(f, this);
    }

    @Override
    public Matrix4x3f rotateY(float f, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.rotationY(f);
        }
        if ((this.properties & 8) != 0) {
            float f2 = this.m30;
            float f3 = this.m31;
            float f4 = this.m32;
            return matrix4x3f.rotationY(f).setTranslation(f2, f3, f4);
        }
        return this.rotateYInternal(f, matrix4x3f);
    }

    private Matrix4x3f rotateYInternal(float f, Matrix4x3f matrix4x3f) {
        float f2;
        float f3 = Math.sin(f);
        float f4 = f2 = Math.cosFromSin(f3, f);
        float f5 = -f3;
        float f6 = f3;
        float f7 = f2;
        float f8 = this.m00 * f4 + this.m20 * f5;
        float f9 = this.m01 * f4 + this.m21 * f5;
        float f10 = this.m02 * f4 + this.m22 * f5;
        matrix4x3f.m20 = this.m00 * f6 + this.m20 * f7;
        matrix4x3f.m21 = this.m01 * f6 + this.m21 * f7;
        matrix4x3f.m22 = this.m02 * f6 + this.m22 * f7;
        matrix4x3f.m00 = f8;
        matrix4x3f.m01 = f9;
        matrix4x3f.m02 = f10;
        matrix4x3f.m10 = this.m10;
        matrix4x3f.m11 = this.m11;
        matrix4x3f.m12 = this.m12;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f rotateY(float f) {
        return this.rotateY(f, this);
    }

    @Override
    public Matrix4x3f rotateZ(float f, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.rotationZ(f);
        }
        if ((this.properties & 8) != 0) {
            float f2 = this.m30;
            float f3 = this.m31;
            float f4 = this.m32;
            return matrix4x3f.rotationZ(f).setTranslation(f2, f3, f4);
        }
        return this.rotateZInternal(f, matrix4x3f);
    }

    private Matrix4x3f rotateZInternal(float f, Matrix4x3f matrix4x3f) {
        float f2;
        float f3 = Math.sin(f);
        float f4 = f2 = Math.cosFromSin(f3, f);
        float f5 = f3;
        float f6 = -f3;
        float f7 = f2;
        float f8 = this.m00 * f4 + this.m10 * f5;
        float f9 = this.m01 * f4 + this.m11 * f5;
        float f10 = this.m02 * f4 + this.m12 * f5;
        matrix4x3f.m10 = this.m00 * f6 + this.m10 * f7;
        matrix4x3f.m11 = this.m01 * f6 + this.m11 * f7;
        matrix4x3f.m12 = this.m02 * f6 + this.m12 * f7;
        matrix4x3f.m00 = f8;
        matrix4x3f.m01 = f9;
        matrix4x3f.m02 = f10;
        matrix4x3f.m20 = this.m20;
        matrix4x3f.m21 = this.m21;
        matrix4x3f.m22 = this.m22;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f rotateZ(float f) {
        return this.rotateZ(f, this);
    }

    public Matrix4x3f rotateXYZ(Vector3f vector3f) {
        return this.rotateXYZ(vector3f.x, vector3f.y, vector3f.z);
    }

    public Matrix4x3f rotateXYZ(float f, float f2, float f3) {
        return this.rotateXYZ(f, f2, f3, this);
    }

    @Override
    public Matrix4x3f rotateXYZ(float f, float f2, float f3, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.rotationXYZ(f, f2, f3);
        }
        if ((this.properties & 8) != 0) {
            float f4 = this.m30;
            float f5 = this.m31;
            float f6 = this.m32;
            return matrix4x3f.rotationXYZ(f, f2, f3).setTranslation(f4, f5, f6);
        }
        return this.rotateXYZInternal(f, f2, f3, matrix4x3f);
    }

    private Matrix4x3f rotateXYZInternal(float f, float f2, float f3, Matrix4x3f matrix4x3f) {
        float f4 = Math.sin(f);
        float f5 = Math.cosFromSin(f4, f);
        float f6 = Math.sin(f2);
        float f7 = Math.cosFromSin(f6, f2);
        float f8 = Math.sin(f3);
        float f9 = Math.cosFromSin(f8, f3);
        float f10 = -f4;
        float f11 = -f6;
        float f12 = -f8;
        float f13 = this.m10 * f5 + this.m20 * f4;
        float f14 = this.m11 * f5 + this.m21 * f4;
        float f15 = this.m12 * f5 + this.m22 * f4;
        float f16 = this.m10 * f10 + this.m20 * f5;
        float f17 = this.m11 * f10 + this.m21 * f5;
        float f18 = this.m12 * f10 + this.m22 * f5;
        float f19 = this.m00 * f7 + f16 * f11;
        float f20 = this.m01 * f7 + f17 * f11;
        float f21 = this.m02 * f7 + f18 * f11;
        matrix4x3f.m20 = this.m00 * f6 + f16 * f7;
        matrix4x3f.m21 = this.m01 * f6 + f17 * f7;
        matrix4x3f.m22 = this.m02 * f6 + f18 * f7;
        matrix4x3f.m00 = f19 * f9 + f13 * f8;
        matrix4x3f.m01 = f20 * f9 + f14 * f8;
        matrix4x3f.m02 = f21 * f9 + f15 * f8;
        matrix4x3f.m10 = f19 * f12 + f13 * f9;
        matrix4x3f.m11 = f20 * f12 + f14 * f9;
        matrix4x3f.m12 = f21 * f12 + f15 * f9;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f rotateZYX(Vector3f vector3f) {
        return this.rotateZYX(vector3f.z, vector3f.y, vector3f.x);
    }

    public Matrix4x3f rotateZYX(float f, float f2, float f3) {
        return this.rotateZYX(f, f2, f3, this);
    }

    @Override
    public Matrix4x3f rotateZYX(float f, float f2, float f3, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.rotationZYX(f, f2, f3);
        }
        if ((this.properties & 8) != 0) {
            float f4 = this.m30;
            float f5 = this.m31;
            float f6 = this.m32;
            return matrix4x3f.rotationZYX(f, f2, f3).setTranslation(f4, f5, f6);
        }
        return this.rotateZYXInternal(f, f2, f3, matrix4x3f);
    }

    private Matrix4x3f rotateZYXInternal(float f, float f2, float f3, Matrix4x3f matrix4x3f) {
        float f4 = Math.sin(f3);
        float f5 = Math.cosFromSin(f4, f3);
        float f6 = Math.sin(f2);
        float f7 = Math.cosFromSin(f6, f2);
        float f8 = Math.sin(f);
        float f9 = Math.cosFromSin(f8, f);
        float f10 = -f8;
        float f11 = -f6;
        float f12 = -f4;
        float f13 = this.m00 * f9 + this.m10 * f8;
        float f14 = this.m01 * f9 + this.m11 * f8;
        float f15 = this.m02 * f9 + this.m12 * f8;
        float f16 = this.m00 * f10 + this.m10 * f9;
        float f17 = this.m01 * f10 + this.m11 * f9;
        float f18 = this.m02 * f10 + this.m12 * f9;
        float f19 = f13 * f6 + this.m20 * f7;
        float f20 = f14 * f6 + this.m21 * f7;
        float f21 = f15 * f6 + this.m22 * f7;
        matrix4x3f.m00 = f13 * f7 + this.m20 * f11;
        matrix4x3f.m01 = f14 * f7 + this.m21 * f11;
        matrix4x3f.m02 = f15 * f7 + this.m22 * f11;
        matrix4x3f.m10 = f16 * f5 + f19 * f4;
        matrix4x3f.m11 = f17 * f5 + f20 * f4;
        matrix4x3f.m12 = f18 * f5 + f21 * f4;
        matrix4x3f.m20 = f16 * f12 + f19 * f5;
        matrix4x3f.m21 = f17 * f12 + f20 * f5;
        matrix4x3f.m22 = f18 * f12 + f21 * f5;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f rotateYXZ(Vector3f vector3f) {
        return this.rotateYXZ(vector3f.y, vector3f.x, vector3f.z);
    }

    public Matrix4x3f rotateYXZ(float f, float f2, float f3) {
        return this.rotateYXZ(f, f2, f3, this);
    }

    @Override
    public Matrix4x3f rotateYXZ(float f, float f2, float f3, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.rotationYXZ(f, f2, f3);
        }
        if ((this.properties & 8) != 0) {
            float f4 = this.m30;
            float f5 = this.m31;
            float f6 = this.m32;
            return matrix4x3f.rotationYXZ(f, f2, f3).setTranslation(f4, f5, f6);
        }
        return this.rotateYXZInternal(f, f2, f3, matrix4x3f);
    }

    private Matrix4x3f rotateYXZInternal(float f, float f2, float f3, Matrix4x3f matrix4x3f) {
        float f4 = Math.sin(f2);
        float f5 = Math.cosFromSin(f4, f2);
        float f6 = Math.sin(f);
        float f7 = Math.cosFromSin(f6, f);
        float f8 = Math.sin(f3);
        float f9 = Math.cosFromSin(f8, f3);
        float f10 = -f6;
        float f11 = -f4;
        float f12 = -f8;
        float f13 = this.m00 * f6 + this.m20 * f7;
        float f14 = this.m01 * f6 + this.m21 * f7;
        float f15 = this.m02 * f6 + this.m22 * f7;
        float f16 = this.m00 * f7 + this.m20 * f10;
        float f17 = this.m01 * f7 + this.m21 * f10;
        float f18 = this.m02 * f7 + this.m22 * f10;
        float f19 = this.m10 * f5 + f13 * f4;
        float f20 = this.m11 * f5 + f14 * f4;
        float f21 = this.m12 * f5 + f15 * f4;
        matrix4x3f.m20 = this.m10 * f11 + f13 * f5;
        matrix4x3f.m21 = this.m11 * f11 + f14 * f5;
        matrix4x3f.m22 = this.m12 * f11 + f15 * f5;
        matrix4x3f.m00 = f16 * f9 + f19 * f8;
        matrix4x3f.m01 = f17 * f9 + f20 * f8;
        matrix4x3f.m02 = f18 * f9 + f21 * f8;
        matrix4x3f.m10 = f16 * f12 + f19 * f9;
        matrix4x3f.m11 = f17 * f12 + f20 * f9;
        matrix4x3f.m12 = f18 * f12 + f21 * f9;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    @Override
    public Matrix4x3f rotate(float f, float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.rotation(f, f2, f3, f4);
        }
        if ((this.properties & 8) != 0) {
            return this.rotateTranslation(f, f2, f3, f4, matrix4x3f);
        }
        return this.rotateGeneric(f, f2, f3, f4, matrix4x3f);
    }

    private Matrix4x3f rotateGeneric(float f, float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        if (f3 == 0.0f && f4 == 0.0f && Math.absEqualsOne(f2)) {
            return this.rotateX(f2 * f, matrix4x3f);
        }
        if (f2 == 0.0f && f4 == 0.0f && Math.absEqualsOne(f3)) {
            return this.rotateY(f3 * f, matrix4x3f);
        }
        if (f2 == 0.0f && f3 == 0.0f && Math.absEqualsOne(f4)) {
            return this.rotateZ(f4 * f, matrix4x3f);
        }
        return this.rotateGenericInternal(f, f2, f3, f4, matrix4x3f);
    }

    private Matrix4x3f rotateGenericInternal(float f, float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        float f5 = Math.sin(f);
        float f6 = Math.cosFromSin(f5, f);
        float f7 = 1.0f - f6;
        float f8 = f2 * f2;
        float f9 = f2 * f3;
        float f10 = f2 * f4;
        float f11 = f3 * f3;
        float f12 = f3 * f4;
        float f13 = f4 * f4;
        float f14 = f8 * f7 + f6;
        float f15 = f9 * f7 + f4 * f5;
        float f16 = f10 * f7 - f3 * f5;
        float f17 = f9 * f7 - f4 * f5;
        float f18 = f11 * f7 + f6;
        float f19 = f12 * f7 + f2 * f5;
        float f20 = f10 * f7 + f3 * f5;
        float f21 = f12 * f7 - f2 * f5;
        float f22 = f13 * f7 + f6;
        float f23 = this.m00 * f14 + this.m10 * f15 + this.m20 * f16;
        float f24 = this.m01 * f14 + this.m11 * f15 + this.m21 * f16;
        float f25 = this.m02 * f14 + this.m12 * f15 + this.m22 * f16;
        float f26 = this.m00 * f17 + this.m10 * f18 + this.m20 * f19;
        float f27 = this.m01 * f17 + this.m11 * f18 + this.m21 * f19;
        float f28 = this.m02 * f17 + this.m12 * f18 + this.m22 * f19;
        matrix4x3f.m20 = this.m00 * f20 + this.m10 * f21 + this.m20 * f22;
        matrix4x3f.m21 = this.m01 * f20 + this.m11 * f21 + this.m21 * f22;
        matrix4x3f.m22 = this.m02 * f20 + this.m12 * f21 + this.m22 * f22;
        matrix4x3f.m00 = f23;
        matrix4x3f.m01 = f24;
        matrix4x3f.m02 = f25;
        matrix4x3f.m10 = f26;
        matrix4x3f.m11 = f27;
        matrix4x3f.m12 = f28;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f rotate(float f, float f2, float f3, float f4) {
        return this.rotate(f, f2, f3, f4, this);
    }

    @Override
    public Matrix4x3f rotateTranslation(float f, float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        float f5 = this.m30;
        float f6 = this.m31;
        float f7 = this.m32;
        if (f3 == 0.0f && f4 == 0.0f && Math.absEqualsOne(f2)) {
            return matrix4x3f.rotationX(f2 * f).setTranslation(f5, f6, f7);
        }
        if (f2 == 0.0f && f4 == 0.0f && Math.absEqualsOne(f3)) {
            return matrix4x3f.rotationY(f3 * f).setTranslation(f5, f6, f7);
        }
        if (f2 == 0.0f && f3 == 0.0f && Math.absEqualsOne(f4)) {
            return matrix4x3f.rotationZ(f4 * f).setTranslation(f5, f6, f7);
        }
        return this.rotateTranslationInternal(f, f2, f3, f4, matrix4x3f);
    }

    private Matrix4x3f rotateTranslationInternal(float f, float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        float f5 = Math.sin(f);
        float f6 = Math.cosFromSin(f5, f);
        float f7 = 1.0f - f6;
        float f8 = f2 * f2;
        float f9 = f2 * f3;
        float f10 = f2 * f4;
        float f11 = f3 * f3;
        float f12 = f3 * f4;
        float f13 = f4 * f4;
        float f14 = f8 * f7 + f6;
        float f15 = f9 * f7 + f4 * f5;
        float f16 = f10 * f7 - f3 * f5;
        float f17 = f9 * f7 - f4 * f5;
        float f18 = f11 * f7 + f6;
        float f19 = f12 * f7 + f2 * f5;
        float f20 = f10 * f7 + f3 * f5;
        float f21 = f12 * f7 - f2 * f5;
        float f22 = f13 * f7 + f6;
        float f23 = f14;
        float f24 = f15;
        float f25 = f16;
        float f26 = f17;
        float f27 = f18;
        float f28 = f19;
        matrix4x3f.m20 = f20;
        matrix4x3f.m21 = f21;
        matrix4x3f.m22 = f22;
        matrix4x3f.m00 = f23;
        matrix4x3f.m01 = f24;
        matrix4x3f.m02 = f25;
        matrix4x3f.m10 = f26;
        matrix4x3f.m11 = f27;
        matrix4x3f.m12 = f28;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f rotateAround(Quaternionfc quaternionfc, float f, float f2, float f3) {
        return this.rotateAround(quaternionfc, f, f2, f3, this);
    }

    private Matrix4x3f rotateAroundAffine(Quaternionfc quaternionfc, float f, float f2, float f3, Matrix4x3f matrix4x3f) {
        float f4 = quaternionfc.w() * quaternionfc.w();
        float f5 = quaternionfc.x() * quaternionfc.x();
        float f6 = quaternionfc.y() * quaternionfc.y();
        float f7 = quaternionfc.z() * quaternionfc.z();
        float f8 = quaternionfc.z() * quaternionfc.w();
        float f9 = f8 + f8;
        float f10 = quaternionfc.x() * quaternionfc.y();
        float f11 = f10 + f10;
        float f12 = quaternionfc.x() * quaternionfc.z();
        float f13 = f12 + f12;
        float f14 = quaternionfc.y() * quaternionfc.w();
        float f15 = f14 + f14;
        float f16 = quaternionfc.y() * quaternionfc.z();
        float f17 = f16 + f16;
        float f18 = quaternionfc.x() * quaternionfc.w();
        float f19 = f18 + f18;
        float f20 = f4 + f5 - f7 - f6;
        float f21 = f11 + f9;
        float f22 = f13 - f15;
        float f23 = f11 - f9;
        float f24 = f6 - f7 + f4 - f5;
        float f25 = f17 + f19;
        float f26 = f15 + f13;
        float f27 = f17 - f19;
        float f28 = f7 - f6 - f5 + f4;
        float f29 = this.m00 * f + this.m10 * f2 + this.m20 * f3 + this.m30;
        float f30 = this.m01 * f + this.m11 * f2 + this.m21 * f3 + this.m31;
        float f31 = this.m02 * f + this.m12 * f2 + this.m22 * f3 + this.m32;
        float f32 = this.m00 * f20 + this.m10 * f21 + this.m20 * f22;
        float f33 = this.m01 * f20 + this.m11 * f21 + this.m21 * f22;
        float f34 = this.m02 * f20 + this.m12 * f21 + this.m22 * f22;
        float f35 = this.m00 * f23 + this.m10 * f24 + this.m20 * f25;
        float f36 = this.m01 * f23 + this.m11 * f24 + this.m21 * f25;
        float f37 = this.m02 * f23 + this.m12 * f24 + this.m22 * f25;
        matrix4x3f._m20(this.m00 * f26 + this.m10 * f27 + this.m20 * f28)._m21(this.m01 * f26 + this.m11 * f27 + this.m21 * f28)._m22(this.m02 * f26 + this.m12 * f27 + this.m22 * f28)._m00(f32)._m01(f33)._m02(f34)._m10(f35)._m11(f36)._m12(f37)._m30(-f32 * f - f35 * f2 - this.m20 * f3 + f29)._m31(-f33 * f - f36 * f2 - this.m21 * f3 + f30)._m32(-f34 * f - f37 * f2 - this.m22 * f3 + f31)._properties(this.properties & 0xFFFFFFF3);
        return matrix4x3f;
    }

    @Override
    public Matrix4x3f rotateAround(Quaternionfc quaternionfc, float f, float f2, float f3, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return this.rotationAround(quaternionfc, f, f2, f3);
        }
        return this.rotateAroundAffine(quaternionfc, f, f2, f3, matrix4x3f);
    }

    public Matrix4x3f rotationAround(Quaternionfc quaternionfc, float f, float f2, float f3) {
        float f4 = quaternionfc.w() * quaternionfc.w();
        float f5 = quaternionfc.x() * quaternionfc.x();
        float f6 = quaternionfc.y() * quaternionfc.y();
        float f7 = quaternionfc.z() * quaternionfc.z();
        float f8 = quaternionfc.z() * quaternionfc.w();
        float f9 = f8 + f8;
        float f10 = quaternionfc.x() * quaternionfc.y();
        float f11 = f10 + f10;
        float f12 = quaternionfc.x() * quaternionfc.z();
        float f13 = f12 + f12;
        float f14 = quaternionfc.y() * quaternionfc.w();
        float f15 = f14 + f14;
        float f16 = quaternionfc.y() * quaternionfc.z();
        float f17 = f16 + f16;
        float f18 = quaternionfc.x() * quaternionfc.w();
        float f19 = f18 + f18;
        this._m20(f15 + f13);
        this._m21(f17 - f19);
        this._m22(f7 - f6 - f5 + f4);
        this._m00(f4 + f5 - f7 - f6);
        this._m01(f11 + f9);
        this._m02(f13 - f15);
        this._m10(f11 - f9);
        this._m11(f6 - f7 + f4 - f5);
        this._m12(f17 + f19);
        this._m30(-this.m00 * f - this.m10 * f2 - this.m20 * f3 + f);
        this._m31(-this.m01 * f - this.m11 * f2 - this.m21 * f3 + f2);
        this._m32(-this.m02 * f - this.m12 * f2 - this.m22 * f3 + f3);
        this.properties = 16;
        return this;
    }

    @Override
    public Matrix4x3f rotateLocal(float f, float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        if (f3 == 0.0f && f4 == 0.0f && Math.absEqualsOne(f2)) {
            return this.rotateLocalX(f2 * f, matrix4x3f);
        }
        if (f2 == 0.0f && f4 == 0.0f && Math.absEqualsOne(f3)) {
            return this.rotateLocalY(f3 * f, matrix4x3f);
        }
        if (f2 == 0.0f && f3 == 0.0f && Math.absEqualsOne(f4)) {
            return this.rotateLocalZ(f4 * f, matrix4x3f);
        }
        return this.rotateLocalInternal(f, f2, f3, f4, matrix4x3f);
    }

    private Matrix4x3f rotateLocalInternal(float f, float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        float f5 = Math.sin(f);
        float f6 = Math.cosFromSin(f5, f);
        float f7 = 1.0f - f6;
        float f8 = f2 * f2;
        float f9 = f2 * f3;
        float f10 = f2 * f4;
        float f11 = f3 * f3;
        float f12 = f3 * f4;
        float f13 = f4 * f4;
        float f14 = f8 * f7 + f6;
        float f15 = f9 * f7 + f4 * f5;
        float f16 = f10 * f7 - f3 * f5;
        float f17 = f9 * f7 - f4 * f5;
        float f18 = f11 * f7 + f6;
        float f19 = f12 * f7 + f2 * f5;
        float f20 = f10 * f7 + f3 * f5;
        float f21 = f12 * f7 - f2 * f5;
        float f22 = f13 * f7 + f6;
        float f23 = f14 * this.m00 + f17 * this.m01 + f20 * this.m02;
        float f24 = f15 * this.m00 + f18 * this.m01 + f21 * this.m02;
        float f25 = f16 * this.m00 + f19 * this.m01 + f22 * this.m02;
        float f26 = f14 * this.m10 + f17 * this.m11 + f20 * this.m12;
        float f27 = f15 * this.m10 + f18 * this.m11 + f21 * this.m12;
        float f28 = f16 * this.m10 + f19 * this.m11 + f22 * this.m12;
        float f29 = f14 * this.m20 + f17 * this.m21 + f20 * this.m22;
        float f30 = f15 * this.m20 + f18 * this.m21 + f21 * this.m22;
        float f31 = f16 * this.m20 + f19 * this.m21 + f22 * this.m22;
        float f32 = f14 * this.m30 + f17 * this.m31 + f20 * this.m32;
        float f33 = f15 * this.m30 + f18 * this.m31 + f21 * this.m32;
        float f34 = f16 * this.m30 + f19 * this.m31 + f22 * this.m32;
        matrix4x3f.m00 = f23;
        matrix4x3f.m01 = f24;
        matrix4x3f.m02 = f25;
        matrix4x3f.m10 = f26;
        matrix4x3f.m11 = f27;
        matrix4x3f.m12 = f28;
        matrix4x3f.m20 = f29;
        matrix4x3f.m21 = f30;
        matrix4x3f.m22 = f31;
        matrix4x3f.m30 = f32;
        matrix4x3f.m31 = f33;
        matrix4x3f.m32 = f34;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f rotateLocal(float f, float f2, float f3, float f4) {
        return this.rotateLocal(f, f2, f3, f4, this);
    }

    public Matrix4x3f rotateLocalX(float f, Matrix4x3f matrix4x3f) {
        float f2 = Math.sin(f);
        float f3 = Math.cosFromSin(f2, f);
        float f4 = f3 * this.m01 - f2 * this.m02;
        float f5 = f2 * this.m01 + f3 * this.m02;
        float f6 = f3 * this.m11 - f2 * this.m12;
        float f7 = f2 * this.m11 + f3 * this.m12;
        float f8 = f3 * this.m21 - f2 * this.m22;
        float f9 = f2 * this.m21 + f3 * this.m22;
        float f10 = f3 * this.m31 - f2 * this.m32;
        float f11 = f2 * this.m31 + f3 * this.m32;
        matrix4x3f._m00(this.m00)._m01(f4)._m02(f5)._m10(this.m10)._m11(f6)._m12(f7)._m20(this.m20)._m21(f8)._m22(f9)._m30(this.m30)._m31(f10)._m32(f11)._properties(this.properties & 0xFFFFFFF3);
        return matrix4x3f;
    }

    public Matrix4x3f rotateLocalX(float f) {
        return this.rotateLocalX(f, this);
    }

    public Matrix4x3f rotateLocalY(float f, Matrix4x3f matrix4x3f) {
        float f2 = Math.sin(f);
        float f3 = Math.cosFromSin(f2, f);
        float f4 = f3 * this.m00 + f2 * this.m02;
        float f5 = -f2 * this.m00 + f3 * this.m02;
        float f6 = f3 * this.m10 + f2 * this.m12;
        float f7 = -f2 * this.m10 + f3 * this.m12;
        float f8 = f3 * this.m20 + f2 * this.m22;
        float f9 = -f2 * this.m20 + f3 * this.m22;
        float f10 = f3 * this.m30 + f2 * this.m32;
        float f11 = -f2 * this.m30 + f3 * this.m32;
        matrix4x3f._m00(f4)._m01(this.m01)._m02(f5)._m10(f6)._m11(this.m11)._m12(f7)._m20(f8)._m21(this.m21)._m22(f9)._m30(f10)._m31(this.m31)._m32(f11)._properties(this.properties & 0xFFFFFFF3);
        return matrix4x3f;
    }

    public Matrix4x3f rotateLocalY(float f) {
        return this.rotateLocalY(f, this);
    }

    public Matrix4x3f rotateLocalZ(float f, Matrix4x3f matrix4x3f) {
        float f2 = Math.sin(f);
        float f3 = Math.cosFromSin(f2, f);
        float f4 = f3 * this.m00 - f2 * this.m01;
        float f5 = f2 * this.m00 + f3 * this.m01;
        float f6 = f3 * this.m10 - f2 * this.m11;
        float f7 = f2 * this.m10 + f3 * this.m11;
        float f8 = f3 * this.m20 - f2 * this.m21;
        float f9 = f2 * this.m20 + f3 * this.m21;
        float f10 = f3 * this.m30 - f2 * this.m31;
        float f11 = f2 * this.m30 + f3 * this.m31;
        matrix4x3f._m00(f4)._m01(f5)._m02(this.m02)._m10(f6)._m11(f7)._m12(this.m12)._m20(f8)._m21(f9)._m22(this.m22)._m30(f10)._m31(f11)._m32(this.m32)._properties(this.properties & 0xFFFFFFF3);
        return matrix4x3f;
    }

    public Matrix4x3f rotateLocalZ(float f) {
        return this.rotateLocalZ(f, this);
    }

    public Matrix4x3f translate(Vector3fc vector3fc) {
        return this.translate(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    @Override
    public Matrix4x3f translate(Vector3fc vector3fc, Matrix4x3f matrix4x3f) {
        return this.translate(vector3fc.x(), vector3fc.y(), vector3fc.z(), matrix4x3f);
    }

    @Override
    public Matrix4x3f translate(float f, float f2, float f3, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.translation(f, f2, f3);
        }
        return this.translateGeneric(f, f2, f3, matrix4x3f);
    }

    private Matrix4x3f translateGeneric(float f, float f2, float f3, Matrix4x3f matrix4x3f) {
        MemUtil.INSTANCE.copy(this, matrix4x3f);
        matrix4x3f.m30 = this.m00 * f + this.m10 * f2 + this.m20 * f3 + this.m30;
        matrix4x3f.m31 = this.m01 * f + this.m11 * f2 + this.m21 * f3 + this.m31;
        matrix4x3f.m32 = this.m02 * f + this.m12 * f2 + this.m22 * f3 + this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFFB;
        return matrix4x3f;
    }

    public Matrix4x3f translate(float f, float f2, float f3) {
        if ((this.properties & 4) != 0) {
            return this.translation(f, f2, f3);
        }
        Matrix4x3f matrix4x3f = this;
        matrix4x3f.m30 = matrix4x3f.m00 * f + matrix4x3f.m10 * f2 + matrix4x3f.m20 * f3 + matrix4x3f.m30;
        matrix4x3f.m31 = matrix4x3f.m01 * f + matrix4x3f.m11 * f2 + matrix4x3f.m21 * f3 + matrix4x3f.m31;
        matrix4x3f.m32 = matrix4x3f.m02 * f + matrix4x3f.m12 * f2 + matrix4x3f.m22 * f3 + matrix4x3f.m32;
        matrix4x3f.properties &= 0xFFFFFFFB;
        return this;
    }

    public Matrix4x3f translateLocal(Vector3fc vector3fc) {
        return this.translateLocal(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    @Override
    public Matrix4x3f translateLocal(Vector3fc vector3fc, Matrix4x3f matrix4x3f) {
        return this.translateLocal(vector3fc.x(), vector3fc.y(), vector3fc.z(), matrix4x3f);
    }

    @Override
    public Matrix4x3f translateLocal(float f, float f2, float f3, Matrix4x3f matrix4x3f) {
        matrix4x3f.m00 = this.m00;
        matrix4x3f.m01 = this.m01;
        matrix4x3f.m02 = this.m02;
        matrix4x3f.m10 = this.m10;
        matrix4x3f.m11 = this.m11;
        matrix4x3f.m12 = this.m12;
        matrix4x3f.m20 = this.m20;
        matrix4x3f.m21 = this.m21;
        matrix4x3f.m22 = this.m22;
        matrix4x3f.m30 = this.m30 + f;
        matrix4x3f.m31 = this.m31 + f2;
        matrix4x3f.m32 = this.m32 + f3;
        matrix4x3f.properties = this.properties & 0xFFFFFFFB;
        return matrix4x3f;
    }

    public Matrix4x3f translateLocal(float f, float f2, float f3) {
        return this.translateLocal(f, f2, f3, this);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeFloat(this.m00);
        objectOutput.writeFloat(this.m01);
        objectOutput.writeFloat(this.m02);
        objectOutput.writeFloat(this.m10);
        objectOutput.writeFloat(this.m11);
        objectOutput.writeFloat(this.m12);
        objectOutput.writeFloat(this.m20);
        objectOutput.writeFloat(this.m21);
        objectOutput.writeFloat(this.m22);
        objectOutput.writeFloat(this.m30);
        objectOutput.writeFloat(this.m31);
        objectOutput.writeFloat(this.m32);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.m00 = objectInput.readFloat();
        this.m01 = objectInput.readFloat();
        this.m02 = objectInput.readFloat();
        this.m10 = objectInput.readFloat();
        this.m11 = objectInput.readFloat();
        this.m12 = objectInput.readFloat();
        this.m20 = objectInput.readFloat();
        this.m21 = objectInput.readFloat();
        this.m22 = objectInput.readFloat();
        this.m30 = objectInput.readFloat();
        this.m31 = objectInput.readFloat();
        this.m32 = objectInput.readFloat();
        this.determineProperties();
    }

    @Override
    public Matrix4x3f ortho(float f, float f2, float f3, float f4, float f5, float f6, boolean bl, Matrix4x3f matrix4x3f) {
        float f7 = 2.0f / (f2 - f);
        float f8 = 2.0f / (f4 - f3);
        float f9 = (bl ? 1.0f : 2.0f) / (f5 - f6);
        float f10 = (f + f2) / (f - f2);
        float f11 = (f4 + f3) / (f3 - f4);
        float f12 = (bl ? f5 : f6 + f5) / (f5 - f6);
        matrix4x3f.m30 = this.m00 * f10 + this.m10 * f11 + this.m20 * f12 + this.m30;
        matrix4x3f.m31 = this.m01 * f10 + this.m11 * f11 + this.m21 * f12 + this.m31;
        matrix4x3f.m32 = this.m02 * f10 + this.m12 * f11 + this.m22 * f12 + this.m32;
        matrix4x3f.m00 = this.m00 * f7;
        matrix4x3f.m01 = this.m01 * f7;
        matrix4x3f.m02 = this.m02 * f7;
        matrix4x3f.m10 = this.m10 * f8;
        matrix4x3f.m11 = this.m11 * f8;
        matrix4x3f.m12 = this.m12 * f8;
        matrix4x3f.m20 = this.m20 * f9;
        matrix4x3f.m21 = this.m21 * f9;
        matrix4x3f.m22 = this.m22 * f9;
        matrix4x3f.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3f;
    }

    @Override
    public Matrix4x3f ortho(float f, float f2, float f3, float f4, float f5, float f6, Matrix4x3f matrix4x3f) {
        return this.ortho(f, f2, f3, f4, f5, f6, false, matrix4x3f);
    }

    public Matrix4x3f ortho(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        return this.ortho(f, f2, f3, f4, f5, f6, bl, this);
    }

    public Matrix4x3f ortho(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.ortho(f, f2, f3, f4, f5, f6, false);
    }

    @Override
    public Matrix4x3f orthoLH(float f, float f2, float f3, float f4, float f5, float f6, boolean bl, Matrix4x3f matrix4x3f) {
        float f7 = 2.0f / (f2 - f);
        float f8 = 2.0f / (f4 - f3);
        float f9 = (bl ? 1.0f : 2.0f) / (f6 - f5);
        float f10 = (f + f2) / (f - f2);
        float f11 = (f4 + f3) / (f3 - f4);
        float f12 = (bl ? f5 : f6 + f5) / (f5 - f6);
        matrix4x3f.m30 = this.m00 * f10 + this.m10 * f11 + this.m20 * f12 + this.m30;
        matrix4x3f.m31 = this.m01 * f10 + this.m11 * f11 + this.m21 * f12 + this.m31;
        matrix4x3f.m32 = this.m02 * f10 + this.m12 * f11 + this.m22 * f12 + this.m32;
        matrix4x3f.m00 = this.m00 * f7;
        matrix4x3f.m01 = this.m01 * f7;
        matrix4x3f.m02 = this.m02 * f7;
        matrix4x3f.m10 = this.m10 * f8;
        matrix4x3f.m11 = this.m11 * f8;
        matrix4x3f.m12 = this.m12 * f8;
        matrix4x3f.m20 = this.m20 * f9;
        matrix4x3f.m21 = this.m21 * f9;
        matrix4x3f.m22 = this.m22 * f9;
        matrix4x3f.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3f;
    }

    @Override
    public Matrix4x3f orthoLH(float f, float f2, float f3, float f4, float f5, float f6, Matrix4x3f matrix4x3f) {
        return this.orthoLH(f, f2, f3, f4, f5, f6, false, matrix4x3f);
    }

    public Matrix4x3f orthoLH(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        return this.orthoLH(f, f2, f3, f4, f5, f6, bl, this);
    }

    public Matrix4x3f orthoLH(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.orthoLH(f, f2, f3, f4, f5, f6, false);
    }

    public Matrix4x3f setOrtho(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        MemUtil.INSTANCE.identity(this);
        this.m00 = 2.0f / (f2 - f);
        this.m11 = 2.0f / (f4 - f3);
        this.m22 = (bl ? 1.0f : 2.0f) / (f5 - f6);
        this.m30 = (f2 + f) / (f - f2);
        this.m31 = (f4 + f3) / (f3 - f4);
        this.m32 = (bl ? f5 : f6 + f5) / (f5 - f6);
        this.properties = 0;
        return this;
    }

    public Matrix4x3f setOrtho(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.setOrtho(f, f2, f3, f4, f5, f6, false);
    }

    public Matrix4x3f setOrthoLH(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        MemUtil.INSTANCE.identity(this);
        this.m00 = 2.0f / (f2 - f);
        this.m11 = 2.0f / (f4 - f3);
        this.m22 = (bl ? 1.0f : 2.0f) / (f6 - f5);
        this.m30 = (f2 + f) / (f - f2);
        this.m31 = (f4 + f3) / (f3 - f4);
        this.m32 = (bl ? f5 : f6 + f5) / (f5 - f6);
        this.properties = 0;
        return this;
    }

    public Matrix4x3f setOrthoLH(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.setOrthoLH(f, f2, f3, f4, f5, f6, false);
    }

    @Override
    public Matrix4x3f orthoSymmetric(float f, float f2, float f3, float f4, boolean bl, Matrix4x3f matrix4x3f) {
        float f5 = 2.0f / f;
        float f6 = 2.0f / f2;
        float f7 = (bl ? 1.0f : 2.0f) / (f3 - f4);
        float f8 = (bl ? f3 : f4 + f3) / (f3 - f4);
        matrix4x3f.m30 = this.m20 * f8 + this.m30;
        matrix4x3f.m31 = this.m21 * f8 + this.m31;
        matrix4x3f.m32 = this.m22 * f8 + this.m32;
        matrix4x3f.m00 = this.m00 * f5;
        matrix4x3f.m01 = this.m01 * f5;
        matrix4x3f.m02 = this.m02 * f5;
        matrix4x3f.m10 = this.m10 * f6;
        matrix4x3f.m11 = this.m11 * f6;
        matrix4x3f.m12 = this.m12 * f6;
        matrix4x3f.m20 = this.m20 * f7;
        matrix4x3f.m21 = this.m21 * f7;
        matrix4x3f.m22 = this.m22 * f7;
        matrix4x3f.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3f;
    }

    @Override
    public Matrix4x3f orthoSymmetric(float f, float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        return this.orthoSymmetric(f, f2, f3, f4, false, matrix4x3f);
    }

    public Matrix4x3f orthoSymmetric(float f, float f2, float f3, float f4, boolean bl) {
        return this.orthoSymmetric(f, f2, f3, f4, bl, this);
    }

    public Matrix4x3f orthoSymmetric(float f, float f2, float f3, float f4) {
        return this.orthoSymmetric(f, f2, f3, f4, false, this);
    }

    @Override
    public Matrix4x3f orthoSymmetricLH(float f, float f2, float f3, float f4, boolean bl, Matrix4x3f matrix4x3f) {
        float f5 = 2.0f / f;
        float f6 = 2.0f / f2;
        float f7 = (bl ? 1.0f : 2.0f) / (f4 - f3);
        float f8 = (bl ? f3 : f4 + f3) / (f3 - f4);
        matrix4x3f.m30 = this.m20 * f8 + this.m30;
        matrix4x3f.m31 = this.m21 * f8 + this.m31;
        matrix4x3f.m32 = this.m22 * f8 + this.m32;
        matrix4x3f.m00 = this.m00 * f5;
        matrix4x3f.m01 = this.m01 * f5;
        matrix4x3f.m02 = this.m02 * f5;
        matrix4x3f.m10 = this.m10 * f6;
        matrix4x3f.m11 = this.m11 * f6;
        matrix4x3f.m12 = this.m12 * f6;
        matrix4x3f.m20 = this.m20 * f7;
        matrix4x3f.m21 = this.m21 * f7;
        matrix4x3f.m22 = this.m22 * f7;
        matrix4x3f.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3f;
    }

    @Override
    public Matrix4x3f orthoSymmetricLH(float f, float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        return this.orthoSymmetricLH(f, f2, f3, f4, false, matrix4x3f);
    }

    public Matrix4x3f orthoSymmetricLH(float f, float f2, float f3, float f4, boolean bl) {
        return this.orthoSymmetricLH(f, f2, f3, f4, bl, this);
    }

    public Matrix4x3f orthoSymmetricLH(float f, float f2, float f3, float f4) {
        return this.orthoSymmetricLH(f, f2, f3, f4, false, this);
    }

    public Matrix4x3f setOrthoSymmetric(float f, float f2, float f3, float f4, boolean bl) {
        MemUtil.INSTANCE.identity(this);
        this.m00 = 2.0f / f;
        this.m11 = 2.0f / f2;
        this.m22 = (bl ? 1.0f : 2.0f) / (f3 - f4);
        this.m32 = (bl ? f3 : f4 + f3) / (f3 - f4);
        this.properties = 0;
        return this;
    }

    public Matrix4x3f setOrthoSymmetric(float f, float f2, float f3, float f4) {
        return this.setOrthoSymmetric(f, f2, f3, f4, false);
    }

    public Matrix4x3f setOrthoSymmetricLH(float f, float f2, float f3, float f4, boolean bl) {
        MemUtil.INSTANCE.identity(this);
        this.m00 = 2.0f / f;
        this.m11 = 2.0f / f2;
        this.m22 = (bl ? 1.0f : 2.0f) / (f4 - f3);
        this.m32 = (bl ? f3 : f4 + f3) / (f3 - f4);
        this.properties = 0;
        return this;
    }

    public Matrix4x3f setOrthoSymmetricLH(float f, float f2, float f3, float f4) {
        return this.setOrthoSymmetricLH(f, f2, f3, f4, false);
    }

    @Override
    public Matrix4x3f ortho2D(float f, float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        float f5 = 2.0f / (f2 - f);
        float f6 = 2.0f / (f4 - f3);
        float f7 = -(f2 + f) / (f2 - f);
        float f8 = -(f4 + f3) / (f4 - f3);
        matrix4x3f.m30 = this.m00 * f7 + this.m10 * f8 + this.m30;
        matrix4x3f.m31 = this.m01 * f7 + this.m11 * f8 + this.m31;
        matrix4x3f.m32 = this.m02 * f7 + this.m12 * f8 + this.m32;
        matrix4x3f.m00 = this.m00 * f5;
        matrix4x3f.m01 = this.m01 * f5;
        matrix4x3f.m02 = this.m02 * f5;
        matrix4x3f.m10 = this.m10 * f6;
        matrix4x3f.m11 = this.m11 * f6;
        matrix4x3f.m12 = this.m12 * f6;
        matrix4x3f.m20 = -this.m20;
        matrix4x3f.m21 = -this.m21;
        matrix4x3f.m22 = -this.m22;
        matrix4x3f.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3f;
    }

    public Matrix4x3f ortho2D(float f, float f2, float f3, float f4) {
        return this.ortho2D(f, f2, f3, f4, this);
    }

    @Override
    public Matrix4x3f ortho2DLH(float f, float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        float f5 = 2.0f / (f2 - f);
        float f6 = 2.0f / (f4 - f3);
        float f7 = -(f2 + f) / (f2 - f);
        float f8 = -(f4 + f3) / (f4 - f3);
        matrix4x3f.m30 = this.m00 * f7 + this.m10 * f8 + this.m30;
        matrix4x3f.m31 = this.m01 * f7 + this.m11 * f8 + this.m31;
        matrix4x3f.m32 = this.m02 * f7 + this.m12 * f8 + this.m32;
        matrix4x3f.m00 = this.m00 * f5;
        matrix4x3f.m01 = this.m01 * f5;
        matrix4x3f.m02 = this.m02 * f5;
        matrix4x3f.m10 = this.m10 * f6;
        matrix4x3f.m11 = this.m11 * f6;
        matrix4x3f.m12 = this.m12 * f6;
        matrix4x3f.m20 = this.m20;
        matrix4x3f.m21 = this.m21;
        matrix4x3f.m22 = this.m22;
        matrix4x3f.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3f;
    }

    public Matrix4x3f ortho2DLH(float f, float f2, float f3, float f4) {
        return this.ortho2DLH(f, f2, f3, f4, this);
    }

    public Matrix4x3f setOrtho2D(float f, float f2, float f3, float f4) {
        MemUtil.INSTANCE.identity(this);
        this.m00 = 2.0f / (f2 - f);
        this.m11 = 2.0f / (f4 - f3);
        this.m22 = -1.0f;
        this.m30 = -(f2 + f) / (f2 - f);
        this.m31 = -(f4 + f3) / (f4 - f3);
        this.properties = 0;
        return this;
    }

    public Matrix4x3f setOrtho2DLH(float f, float f2, float f3, float f4) {
        MemUtil.INSTANCE.identity(this);
        this.m00 = 2.0f / (f2 - f);
        this.m11 = 2.0f / (f4 - f3);
        this.m22 = 1.0f;
        this.m30 = -(f2 + f) / (f2 - f);
        this.m31 = -(f4 + f3) / (f4 - f3);
        this.properties = 0;
        return this;
    }

    public Matrix4x3f lookAlong(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.lookAlong(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), this);
    }

    @Override
    public Matrix4x3f lookAlong(Vector3fc vector3fc, Vector3fc vector3fc2, Matrix4x3f matrix4x3f) {
        return this.lookAlong(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), matrix4x3f);
    }

    @Override
    public Matrix4x3f lookAlong(float f, float f2, float f3, float f4, float f5, float f6, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return this.setLookAlong(f, f2, f3, f4, f5, f6);
        }
        float f7 = Math.invsqrt(f * f + f2 * f2 + f3 * f3);
        float f8 = f5 * (f3 *= -f7) - f6 * (f2 *= -f7);
        float f9 = f6 * (f *= -f7) - f4 * f3;
        float f10 = f4 * f2 - f5 * f;
        float f11 = Math.invsqrt(f8 * f8 + f9 * f9 + f10 * f10);
        float f12 = f2 * (f10 *= f11) - f3 * (f9 *= f11);
        float f13 = f3 * (f8 *= f11) - f * f10;
        float f14 = f * f9 - f2 * f8;
        float f15 = f8;
        float f16 = f12;
        float f17 = f;
        float f18 = f9;
        float f19 = f13;
        float f20 = f2;
        float f21 = f10;
        float f22 = f14;
        float f23 = f3;
        float f24 = this.m00 * f15 + this.m10 * f16 + this.m20 * f17;
        float f25 = this.m01 * f15 + this.m11 * f16 + this.m21 * f17;
        float f26 = this.m02 * f15 + this.m12 * f16 + this.m22 * f17;
        float f27 = this.m00 * f18 + this.m10 * f19 + this.m20 * f20;
        float f28 = this.m01 * f18 + this.m11 * f19 + this.m21 * f20;
        float f29 = this.m02 * f18 + this.m12 * f19 + this.m22 * f20;
        matrix4x3f.m20 = this.m00 * f21 + this.m10 * f22 + this.m20 * f23;
        matrix4x3f.m21 = this.m01 * f21 + this.m11 * f22 + this.m21 * f23;
        matrix4x3f.m22 = this.m02 * f21 + this.m12 * f22 + this.m22 * f23;
        matrix4x3f.m00 = f24;
        matrix4x3f.m01 = f25;
        matrix4x3f.m02 = f26;
        matrix4x3f.m10 = f27;
        matrix4x3f.m11 = f28;
        matrix4x3f.m12 = f29;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f lookAlong(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.lookAlong(f, f2, f3, f4, f5, f6, this);
    }

    public Matrix4x3f setLookAlong(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.setLookAlong(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    public Matrix4x3f setLookAlong(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = Math.invsqrt(f * f + f2 * f2 + f3 * f3);
        float f8 = f5 * (f3 *= -f7) - f6 * (f2 *= -f7);
        float f9 = f6 * (f *= -f7) - f4 * f3;
        float f10 = f4 * f2 - f5 * f;
        float f11 = Math.invsqrt(f8 * f8 + f9 * f9 + f10 * f10);
        float f12 = f2 * (f10 *= f11) - f3 * (f9 *= f11);
        float f13 = f3 * (f8 *= f11) - f * f10;
        float f14 = f * f9 - f2 * f8;
        this.m00 = f8;
        this.m01 = f12;
        this.m02 = f;
        this.m10 = f9;
        this.m11 = f13;
        this.m12 = f2;
        this.m20 = f10;
        this.m21 = f14;
        this.m22 = f3;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f setLookAt(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3) {
        return this.setLookAt(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z());
    }

    public Matrix4x3f setLookAt(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = f - f4;
        float f11 = f2 - f5;
        float f12 = f3 - f6;
        float f13 = Math.invsqrt(f10 * f10 + f11 * f11 + f12 * f12);
        float f14 = f8 * (f12 *= f13) - f9 * (f11 *= f13);
        float f15 = f9 * (f10 *= f13) - f7 * f12;
        float f16 = f7 * f11 - f8 * f10;
        float f17 = Math.invsqrt(f14 * f14 + f15 * f15 + f16 * f16);
        float f18 = f11 * (f16 *= f17) - f12 * (f15 *= f17);
        float f19 = f12 * (f14 *= f17) - f10 * f16;
        float f20 = f10 * f15 - f11 * f14;
        this.m00 = f14;
        this.m01 = f18;
        this.m02 = f10;
        this.m10 = f15;
        this.m11 = f19;
        this.m12 = f11;
        this.m20 = f16;
        this.m21 = f20;
        this.m22 = f12;
        this.m30 = -(f14 * f + f15 * f2 + f16 * f3);
        this.m31 = -(f18 * f + f19 * f2 + f20 * f3);
        this.m32 = -(f10 * f + f11 * f2 + f12 * f3);
        this.properties = 16;
        return this;
    }

    @Override
    public Matrix4x3f lookAt(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, Matrix4x3f matrix4x3f) {
        return this.lookAt(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z(), matrix4x3f);
    }

    public Matrix4x3f lookAt(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3) {
        return this.lookAt(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z(), this);
    }

    @Override
    public Matrix4x3f lookAt(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.setLookAt(f, f2, f3, f4, f5, f6, f7, f8, f9);
        }
        return this.lookAtGeneric(f, f2, f3, f4, f5, f6, f7, f8, f9, matrix4x3f);
    }

    private Matrix4x3f lookAtGeneric(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, Matrix4x3f matrix4x3f) {
        float f10 = f - f4;
        float f11 = f2 - f5;
        float f12 = f3 - f6;
        float f13 = Math.invsqrt(f10 * f10 + f11 * f11 + f12 * f12);
        float f14 = f8 * (f12 *= f13) - f9 * (f11 *= f13);
        float f15 = f9 * (f10 *= f13) - f7 * f12;
        float f16 = f7 * f11 - f8 * f10;
        float f17 = Math.invsqrt(f14 * f14 + f15 * f15 + f16 * f16);
        float f18 = f11 * (f16 *= f17) - f12 * (f15 *= f17);
        float f19 = f12 * (f14 *= f17) - f10 * f16;
        float f20 = f10 * f15 - f11 * f14;
        float f21 = f14;
        float f22 = f18;
        float f23 = f10;
        float f24 = f15;
        float f25 = f19;
        float f26 = f11;
        float f27 = f16;
        float f28 = f20;
        float f29 = f12;
        float f30 = -(f14 * f + f15 * f2 + f16 * f3);
        float f31 = -(f18 * f + f19 * f2 + f20 * f3);
        float f32 = -(f10 * f + f11 * f2 + f12 * f3);
        matrix4x3f.m30 = this.m00 * f30 + this.m10 * f31 + this.m20 * f32 + this.m30;
        matrix4x3f.m31 = this.m01 * f30 + this.m11 * f31 + this.m21 * f32 + this.m31;
        matrix4x3f.m32 = this.m02 * f30 + this.m12 * f31 + this.m22 * f32 + this.m32;
        float f33 = this.m00 * f21 + this.m10 * f22 + this.m20 * f23;
        float f34 = this.m01 * f21 + this.m11 * f22 + this.m21 * f23;
        float f35 = this.m02 * f21 + this.m12 * f22 + this.m22 * f23;
        float f36 = this.m00 * f24 + this.m10 * f25 + this.m20 * f26;
        float f37 = this.m01 * f24 + this.m11 * f25 + this.m21 * f26;
        float f38 = this.m02 * f24 + this.m12 * f25 + this.m22 * f26;
        matrix4x3f.m20 = this.m00 * f27 + this.m10 * f28 + this.m20 * f29;
        matrix4x3f.m21 = this.m01 * f27 + this.m11 * f28 + this.m21 * f29;
        matrix4x3f.m22 = this.m02 * f27 + this.m12 * f28 + this.m22 * f29;
        matrix4x3f.m00 = f33;
        matrix4x3f.m01 = f34;
        matrix4x3f.m02 = f35;
        matrix4x3f.m10 = f36;
        matrix4x3f.m11 = f37;
        matrix4x3f.m12 = f38;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f lookAt(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        return this.lookAt(f, f2, f3, f4, f5, f6, f7, f8, f9, this);
    }

    public Matrix4x3f setLookAtLH(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3) {
        return this.setLookAtLH(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z());
    }

    public Matrix4x3f setLookAtLH(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = f4 - f;
        float f11 = f5 - f2;
        float f12 = f6 - f3;
        float f13 = Math.invsqrt(f10 * f10 + f11 * f11 + f12 * f12);
        float f14 = f8 * (f12 *= f13) - f9 * (f11 *= f13);
        float f15 = f9 * (f10 *= f13) - f7 * f12;
        float f16 = f7 * f11 - f8 * f10;
        float f17 = Math.invsqrt(f14 * f14 + f15 * f15 + f16 * f16);
        float f18 = f11 * (f16 *= f17) - f12 * (f15 *= f17);
        float f19 = f12 * (f14 *= f17) - f10 * f16;
        float f20 = f10 * f15 - f11 * f14;
        this.m00 = f14;
        this.m01 = f18;
        this.m02 = f10;
        this.m10 = f15;
        this.m11 = f19;
        this.m12 = f11;
        this.m20 = f16;
        this.m21 = f20;
        this.m22 = f12;
        this.m30 = -(f14 * f + f15 * f2 + f16 * f3);
        this.m31 = -(f18 * f + f19 * f2 + f20 * f3);
        this.m32 = -(f10 * f + f11 * f2 + f12 * f3);
        this.properties = 16;
        return this;
    }

    @Override
    public Matrix4x3f lookAtLH(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, Matrix4x3f matrix4x3f) {
        return this.lookAtLH(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z(), matrix4x3f);
    }

    public Matrix4x3f lookAtLH(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3) {
        return this.lookAtLH(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z(), this);
    }

    @Override
    public Matrix4x3f lookAtLH(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.setLookAtLH(f, f2, f3, f4, f5, f6, f7, f8, f9);
        }
        return this.lookAtLHGeneric(f, f2, f3, f4, f5, f6, f7, f8, f9, matrix4x3f);
    }

    private Matrix4x3f lookAtLHGeneric(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, Matrix4x3f matrix4x3f) {
        float f10 = f4 - f;
        float f11 = f5 - f2;
        float f12 = f6 - f3;
        float f13 = Math.invsqrt(f10 * f10 + f11 * f11 + f12 * f12);
        float f14 = f8 * (f12 *= f13) - f9 * (f11 *= f13);
        float f15 = f9 * (f10 *= f13) - f7 * f12;
        float f16 = f7 * f11 - f8 * f10;
        float f17 = Math.invsqrt(f14 * f14 + f15 * f15 + f16 * f16);
        float f18 = f11 * (f16 *= f17) - f12 * (f15 *= f17);
        float f19 = f12 * (f14 *= f17) - f10 * f16;
        float f20 = f10 * f15 - f11 * f14;
        float f21 = f14;
        float f22 = f18;
        float f23 = f10;
        float f24 = f15;
        float f25 = f19;
        float f26 = f11;
        float f27 = f16;
        float f28 = f20;
        float f29 = f12;
        float f30 = -(f14 * f + f15 * f2 + f16 * f3);
        float f31 = -(f18 * f + f19 * f2 + f20 * f3);
        float f32 = -(f10 * f + f11 * f2 + f12 * f3);
        matrix4x3f.m30 = this.m00 * f30 + this.m10 * f31 + this.m20 * f32 + this.m30;
        matrix4x3f.m31 = this.m01 * f30 + this.m11 * f31 + this.m21 * f32 + this.m31;
        matrix4x3f.m32 = this.m02 * f30 + this.m12 * f31 + this.m22 * f32 + this.m32;
        float f33 = this.m00 * f21 + this.m10 * f22 + this.m20 * f23;
        float f34 = this.m01 * f21 + this.m11 * f22 + this.m21 * f23;
        float f35 = this.m02 * f21 + this.m12 * f22 + this.m22 * f23;
        float f36 = this.m00 * f24 + this.m10 * f25 + this.m20 * f26;
        float f37 = this.m01 * f24 + this.m11 * f25 + this.m21 * f26;
        float f38 = this.m02 * f24 + this.m12 * f25 + this.m22 * f26;
        matrix4x3f.m20 = this.m00 * f27 + this.m10 * f28 + this.m20 * f29;
        matrix4x3f.m21 = this.m01 * f27 + this.m11 * f28 + this.m21 * f29;
        matrix4x3f.m22 = this.m02 * f27 + this.m12 * f28 + this.m22 * f29;
        matrix4x3f.m00 = f33;
        matrix4x3f.m01 = f34;
        matrix4x3f.m02 = f35;
        matrix4x3f.m10 = f36;
        matrix4x3f.m11 = f37;
        matrix4x3f.m12 = f38;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f lookAtLH(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        return this.lookAtLH(f, f2, f3, f4, f5, f6, f7, f8, f9, this);
    }

    @Override
    public Matrix4x3f rotate(Quaternionfc quaternionfc, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.rotation(quaternionfc);
        }
        if ((this.properties & 8) != 0) {
            return this.rotateTranslation(quaternionfc, matrix4x3f);
        }
        return this.rotateGeneric(quaternionfc, matrix4x3f);
    }

    private Matrix4x3f rotateGeneric(Quaternionfc quaternionfc, Matrix4x3f matrix4x3f) {
        float f = quaternionfc.w() * quaternionfc.w();
        float f2 = quaternionfc.x() * quaternionfc.x();
        float f3 = quaternionfc.y() * quaternionfc.y();
        float f4 = quaternionfc.z() * quaternionfc.z();
        float f5 = quaternionfc.z() * quaternionfc.w();
        float f6 = f5 + f5;
        float f7 = quaternionfc.x() * quaternionfc.y();
        float f8 = f7 + f7;
        float f9 = quaternionfc.x() * quaternionfc.z();
        float f10 = f9 + f9;
        float f11 = quaternionfc.y() * quaternionfc.w();
        float f12 = f11 + f11;
        float f13 = quaternionfc.y() * quaternionfc.z();
        float f14 = f13 + f13;
        float f15 = quaternionfc.x() * quaternionfc.w();
        float f16 = f15 + f15;
        float f17 = f + f2 - f4 - f3;
        float f18 = f8 + f6;
        float f19 = f10 - f12;
        float f20 = f8 - f6;
        float f21 = f3 - f4 + f - f2;
        float f22 = f14 + f16;
        float f23 = f12 + f10;
        float f24 = f14 - f16;
        float f25 = f4 - f3 - f2 + f;
        float f26 = this.m00 * f17 + this.m10 * f18 + this.m20 * f19;
        float f27 = this.m01 * f17 + this.m11 * f18 + this.m21 * f19;
        float f28 = this.m02 * f17 + this.m12 * f18 + this.m22 * f19;
        float f29 = this.m00 * f20 + this.m10 * f21 + this.m20 * f22;
        float f30 = this.m01 * f20 + this.m11 * f21 + this.m21 * f22;
        float f31 = this.m02 * f20 + this.m12 * f21 + this.m22 * f22;
        matrix4x3f.m20 = this.m00 * f23 + this.m10 * f24 + this.m20 * f25;
        matrix4x3f.m21 = this.m01 * f23 + this.m11 * f24 + this.m21 * f25;
        matrix4x3f.m22 = this.m02 * f23 + this.m12 * f24 + this.m22 * f25;
        matrix4x3f.m00 = f26;
        matrix4x3f.m01 = f27;
        matrix4x3f.m02 = f28;
        matrix4x3f.m10 = f29;
        matrix4x3f.m11 = f30;
        matrix4x3f.m12 = f31;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f rotate(Quaternionfc quaternionfc) {
        return this.rotate(quaternionfc, this);
    }

    @Override
    public Matrix4x3f rotateTranslation(Quaternionfc quaternionfc, Matrix4x3f matrix4x3f) {
        float f = quaternionfc.w() * quaternionfc.w();
        float f2 = quaternionfc.x() * quaternionfc.x();
        float f3 = quaternionfc.y() * quaternionfc.y();
        float f4 = quaternionfc.z() * quaternionfc.z();
        float f5 = quaternionfc.z() * quaternionfc.w();
        float f6 = f5 + f5;
        float f7 = quaternionfc.x() * quaternionfc.y();
        float f8 = f7 + f7;
        float f9 = quaternionfc.x() * quaternionfc.z();
        float f10 = f9 + f9;
        float f11 = quaternionfc.y() * quaternionfc.w();
        float f12 = f11 + f11;
        float f13 = quaternionfc.y() * quaternionfc.z();
        float f14 = f13 + f13;
        float f15 = quaternionfc.x() * quaternionfc.w();
        float f16 = f15 + f15;
        float f17 = f + f2 - f4 - f3;
        float f18 = f8 + f6;
        float f19 = f10 - f12;
        float f20 = f8 - f6;
        float f21 = f3 - f4 + f - f2;
        float f22 = f14 + f16;
        float f23 = f12 + f10;
        float f24 = f14 - f16;
        float f25 = f4 - f3 - f2 + f;
        matrix4x3f.m20 = f23;
        matrix4x3f.m21 = f24;
        matrix4x3f.m22 = f25;
        matrix4x3f.m00 = f17;
        matrix4x3f.m01 = f18;
        matrix4x3f.m02 = f19;
        matrix4x3f.m10 = f20;
        matrix4x3f.m11 = f21;
        matrix4x3f.m12 = f22;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    @Override
    public Matrix4x3f rotateLocal(Quaternionfc quaternionfc, Matrix4x3f matrix4x3f) {
        float f = quaternionfc.w() * quaternionfc.w();
        float f2 = quaternionfc.x() * quaternionfc.x();
        float f3 = quaternionfc.y() * quaternionfc.y();
        float f4 = quaternionfc.z() * quaternionfc.z();
        float f5 = quaternionfc.z() * quaternionfc.w();
        float f6 = quaternionfc.x() * quaternionfc.y();
        float f7 = quaternionfc.x() * quaternionfc.z();
        float f8 = quaternionfc.y() * quaternionfc.w();
        float f9 = quaternionfc.y() * quaternionfc.z();
        float f10 = quaternionfc.x() * quaternionfc.w();
        float f11 = f + f2 - f4 - f3;
        float f12 = f6 + f5 + f5 + f6;
        float f13 = f7 - f8 + f7 - f8;
        float f14 = -f5 + f6 - f5 + f6;
        float f15 = f3 - f4 + f - f2;
        float f16 = f9 + f9 + f10 + f10;
        float f17 = f8 + f7 + f7 + f8;
        float f18 = f9 + f9 - f10 - f10;
        float f19 = f4 - f3 - f2 + f;
        float f20 = f11 * this.m00 + f14 * this.m01 + f17 * this.m02;
        float f21 = f12 * this.m00 + f15 * this.m01 + f18 * this.m02;
        float f22 = f13 * this.m00 + f16 * this.m01 + f19 * this.m02;
        float f23 = f11 * this.m10 + f14 * this.m11 + f17 * this.m12;
        float f24 = f12 * this.m10 + f15 * this.m11 + f18 * this.m12;
        float f25 = f13 * this.m10 + f16 * this.m11 + f19 * this.m12;
        float f26 = f11 * this.m20 + f14 * this.m21 + f17 * this.m22;
        float f27 = f12 * this.m20 + f15 * this.m21 + f18 * this.m22;
        float f28 = f13 * this.m20 + f16 * this.m21 + f19 * this.m22;
        float f29 = f11 * this.m30 + f14 * this.m31 + f17 * this.m32;
        float f30 = f12 * this.m30 + f15 * this.m31 + f18 * this.m32;
        float f31 = f13 * this.m30 + f16 * this.m31 + f19 * this.m32;
        matrix4x3f.m00 = f20;
        matrix4x3f.m01 = f21;
        matrix4x3f.m02 = f22;
        matrix4x3f.m10 = f23;
        matrix4x3f.m11 = f24;
        matrix4x3f.m12 = f25;
        matrix4x3f.m20 = f26;
        matrix4x3f.m21 = f27;
        matrix4x3f.m22 = f28;
        matrix4x3f.m30 = f29;
        matrix4x3f.m31 = f30;
        matrix4x3f.m32 = f31;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f rotateLocal(Quaternionfc quaternionfc) {
        return this.rotateLocal(quaternionfc, this);
    }

    public Matrix4x3f rotate(AxisAngle4f axisAngle4f) {
        return this.rotate(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    @Override
    public Matrix4x3f rotate(AxisAngle4f axisAngle4f, Matrix4x3f matrix4x3f) {
        return this.rotate(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z, matrix4x3f);
    }

    public Matrix4x3f rotate(float f, Vector3fc vector3fc) {
        return this.rotate(f, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    @Override
    public Matrix4x3f rotate(float f, Vector3fc vector3fc, Matrix4x3f matrix4x3f) {
        return this.rotate(f, vector3fc.x(), vector3fc.y(), vector3fc.z(), matrix4x3f);
    }

    @Override
    public Matrix4x3f reflect(float f, float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.reflection(f, f2, f3, f4);
        }
        float f5 = f + f;
        float f6 = f2 + f2;
        float f7 = f3 + f3;
        float f8 = f4 + f4;
        float f9 = 1.0f - f5 * f;
        float f10 = -f5 * f2;
        float f11 = -f5 * f3;
        float f12 = -f6 * f;
        float f13 = 1.0f - f6 * f2;
        float f14 = -f6 * f3;
        float f15 = -f7 * f;
        float f16 = -f7 * f2;
        float f17 = 1.0f - f7 * f3;
        float f18 = -f8 * f;
        float f19 = -f8 * f2;
        float f20 = -f8 * f3;
        matrix4x3f.m30 = this.m00 * f18 + this.m10 * f19 + this.m20 * f20 + this.m30;
        matrix4x3f.m31 = this.m01 * f18 + this.m11 * f19 + this.m21 * f20 + this.m31;
        matrix4x3f.m32 = this.m02 * f18 + this.m12 * f19 + this.m22 * f20 + this.m32;
        float f21 = this.m00 * f9 + this.m10 * f10 + this.m20 * f11;
        float f22 = this.m01 * f9 + this.m11 * f10 + this.m21 * f11;
        float f23 = this.m02 * f9 + this.m12 * f10 + this.m22 * f11;
        float f24 = this.m00 * f12 + this.m10 * f13 + this.m20 * f14;
        float f25 = this.m01 * f12 + this.m11 * f13 + this.m21 * f14;
        float f26 = this.m02 * f12 + this.m12 * f13 + this.m22 * f14;
        matrix4x3f.m20 = this.m00 * f15 + this.m10 * f16 + this.m20 * f17;
        matrix4x3f.m21 = this.m01 * f15 + this.m11 * f16 + this.m21 * f17;
        matrix4x3f.m22 = this.m02 * f15 + this.m12 * f16 + this.m22 * f17;
        matrix4x3f.m00 = f21;
        matrix4x3f.m01 = f22;
        matrix4x3f.m02 = f23;
        matrix4x3f.m10 = f24;
        matrix4x3f.m11 = f25;
        matrix4x3f.m12 = f26;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f reflect(float f, float f2, float f3, float f4) {
        return this.reflect(f, f2, f3, f4, this);
    }

    public Matrix4x3f reflect(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.reflect(f, f2, f3, f4, f5, f6, this);
    }

    @Override
    public Matrix4x3f reflect(float f, float f2, float f3, float f4, float f5, float f6, Matrix4x3f matrix4x3f) {
        float f7 = Math.invsqrt(f * f + f2 * f2 + f3 * f3);
        float f8 = f * f7;
        float f9 = f2 * f7;
        float f10 = f3 * f7;
        return this.reflect(f8, f9, f10, -f8 * f4 - f9 * f5 - f10 * f6, matrix4x3f);
    }

    public Matrix4x3f reflect(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.reflect(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    public Matrix4x3f reflect(Quaternionfc quaternionfc, Vector3fc vector3fc) {
        return this.reflect(quaternionfc, vector3fc, this);
    }

    @Override
    public Matrix4x3f reflect(Quaternionfc quaternionfc, Vector3fc vector3fc, Matrix4x3f matrix4x3f) {
        double d = quaternionfc.x() + quaternionfc.x();
        double d2 = quaternionfc.y() + quaternionfc.y();
        double d3 = quaternionfc.z() + quaternionfc.z();
        float f = (float)((double)quaternionfc.x() * d3 + (double)quaternionfc.w() * d2);
        float f2 = (float)((double)quaternionfc.y() * d3 - (double)quaternionfc.w() * d);
        float f3 = (float)(1.0 - ((double)quaternionfc.x() * d + (double)quaternionfc.y() * d2));
        return this.reflect(f, f2, f3, vector3fc.x(), vector3fc.y(), vector3fc.z(), matrix4x3f);
    }

    @Override
    public Matrix4x3f reflect(Vector3fc vector3fc, Vector3fc vector3fc2, Matrix4x3f matrix4x3f) {
        return this.reflect(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), matrix4x3f);
    }

    public Matrix4x3f reflection(float f, float f2, float f3, float f4) {
        float f5 = f + f;
        float f6 = f2 + f2;
        float f7 = f3 + f3;
        float f8 = f4 + f4;
        this.m00 = 1.0f - f5 * f;
        this.m01 = -f5 * f2;
        this.m02 = -f5 * f3;
        this.m10 = -f6 * f;
        this.m11 = 1.0f - f6 * f2;
        this.m12 = -f6 * f3;
        this.m20 = -f7 * f;
        this.m21 = -f7 * f2;
        this.m22 = 1.0f - f7 * f3;
        this.m30 = -f8 * f;
        this.m31 = -f8 * f2;
        this.m32 = -f8 * f3;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f reflection(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = Math.invsqrt(f * f + f2 * f2 + f3 * f3);
        float f8 = f * f7;
        float f9 = f2 * f7;
        float f10 = f3 * f7;
        return this.reflection(f8, f9, f10, -f8 * f4 - f9 * f5 - f10 * f6);
    }

    public Matrix4x3f reflection(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.reflection(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    public Matrix4x3f reflection(Quaternionfc quaternionfc, Vector3fc vector3fc) {
        double d = quaternionfc.x() + quaternionfc.x();
        double d2 = quaternionfc.y() + quaternionfc.y();
        double d3 = quaternionfc.z() + quaternionfc.z();
        float f = (float)((double)quaternionfc.x() * d3 + (double)quaternionfc.w() * d2);
        float f2 = (float)((double)quaternionfc.y() * d3 - (double)quaternionfc.w() * d);
        float f3 = (float)(1.0 - ((double)quaternionfc.x() * d + (double)quaternionfc.y() * d2));
        return this.reflection(f, f2, f3, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    @Override
    public Vector4f getRow(int n, Vector4f vector4f) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                vector4f.x = this.m00;
                vector4f.y = this.m10;
                vector4f.z = this.m20;
                vector4f.w = this.m30;
                break;
            }
            case 1: {
                vector4f.x = this.m01;
                vector4f.y = this.m11;
                vector4f.z = this.m21;
                vector4f.w = this.m31;
                break;
            }
            case 2: {
                vector4f.x = this.m02;
                vector4f.y = this.m12;
                vector4f.z = this.m22;
                vector4f.w = this.m32;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return vector4f;
    }

    public Matrix4x3f setRow(int n, Vector4fc vector4fc) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                this.m00 = vector4fc.x();
                this.m10 = vector4fc.y();
                this.m20 = vector4fc.z();
                this.m30 = vector4fc.w();
                break;
            }
            case 1: {
                this.m01 = vector4fc.x();
                this.m11 = vector4fc.y();
                this.m21 = vector4fc.z();
                this.m31 = vector4fc.w();
                break;
            }
            case 2: {
                this.m02 = vector4fc.x();
                this.m12 = vector4fc.y();
                this.m22 = vector4fc.z();
                this.m32 = vector4fc.w();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        this.properties = 0;
        return this;
    }

    @Override
    public Vector3f getColumn(int n, Vector3f vector3f) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                vector3f.x = this.m00;
                vector3f.y = this.m01;
                vector3f.z = this.m02;
                break;
            }
            case 1: {
                vector3f.x = this.m10;
                vector3f.y = this.m11;
                vector3f.z = this.m12;
                break;
            }
            case 2: {
                vector3f.x = this.m20;
                vector3f.y = this.m21;
                vector3f.z = this.m22;
                break;
            }
            case 3: {
                vector3f.x = this.m30;
                vector3f.y = this.m31;
                vector3f.z = this.m32;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return vector3f;
    }

    public Matrix4x3f setColumn(int n, Vector3fc vector3fc) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                this.m00 = vector3fc.x();
                this.m01 = vector3fc.y();
                this.m02 = vector3fc.z();
                break;
            }
            case 1: {
                this.m10 = vector3fc.x();
                this.m11 = vector3fc.y();
                this.m12 = vector3fc.z();
                break;
            }
            case 2: {
                this.m20 = vector3fc.x();
                this.m21 = vector3fc.y();
                this.m22 = vector3fc.z();
                break;
            }
            case 3: {
                this.m30 = vector3fc.x();
                this.m31 = vector3fc.y();
                this.m32 = vector3fc.z();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        this.properties = 0;
        return this;
    }

    public Matrix4x3f normal() {
        return this.normal(this);
    }

    @Override
    public Matrix4x3f normal(Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.identity();
        }
        if ((this.properties & 0x10) != 0) {
            return this.normalOrthonormal(matrix4x3f);
        }
        return this.normalGeneric(matrix4x3f);
    }

    private Matrix4x3f normalOrthonormal(Matrix4x3f matrix4x3f) {
        if (matrix4x3f != this) {
            matrix4x3f.set(this);
        }
        return matrix4x3f._properties(16);
    }

    private Matrix4x3f normalGeneric(Matrix4x3f matrix4x3f) {
        float f = this.m00 * this.m11;
        float f2 = this.m01 * this.m10;
        float f3 = this.m02 * this.m10;
        float f4 = this.m00 * this.m12;
        float f5 = this.m01 * this.m12;
        float f6 = this.m02 * this.m11;
        float f7 = (f - f2) * this.m22 + (f3 - f4) * this.m21 + (f5 - f6) * this.m20;
        float f8 = 1.0f / f7;
        float f9 = (this.m11 * this.m22 - this.m21 * this.m12) * f8;
        float f10 = (this.m20 * this.m12 - this.m10 * this.m22) * f8;
        float f11 = (this.m10 * this.m21 - this.m20 * this.m11) * f8;
        float f12 = (this.m21 * this.m02 - this.m01 * this.m22) * f8;
        float f13 = (this.m00 * this.m22 - this.m20 * this.m02) * f8;
        float f14 = (this.m20 * this.m01 - this.m00 * this.m21) * f8;
        float f15 = (f5 - f6) * f8;
        float f16 = (f3 - f4) * f8;
        float f17 = (f - f2) * f8;
        matrix4x3f.m00 = f9;
        matrix4x3f.m01 = f10;
        matrix4x3f.m02 = f11;
        matrix4x3f.m10 = f12;
        matrix4x3f.m11 = f13;
        matrix4x3f.m12 = f14;
        matrix4x3f.m20 = f15;
        matrix4x3f.m21 = f16;
        matrix4x3f.m22 = f17;
        matrix4x3f.m30 = 0.0f;
        matrix4x3f.m31 = 0.0f;
        matrix4x3f.m32 = 0.0f;
        matrix4x3f.properties = this.properties & 0xFFFFFFF7;
        return matrix4x3f;
    }

    @Override
    public Matrix3f normal(Matrix3f matrix3f) {
        if ((this.properties & 0x10) != 0) {
            return this.normalOrthonormal(matrix3f);
        }
        return this.normalGeneric(matrix3f);
    }

    private Matrix3f normalOrthonormal(Matrix3f matrix3f) {
        return matrix3f.set(this);
    }

    private Matrix3f normalGeneric(Matrix3f matrix3f) {
        float f = this.m00 * this.m11;
        float f2 = this.m01 * this.m10;
        float f3 = this.m02 * this.m10;
        float f4 = this.m00 * this.m12;
        float f5 = this.m01 * this.m12;
        float f6 = this.m02 * this.m11;
        float f7 = (f - f2) * this.m22 + (f3 - f4) * this.m21 + (f5 - f6) * this.m20;
        float f8 = 1.0f / f7;
        matrix3f.m00((this.m11 * this.m22 - this.m21 * this.m12) * f8);
        matrix3f.m01((this.m20 * this.m12 - this.m10 * this.m22) * f8);
        matrix3f.m02((this.m10 * this.m21 - this.m20 * this.m11) * f8);
        matrix3f.m10((this.m21 * this.m02 - this.m01 * this.m22) * f8);
        matrix3f.m11((this.m00 * this.m22 - this.m20 * this.m02) * f8);
        matrix3f.m12((this.m20 * this.m01 - this.m00 * this.m21) * f8);
        matrix3f.m20((f5 - f6) * f8);
        matrix3f.m21((f3 - f4) * f8);
        matrix3f.m22((f - f2) * f8);
        return matrix3f;
    }

    public Matrix4x3f cofactor3x3() {
        return this.cofactor3x3(this);
    }

    @Override
    public Matrix3f cofactor3x3(Matrix3f matrix3f) {
        matrix3f.m00 = this.m11 * this.m22 - this.m21 * this.m12;
        matrix3f.m01 = this.m20 * this.m12 - this.m10 * this.m22;
        matrix3f.m02 = this.m10 * this.m21 - this.m20 * this.m11;
        matrix3f.m10 = this.m21 * this.m02 - this.m01 * this.m22;
        matrix3f.m11 = this.m00 * this.m22 - this.m20 * this.m02;
        matrix3f.m12 = this.m20 * this.m01 - this.m00 * this.m21;
        matrix3f.m20 = this.m01 * this.m12 - this.m02 * this.m11;
        matrix3f.m21 = this.m02 * this.m10 - this.m00 * this.m12;
        matrix3f.m22 = this.m00 * this.m11 - this.m01 * this.m10;
        return matrix3f;
    }

    @Override
    public Matrix4x3f cofactor3x3(Matrix4x3f matrix4x3f) {
        float f = this.m11 * this.m22 - this.m21 * this.m12;
        float f2 = this.m20 * this.m12 - this.m10 * this.m22;
        float f3 = this.m10 * this.m21 - this.m20 * this.m11;
        float f4 = this.m21 * this.m02 - this.m01 * this.m22;
        float f5 = this.m00 * this.m22 - this.m20 * this.m02;
        float f6 = this.m20 * this.m01 - this.m00 * this.m21;
        float f7 = this.m01 * this.m12 - this.m11 * this.m02;
        float f8 = this.m02 * this.m10 - this.m12 * this.m00;
        float f9 = this.m00 * this.m11 - this.m10 * this.m01;
        matrix4x3f.m00 = f;
        matrix4x3f.m01 = f2;
        matrix4x3f.m02 = f3;
        matrix4x3f.m10 = f4;
        matrix4x3f.m11 = f5;
        matrix4x3f.m12 = f6;
        matrix4x3f.m20 = f7;
        matrix4x3f.m21 = f8;
        matrix4x3f.m22 = f9;
        matrix4x3f.m30 = 0.0f;
        matrix4x3f.m31 = 0.0f;
        matrix4x3f.m32 = 0.0f;
        matrix4x3f.properties = this.properties & 0xFFFFFFF7;
        return matrix4x3f;
    }

    public Matrix4x3f normalize3x3() {
        return this.normalize3x3(this);
    }

    @Override
    public Matrix4x3f normalize3x3(Matrix4x3f matrix4x3f) {
        float f = Math.invsqrt(this.m00 * this.m00 + this.m01 * this.m01 + this.m02 * this.m02);
        float f2 = Math.invsqrt(this.m10 * this.m10 + this.m11 * this.m11 + this.m12 * this.m12);
        float f3 = Math.invsqrt(this.m20 * this.m20 + this.m21 * this.m21 + this.m22 * this.m22);
        matrix4x3f.m00 = this.m00 * f;
        matrix4x3f.m01 = this.m01 * f;
        matrix4x3f.m02 = this.m02 * f;
        matrix4x3f.m10 = this.m10 * f2;
        matrix4x3f.m11 = this.m11 * f2;
        matrix4x3f.m12 = this.m12 * f2;
        matrix4x3f.m20 = this.m20 * f3;
        matrix4x3f.m21 = this.m21 * f3;
        matrix4x3f.m22 = this.m22 * f3;
        matrix4x3f.properties = this.properties;
        return matrix4x3f;
    }

    @Override
    public Matrix3f normalize3x3(Matrix3f matrix3f) {
        float f = Math.invsqrt(this.m00 * this.m00 + this.m01 * this.m01 + this.m02 * this.m02);
        float f2 = Math.invsqrt(this.m10 * this.m10 + this.m11 * this.m11 + this.m12 * this.m12);
        float f3 = Math.invsqrt(this.m20 * this.m20 + this.m21 * this.m21 + this.m22 * this.m22);
        matrix3f.m00(this.m00 * f);
        matrix3f.m01(this.m01 * f);
        matrix3f.m02(this.m02 * f);
        matrix3f.m10(this.m10 * f2);
        matrix3f.m11(this.m11 * f2);
        matrix3f.m12(this.m12 * f2);
        matrix3f.m20(this.m20 * f3);
        matrix3f.m21(this.m21 * f3);
        matrix3f.m22(this.m22 * f3);
        return matrix3f;
    }

    @Override
    public Vector4f frustumPlane(int n, Vector4f vector4f) {
        switch (n) {
            case 0: {
                vector4f.set(this.m00, this.m10, this.m20, 1.0f + this.m30).normalize();
                break;
            }
            case 1: {
                vector4f.set(-this.m00, -this.m10, -this.m20, 1.0f - this.m30).normalize();
                break;
            }
            case 2: {
                vector4f.set(this.m01, this.m11, this.m21, 1.0f + this.m31).normalize();
                break;
            }
            case 3: {
                vector4f.set(-this.m01, -this.m11, -this.m21, 1.0f - this.m31).normalize();
                break;
            }
            case 4: {
                vector4f.set(this.m02, this.m12, this.m22, 1.0f + this.m32).normalize();
                break;
            }
            case 5: {
                vector4f.set(-this.m02, -this.m12, -this.m22, 1.0f - this.m32).normalize();
                break;
            }
            default: {
                throw new IllegalArgumentException("which");
            }
        }
        return vector4f;
    }

    @Override
    public Vector3f positiveZ(Vector3f vector3f) {
        vector3f.x = this.m10 * this.m21 - this.m11 * this.m20;
        vector3f.y = this.m20 * this.m01 - this.m21 * this.m00;
        vector3f.z = this.m00 * this.m11 - this.m01 * this.m10;
        return vector3f.normalize(vector3f);
    }

    @Override
    public Vector3f normalizedPositiveZ(Vector3f vector3f) {
        vector3f.x = this.m02;
        vector3f.y = this.m12;
        vector3f.z = this.m22;
        return vector3f;
    }

    @Override
    public Vector3f positiveX(Vector3f vector3f) {
        vector3f.x = this.m11 * this.m22 - this.m12 * this.m21;
        vector3f.y = this.m02 * this.m21 - this.m01 * this.m22;
        vector3f.z = this.m01 * this.m12 - this.m02 * this.m11;
        return vector3f.normalize(vector3f);
    }

    @Override
    public Vector3f normalizedPositiveX(Vector3f vector3f) {
        vector3f.x = this.m00;
        vector3f.y = this.m10;
        vector3f.z = this.m20;
        return vector3f;
    }

    @Override
    public Vector3f positiveY(Vector3f vector3f) {
        vector3f.x = this.m12 * this.m20 - this.m10 * this.m22;
        vector3f.y = this.m00 * this.m22 - this.m02 * this.m20;
        vector3f.z = this.m02 * this.m10 - this.m00 * this.m12;
        return vector3f.normalize(vector3f);
    }

    @Override
    public Vector3f normalizedPositiveY(Vector3f vector3f) {
        vector3f.x = this.m01;
        vector3f.y = this.m11;
        vector3f.z = this.m21;
        return vector3f;
    }

    @Override
    public Vector3f origin(Vector3f vector3f) {
        float f = this.m00 * this.m11 - this.m01 * this.m10;
        float f2 = this.m00 * this.m12 - this.m02 * this.m10;
        float f3 = this.m01 * this.m12 - this.m02 * this.m11;
        float f4 = this.m20 * this.m31 - this.m21 * this.m30;
        float f5 = this.m20 * this.m32 - this.m22 * this.m30;
        float f6 = this.m21 * this.m32 - this.m22 * this.m31;
        vector3f.x = -this.m10 * f6 + this.m11 * f5 - this.m12 * f4;
        vector3f.y = this.m00 * f6 - this.m01 * f5 + this.m02 * f4;
        vector3f.z = -this.m30 * f3 + this.m31 * f2 - this.m32 * f;
        return vector3f;
    }

    public Matrix4x3f shadow(Vector4fc vector4fc, float f, float f2, float f3, float f4) {
        return this.shadow(vector4fc.x(), vector4fc.y(), vector4fc.z(), vector4fc.w(), f, f2, f3, f4, this);
    }

    @Override
    public Matrix4x3f shadow(Vector4fc vector4fc, float f, float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        return this.shadow(vector4fc.x(), vector4fc.y(), vector4fc.z(), vector4fc.w(), f, f2, f3, f4, matrix4x3f);
    }

    public Matrix4x3f shadow(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        return this.shadow(f, f2, f3, f4, f5, f6, f7, f8, this);
    }

    @Override
    public Matrix4x3f shadow(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, Matrix4x3f matrix4x3f) {
        float f9 = Math.invsqrt(f5 * f5 + f6 * f6 + f7 * f7);
        float f10 = f5 * f9;
        float f11 = f6 * f9;
        float f12 = f7 * f9;
        float f13 = f8 * f9;
        float f14 = f10 * f + f11 * f2 + f12 * f3 + f13 * f4;
        float f15 = f14 - f10 * f;
        float f16 = -f10 * f2;
        float f17 = -f10 * f3;
        float f18 = -f10 * f4;
        float f19 = -f11 * f;
        float f20 = f14 - f11 * f2;
        float f21 = -f11 * f3;
        float f22 = -f11 * f4;
        float f23 = -f12 * f;
        float f24 = -f12 * f2;
        float f25 = f14 - f12 * f3;
        float f26 = -f12 * f4;
        float f27 = -f13 * f;
        float f28 = -f13 * f2;
        float f29 = -f13 * f3;
        float f30 = f14 - f13 * f4;
        float f31 = this.m00 * f15 + this.m10 * f16 + this.m20 * f17 + this.m30 * f18;
        float f32 = this.m01 * f15 + this.m11 * f16 + this.m21 * f17 + this.m31 * f18;
        float f33 = this.m02 * f15 + this.m12 * f16 + this.m22 * f17 + this.m32 * f18;
        float f34 = this.m00 * f19 + this.m10 * f20 + this.m20 * f21 + this.m30 * f22;
        float f35 = this.m01 * f19 + this.m11 * f20 + this.m21 * f21 + this.m31 * f22;
        float f36 = this.m02 * f19 + this.m12 * f20 + this.m22 * f21 + this.m32 * f22;
        float f37 = this.m00 * f23 + this.m10 * f24 + this.m20 * f25 + this.m30 * f26;
        float f38 = this.m01 * f23 + this.m11 * f24 + this.m21 * f25 + this.m31 * f26;
        float f39 = this.m02 * f23 + this.m12 * f24 + this.m22 * f25 + this.m32 * f26;
        matrix4x3f.m30 = this.m00 * f27 + this.m10 * f28 + this.m20 * f29 + this.m30 * f30;
        matrix4x3f.m31 = this.m01 * f27 + this.m11 * f28 + this.m21 * f29 + this.m31 * f30;
        matrix4x3f.m32 = this.m02 * f27 + this.m12 * f28 + this.m22 * f29 + this.m32 * f30;
        matrix4x3f.m00 = f31;
        matrix4x3f.m01 = f32;
        matrix4x3f.m02 = f33;
        matrix4x3f.m10 = f34;
        matrix4x3f.m11 = f35;
        matrix4x3f.m12 = f36;
        matrix4x3f.m20 = f37;
        matrix4x3f.m21 = f38;
        matrix4x3f.m22 = f39;
        matrix4x3f.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3f;
    }

    @Override
    public Matrix4x3f shadow(Vector4fc vector4fc, Matrix4x3fc matrix4x3fc, Matrix4x3f matrix4x3f) {
        float f = matrix4x3fc.m10();
        float f2 = matrix4x3fc.m11();
        float f3 = matrix4x3fc.m12();
        float f4 = -f * matrix4x3fc.m30() - f2 * matrix4x3fc.m31() - f3 * matrix4x3fc.m32();
        return this.shadow(vector4fc.x(), vector4fc.y(), vector4fc.z(), vector4fc.w(), f, f2, f3, f4, matrix4x3f);
    }

    public Matrix4x3f shadow(Vector4fc vector4fc, Matrix4x3fc matrix4x3fc) {
        return this.shadow(vector4fc, matrix4x3fc, this);
    }

    @Override
    public Matrix4x3f shadow(float f, float f2, float f3, float f4, Matrix4x3fc matrix4x3fc, Matrix4x3f matrix4x3f) {
        float f5 = matrix4x3fc.m10();
        float f6 = matrix4x3fc.m11();
        float f7 = matrix4x3fc.m12();
        float f8 = -f5 * matrix4x3fc.m30() - f6 * matrix4x3fc.m31() - f7 * matrix4x3fc.m32();
        return this.shadow(f, f2, f3, f4, f5, f6, f7, f8, matrix4x3f);
    }

    public Matrix4x3f shadow(float f, float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        return this.shadow(f, f2, f3, f4, matrix4x3f, this);
    }

    public Matrix4x3f billboardCylindrical(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3) {
        float f = vector3fc2.x() - vector3fc.x();
        float f2 = vector3fc2.y() - vector3fc.y();
        float f3 = vector3fc2.z() - vector3fc.z();
        float f4 = vector3fc3.y() * f3 - vector3fc3.z() * f2;
        float f5 = vector3fc3.z() * f - vector3fc3.x() * f3;
        float f6 = vector3fc3.x() * f2 - vector3fc3.y() * f;
        float f7 = Math.invsqrt(f4 * f4 + f5 * f5 + f6 * f6);
        f = (f5 *= f7) * vector3fc3.z() - (f6 *= f7) * vector3fc3.y();
        f2 = f6 * vector3fc3.x() - (f4 *= f7) * vector3fc3.z();
        f3 = f4 * vector3fc3.y() - f5 * vector3fc3.x();
        float f8 = Math.invsqrt(f * f + f2 * f2 + f3 * f3);
        f *= f8;
        f2 *= f8;
        f3 *= f8;
        this.m00 = f4;
        this.m01 = f5;
        this.m02 = f6;
        this.m10 = vector3fc3.x();
        this.m11 = vector3fc3.y();
        this.m12 = vector3fc3.z();
        this.m20 = f;
        this.m21 = f2;
        this.m22 = f3;
        this.m30 = vector3fc.x();
        this.m31 = vector3fc.y();
        this.m32 = vector3fc.z();
        this.properties = 16;
        return this;
    }

    public Matrix4x3f billboardSpherical(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3) {
        float f = vector3fc2.x() - vector3fc.x();
        float f2 = vector3fc2.y() - vector3fc.y();
        float f3 = vector3fc2.z() - vector3fc.z();
        float f4 = Math.invsqrt(f * f + f2 * f2 + f3 * f3);
        float f5 = vector3fc3.y() * (f3 *= f4) - vector3fc3.z() * (f2 *= f4);
        float f6 = vector3fc3.z() * (f *= f4) - vector3fc3.x() * f3;
        float f7 = vector3fc3.x() * f2 - vector3fc3.y() * f;
        float f8 = Math.invsqrt(f5 * f5 + f6 * f6 + f7 * f7);
        float f9 = f2 * (f7 *= f8) - f3 * (f6 *= f8);
        float f10 = f3 * (f5 *= f8) - f * f7;
        float f11 = f * f6 - f2 * f5;
        this.m00 = f5;
        this.m01 = f6;
        this.m02 = f7;
        this.m10 = f9;
        this.m11 = f10;
        this.m12 = f11;
        this.m20 = f;
        this.m21 = f2;
        this.m22 = f3;
        this.m30 = vector3fc.x();
        this.m31 = vector3fc.y();
        this.m32 = vector3fc.z();
        this.properties = 16;
        return this;
    }

    public Matrix4x3f billboardSpherical(Vector3fc vector3fc, Vector3fc vector3fc2) {
        float f = vector3fc2.x() - vector3fc.x();
        float f2 = vector3fc2.y() - vector3fc.y();
        float f3 = vector3fc2.z() - vector3fc.z();
        float f4 = -f2;
        float f5 = f;
        float f6 = Math.sqrt(f * f + f2 * f2 + f3 * f3) + f3;
        float f7 = Math.invsqrt(f4 * f4 + f5 * f5 + f6 * f6);
        float f8 = ((f4 *= f7) + f4) * f4;
        float f9 = ((f5 *= f7) + f5) * f5;
        float f10 = (f4 + f4) * f5;
        float f11 = (f4 + f4) * (f6 *= f7);
        float f12 = (f5 + f5) * f6;
        this.m00 = 1.0f - f9;
        this.m01 = f10;
        this.m02 = -f12;
        this.m10 = f10;
        this.m11 = 1.0f - f8;
        this.m12 = f11;
        this.m20 = f12;
        this.m21 = -f11;
        this.m22 = 1.0f - f9 - f8;
        this.m30 = vector3fc.x();
        this.m31 = vector3fc.y();
        this.m32 = vector3fc.z();
        this.properties = 16;
        return this;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Float.floatToIntBits(this.m00);
        n = 31 * n + Float.floatToIntBits(this.m01);
        n = 31 * n + Float.floatToIntBits(this.m02);
        n = 31 * n + Float.floatToIntBits(this.m10);
        n = 31 * n + Float.floatToIntBits(this.m11);
        n = 31 * n + Float.floatToIntBits(this.m12);
        n = 31 * n + Float.floatToIntBits(this.m20);
        n = 31 * n + Float.floatToIntBits(this.m21);
        n = 31 * n + Float.floatToIntBits(this.m22);
        n = 31 * n + Float.floatToIntBits(this.m30);
        n = 31 * n + Float.floatToIntBits(this.m31);
        n = 31 * n + Float.floatToIntBits(this.m32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Matrix4x3f)) {
            return false;
        }
        Matrix4x3f matrix4x3f = (Matrix4x3f)object;
        if (Float.floatToIntBits(this.m00) != Float.floatToIntBits(matrix4x3f.m00)) {
            return false;
        }
        if (Float.floatToIntBits(this.m01) != Float.floatToIntBits(matrix4x3f.m01)) {
            return false;
        }
        if (Float.floatToIntBits(this.m02) != Float.floatToIntBits(matrix4x3f.m02)) {
            return false;
        }
        if (Float.floatToIntBits(this.m10) != Float.floatToIntBits(matrix4x3f.m10)) {
            return false;
        }
        if (Float.floatToIntBits(this.m11) != Float.floatToIntBits(matrix4x3f.m11)) {
            return false;
        }
        if (Float.floatToIntBits(this.m12) != Float.floatToIntBits(matrix4x3f.m12)) {
            return false;
        }
        if (Float.floatToIntBits(this.m20) != Float.floatToIntBits(matrix4x3f.m20)) {
            return false;
        }
        if (Float.floatToIntBits(this.m21) != Float.floatToIntBits(matrix4x3f.m21)) {
            return false;
        }
        if (Float.floatToIntBits(this.m22) != Float.floatToIntBits(matrix4x3f.m22)) {
            return false;
        }
        if (Float.floatToIntBits(this.m30) != Float.floatToIntBits(matrix4x3f.m30)) {
            return false;
        }
        if (Float.floatToIntBits(this.m31) != Float.floatToIntBits(matrix4x3f.m31)) {
            return false;
        }
        return Float.floatToIntBits(this.m32) == Float.floatToIntBits(matrix4x3f.m32);
    }

    @Override
    public boolean equals(Matrix4x3fc matrix4x3fc, float f) {
        if (this == matrix4x3fc) {
            return true;
        }
        if (matrix4x3fc == null) {
            return false;
        }
        if (!(matrix4x3fc instanceof Matrix4x3f)) {
            return false;
        }
        if (!Runtime.equals(this.m00, matrix4x3fc.m00(), f)) {
            return false;
        }
        if (!Runtime.equals(this.m01, matrix4x3fc.m01(), f)) {
            return false;
        }
        if (!Runtime.equals(this.m02, matrix4x3fc.m02(), f)) {
            return false;
        }
        if (!Runtime.equals(this.m10, matrix4x3fc.m10(), f)) {
            return false;
        }
        if (!Runtime.equals(this.m11, matrix4x3fc.m11(), f)) {
            return false;
        }
        if (!Runtime.equals(this.m12, matrix4x3fc.m12(), f)) {
            return false;
        }
        if (!Runtime.equals(this.m20, matrix4x3fc.m20(), f)) {
            return false;
        }
        if (!Runtime.equals(this.m21, matrix4x3fc.m21(), f)) {
            return false;
        }
        if (!Runtime.equals(this.m22, matrix4x3fc.m22(), f)) {
            return false;
        }
        if (!Runtime.equals(this.m30, matrix4x3fc.m30(), f)) {
            return false;
        }
        if (!Runtime.equals(this.m31, matrix4x3fc.m31(), f)) {
            return false;
        }
        return Runtime.equals(this.m32, matrix4x3fc.m32(), f);
    }

    @Override
    public Matrix4x3f pick(float f, float f2, float f3, float f4, int[] nArray, Matrix4x3f matrix4x3f) {
        float f5 = (float)nArray[2] / f3;
        float f6 = (float)nArray[3] / f4;
        float f7 = ((float)nArray[2] + 2.0f * ((float)nArray[0] - f)) / f3;
        float f8 = ((float)nArray[3] + 2.0f * ((float)nArray[1] - f2)) / f4;
        matrix4x3f.m30 = this.m00 * f7 + this.m10 * f8 + this.m30;
        matrix4x3f.m31 = this.m01 * f7 + this.m11 * f8 + this.m31;
        matrix4x3f.m32 = this.m02 * f7 + this.m12 * f8 + this.m32;
        matrix4x3f.m00 = this.m00 * f5;
        matrix4x3f.m01 = this.m01 * f5;
        matrix4x3f.m02 = this.m02 * f5;
        matrix4x3f.m10 = this.m10 * f6;
        matrix4x3f.m11 = this.m11 * f6;
        matrix4x3f.m12 = this.m12 * f6;
        matrix4x3f.properties = 0;
        return matrix4x3f;
    }

    public Matrix4x3f pick(float f, float f2, float f3, float f4, int[] nArray) {
        return this.pick(f, f2, f3, f4, nArray, this);
    }

    public Matrix4x3f swap(Matrix4x3f matrix4x3f) {
        MemUtil.INSTANCE.swap(this, matrix4x3f);
        int n = this.properties;
        this.properties = matrix4x3f.properties;
        matrix4x3f.properties = n;
        return this;
    }

    @Override
    public Matrix4x3f arcball(float f, float f2, float f3, float f4, float f5, float f6, Matrix4x3f matrix4x3f) {
        float f7 = this.m20 * -f + this.m30;
        float f8 = this.m21 * -f + this.m31;
        float f9 = this.m22 * -f + this.m32;
        float f10 = Math.sin(f5);
        float f11 = Math.cosFromSin(f10, f5);
        float f12 = this.m10 * f11 + this.m20 * f10;
        float f13 = this.m11 * f11 + this.m21 * f10;
        float f14 = this.m12 * f11 + this.m22 * f10;
        float f15 = this.m20 * f11 - this.m10 * f10;
        float f16 = this.m21 * f11 - this.m11 * f10;
        float f17 = this.m22 * f11 - this.m12 * f10;
        f10 = Math.sin(f6);
        f11 = Math.cosFromSin(f10, f6);
        float f18 = this.m00 * f11 - f15 * f10;
        float f19 = this.m01 * f11 - f16 * f10;
        float f20 = this.m02 * f11 - f17 * f10;
        float f21 = this.m00 * f10 + f15 * f11;
        float f22 = this.m01 * f10 + f16 * f11;
        float f23 = this.m02 * f10 + f17 * f11;
        matrix4x3f.m30 = -f18 * f2 - f12 * f3 - f21 * f4 + f7;
        matrix4x3f.m31 = -f19 * f2 - f13 * f3 - f22 * f4 + f8;
        matrix4x3f.m32 = -f20 * f2 - f14 * f3 - f23 * f4 + f9;
        matrix4x3f.m20 = f21;
        matrix4x3f.m21 = f22;
        matrix4x3f.m22 = f23;
        matrix4x3f.m10 = f12;
        matrix4x3f.m11 = f13;
        matrix4x3f.m12 = f14;
        matrix4x3f.m00 = f18;
        matrix4x3f.m01 = f19;
        matrix4x3f.m02 = f20;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    @Override
    public Matrix4x3f arcball(float f, Vector3fc vector3fc, float f2, float f3, Matrix4x3f matrix4x3f) {
        return this.arcball(f, vector3fc.x(), vector3fc.y(), vector3fc.z(), f2, f3, matrix4x3f);
    }

    public Matrix4x3f arcball(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.arcball(f, f2, f3, f4, f5, f6, this);
    }

    public Matrix4x3f arcball(float f, Vector3fc vector3fc, float f2, float f3) {
        return this.arcball(f, vector3fc.x(), vector3fc.y(), vector3fc.z(), f2, f3, this);
    }

    @Override
    public Matrix4x3f transformAab(float f, float f2, float f3, float f4, float f5, float f6, Vector3f vector3f, Vector3f vector3f2) {
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        float f15;
        float f16;
        float f17;
        float f18;
        float f19;
        float f20;
        float f21;
        float f22;
        float f23;
        float f24;
        float f25 = this.m00 * f;
        float f26 = this.m01 * f;
        float f27 = this.m02 * f;
        float f28 = this.m00 * f4;
        float f29 = this.m01 * f4;
        float f30 = this.m02 * f4;
        float f31 = this.m10 * f2;
        float f32 = this.m11 * f2;
        float f33 = this.m12 * f2;
        float f34 = this.m10 * f5;
        float f35 = this.m11 * f5;
        float f36 = this.m12 * f5;
        float f37 = this.m20 * f3;
        float f38 = this.m21 * f3;
        float f39 = this.m22 * f3;
        float f40 = this.m20 * f6;
        float f41 = this.m21 * f6;
        float f42 = this.m22 * f6;
        if (f25 < f28) {
            f24 = f25;
            f23 = f28;
        } else {
            f24 = f28;
            f23 = f25;
        }
        if (f26 < f29) {
            f22 = f26;
            f21 = f29;
        } else {
            f22 = f29;
            f21 = f26;
        }
        if (f27 < f30) {
            f20 = f27;
            f19 = f30;
        } else {
            f20 = f30;
            f19 = f27;
        }
        if (f31 < f34) {
            f18 = f31;
            f17 = f34;
        } else {
            f18 = f34;
            f17 = f31;
        }
        if (f32 < f35) {
            f16 = f32;
            f15 = f35;
        } else {
            f16 = f35;
            f15 = f32;
        }
        if (f33 < f36) {
            f14 = f33;
            f13 = f36;
        } else {
            f14 = f36;
            f13 = f33;
        }
        if (f37 < f40) {
            f12 = f37;
            f11 = f40;
        } else {
            f12 = f40;
            f11 = f37;
        }
        if (f38 < f41) {
            f10 = f38;
            f9 = f41;
        } else {
            f10 = f41;
            f9 = f38;
        }
        if (f39 < f42) {
            f8 = f39;
            f7 = f42;
        } else {
            f8 = f42;
            f7 = f39;
        }
        vector3f.x = f24 + f18 + f12 + this.m30;
        vector3f.y = f22 + f16 + f10 + this.m31;
        vector3f.z = f20 + f14 + f8 + this.m32;
        vector3f2.x = f23 + f17 + f11 + this.m30;
        vector3f2.y = f21 + f15 + f9 + this.m31;
        vector3f2.z = f19 + f13 + f7 + this.m32;
        return this;
    }

    @Override
    public Matrix4x3f transformAab(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3f vector3f, Vector3f vector3f2) {
        return this.transformAab(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3f, vector3f2);
    }

    public Matrix4x3f lerp(Matrix4x3fc matrix4x3fc, float f) {
        return this.lerp(matrix4x3fc, f, this);
    }

    @Override
    public Matrix4x3f lerp(Matrix4x3fc matrix4x3fc, float f, Matrix4x3f matrix4x3f) {
        matrix4x3f.m00 = Math.fma(matrix4x3fc.m00() - this.m00, f, this.m00);
        matrix4x3f.m01 = Math.fma(matrix4x3fc.m01() - this.m01, f, this.m01);
        matrix4x3f.m02 = Math.fma(matrix4x3fc.m02() - this.m02, f, this.m02);
        matrix4x3f.m10 = Math.fma(matrix4x3fc.m10() - this.m10, f, this.m10);
        matrix4x3f.m11 = Math.fma(matrix4x3fc.m11() - this.m11, f, this.m11);
        matrix4x3f.m12 = Math.fma(matrix4x3fc.m12() - this.m12, f, this.m12);
        matrix4x3f.m20 = Math.fma(matrix4x3fc.m20() - this.m20, f, this.m20);
        matrix4x3f.m21 = Math.fma(matrix4x3fc.m21() - this.m21, f, this.m21);
        matrix4x3f.m22 = Math.fma(matrix4x3fc.m22() - this.m22, f, this.m22);
        matrix4x3f.m30 = Math.fma(matrix4x3fc.m30() - this.m30, f, this.m30);
        matrix4x3f.m31 = Math.fma(matrix4x3fc.m31() - this.m31, f, this.m31);
        matrix4x3f.m32 = Math.fma(matrix4x3fc.m32() - this.m32, f, this.m32);
        matrix4x3f.properties = this.properties & matrix4x3fc.properties();
        return matrix4x3f;
    }

    @Override
    public Matrix4x3f rotateTowards(Vector3fc vector3fc, Vector3fc vector3fc2, Matrix4x3f matrix4x3f) {
        return this.rotateTowards(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), matrix4x3f);
    }

    public Matrix4x3f rotateTowards(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.rotateTowards(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), this);
    }

    public Matrix4x3f rotateTowards(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.rotateTowards(f, f2, f3, f4, f5, f6, this);
    }

    @Override
    public Matrix4x3f rotateTowards(float f, float f2, float f3, float f4, float f5, float f6, Matrix4x3f matrix4x3f) {
        float f7 = Math.invsqrt(f * f + f2 * f2 + f3 * f3);
        float f8 = f * f7;
        float f9 = f2 * f7;
        float f10 = f3 * f7;
        float f11 = f5 * f10 - f6 * f9;
        float f12 = f6 * f8 - f4 * f10;
        float f13 = f4 * f9 - f5 * f8;
        float f14 = Math.invsqrt(f11 * f11 + f12 * f12 + f13 * f13);
        float f15 = f9 * (f13 *= f14) - f10 * (f12 *= f14);
        float f16 = f10 * (f11 *= f14) - f8 * f13;
        float f17 = f8 * f12 - f9 * f11;
        float f18 = f11;
        float f19 = f12;
        float f20 = f13;
        float f21 = f15;
        float f22 = f16;
        float f23 = f17;
        float f24 = f8;
        float f25 = f9;
        float f26 = f10;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        float f27 = this.m00 * f18 + this.m10 * f19 + this.m20 * f20;
        float f28 = this.m01 * f18 + this.m11 * f19 + this.m21 * f20;
        float f29 = this.m02 * f18 + this.m12 * f19 + this.m22 * f20;
        float f30 = this.m00 * f21 + this.m10 * f22 + this.m20 * f23;
        float f31 = this.m01 * f21 + this.m11 * f22 + this.m21 * f23;
        float f32 = this.m02 * f21 + this.m12 * f22 + this.m22 * f23;
        matrix4x3f.m20 = this.m00 * f24 + this.m10 * f25 + this.m20 * f26;
        matrix4x3f.m21 = this.m01 * f24 + this.m11 * f25 + this.m21 * f26;
        matrix4x3f.m22 = this.m02 * f24 + this.m12 * f25 + this.m22 * f26;
        matrix4x3f.m00 = f27;
        matrix4x3f.m01 = f28;
        matrix4x3f.m02 = f29;
        matrix4x3f.m10 = f30;
        matrix4x3f.m11 = f31;
        matrix4x3f.m12 = f32;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f rotationTowards(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.rotationTowards(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    public Matrix4x3f rotationTowards(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = Math.invsqrt(f * f + f2 * f2 + f3 * f3);
        float f8 = f * f7;
        float f9 = f2 * f7;
        float f10 = f3 * f7;
        float f11 = f5 * f10 - f6 * f9;
        float f12 = f6 * f8 - f4 * f10;
        float f13 = f4 * f9 - f5 * f8;
        float f14 = Math.invsqrt(f11 * f11 + f12 * f12 + f13 * f13);
        float f15 = f9 * (f13 *= f14) - f10 * (f12 *= f14);
        float f16 = f10 * (f11 *= f14) - f8 * f13;
        float f17 = f8 * f12 - f9 * f11;
        this.m00 = f11;
        this.m01 = f12;
        this.m02 = f13;
        this.m10 = f15;
        this.m11 = f16;
        this.m12 = f17;
        this.m20 = f8;
        this.m21 = f9;
        this.m22 = f10;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f translationRotateTowards(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3) {
        return this.translationRotateTowards(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z());
    }

    public Matrix4x3f translationRotateTowards(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = Math.invsqrt(f4 * f4 + f5 * f5 + f6 * f6);
        float f11 = f4 * f10;
        float f12 = f5 * f10;
        float f13 = f6 * f10;
        float f14 = f8 * f13 - f9 * f12;
        float f15 = f9 * f11 - f7 * f13;
        float f16 = f7 * f12 - f8 * f11;
        float f17 = Math.invsqrt(f14 * f14 + f15 * f15 + f16 * f16);
        float f18 = f12 * (f16 *= f17) - f13 * (f15 *= f17);
        float f19 = f13 * (f14 *= f17) - f11 * f16;
        float f20 = f11 * f15 - f12 * f14;
        this.m00 = f14;
        this.m01 = f15;
        this.m02 = f16;
        this.m10 = f18;
        this.m11 = f19;
        this.m12 = f20;
        this.m20 = f11;
        this.m21 = f12;
        this.m22 = f13;
        this.m30 = f;
        this.m31 = f2;
        this.m32 = f3;
        this.properties = 16;
        return this;
    }

    @Override
    public Vector3f getEulerAnglesZYX(Vector3f vector3f) {
        vector3f.x = Math.atan2(this.m12, this.m22);
        vector3f.y = Math.atan2(-this.m02, Math.sqrt(this.m12 * this.m12 + this.m22 * this.m22));
        vector3f.z = Math.atan2(this.m01, this.m00);
        return vector3f;
    }

    public Matrix4x3f obliqueZ(float f, float f2) {
        this.m20 = this.m00 * f + this.m10 * f2 + this.m20;
        this.m21 = this.m01 * f + this.m11 * f2 + this.m21;
        this.m22 = this.m02 * f + this.m12 * f2 + this.m22;
        this.properties = 0;
        return this;
    }

    @Override
    public Matrix4x3f obliqueZ(float f, float f2, Matrix4x3f matrix4x3f) {
        matrix4x3f.m00 = this.m00;
        matrix4x3f.m01 = this.m01;
        matrix4x3f.m02 = this.m02;
        matrix4x3f.m10 = this.m10;
        matrix4x3f.m11 = this.m11;
        matrix4x3f.m12 = this.m12;
        matrix4x3f.m20 = this.m00 * f + this.m10 * f2 + this.m20;
        matrix4x3f.m21 = this.m01 * f + this.m11 * f2 + this.m21;
        matrix4x3f.m22 = this.m02 * f + this.m12 * f2 + this.m22;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = 0;
        return matrix4x3f;
    }

    public Matrix4x3f withLookAtUp(Vector3fc vector3fc) {
        return this.withLookAtUp(vector3fc.x(), vector3fc.y(), vector3fc.z(), this);
    }

    @Override
    public Matrix4x3f withLookAtUp(Vector3fc vector3fc, Matrix4x3f matrix4x3f) {
        return this.withLookAtUp(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix4x3f withLookAtUp(float f, float f2, float f3) {
        return this.withLookAtUp(f, f2, f3, this);
    }

    @Override
    public Matrix4x3f withLookAtUp(float f, float f2, float f3, Matrix4x3f matrix4x3f) {
        float f4 = (f2 * this.m21 - f3 * this.m11) * this.m02 + (f3 * this.m01 - f * this.m21) * this.m12 + (f * this.m11 - f2 * this.m01) * this.m22;
        float f5 = f * this.m01 + f2 * this.m11 + f3 * this.m21;
        if ((this.properties & 0x10) == 0) {
            f5 *= Math.sqrt(this.m01 * this.m01 + this.m11 * this.m11 + this.m21 * this.m21);
        }
        float f6 = Math.invsqrt(f4 * f4 + f5 * f5);
        float f7 = f5 * f6;
        float f8 = f4 * f6;
        float f9 = f7 * this.m00 - f8 * this.m01;
        float f10 = f7 * this.m10 - f8 * this.m11;
        float f11 = f7 * this.m20 - f8 * this.m21;
        float f12 = f8 * this.m30 + f7 * this.m31;
        float f13 = f8 * this.m00 + f7 * this.m01;
        float f14 = f8 * this.m10 + f7 * this.m11;
        float f15 = f8 * this.m20 + f7 * this.m21;
        float f16 = f7 * this.m30 - f8 * this.m31;
        matrix4x3f._m00(f9)._m10(f10)._m20(f11)._m30(f16)._m01(f13)._m11(f14)._m21(f15)._m31(f12);
        if (matrix4x3f != this) {
            matrix4x3f._m02(this.m02)._m12(this.m12)._m22(this.m22)._m32(this.m32);
        }
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    @Override
    public boolean isFinite() {
        return Math.isFinite(this.m00) && Math.isFinite(this.m01) && Math.isFinite(this.m02) && Math.isFinite(this.m10) && Math.isFinite(this.m11) && Math.isFinite(this.m12) && Math.isFinite(this.m20) && Math.isFinite(this.m21) && Math.isFinite(this.m22) && Math.isFinite(this.m30) && Math.isFinite(this.m31) && Math.isFinite(this.m32);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

