/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.vendored.joml;

public class RayAabIntersection {
    private float originX;
    private float originY;
    private float originZ;
    private float dirX;
    private float dirY;
    private float dirZ;
    private float c_xy;
    private float c_yx;
    private float c_zy;
    private float c_yz;
    private float c_xz;
    private float c_zx;
    private float s_xy;
    private float s_yx;
    private float s_zy;
    private float s_yz;
    private float s_xz;
    private float s_zx;
    private byte classification;

    public RayAabIntersection() {
    }

    public RayAabIntersection(float f, float f2, float f3, float f4, float f5, float f6) {
        this.set(f, f2, f3, f4, f5, f6);
    }

    public void set(float f, float f2, float f3, float f4, float f5, float f6) {
        this.originX = f;
        this.originY = f2;
        this.originZ = f3;
        this.dirX = f4;
        this.dirY = f5;
        this.dirZ = f6;
        this.precomputeSlope();
    }

    private static int signum(float f) {
        return f == 0.0f || Float.isNaN(f) ? 0 : (1 - Float.floatToIntBits(f) >>> 31 << 1) - 1;
    }

    private void precomputeSlope() {
        float f = 1.0f / this.dirX;
        float f2 = 1.0f / this.dirY;
        float f3 = 1.0f / this.dirZ;
        this.s_yx = this.dirX * f2;
        this.s_xy = this.dirY * f;
        this.s_zy = this.dirY * f3;
        this.s_yz = this.dirZ * f2;
        this.s_xz = this.dirZ * f;
        this.s_zx = this.dirX * f3;
        this.c_xy = this.originY - this.s_xy * this.originX;
        this.c_yx = this.originX - this.s_yx * this.originY;
        this.c_zy = this.originY - this.s_zy * this.originZ;
        this.c_yz = this.originZ - this.s_yz * this.originY;
        this.c_xz = this.originZ - this.s_xz * this.originX;
        this.c_zx = this.originX - this.s_zx * this.originZ;
        int n = RayAabIntersection.signum(this.dirX);
        int n2 = RayAabIntersection.signum(this.dirY);
        int n3 = RayAabIntersection.signum(this.dirZ);
        this.classification = (byte)(n3 + 1 << 4 | n2 + 1 << 2 | n + 1);
    }

    public boolean test(float f, float f2, float f3, float f4, float f5, float f6) {
        switch (this.classification) {
            case 0: {
                return this.MMM(f, f2, f3, f4, f5, f6);
            }
            case 1: {
                return this.OMM(f, f2, f3, f4, f5, f6);
            }
            case 2: {
                return this.PMM(f, f2, f3, f4, f5, f6);
            }
            case 3: {
                return false;
            }
            case 4: {
                return this.MOM(f, f2, f3, f4, f5, f6);
            }
            case 5: {
                return this.OOM(f, f2, f3, f4, f5);
            }
            case 6: {
                return this.POM(f, f2, f3, f4, f5, f6);
            }
            case 7: {
                return false;
            }
            case 8: {
                return this.MPM(f, f2, f3, f4, f5, f6);
            }
            case 9: {
                return this.OPM(f, f2, f3, f4, f5, f6);
            }
            case 10: {
                return this.PPM(f, f2, f3, f4, f5, f6);
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return false;
            }
            case 16: {
                return this.MMO(f, f2, f3, f4, f5, f6);
            }
            case 17: {
                return this.OMO(f, f2, f3, f4, f6);
            }
            case 18: {
                return this.PMO(f, f2, f3, f4, f5, f6);
            }
            case 19: {
                return false;
            }
            case 20: {
                return this.MOO(f, f2, f3, f5, f6);
            }
            case 21: {
                return false;
            }
            case 22: {
                return this.POO(f2, f3, f4, f5, f6);
            }
            case 23: {
                return false;
            }
            case 24: {
                return this.MPO(f, f2, f3, f4, f5, f6);
            }
            case 25: {
                return this.OPO(f, f3, f4, f5, f6);
            }
            case 26: {
                return this.PPO(f, f2, f3, f4, f5, f6);
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                return false;
            }
            case 32: {
                return this.MMP(f, f2, f3, f4, f5, f6);
            }
            case 33: {
                return this.OMP(f, f2, f3, f4, f5, f6);
            }
            case 34: {
                return this.PMP(f, f2, f3, f4, f5, f6);
            }
            case 35: {
                return false;
            }
            case 36: {
                return this.MOP(f, f2, f3, f4, f5, f6);
            }
            case 37: {
                return this.OOP(f, f2, f4, f5, f6);
            }
            case 38: {
                return this.POP(f, f2, f3, f4, f5, f6);
            }
            case 39: {
                return false;
            }
            case 40: {
                return this.MPP(f, f2, f3, f4, f5, f6);
            }
            case 41: {
                return this.OPP(f, f2, f3, f4, f5, f6);
            }
            case 42: {
                return this.PPP(f, f2, f3, f4, f5, f6);
            }
        }
        return false;
    }

    private boolean MMM(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.originX >= f && this.originY >= f2 && this.originZ >= f3 && this.s_xy * f - f5 + this.c_xy <= 0.0f && this.s_yx * f2 - f4 + this.c_yx <= 0.0f && this.s_zy * f3 - f5 + this.c_zy <= 0.0f && this.s_yz * f2 - f6 + this.c_yz <= 0.0f && this.s_xz * f - f6 + this.c_xz <= 0.0f && this.s_zx * f3 - f4 + this.c_zx <= 0.0f;
    }

    private boolean OMM(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.originX >= f && this.originX <= f4 && this.originY >= f2 && this.originZ >= f3 && this.s_zy * f3 - f5 + this.c_zy <= 0.0f && this.s_yz * f2 - f6 + this.c_yz <= 0.0f;
    }

    private boolean PMM(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.originX <= f4 && this.originY >= f2 && this.originZ >= f3 && this.s_xy * f4 - f5 + this.c_xy <= 0.0f && this.s_yx * f2 - f + this.c_yx >= 0.0f && this.s_zy * f3 - f5 + this.c_zy <= 0.0f && this.s_yz * f2 - f6 + this.c_yz <= 0.0f && this.s_xz * f4 - f6 + this.c_xz <= 0.0f && this.s_zx * f3 - f + this.c_zx >= 0.0f;
    }

    private boolean MOM(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.originY >= f2 && this.originY <= f5 && this.originX >= f && this.originZ >= f3 && this.s_xz * f - f6 + this.c_xz <= 0.0f && this.s_zx * f3 - f4 + this.c_zx <= 0.0f;
    }

    private boolean OOM(float f, float f2, float f3, float f4, float f5) {
        return this.originZ >= f3 && this.originX >= f && this.originX <= f4 && this.originY >= f2 && this.originY <= f5;
    }

    private boolean POM(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.originY >= f2 && this.originY <= f5 && this.originX <= f4 && this.originZ >= f3 && this.s_xz * f4 - f6 + this.c_xz <= 0.0f && this.s_zx * f3 - f + this.c_zx >= 0.0f;
    }

    private boolean MPM(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.originX >= f && this.originY <= f5 && this.originZ >= f3 && this.s_xy * f - f2 + this.c_xy >= 0.0f && this.s_yx * f5 - f4 + this.c_yx <= 0.0f && this.s_zy * f3 - f2 + this.c_zy >= 0.0f && this.s_yz * f5 - f6 + this.c_yz <= 0.0f && this.s_xz * f - f6 + this.c_xz <= 0.0f && this.s_zx * f3 - f4 + this.c_zx <= 0.0f;
    }

    private boolean OPM(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.originX >= f && this.originX <= f4 && this.originY <= f5 && this.originZ >= f3 && this.s_zy * f3 - f2 + this.c_zy >= 0.0f && this.s_yz * f5 - f6 + this.c_yz <= 0.0f;
    }

    private boolean PPM(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.originX <= f4 && this.originY <= f5 && this.originZ >= f3 && this.s_xy * f4 - f2 + this.c_xy >= 0.0f && this.s_yx * f5 - f + this.c_yx >= 0.0f && this.s_zy * f3 - f2 + this.c_zy >= 0.0f && this.s_yz * f5 - f6 + this.c_yz <= 0.0f && this.s_xz * f4 - f6 + this.c_xz <= 0.0f && this.s_zx * f3 - f + this.c_zx >= 0.0f;
    }

    private boolean MMO(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.originZ >= f3 && this.originZ <= f6 && this.originX >= f && this.originY >= f2 && this.s_xy * f - f5 + this.c_xy <= 0.0f && this.s_yx * f2 - f4 + this.c_yx <= 0.0f;
    }

    private boolean OMO(float f, float f2, float f3, float f4, float f5) {
        return this.originY >= f2 && this.originX >= f && this.originX <= f4 && this.originZ >= f3 && this.originZ <= f5;
    }

    private boolean PMO(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.originZ >= f3 && this.originZ <= f6 && this.originX <= f4 && this.originY >= f2 && this.s_xy * f4 - f5 + this.c_xy <= 0.0f && this.s_yx * f2 - f + this.c_yx >= 0.0f;
    }

    private boolean MOO(float f, float f2, float f3, float f4, float f5) {
        return this.originX >= f && this.originY >= f2 && this.originY <= f4 && this.originZ >= f3 && this.originZ <= f5;
    }

    private boolean POO(float f, float f2, float f3, float f4, float f5) {
        return this.originX <= f3 && this.originY >= f && this.originY <= f4 && this.originZ >= f2 && this.originZ <= f5;
    }

    private boolean MPO(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.originZ >= f3 && this.originZ <= f6 && this.originX >= f && this.originY <= f5 && this.s_xy * f - f2 + this.c_xy >= 0.0f && this.s_yx * f5 - f4 + this.c_yx <= 0.0f;
    }

    private boolean OPO(float f, float f2, float f3, float f4, float f5) {
        return this.originY <= f4 && this.originX >= f && this.originX <= f3 && this.originZ >= f2 && this.originZ <= f5;
    }

    private boolean PPO(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.originZ >= f3 && this.originZ <= f6 && this.originX <= f4 && this.originY <= f5 && this.s_xy * f4 - f2 + this.c_xy >= 0.0f && this.s_yx * f5 - f + this.c_yx >= 0.0f;
    }

    private boolean MMP(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.originX >= f && this.originY >= f2 && this.originZ <= f6 && this.s_xy * f - f5 + this.c_xy <= 0.0f && this.s_yx * f2 - f4 + this.c_yx <= 0.0f && this.s_zy * f6 - f5 + this.c_zy <= 0.0f && this.s_yz * f2 - f3 + this.c_yz >= 0.0f && this.s_xz * f - f3 + this.c_xz >= 0.0f && this.s_zx * f6 - f4 + this.c_zx <= 0.0f;
    }

    private boolean OMP(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.originX >= f && this.originX <= f4 && this.originY >= f2 && this.originZ <= f6 && this.s_zy * f6 - f5 + this.c_zy <= 0.0f && this.s_yz * f2 - f3 + this.c_yz >= 0.0f;
    }

    private boolean PMP(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.originX <= f4 && this.originY >= f2 && this.originZ <= f6 && this.s_xy * f4 - f5 + this.c_xy <= 0.0f && this.s_yx * f2 - f + this.c_yx >= 0.0f && this.s_zy * f6 - f5 + this.c_zy <= 0.0f && this.s_yz * f2 - f3 + this.c_yz >= 0.0f && this.s_xz * f4 - f3 + this.c_xz >= 0.0f && this.s_zx * f6 - f + this.c_zx >= 0.0f;
    }

    private boolean MOP(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.originY >= f2 && this.originY <= f5 && this.originX >= f && this.originZ <= f6 && this.s_xz * f - f3 + this.c_xz >= 0.0f && this.s_zx * f6 - f4 + this.c_zx <= 0.0f;
    }

    private boolean OOP(float f, float f2, float f3, float f4, float f5) {
        return this.originZ <= f5 && this.originX >= f && this.originX <= f3 && this.originY >= f2 && this.originY <= f4;
    }

    private boolean POP(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.originY >= f2 && this.originY <= f5 && this.originX <= f4 && this.originZ <= f6 && this.s_xz * f4 - f3 + this.c_xz >= 0.0f && this.s_zx * f6 - f + this.c_zx <= 0.0f;
    }

    private boolean MPP(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.originX >= f && this.originY <= f5 && this.originZ <= f6 && this.s_xy * f - f2 + this.c_xy >= 0.0f && this.s_yx * f5 - f4 + this.c_yx <= 0.0f && this.s_zy * f6 - f2 + this.c_zy >= 0.0f && this.s_yz * f5 - f3 + this.c_yz >= 0.0f && this.s_xz * f - f3 + this.c_xz >= 0.0f && this.s_zx * f6 - f4 + this.c_zx <= 0.0f;
    }

    private boolean OPP(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.originX >= f && this.originX <= f4 && this.originY <= f5 && this.originZ <= f6 && this.s_zy * f6 - f2 + this.c_zy <= 0.0f && this.s_yz * f5 - f3 + this.c_yz <= 0.0f;
    }

    private boolean PPP(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.originX <= f4 && this.originY <= f5 && this.originZ <= f6 && this.s_xy * f4 - f2 + this.c_xy >= 0.0f && this.s_yx * f5 - f + this.c_yx >= 0.0f && this.s_zy * f6 - f2 + this.c_zy >= 0.0f && this.s_yz * f5 - f3 + this.c_yz >= 0.0f && this.s_xz * f4 - f3 + this.c_xz >= 0.0f && this.s_zx * f6 - f + this.c_zx >= 0.0f;
    }
}

