/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.vendored.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.text.NumberFormat;
import net.coderbot.iris.vendored.joml.Math;
import net.coderbot.iris.vendored.joml.MemUtil;
import net.coderbot.iris.vendored.joml.Options;
import net.coderbot.iris.vendored.joml.Runtime;
import net.coderbot.iris.vendored.joml.Vector2dc;
import net.coderbot.iris.vendored.joml.Vector2fc;
import net.coderbot.iris.vendored.joml.Vector2ic;
import net.coderbot.iris.vendored.joml.Vector3dc;
import net.coderbot.iris.vendored.joml.Vector3fc;
import net.coderbot.iris.vendored.joml.Vector3ic;

public class Vector3i
implements Externalizable,
Cloneable,
Vector3ic {
    private static final long serialVersionUID = 1L;
    public int x;
    public int y;
    public int z;

    public Vector3i() {
    }

    public Vector3i(int n) {
        this.x = n;
        this.y = n;
        this.z = n;
    }

    public Vector3i(int n, int n2, int n3) {
        this.x = n;
        this.y = n2;
        this.z = n3;
    }

    public Vector3i(Vector3ic vector3ic) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
        this.z = vector3ic.z();
    }

    public Vector3i(Vector2ic vector2ic, int n) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = n;
    }

    public Vector3i(float f, float f2, float f3, int n) {
        this.x = Math.roundUsing(f, n);
        this.y = Math.roundUsing(f2, n);
        this.z = Math.roundUsing(f3, n);
    }

    public Vector3i(double d, double d2, double d3, int n) {
        this.x = Math.roundUsing(d, n);
        this.y = Math.roundUsing(d2, n);
        this.z = Math.roundUsing(d3, n);
    }

    public Vector3i(Vector2fc vector2fc, float f, int n) {
        this.x = Math.roundUsing(vector2fc.x(), n);
        this.y = Math.roundUsing(vector2fc.y(), n);
        this.z = Math.roundUsing(f, n);
    }

    public Vector3i(Vector3fc vector3fc, int n) {
        this.x = Math.roundUsing(vector3fc.x(), n);
        this.y = Math.roundUsing(vector3fc.y(), n);
        this.z = Math.roundUsing(vector3fc.z(), n);
    }

    public Vector3i(Vector2dc vector2dc, float f, int n) {
        this.x = Math.roundUsing(vector2dc.x(), n);
        this.y = Math.roundUsing(vector2dc.y(), n);
        this.z = Math.roundUsing(f, n);
    }

    public Vector3i(Vector3dc vector3dc, int n) {
        this.x = Math.roundUsing(vector3dc.x(), n);
        this.y = Math.roundUsing(vector3dc.y(), n);
        this.z = Math.roundUsing(vector3dc.z(), n);
    }

    public Vector3i(int[] nArray) {
        this.x = nArray[0];
        this.y = nArray[1];
        this.z = nArray[2];
    }

    public Vector3i(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
    }

    public Vector3i(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n, byteBuffer);
    }

    public Vector3i(IntBuffer intBuffer) {
        MemUtil.INSTANCE.get(this, intBuffer.position(), intBuffer);
    }

    public Vector3i(int n, IntBuffer intBuffer) {
        MemUtil.INSTANCE.get(this, n, intBuffer);
    }

    @Override
    public int x() {
        return this.x;
    }

    @Override
    public int y() {
        return this.y;
    }

    @Override
    public int z() {
        return this.z;
    }

    public Vector3i set(Vector3ic vector3ic) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
        this.z = vector3ic.z();
        return this;
    }

    public Vector3i set(Vector3dc vector3dc) {
        this.x = (int)vector3dc.x();
        this.y = (int)vector3dc.y();
        this.z = (int)vector3dc.z();
        return this;
    }

    public Vector3i set(Vector3dc vector3dc, int n) {
        this.x = Math.roundUsing(vector3dc.x(), n);
        this.y = Math.roundUsing(vector3dc.y(), n);
        this.z = Math.roundUsing(vector3dc.z(), n);
        return this;
    }

    public Vector3i set(Vector3fc vector3fc, int n) {
        this.x = Math.roundUsing(vector3fc.x(), n);
        this.y = Math.roundUsing(vector3fc.y(), n);
        this.z = Math.roundUsing(vector3fc.z(), n);
        return this;
    }

    public Vector3i set(Vector2ic vector2ic, int n) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = n;
        return this;
    }

    public Vector3i set(int n) {
        this.x = n;
        this.y = n;
        this.z = n;
        return this;
    }

    public Vector3i set(int n, int n2, int n3) {
        this.x = n;
        this.y = n2;
        this.z = n3;
        return this;
    }

    public Vector3i set(int[] nArray) {
        this.x = nArray[0];
        this.y = nArray[1];
        this.z = nArray[2];
        return this;
    }

    public Vector3i set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Vector3i set(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n, byteBuffer);
        return this;
    }

    public Vector3i set(IntBuffer intBuffer) {
        MemUtil.INSTANCE.get(this, intBuffer.position(), intBuffer);
        return this;
    }

    public Vector3i set(int n, IntBuffer intBuffer) {
        MemUtil.INSTANCE.get(this, n, intBuffer);
        return this;
    }

    @Override
    public int get(int n) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException();
    }

    public Vector3i setComponent(int n, int n2) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                this.x = n2;
                break;
            }
            case 1: {
                this.y = n2;
                break;
            }
            case 2: {
                this.z = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    @Override
    public IntBuffer get(IntBuffer intBuffer) {
        MemUtil.INSTANCE.put(this, intBuffer.position(), intBuffer);
        return intBuffer;
    }

    @Override
    public IntBuffer get(int n, IntBuffer intBuffer) {
        MemUtil.INSTANCE.put(this, n, intBuffer);
        return intBuffer;
    }

    @Override
    public ByteBuffer get(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    @Override
    public ByteBuffer get(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n, byteBuffer);
        return byteBuffer;
    }

    public Vector3i sub(Vector3ic vector3ic) {
        this.x -= vector3ic.x();
        this.y -= vector3ic.y();
        this.z -= vector3ic.z();
        return this;
    }

    @Override
    public Vector3i sub(Vector3ic vector3ic, Vector3i vector3i) {
        vector3i.x = this.x - vector3ic.x();
        vector3i.y = this.y - vector3ic.y();
        vector3i.z = this.z - vector3ic.z();
        return vector3i;
    }

    public Vector3i sub(int n, int n2, int n3) {
        this.x -= n;
        this.y -= n2;
        this.z -= n3;
        return this;
    }

    @Override
    public Vector3i sub(int n, int n2, int n3, Vector3i vector3i) {
        vector3i.x = this.x - n;
        vector3i.y = this.y - n2;
        vector3i.z = this.z - n3;
        return vector3i;
    }

    public Vector3i add(Vector3ic vector3ic) {
        this.x += vector3ic.x();
        this.y += vector3ic.y();
        this.z += vector3ic.z();
        return this;
    }

    @Override
    public Vector3i add(Vector3ic vector3ic, Vector3i vector3i) {
        vector3i.x = this.x + vector3ic.x();
        vector3i.y = this.y + vector3ic.y();
        vector3i.z = this.z + vector3ic.z();
        return vector3i;
    }

    public Vector3i add(int n, int n2, int n3) {
        this.x += n;
        this.y += n2;
        this.z += n3;
        return this;
    }

    @Override
    public Vector3i add(int n, int n2, int n3, Vector3i vector3i) {
        vector3i.x = this.x + n;
        vector3i.y = this.y + n2;
        vector3i.z = this.z + n3;
        return vector3i;
    }

    public Vector3i mul(int n) {
        this.x *= n;
        this.y *= n;
        this.z *= n;
        return this;
    }

    @Override
    public Vector3i mul(int n, Vector3i vector3i) {
        vector3i.x = this.x * n;
        vector3i.y = this.y * n;
        vector3i.z = this.z * n;
        return vector3i;
    }

    public Vector3i mul(Vector3ic vector3ic) {
        this.x *= vector3ic.x();
        this.y *= vector3ic.y();
        this.z *= vector3ic.z();
        return this;
    }

    @Override
    public Vector3i mul(Vector3ic vector3ic, Vector3i vector3i) {
        vector3i.x = this.x * vector3ic.x();
        vector3i.y = this.y * vector3ic.y();
        vector3i.z = this.z * vector3ic.z();
        return vector3i;
    }

    public Vector3i mul(int n, int n2, int n3) {
        this.x *= n;
        this.y *= n2;
        this.z *= n3;
        return this;
    }

    @Override
    public Vector3i mul(int n, int n2, int n3, Vector3i vector3i) {
        vector3i.x = this.x * n;
        vector3i.y = this.y * n2;
        vector3i.z = this.z * n3;
        return vector3i;
    }

    public Vector3i div(float f) {
        float f2 = 1.0f / f;
        this.x = (int)((float)this.x * f2);
        this.y = (int)((float)this.y * f2);
        this.z = (int)((float)this.z * f2);
        return this;
    }

    @Override
    public Vector3i div(float f, Vector3i vector3i) {
        float f2 = 1.0f / f;
        vector3i.x = (int)((float)this.x * f2);
        vector3i.y = (int)((float)this.y * f2);
        vector3i.z = (int)((float)this.z * f2);
        return vector3i;
    }

    public Vector3i div(int n) {
        this.x /= n;
        this.y /= n;
        this.z /= n;
        return this;
    }

    @Override
    public Vector3i div(int n, Vector3i vector3i) {
        vector3i.x = this.x / n;
        vector3i.y = this.y / n;
        vector3i.z = this.z / n;
        return vector3i;
    }

    @Override
    public long lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public static long lengthSquared(int n, int n2, int n3) {
        return n * n + n2 * n2 + n3 * n3;
    }

    @Override
    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public static double length(int n, int n2, int n3) {
        return Math.sqrt(n * n + n2 * n2 + n3 * n3);
    }

    @Override
    public double distance(Vector3ic vector3ic) {
        int n = this.x - vector3ic.x();
        int n2 = this.y - vector3ic.y();
        int n3 = this.z - vector3ic.z();
        return Math.sqrt(n * n + n2 * n2 + n3 * n3);
    }

    @Override
    public double distance(int n, int n2, int n3) {
        int n4 = this.x - n;
        int n5 = this.y - n2;
        int n6 = this.z - n3;
        return Math.sqrt(n4 * n4 + n5 * n5 + n6 * n6);
    }

    @Override
    public long gridDistance(Vector3ic vector3ic) {
        return Math.abs(vector3ic.x() - this.x()) + Math.abs(vector3ic.y() - this.y()) + Math.abs(vector3ic.z() - this.z());
    }

    @Override
    public long gridDistance(int n, int n2, int n3) {
        return Math.abs(n - this.x()) + Math.abs(n2 - this.y()) + Math.abs(n3 - this.z());
    }

    @Override
    public long distanceSquared(Vector3ic vector3ic) {
        int n = this.x - vector3ic.x();
        int n2 = this.y - vector3ic.y();
        int n3 = this.z - vector3ic.z();
        return n * n + n2 * n2 + n3 * n3;
    }

    @Override
    public long distanceSquared(int n, int n2, int n3) {
        int n4 = this.x - n;
        int n5 = this.y - n2;
        int n6 = this.z - n3;
        return n4 * n4 + n5 * n5 + n6 * n6;
    }

    public static double distance(int n, int n2, int n3, int n4, int n5, int n6) {
        return Math.sqrt(Vector3i.distanceSquared(n, n2, n3, n4, n5, n6));
    }

    public static long distanceSquared(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n - n4;
        int n8 = n2 - n5;
        int n9 = n3 - n6;
        return n7 * n7 + n8 * n8 + n9 * n9;
    }

    public Vector3i zero() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
        return this;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + numberFormat.format(this.x) + " " + numberFormat.format(this.y) + " " + numberFormat.format(this.z) + ")";
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.x);
        objectOutput.writeInt(this.y);
        objectOutput.writeInt(this.z);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.x = objectInput.readInt();
        this.y = objectInput.readInt();
        this.z = objectInput.readInt();
    }

    public Vector3i negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    @Override
    public Vector3i negate(Vector3i vector3i) {
        vector3i.x = -this.x;
        vector3i.y = -this.y;
        vector3i.z = -this.z;
        return vector3i;
    }

    public Vector3i min(Vector3ic vector3ic) {
        this.x = this.x < vector3ic.x() ? this.x : vector3ic.x();
        this.y = this.y < vector3ic.y() ? this.y : vector3ic.y();
        this.z = this.z < vector3ic.z() ? this.z : vector3ic.z();
        return this;
    }

    @Override
    public Vector3i min(Vector3ic vector3ic, Vector3i vector3i) {
        vector3i.x = this.x < vector3ic.x() ? this.x : vector3ic.x();
        vector3i.y = this.y < vector3ic.y() ? this.y : vector3ic.y();
        vector3i.z = this.z < vector3ic.z() ? this.z : vector3ic.z();
        return vector3i;
    }

    public Vector3i max(Vector3ic vector3ic) {
        this.x = this.x > vector3ic.x() ? this.x : vector3ic.x();
        this.y = this.y > vector3ic.y() ? this.y : vector3ic.y();
        this.z = this.z > vector3ic.z() ? this.z : vector3ic.z();
        return this;
    }

    @Override
    public Vector3i max(Vector3ic vector3ic, Vector3i vector3i) {
        vector3i.x = this.x > vector3ic.x() ? this.x : vector3ic.x();
        vector3i.y = this.y > vector3ic.y() ? this.y : vector3ic.y();
        vector3i.z = this.z > vector3ic.z() ? this.z : vector3ic.z();
        return vector3i;
    }

    @Override
    public int maxComponent() {
        float f = Math.abs(this.x);
        float f2 = Math.abs(this.y);
        float f3 = Math.abs(this.z);
        if (f >= f2 && f >= f3) {
            return 0;
        }
        if (f2 >= f3) {
            return 1;
        }
        return 2;
    }

    @Override
    public int minComponent() {
        float f = Math.abs(this.x);
        float f2 = Math.abs(this.y);
        float f3 = Math.abs(this.z);
        if (f < f2 && f < f3) {
            return 0;
        }
        if (f2 < f3) {
            return 1;
        }
        return 2;
    }

    public Vector3i absolute() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        this.z = Math.abs(this.z);
        return this;
    }

    @Override
    public Vector3i absolute(Vector3i vector3i) {
        vector3i.x = Math.abs(this.x);
        vector3i.y = Math.abs(this.y);
        vector3i.z = Math.abs(this.z);
        return vector3i;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.x;
        n = 31 * n + this.y;
        n = 31 * n + this.z;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Vector3i vector3i = (Vector3i)object;
        if (this.x != vector3i.x) {
            return false;
        }
        if (this.y != vector3i.y) {
            return false;
        }
        return this.z == vector3i.z;
    }

    @Override
    public boolean equals(int n, int n2, int n3) {
        if (this.x != n) {
            return false;
        }
        if (this.y != n2) {
            return false;
        }
        return this.z == n3;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

