/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.vendored.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.text.NumberFormat;
import net.coderbot.iris.vendored.joml.Math;
import net.coderbot.iris.vendored.joml.Matrix4dc;
import net.coderbot.iris.vendored.joml.Matrix4fc;
import net.coderbot.iris.vendored.joml.Matrix4x3dc;
import net.coderbot.iris.vendored.joml.Matrix4x3fc;
import net.coderbot.iris.vendored.joml.MemUtil;
import net.coderbot.iris.vendored.joml.Options;
import net.coderbot.iris.vendored.joml.Quaterniondc;
import net.coderbot.iris.vendored.joml.Runtime;
import net.coderbot.iris.vendored.joml.Vector2dc;
import net.coderbot.iris.vendored.joml.Vector2fc;
import net.coderbot.iris.vendored.joml.Vector2ic;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.coderbot.iris.vendored.joml.Vector3dc;
import net.coderbot.iris.vendored.joml.Vector3fc;
import net.coderbot.iris.vendored.joml.Vector3ic;
import net.coderbot.iris.vendored.joml.Vector4dc;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.coderbot.iris.vendored.joml.Vector4fc;
import net.coderbot.iris.vendored.joml.Vector4i;
import net.coderbot.iris.vendored.joml.Vector4ic;

public class Vector4d
implements Externalizable,
Cloneable,
Vector4dc {
    private static final long serialVersionUID = 1L;
    public double x;
    public double y;
    public double z;
    public double w;

    public Vector4d() {
        this.w = 1.0;
    }

    public Vector4d(Vector4dc vector4dc) {
        this.x = vector4dc.x();
        this.y = vector4dc.y();
        this.z = vector4dc.z();
        this.w = vector4dc.w();
    }

    public Vector4d(Vector4ic vector4ic) {
        this.x = vector4ic.x();
        this.y = vector4ic.y();
        this.z = vector4ic.z();
        this.w = vector4ic.w();
    }

    public Vector4d(Vector3dc vector3dc, double d) {
        this.x = vector3dc.x();
        this.y = vector3dc.y();
        this.z = vector3dc.z();
        this.w = d;
    }

    public Vector4d(Vector3ic vector3ic, double d) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
        this.z = vector3ic.z();
        this.w = d;
    }

    public Vector4d(Vector2dc vector2dc, double d, double d2) {
        this.x = vector2dc.x();
        this.y = vector2dc.y();
        this.z = d;
        this.w = d2;
    }

    public Vector4d(Vector2ic vector2ic, double d, double d2) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = d;
        this.w = d2;
    }

    public Vector4d(double d) {
        this.x = d;
        this.y = d;
        this.z = d;
        this.w = d;
    }

    public Vector4d(Vector4fc vector4fc) {
        this.x = vector4fc.x();
        this.y = vector4fc.y();
        this.z = vector4fc.z();
        this.w = vector4fc.w();
    }

    public Vector4d(Vector3fc vector3fc, double d) {
        this.x = vector3fc.x();
        this.y = vector3fc.y();
        this.z = vector3fc.z();
        this.w = d;
    }

    public Vector4d(Vector2fc vector2fc, double d, double d2) {
        this.x = vector2fc.x();
        this.y = vector2fc.y();
        this.z = d;
        this.w = d2;
    }

    public Vector4d(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
    }

    public Vector4d(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
        this.w = fArray[3];
    }

    public Vector4d(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
        this.w = dArray[3];
    }

    public Vector4d(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
    }

    public Vector4d(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n, byteBuffer);
    }

    public Vector4d(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, doubleBuffer.position(), doubleBuffer);
    }

    public Vector4d(int n, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, n, doubleBuffer);
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    public double z() {
        return this.z;
    }

    @Override
    public double w() {
        return this.w;
    }

    public Vector4d set(Vector4dc vector4dc) {
        this.x = vector4dc.x();
        this.y = vector4dc.y();
        this.z = vector4dc.z();
        this.w = vector4dc.w();
        return this;
    }

    public Vector4d set(Vector4fc vector4fc) {
        this.x = vector4fc.x();
        this.y = vector4fc.y();
        this.z = vector4fc.z();
        this.w = vector4fc.w();
        return this;
    }

    public Vector4d set(Vector4ic vector4ic) {
        this.x = vector4ic.x();
        this.y = vector4ic.y();
        this.z = vector4ic.z();
        this.w = vector4ic.w();
        return this;
    }

    public Vector4d set(Vector3dc vector3dc, double d) {
        this.x = vector3dc.x();
        this.y = vector3dc.y();
        this.z = vector3dc.z();
        this.w = d;
        return this;
    }

    public Vector4d set(Vector3ic vector3ic, double d) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
        this.z = vector3ic.z();
        this.w = d;
        return this;
    }

    public Vector4d set(Vector3fc vector3fc, double d) {
        this.x = vector3fc.x();
        this.y = vector3fc.y();
        this.z = vector3fc.z();
        this.w = d;
        return this;
    }

    public Vector4d set(Vector2dc vector2dc, double d, double d2) {
        this.x = vector2dc.x();
        this.y = vector2dc.y();
        this.z = d;
        this.w = d2;
        return this;
    }

    public Vector4d set(Vector2ic vector2ic, double d, double d2) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = d;
        this.w = d2;
        return this;
    }

    public Vector4d set(double d) {
        this.x = d;
        this.y = d;
        this.z = d;
        this.w = d;
        return this;
    }

    public Vector4d set(Vector2fc vector2fc, double d, double d2) {
        this.x = vector2fc.x();
        this.y = vector2fc.y();
        this.z = d;
        this.w = d2;
        return this;
    }

    public Vector4d set(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
        return this;
    }

    public Vector4d set(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public Vector4d set(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
        this.w = dArray[3];
        return this;
    }

    public Vector4d set(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
        this.w = fArray[3];
        return this;
    }

    public Vector4d set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Vector4d set(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n, byteBuffer);
        return this;
    }

    public Vector4d set(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, doubleBuffer.position(), doubleBuffer);
        return this;
    }

    public Vector4d set(int n, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, n, doubleBuffer);
        return this;
    }

    public Vector4d setComponent(int n, double d) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                this.x = d;
                break;
            }
            case 1: {
                this.y = d;
                break;
            }
            case 2: {
                this.z = d;
                break;
            }
            case 3: {
                this.w = d;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    @Override
    public ByteBuffer get(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    @Override
    public ByteBuffer get(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public DoubleBuffer get(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put(this, doubleBuffer.position(), doubleBuffer);
        return doubleBuffer;
    }

    @Override
    public DoubleBuffer get(int n, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put(this, n, doubleBuffer);
        return doubleBuffer;
    }

    @Override
    public ByteBuffer getf(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putf(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    @Override
    public ByteBuffer getf(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putf(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public FloatBuffer get(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, floatBuffer.position(), floatBuffer);
        return floatBuffer;
    }

    @Override
    public FloatBuffer get(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, n, floatBuffer);
        return floatBuffer;
    }

    public Vector4d sub(Vector4dc vector4dc) {
        this.x -= vector4dc.x();
        this.y -= vector4dc.y();
        this.z -= vector4dc.z();
        this.w -= vector4dc.w();
        return this;
    }

    @Override
    public Vector4d sub(Vector4dc vector4dc, Vector4d vector4d) {
        vector4d.x = this.x - vector4dc.x();
        vector4d.y = this.y - vector4dc.y();
        vector4d.z = this.z - vector4dc.z();
        vector4d.w = this.w - vector4dc.w();
        return vector4d;
    }

    public Vector4d sub(Vector4fc vector4fc) {
        this.x -= (double)vector4fc.x();
        this.y -= (double)vector4fc.y();
        this.z -= (double)vector4fc.z();
        this.w -= (double)vector4fc.w();
        return this;
    }

    @Override
    public Vector4d sub(Vector4fc vector4fc, Vector4d vector4d) {
        vector4d.x = this.x - (double)vector4fc.x();
        vector4d.y = this.y - (double)vector4fc.y();
        vector4d.z = this.z - (double)vector4fc.z();
        vector4d.w = this.w - (double)vector4fc.w();
        return vector4d;
    }

    public Vector4d sub(double d, double d2, double d3, double d4) {
        this.x -= d;
        this.y -= d2;
        this.z -= d3;
        this.w -= d4;
        return this;
    }

    @Override
    public Vector4d sub(double d, double d2, double d3, double d4, Vector4d vector4d) {
        vector4d.x = this.x - d;
        vector4d.y = this.y - d2;
        vector4d.z = this.z - d3;
        vector4d.w = this.w - d4;
        return vector4d;
    }

    public Vector4d add(Vector4dc vector4dc) {
        this.x += vector4dc.x();
        this.y += vector4dc.y();
        this.z += vector4dc.z();
        this.w += vector4dc.w();
        return this;
    }

    @Override
    public Vector4d add(Vector4dc vector4dc, Vector4d vector4d) {
        vector4d.x = this.x + vector4dc.x();
        vector4d.y = this.y + vector4dc.y();
        vector4d.z = this.z + vector4dc.z();
        vector4d.w = this.w + vector4dc.w();
        return vector4d;
    }

    @Override
    public Vector4d add(Vector4fc vector4fc, Vector4d vector4d) {
        vector4d.x = this.x + (double)vector4fc.x();
        vector4d.y = this.y + (double)vector4fc.y();
        vector4d.z = this.z + (double)vector4fc.z();
        vector4d.w = this.w + (double)vector4fc.w();
        return vector4d;
    }

    public Vector4d add(double d, double d2, double d3, double d4) {
        this.x += d;
        this.y += d2;
        this.z += d3;
        this.w += d4;
        return this;
    }

    @Override
    public Vector4d add(double d, double d2, double d3, double d4, Vector4d vector4d) {
        vector4d.x = this.x + d;
        vector4d.y = this.y + d2;
        vector4d.z = this.z + d3;
        vector4d.w = this.w + d4;
        return vector4d;
    }

    public Vector4d add(Vector4fc vector4fc) {
        this.x += (double)vector4fc.x();
        this.y += (double)vector4fc.y();
        this.z += (double)vector4fc.z();
        this.w += (double)vector4fc.w();
        return this;
    }

    public Vector4d fma(Vector4dc vector4dc, Vector4dc vector4dc2) {
        this.x = Math.fma(vector4dc.x(), vector4dc2.x(), this.x);
        this.y = Math.fma(vector4dc.y(), vector4dc2.y(), this.y);
        this.z = Math.fma(vector4dc.z(), vector4dc2.z(), this.z);
        this.w = Math.fma(vector4dc.w(), vector4dc2.w(), this.w);
        return this;
    }

    public Vector4d fma(double d, Vector4dc vector4dc) {
        this.x = Math.fma(d, vector4dc.x(), this.x);
        this.y = Math.fma(d, vector4dc.y(), this.y);
        this.z = Math.fma(d, vector4dc.z(), this.z);
        this.w = Math.fma(d, vector4dc.w(), this.w);
        return this;
    }

    @Override
    public Vector4d fma(Vector4dc vector4dc, Vector4dc vector4dc2, Vector4d vector4d) {
        vector4d.x = Math.fma(vector4dc.x(), vector4dc2.x(), this.x);
        vector4d.y = Math.fma(vector4dc.y(), vector4dc2.y(), this.y);
        vector4d.z = Math.fma(vector4dc.z(), vector4dc2.z(), this.z);
        vector4d.w = Math.fma(vector4dc.w(), vector4dc2.w(), this.w);
        return vector4d;
    }

    @Override
    public Vector4d fma(double d, Vector4dc vector4dc, Vector4d vector4d) {
        vector4d.x = Math.fma(d, vector4dc.x(), this.x);
        vector4d.y = Math.fma(d, vector4dc.y(), this.y);
        vector4d.z = Math.fma(d, vector4dc.z(), this.z);
        vector4d.w = Math.fma(d, vector4dc.w(), this.w);
        return vector4d;
    }

    public Vector4d mulAdd(Vector4dc vector4dc, Vector4dc vector4dc2) {
        this.x = Math.fma(this.x, vector4dc.x(), vector4dc2.x());
        this.y = Math.fma(this.y, vector4dc.y(), vector4dc2.y());
        this.z = Math.fma(this.z, vector4dc.z(), vector4dc2.z());
        return this;
    }

    public Vector4d mulAdd(double d, Vector4dc vector4dc) {
        this.x = Math.fma(this.x, d, vector4dc.x());
        this.y = Math.fma(this.y, d, vector4dc.y());
        this.z = Math.fma(this.z, d, vector4dc.z());
        return this;
    }

    @Override
    public Vector4d mulAdd(Vector4dc vector4dc, Vector4dc vector4dc2, Vector4d vector4d) {
        vector4d.x = Math.fma(this.x, vector4dc.x(), vector4dc2.x());
        vector4d.y = Math.fma(this.y, vector4dc.y(), vector4dc2.y());
        vector4d.z = Math.fma(this.z, vector4dc.z(), vector4dc2.z());
        return vector4d;
    }

    @Override
    public Vector4d mulAdd(double d, Vector4dc vector4dc, Vector4d vector4d) {
        vector4d.x = Math.fma(this.x, d, vector4dc.x());
        vector4d.y = Math.fma(this.y, d, vector4dc.y());
        vector4d.z = Math.fma(this.z, d, vector4dc.z());
        return vector4d;
    }

    public Vector4d mul(Vector4dc vector4dc) {
        this.x *= vector4dc.x();
        this.y *= vector4dc.y();
        this.z *= vector4dc.z();
        this.w *= vector4dc.w();
        return this;
    }

    @Override
    public Vector4d mul(Vector4dc vector4dc, Vector4d vector4d) {
        vector4d.x = this.x * vector4dc.x();
        vector4d.y = this.y * vector4dc.y();
        vector4d.z = this.z * vector4dc.z();
        vector4d.w = this.w * vector4dc.w();
        return vector4d;
    }

    public Vector4d div(Vector4dc vector4dc) {
        this.x /= vector4dc.x();
        this.y /= vector4dc.y();
        this.z /= vector4dc.z();
        this.w /= vector4dc.w();
        return this;
    }

    @Override
    public Vector4d div(Vector4dc vector4dc, Vector4d vector4d) {
        vector4d.x = this.x / vector4dc.x();
        vector4d.y = this.y / vector4dc.y();
        vector4d.z = this.z / vector4dc.z();
        vector4d.w = this.w / vector4dc.w();
        return vector4d;
    }

    public Vector4d mul(Vector4fc vector4fc) {
        this.x *= (double)vector4fc.x();
        this.y *= (double)vector4fc.y();
        this.z *= (double)vector4fc.z();
        this.w *= (double)vector4fc.w();
        return this;
    }

    @Override
    public Vector4d mul(Vector4fc vector4fc, Vector4d vector4d) {
        vector4d.x = this.x * (double)vector4fc.x();
        vector4d.y = this.y * (double)vector4fc.y();
        vector4d.z = this.z * (double)vector4fc.z();
        vector4d.w = this.w * (double)vector4fc.w();
        return vector4d;
    }

    public Vector4d mul(Matrix4dc matrix4dc) {
        if ((matrix4dc.properties() & 2) != 0) {
            return this.mulAffine(matrix4dc, this);
        }
        return this.mulGeneric(matrix4dc, this);
    }

    @Override
    public Vector4d mul(Matrix4dc matrix4dc, Vector4d vector4d) {
        if ((matrix4dc.properties() & 2) != 0) {
            return this.mulAffine(matrix4dc, vector4d);
        }
        return this.mulGeneric(matrix4dc, vector4d);
    }

    public Vector4d mulTranspose(Matrix4dc matrix4dc) {
        if ((matrix4dc.properties() & 2) != 0) {
            return this.mulAffineTranspose(matrix4dc, this);
        }
        return this.mulGenericTranspose(matrix4dc, this);
    }

    @Override
    public Vector4d mulTranspose(Matrix4dc matrix4dc, Vector4d vector4d) {
        if ((matrix4dc.properties() & 2) != 0) {
            return this.mulAffineTranspose(matrix4dc, vector4d);
        }
        return this.mulGenericTranspose(matrix4dc, vector4d);
    }

    @Override
    public Vector4d mulAffine(Matrix4dc matrix4dc, Vector4d vector4d) {
        double d = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m10(), this.y, Math.fma(matrix4dc.m20(), this.z, matrix4dc.m30() * this.w)));
        double d2 = Math.fma(matrix4dc.m01(), this.x, Math.fma(matrix4dc.m11(), this.y, Math.fma(matrix4dc.m21(), this.z, matrix4dc.m31() * this.w)));
        double d3 = Math.fma(matrix4dc.m02(), this.x, Math.fma(matrix4dc.m12(), this.y, Math.fma(matrix4dc.m22(), this.z, matrix4dc.m32() * this.w)));
        vector4d.x = d;
        vector4d.y = d2;
        vector4d.z = d3;
        vector4d.w = this.w;
        return vector4d;
    }

    private Vector4d mulGeneric(Matrix4dc matrix4dc, Vector4d vector4d) {
        double d = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m10(), this.y, Math.fma(matrix4dc.m20(), this.z, matrix4dc.m30() * this.w)));
        double d2 = Math.fma(matrix4dc.m01(), this.x, Math.fma(matrix4dc.m11(), this.y, Math.fma(matrix4dc.m21(), this.z, matrix4dc.m31() * this.w)));
        double d3 = Math.fma(matrix4dc.m02(), this.x, Math.fma(matrix4dc.m12(), this.y, Math.fma(matrix4dc.m22(), this.z, matrix4dc.m32() * this.w)));
        double d4 = Math.fma(matrix4dc.m03(), this.x, Math.fma(matrix4dc.m13(), this.y, Math.fma(matrix4dc.m23(), this.z, matrix4dc.m33() * this.w)));
        vector4d.x = d;
        vector4d.y = d2;
        vector4d.z = d3;
        vector4d.w = d4;
        return vector4d;
    }

    @Override
    public Vector4d mulAffineTranspose(Matrix4dc matrix4dc, Vector4d vector4d) {
        double d = this.x;
        double d2 = this.y;
        double d3 = this.z;
        double d4 = this.w;
        vector4d.x = Math.fma(matrix4dc.m00(), d, Math.fma(matrix4dc.m01(), d2, matrix4dc.m02() * d3));
        vector4d.y = Math.fma(matrix4dc.m10(), d, Math.fma(matrix4dc.m11(), d2, matrix4dc.m12() * d3));
        vector4d.z = Math.fma(matrix4dc.m20(), d, Math.fma(matrix4dc.m21(), d2, matrix4dc.m22() * d3));
        vector4d.w = Math.fma(matrix4dc.m30(), d, Math.fma(matrix4dc.m31(), d2, matrix4dc.m32() * d3 + d4));
        return vector4d;
    }

    private Vector4d mulGenericTranspose(Matrix4dc matrix4dc, Vector4d vector4d) {
        double d = this.x;
        double d2 = this.y;
        double d3 = this.z;
        double d4 = this.w;
        vector4d.x = Math.fma(matrix4dc.m00(), d, Math.fma(matrix4dc.m01(), d2, Math.fma(matrix4dc.m02(), d3, matrix4dc.m03() * d4)));
        vector4d.y = Math.fma(matrix4dc.m10(), d, Math.fma(matrix4dc.m11(), d2, Math.fma(matrix4dc.m12(), d3, matrix4dc.m13() * d4)));
        vector4d.z = Math.fma(matrix4dc.m20(), d, Math.fma(matrix4dc.m21(), d2, Math.fma(matrix4dc.m22(), d3, matrix4dc.m23() * d4)));
        vector4d.w = Math.fma(matrix4dc.m30(), d, Math.fma(matrix4dc.m31(), d2, Math.fma(matrix4dc.m32(), d3, matrix4dc.m33() * d4)));
        return vector4d;
    }

    public Vector4d mul(Matrix4x3dc matrix4x3dc) {
        double d = Math.fma(matrix4x3dc.m00(), this.x, Math.fma(matrix4x3dc.m10(), this.y, Math.fma(matrix4x3dc.m20(), this.z, matrix4x3dc.m30() * this.w)));
        double d2 = Math.fma(matrix4x3dc.m01(), this.x, Math.fma(matrix4x3dc.m11(), this.y, Math.fma(matrix4x3dc.m21(), this.z, matrix4x3dc.m31() * this.w)));
        double d3 = Math.fma(matrix4x3dc.m02(), this.x, Math.fma(matrix4x3dc.m12(), this.y, Math.fma(matrix4x3dc.m22(), this.z, matrix4x3dc.m32() * this.w)));
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    @Override
    public Vector4d mul(Matrix4x3dc matrix4x3dc, Vector4d vector4d) {
        double d = Math.fma(matrix4x3dc.m00(), this.x, Math.fma(matrix4x3dc.m10(), this.y, Math.fma(matrix4x3dc.m20(), this.z, matrix4x3dc.m30() * this.w)));
        double d2 = Math.fma(matrix4x3dc.m01(), this.x, Math.fma(matrix4x3dc.m11(), this.y, Math.fma(matrix4x3dc.m21(), this.z, matrix4x3dc.m31() * this.w)));
        double d3 = Math.fma(matrix4x3dc.m02(), this.x, Math.fma(matrix4x3dc.m12(), this.y, Math.fma(matrix4x3dc.m22(), this.z, matrix4x3dc.m32() * this.w)));
        vector4d.x = d;
        vector4d.y = d2;
        vector4d.z = d3;
        vector4d.w = this.w;
        return vector4d;
    }

    public Vector4d mul(Matrix4x3fc matrix4x3fc) {
        double d = Math.fma((double)matrix4x3fc.m00(), this.x, Math.fma((double)matrix4x3fc.m10(), this.y, Math.fma((double)matrix4x3fc.m20(), this.z, (double)matrix4x3fc.m30() * this.w)));
        double d2 = Math.fma((double)matrix4x3fc.m01(), this.x, Math.fma((double)matrix4x3fc.m11(), this.y, Math.fma((double)matrix4x3fc.m21(), this.z, (double)matrix4x3fc.m31() * this.w)));
        double d3 = Math.fma((double)matrix4x3fc.m02(), this.x, Math.fma((double)matrix4x3fc.m12(), this.y, Math.fma((double)matrix4x3fc.m22(), this.z, (double)matrix4x3fc.m32() * this.w)));
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    @Override
    public Vector4d mul(Matrix4x3fc matrix4x3fc, Vector4d vector4d) {
        double d = Math.fma((double)matrix4x3fc.m00(), this.x, Math.fma((double)matrix4x3fc.m10(), this.y, Math.fma((double)matrix4x3fc.m20(), this.z, (double)matrix4x3fc.m30() * this.w)));
        double d2 = Math.fma((double)matrix4x3fc.m01(), this.x, Math.fma((double)matrix4x3fc.m11(), this.y, Math.fma((double)matrix4x3fc.m21(), this.z, (double)matrix4x3fc.m31() * this.w)));
        double d3 = Math.fma((double)matrix4x3fc.m02(), this.x, Math.fma((double)matrix4x3fc.m12(), this.y, Math.fma((double)matrix4x3fc.m22(), this.z, (double)matrix4x3fc.m32() * this.w)));
        vector4d.x = d;
        vector4d.y = d2;
        vector4d.z = d3;
        vector4d.w = this.w;
        return vector4d;
    }

    public Vector4d mul(Matrix4fc matrix4fc) {
        if ((matrix4fc.properties() & 2) != 0) {
            return this.mulAffine(matrix4fc, this);
        }
        return this.mulGeneric(matrix4fc, this);
    }

    @Override
    public Vector4d mul(Matrix4fc matrix4fc, Vector4d vector4d) {
        if ((matrix4fc.properties() & 2) != 0) {
            return this.mulAffine(matrix4fc, vector4d);
        }
        return this.mulGeneric(matrix4fc, vector4d);
    }

    private Vector4d mulAffine(Matrix4fc matrix4fc, Vector4d vector4d) {
        double d = Math.fma((double)matrix4fc.m00(), this.x, Math.fma((double)matrix4fc.m10(), this.y, Math.fma((double)matrix4fc.m20(), this.z, (double)matrix4fc.m30() * this.w)));
        double d2 = Math.fma((double)matrix4fc.m01(), this.x, Math.fma((double)matrix4fc.m11(), this.y, Math.fma((double)matrix4fc.m21(), this.z, (double)matrix4fc.m31() * this.w)));
        double d3 = Math.fma((double)matrix4fc.m02(), this.x, Math.fma((double)matrix4fc.m12(), this.y, Math.fma((double)matrix4fc.m22(), this.z, (double)matrix4fc.m32() * this.w)));
        vector4d.x = d;
        vector4d.y = d2;
        vector4d.z = d3;
        vector4d.w = this.w;
        return vector4d;
    }

    private Vector4d mulGeneric(Matrix4fc matrix4fc, Vector4d vector4d) {
        double d = Math.fma((double)matrix4fc.m00(), this.x, Math.fma((double)matrix4fc.m10(), this.y, Math.fma((double)matrix4fc.m20(), this.z, (double)matrix4fc.m30() * this.w)));
        double d2 = Math.fma((double)matrix4fc.m01(), this.x, Math.fma((double)matrix4fc.m11(), this.y, Math.fma((double)matrix4fc.m21(), this.z, (double)matrix4fc.m31() * this.w)));
        double d3 = Math.fma((double)matrix4fc.m02(), this.x, Math.fma((double)matrix4fc.m12(), this.y, Math.fma((double)matrix4fc.m22(), this.z, (double)matrix4fc.m32() * this.w)));
        double d4 = Math.fma((double)matrix4fc.m03(), this.x, Math.fma((double)matrix4fc.m13(), this.y, Math.fma((double)matrix4fc.m23(), this.z, (double)matrix4fc.m33() * this.w)));
        vector4d.x = d;
        vector4d.y = d2;
        vector4d.z = d3;
        vector4d.w = d4;
        return vector4d;
    }

    @Override
    public Vector4d mulProject(Matrix4dc matrix4dc, Vector4d vector4d) {
        double d = 1.0 / Math.fma(matrix4dc.m03(), this.x, Math.fma(matrix4dc.m13(), this.y, Math.fma(matrix4dc.m23(), this.z, matrix4dc.m33() * this.w)));
        double d2 = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m10(), this.y, Math.fma(matrix4dc.m20(), this.z, matrix4dc.m30() * this.w))) * d;
        double d3 = Math.fma(matrix4dc.m01(), this.x, Math.fma(matrix4dc.m11(), this.y, Math.fma(matrix4dc.m21(), this.z, matrix4dc.m31() * this.w))) * d;
        double d4 = Math.fma(matrix4dc.m02(), this.x, Math.fma(matrix4dc.m12(), this.y, Math.fma(matrix4dc.m22(), this.z, matrix4dc.m32() * this.w))) * d;
        vector4d.x = d2;
        vector4d.y = d3;
        vector4d.z = d4;
        vector4d.w = 1.0;
        return vector4d;
    }

    public Vector4d mulProject(Matrix4dc matrix4dc) {
        double d = 1.0 / Math.fma(matrix4dc.m03(), this.x, Math.fma(matrix4dc.m13(), this.y, Math.fma(matrix4dc.m23(), this.z, matrix4dc.m33() * this.w)));
        double d2 = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m10(), this.y, Math.fma(matrix4dc.m20(), this.z, matrix4dc.m30() * this.w))) * d;
        double d3 = Math.fma(matrix4dc.m01(), this.x, Math.fma(matrix4dc.m11(), this.y, Math.fma(matrix4dc.m21(), this.z, matrix4dc.m31() * this.w))) * d;
        double d4 = Math.fma(matrix4dc.m02(), this.x, Math.fma(matrix4dc.m12(), this.y, Math.fma(matrix4dc.m22(), this.z, matrix4dc.m32() * this.w))) * d;
        this.x = d2;
        this.y = d3;
        this.z = d4;
        this.w = 1.0;
        return this;
    }

    @Override
    public Vector3d mulProject(Matrix4dc matrix4dc, Vector3d vector3d) {
        double d = 1.0 / Math.fma(matrix4dc.m03(), this.x, Math.fma(matrix4dc.m13(), this.y, Math.fma(matrix4dc.m23(), this.z, matrix4dc.m33() * this.w)));
        double d2 = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m10(), this.y, Math.fma(matrix4dc.m20(), this.z, matrix4dc.m30() * this.w))) * d;
        double d3 = Math.fma(matrix4dc.m01(), this.x, Math.fma(matrix4dc.m11(), this.y, Math.fma(matrix4dc.m21(), this.z, matrix4dc.m31() * this.w))) * d;
        double d4 = Math.fma(matrix4dc.m02(), this.x, Math.fma(matrix4dc.m12(), this.y, Math.fma(matrix4dc.m22(), this.z, matrix4dc.m32() * this.w))) * d;
        vector3d.x = d2;
        vector3d.y = d3;
        vector3d.z = d4;
        return vector3d;
    }

    public Vector4d mul(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
        this.w *= d;
        return this;
    }

    @Override
    public Vector4d mul(double d, Vector4d vector4d) {
        vector4d.x = this.x * d;
        vector4d.y = this.y * d;
        vector4d.z = this.z * d;
        vector4d.w = this.w * d;
        return vector4d;
    }

    public Vector4d div(double d) {
        double d2 = 1.0 / d;
        this.x *= d2;
        this.y *= d2;
        this.z *= d2;
        this.w *= d2;
        return this;
    }

    @Override
    public Vector4d div(double d, Vector4d vector4d) {
        double d2 = 1.0 / d;
        vector4d.x = this.x * d2;
        vector4d.y = this.y * d2;
        vector4d.z = this.z * d2;
        vector4d.w = this.w * d2;
        return vector4d;
    }

    public Vector4d rotate(Quaterniondc quaterniondc) {
        quaterniondc.transform(this, this);
        return this;
    }

    @Override
    public Vector4d rotate(Quaterniondc quaterniondc, Vector4d vector4d) {
        quaterniondc.transform(this, vector4d);
        return vector4d;
    }

    public Vector4d rotateAxis(double d, double d2, double d3, double d4) {
        if (d3 == 0.0 && d4 == 0.0 && Math.absEqualsOne(d2)) {
            return this.rotateX(d2 * d, this);
        }
        if (d2 == 0.0 && d4 == 0.0 && Math.absEqualsOne(d3)) {
            return this.rotateY(d3 * d, this);
        }
        if (d2 == 0.0 && d3 == 0.0 && Math.absEqualsOne(d4)) {
            return this.rotateZ(d4 * d, this);
        }
        return this.rotateAxisInternal(d, d2, d3, d4, this);
    }

    @Override
    public Vector4d rotateAxis(double d, double d2, double d3, double d4, Vector4d vector4d) {
        if (d3 == 0.0 && d4 == 0.0 && Math.absEqualsOne(d2)) {
            return this.rotateX(d2 * d, vector4d);
        }
        if (d2 == 0.0 && d4 == 0.0 && Math.absEqualsOne(d3)) {
            return this.rotateY(d3 * d, vector4d);
        }
        if (d2 == 0.0 && d3 == 0.0 && Math.absEqualsOne(d4)) {
            return this.rotateZ(d4 * d, vector4d);
        }
        return this.rotateAxisInternal(d, d2, d3, d4, vector4d);
    }

    private Vector4d rotateAxisInternal(double d, double d2, double d3, double d4, Vector4d vector4d) {
        double d5 = d * 0.5;
        double d6 = Math.sin(d5);
        double d7 = d2 * d6;
        double d8 = d3 * d6;
        double d9 = d4 * d6;
        double d10 = Math.cosFromSin(d6, d5);
        double d11 = d10 * d10;
        double d12 = d7 * d7;
        double d13 = d8 * d8;
        double d14 = d9 * d9;
        double d15 = d9 * d10;
        double d16 = d7 * d8;
        double d17 = d7 * d9;
        double d18 = d8 * d10;
        double d19 = d8 * d9;
        double d20 = d7 * d10;
        double d21 = (d11 + d12 - d14 - d13) * this.x + (-d15 + d16 - d15 + d16) * this.y + (d18 + d17 + d17 + d18) * this.z;
        double d22 = (d16 + d15 + d15 + d16) * this.x + (d13 - d14 + d11 - d12) * this.y + (d19 + d19 - d20 - d20) * this.z;
        double d23 = (d17 - d18 + d17 - d18) * this.x + (d19 + d19 + d20 + d20) * this.y + (d14 - d13 - d12 + d11) * this.z;
        vector4d.x = d21;
        vector4d.y = d22;
        vector4d.z = d23;
        return vector4d;
    }

    public Vector4d rotateX(double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cosFromSin(d2, d);
        double d4 = this.y * d3 - this.z * d2;
        double d5 = this.y * d2 + this.z * d3;
        this.y = d4;
        this.z = d5;
        return this;
    }

    @Override
    public Vector4d rotateX(double d, Vector4d vector4d) {
        double d2 = Math.sin(d);
        double d3 = Math.cosFromSin(d2, d);
        double d4 = this.y * d3 - this.z * d2;
        double d5 = this.y * d2 + this.z * d3;
        vector4d.x = this.x;
        vector4d.y = d4;
        vector4d.z = d5;
        vector4d.w = this.w;
        return vector4d;
    }

    public Vector4d rotateY(double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cosFromSin(d2, d);
        double d4 = this.x * d3 + this.z * d2;
        double d5 = -this.x * d2 + this.z * d3;
        this.x = d4;
        this.z = d5;
        return this;
    }

    @Override
    public Vector4d rotateY(double d, Vector4d vector4d) {
        double d2 = Math.sin(d);
        double d3 = Math.cosFromSin(d2, d);
        double d4 = this.x * d3 + this.z * d2;
        double d5 = -this.x * d2 + this.z * d3;
        vector4d.x = d4;
        vector4d.y = this.y;
        vector4d.z = d5;
        vector4d.w = this.w;
        return vector4d;
    }

    public Vector4d rotateZ(double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cosFromSin(d2, d);
        double d4 = this.x * d3 - this.y * d2;
        double d5 = this.x * d2 + this.y * d3;
        this.x = d4;
        this.y = d5;
        return this;
    }

    @Override
    public Vector4d rotateZ(double d, Vector4d vector4d) {
        double d2 = Math.sin(d);
        double d3 = Math.cosFromSin(d2, d);
        double d4 = this.x * d3 - this.y * d2;
        double d5 = this.x * d2 + this.y * d3;
        vector4d.x = d4;
        vector4d.y = d5;
        vector4d.z = this.z;
        vector4d.w = this.w;
        return vector4d;
    }

    @Override
    public double lengthSquared() {
        return Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
    }

    public static double lengthSquared(double d, double d2, double d3, double d4) {
        return Math.fma(d, d, Math.fma(d2, d2, Math.fma(d3, d3, d4 * d4)));
    }

    @Override
    public double length() {
        return Math.sqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w))));
    }

    public static double length(double d, double d2, double d3, double d4) {
        return Math.sqrt(Math.fma(d, d, Math.fma(d2, d2, Math.fma(d3, d3, d4 * d4))));
    }

    public Vector4d normalize() {
        double d = 1.0 / this.length();
        this.x *= d;
        this.y *= d;
        this.z *= d;
        this.w *= d;
        return this;
    }

    @Override
    public Vector4d normalize(Vector4d vector4d) {
        double d = 1.0 / this.length();
        vector4d.x = this.x * d;
        vector4d.y = this.y * d;
        vector4d.z = this.z * d;
        vector4d.w = this.w * d;
        return vector4d;
    }

    public Vector4d normalize(double d) {
        double d2 = 1.0 / this.length() * d;
        this.x *= d2;
        this.y *= d2;
        this.z *= d2;
        this.w *= d2;
        return this;
    }

    @Override
    public Vector4d normalize(double d, Vector4d vector4d) {
        double d2 = 1.0 / this.length() * d;
        vector4d.x = this.x * d2;
        vector4d.y = this.y * d2;
        vector4d.z = this.z * d2;
        vector4d.w = this.w * d2;
        return vector4d;
    }

    public Vector4d normalize3() {
        double d = Math.invsqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z)));
        this.x *= d;
        this.y *= d;
        this.z *= d;
        this.w *= d;
        return this;
    }

    @Override
    public Vector4d normalize3(Vector4d vector4d) {
        double d = Math.invsqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z)));
        vector4d.x = this.x * d;
        vector4d.y = this.y * d;
        vector4d.z = this.z * d;
        vector4d.w = this.w * d;
        return vector4d;
    }

    @Override
    public double distance(Vector4dc vector4dc) {
        double d = this.x - vector4dc.x();
        double d2 = this.y - vector4dc.y();
        double d3 = this.z - vector4dc.z();
        double d4 = this.w - vector4dc.w();
        return Math.sqrt(Math.fma(d, d, Math.fma(d2, d2, Math.fma(d3, d3, d4 * d4))));
    }

    @Override
    public double distance(double d, double d2, double d3, double d4) {
        double d5 = this.x - d;
        double d6 = this.y - d2;
        double d7 = this.z - d3;
        double d8 = this.w - d4;
        return Math.sqrt(Math.fma(d5, d5, Math.fma(d6, d6, Math.fma(d7, d7, d8 * d8))));
    }

    @Override
    public double distanceSquared(Vector4dc vector4dc) {
        double d = this.x - vector4dc.x();
        double d2 = this.y - vector4dc.y();
        double d3 = this.z - vector4dc.z();
        double d4 = this.w - vector4dc.w();
        return Math.fma(d, d, Math.fma(d2, d2, Math.fma(d3, d3, d4 * d4)));
    }

    @Override
    public double distanceSquared(double d, double d2, double d3, double d4) {
        double d5 = this.x - d;
        double d6 = this.y - d2;
        double d7 = this.z - d3;
        double d8 = this.w - d4;
        return Math.fma(d5, d5, Math.fma(d6, d6, Math.fma(d7, d7, d8 * d8)));
    }

    public static double distance(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = d - d5;
        double d10 = d2 - d6;
        double d11 = d3 - d7;
        double d12 = d4 - d8;
        return Math.sqrt(Math.fma(d9, d9, Math.fma(d10, d10, Math.fma(d11, d11, d12 * d12))));
    }

    public static double distanceSquared(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = d - d5;
        double d10 = d2 - d6;
        double d11 = d3 - d7;
        double d12 = d4 - d8;
        return Math.fma(d9, d9, Math.fma(d10, d10, Math.fma(d11, d11, d12 * d12)));
    }

    @Override
    public double dot(Vector4dc vector4dc) {
        return Math.fma(this.x, vector4dc.x(), Math.fma(this.y, vector4dc.y(), Math.fma(this.z, vector4dc.z(), this.w * vector4dc.w())));
    }

    @Override
    public double dot(double d, double d2, double d3, double d4) {
        return Math.fma(this.x, d, Math.fma(this.y, d2, Math.fma(this.z, d3, this.w * d4)));
    }

    @Override
    public double angleCos(Vector4dc vector4dc) {
        double d = Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        double d2 = Math.fma(vector4dc.x(), vector4dc.x(), Math.fma(vector4dc.y(), vector4dc.y(), Math.fma(vector4dc.z(), vector4dc.z(), vector4dc.w() * vector4dc.w())));
        double d3 = Math.fma(this.x, vector4dc.x(), Math.fma(this.y, vector4dc.y(), Math.fma(this.z, vector4dc.z(), this.w * vector4dc.w())));
        return d3 / Math.sqrt(d * d2);
    }

    @Override
    public double angle(Vector4dc vector4dc) {
        double d = this.angleCos(vector4dc);
        d = d < 1.0 ? d : 1.0;
        d = d > -1.0 ? d : -1.0;
        return Math.acos(d);
    }

    public Vector4d zero() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.w = 0.0;
        return this;
    }

    public Vector4d negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
        return this;
    }

    @Override
    public Vector4d negate(Vector4d vector4d) {
        vector4d.x = -this.x;
        vector4d.y = -this.y;
        vector4d.z = -this.z;
        vector4d.w = -this.w;
        return vector4d;
    }

    public Vector4d min(Vector4dc vector4dc) {
        this.x = this.x < vector4dc.x() ? this.x : vector4dc.x();
        this.y = this.y < vector4dc.y() ? this.y : vector4dc.y();
        this.z = this.z < vector4dc.z() ? this.z : vector4dc.z();
        this.w = this.w < vector4dc.w() ? this.w : vector4dc.w();
        return this;
    }

    @Override
    public Vector4d min(Vector4dc vector4dc, Vector4d vector4d) {
        vector4d.x = this.x < vector4dc.x() ? this.x : vector4dc.x();
        vector4d.y = this.y < vector4dc.y() ? this.y : vector4dc.y();
        vector4d.z = this.z < vector4dc.z() ? this.z : vector4dc.z();
        vector4d.w = this.w < vector4dc.w() ? this.w : vector4dc.w();
        return vector4d;
    }

    public Vector4d max(Vector4dc vector4dc) {
        this.x = this.x > vector4dc.x() ? this.x : vector4dc.x();
        this.y = this.y > vector4dc.y() ? this.y : vector4dc.y();
        this.z = this.z > vector4dc.z() ? this.z : vector4dc.z();
        this.w = this.w > vector4dc.w() ? this.w : vector4dc.w();
        return this;
    }

    @Override
    public Vector4d max(Vector4dc vector4dc, Vector4d vector4d) {
        vector4d.x = this.x > vector4dc.x() ? this.x : vector4dc.x();
        vector4d.y = this.y > vector4dc.y() ? this.y : vector4dc.y();
        vector4d.z = this.z > vector4dc.z() ? this.z : vector4dc.z();
        vector4d.w = this.w > vector4dc.w() ? this.w : vector4dc.w();
        return vector4d;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + Runtime.format(this.x, numberFormat) + " " + Runtime.format(this.y, numberFormat) + " " + Runtime.format(this.z, numberFormat) + " " + Runtime.format(this.w, numberFormat) + ")";
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeDouble(this.x);
        objectOutput.writeDouble(this.y);
        objectOutput.writeDouble(this.z);
        objectOutput.writeDouble(this.w);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.x = objectInput.readDouble();
        this.y = objectInput.readDouble();
        this.z = objectInput.readDouble();
        this.w = objectInput.readDouble();
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.w);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.x);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.y);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.z);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Vector4d vector4d = (Vector4d)object;
        if (Double.doubleToLongBits(this.w) != Double.doubleToLongBits(vector4d.w)) {
            return false;
        }
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(vector4d.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(vector4d.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(vector4d.z);
    }

    @Override
    public boolean equals(Vector4dc vector4dc, double d) {
        if (this == vector4dc) {
            return true;
        }
        if (vector4dc == null) {
            return false;
        }
        if (!(vector4dc instanceof Vector4dc)) {
            return false;
        }
        if (!Runtime.equals(this.x, vector4dc.x(), d)) {
            return false;
        }
        if (!Runtime.equals(this.y, vector4dc.y(), d)) {
            return false;
        }
        if (!Runtime.equals(this.z, vector4dc.z(), d)) {
            return false;
        }
        return Runtime.equals(this.w, vector4dc.w(), d);
    }

    @Override
    public boolean equals(double d, double d2, double d3, double d4) {
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(d)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(d2)) {
            return false;
        }
        if (Double.doubleToLongBits(this.z) != Double.doubleToLongBits(d3)) {
            return false;
        }
        return Double.doubleToLongBits(this.w) == Double.doubleToLongBits(d4);
    }

    @Override
    public Vector4d smoothStep(Vector4dc vector4dc, double d, Vector4d vector4d) {
        double d2 = d * d;
        double d3 = d2 * d;
        vector4d.x = (this.x + this.x - vector4dc.x() - vector4dc.x()) * d3 + (3.0 * vector4dc.x() - 3.0 * this.x) * d2 + this.x * d + this.x;
        vector4d.y = (this.y + this.y - vector4dc.y() - vector4dc.y()) * d3 + (3.0 * vector4dc.y() - 3.0 * this.y) * d2 + this.y * d + this.y;
        vector4d.z = (this.z + this.z - vector4dc.z() - vector4dc.z()) * d3 + (3.0 * vector4dc.z() - 3.0 * this.z) * d2 + this.z * d + this.z;
        vector4d.w = (this.w + this.w - vector4dc.w() - vector4dc.w()) * d3 + (3.0 * vector4dc.w() - 3.0 * this.w) * d2 + this.w * d + this.w;
        return vector4d;
    }

    @Override
    public Vector4d hermite(Vector4dc vector4dc, Vector4dc vector4dc2, Vector4dc vector4dc3, double d, Vector4d vector4d) {
        double d2 = d * d;
        double d3 = d2 * d;
        vector4d.x = (this.x + this.x - vector4dc2.x() - vector4dc2.x() + vector4dc3.x() + vector4dc.x()) * d3 + (3.0 * vector4dc2.x() - 3.0 * this.x - vector4dc.x() - vector4dc.x() - vector4dc3.x()) * d2 + this.x * d + this.x;
        vector4d.y = (this.y + this.y - vector4dc2.y() - vector4dc2.y() + vector4dc3.y() + vector4dc.y()) * d3 + (3.0 * vector4dc2.y() - 3.0 * this.y - vector4dc.y() - vector4dc.y() - vector4dc3.y()) * d2 + this.y * d + this.y;
        vector4d.z = (this.z + this.z - vector4dc2.z() - vector4dc2.z() + vector4dc3.z() + vector4dc.z()) * d3 + (3.0 * vector4dc2.z() - 3.0 * this.z - vector4dc.z() - vector4dc.z() - vector4dc3.z()) * d2 + this.z * d + this.z;
        vector4d.w = (this.w + this.w - vector4dc2.w() - vector4dc2.w() + vector4dc3.w() + vector4dc.w()) * d3 + (3.0 * vector4dc2.w() - 3.0 * this.w - vector4dc.w() - vector4dc.w() - vector4dc3.w()) * d2 + this.w * d + this.w;
        return vector4d;
    }

    public Vector4d lerp(Vector4dc vector4dc, double d) {
        this.x = Math.fma(vector4dc.x() - this.x, d, this.x);
        this.y = Math.fma(vector4dc.y() - this.y, d, this.y);
        this.z = Math.fma(vector4dc.z() - this.z, d, this.z);
        this.w = Math.fma(vector4dc.w() - this.w, d, this.w);
        return this;
    }

    @Override
    public Vector4d lerp(Vector4dc vector4dc, double d, Vector4d vector4d) {
        vector4d.x = Math.fma(vector4dc.x() - this.x, d, this.x);
        vector4d.y = Math.fma(vector4dc.y() - this.y, d, this.y);
        vector4d.z = Math.fma(vector4dc.z() - this.z, d, this.z);
        vector4d.w = Math.fma(vector4dc.w() - this.w, d, this.w);
        return vector4d;
    }

    @Override
    public double get(int n) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Vector4i get(int n, Vector4i vector4i) {
        vector4i.x = Math.roundUsing(this.x(), n);
        vector4i.y = Math.roundUsing(this.y(), n);
        vector4i.z = Math.roundUsing(this.z(), n);
        vector4i.w = Math.roundUsing(this.w(), n);
        return vector4i;
    }

    @Override
    public Vector4f get(Vector4f vector4f) {
        vector4f.x = (float)this.x();
        vector4f.y = (float)this.y();
        vector4f.z = (float)this.z();
        vector4f.w = (float)this.w();
        return vector4f;
    }

    @Override
    public Vector4d get(Vector4d vector4d) {
        vector4d.x = this.x();
        vector4d.y = this.y();
        vector4d.z = this.z();
        vector4d.w = this.w();
        return vector4d;
    }

    @Override
    public int maxComponent() {
        double d = Math.abs(this.x);
        double d2 = Math.abs(this.y);
        double d3 = Math.abs(this.z);
        double d4 = Math.abs(this.w);
        if (d >= d2 && d >= d3 && d >= d4) {
            return 0;
        }
        if (d2 >= d3 && d2 >= d4) {
            return 1;
        }
        if (d3 >= d4) {
            return 2;
        }
        return 3;
    }

    @Override
    public int minComponent() {
        double d = Math.abs(this.x);
        double d2 = Math.abs(this.y);
        double d3 = Math.abs(this.z);
        double d4 = Math.abs(this.w);
        if (d < d2 && d < d3 && d < d4) {
            return 0;
        }
        if (d2 < d3 && d2 < d4) {
            return 1;
        }
        if (d3 < d4) {
            return 2;
        }
        return 3;
    }

    public Vector4d floor() {
        this.x = Math.floor(this.x);
        this.y = Math.floor(this.y);
        this.z = Math.floor(this.z);
        this.w = Math.floor(this.w);
        return this;
    }

    @Override
    public Vector4d floor(Vector4d vector4d) {
        vector4d.x = Math.floor(this.x);
        vector4d.y = Math.floor(this.y);
        vector4d.z = Math.floor(this.z);
        vector4d.w = Math.floor(this.w);
        return vector4d;
    }

    public Vector4d ceil() {
        this.x = Math.ceil(this.x);
        this.y = Math.ceil(this.y);
        this.z = Math.ceil(this.z);
        this.w = Math.ceil(this.w);
        return this;
    }

    @Override
    public Vector4d ceil(Vector4d vector4d) {
        vector4d.x = Math.ceil(this.x);
        vector4d.y = Math.ceil(this.y);
        vector4d.z = Math.ceil(this.z);
        vector4d.w = Math.ceil(this.w);
        return vector4d;
    }

    public Vector4d round() {
        this.x = Math.round(this.x);
        this.y = Math.round(this.y);
        this.z = Math.round(this.z);
        this.w = Math.round(this.w);
        return this;
    }

    @Override
    public Vector4d round(Vector4d vector4d) {
        vector4d.x = Math.round(this.x);
        vector4d.y = Math.round(this.y);
        vector4d.z = Math.round(this.z);
        vector4d.w = Math.round(this.w);
        return vector4d;
    }

    @Override
    public boolean isFinite() {
        return Math.isFinite(this.x) && Math.isFinite(this.y) && Math.isFinite(this.z) && Math.isFinite(this.w);
    }

    public Vector4d absolute() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        this.z = Math.abs(this.z);
        this.w = Math.abs(this.w);
        return this;
    }

    @Override
    public Vector4d absolute(Vector4d vector4d) {
        vector4d.x = Math.abs(this.x);
        vector4d.y = Math.abs(this.y);
        vector4d.z = Math.abs(this.z);
        vector4d.w = Math.abs(this.w);
        return vector4d;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

