/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.favorites;

import java.util.List;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.AbstractRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1162;
import net.minecraft.class_156;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class CompoundFavoriteRenderer
extends AbstractRenderer {
    protected NumberAnimator<Double> offset = ValueAnimator.ofDouble();
    protected Rectangle scissorArea = new Rectangle();
    protected long nextSwitch = -1L;
    protected IntFunction<Renderer> renderers;
    protected int count;
    protected boolean showcase;
    protected IntSupplier supplier;

    public CompoundFavoriteRenderer(List<Renderer> renderers) {
        this(true, renderers, null);
    }

    public CompoundFavoriteRenderer(List<Renderer> renderers, IntSupplier supplier) {
        this(false, renderers, supplier);
    }

    protected CompoundFavoriteRenderer(boolean showcase, List<Renderer> renderers, IntSupplier supplier) {
        this(showcase, renderers.size(), renderers::get, supplier);
    }

    public CompoundFavoriteRenderer(int count, IntFunction<Renderer> renderers) {
        this(true, count, renderers, null);
    }

    public CompoundFavoriteRenderer(int count, IntFunction<Renderer> renderers, IntSupplier supplier) {
        this(false, count, renderers, supplier);
    }

    public CompoundFavoriteRenderer(boolean showcase, int count, IntFunction<Renderer> renderers, IntSupplier supplier) {
        this.count = count;
        this.showcase = showcase;
        this.renderers = renderers;
        this.supplier = supplier;
    }

    @Override
    public void render(class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
        this.updateAnimator(delta);
        class_1162 vector4f = new class_1162((float)bounds.x, (float)bounds.y, 0.0f, 1.0f);
        vector4f.method_22674(matrices.method_23760().method_23761());
        class_1162 vector4f2 = new class_1162((float)bounds.getMaxX(), (float)bounds.getMaxY(), 0.0f, 1.0f);
        vector4f2.method_22674(matrices.method_23760().method_23761());
        this.scissorArea.setBounds((int)vector4f.method_4953(), (int)vector4f.method_4956(), (int)vector4f2.method_4953() - (int)vector4f.method_4953(), (int)vector4f2.method_4956() - (int)vector4f.method_4956());
        ScissorsHandler.INSTANCE.scissor(this.scissorArea);
        matrices.method_22903();
        matrices.method_22904(0.0, (double)(this.offset.floatValue() * (float)(-bounds.getHeight())), 0.0);
        for (int i = 0; i < this.count; ++i) {
            this.renderers.apply(i).render(matrices, bounds, mouseX, mouseY, delta);
            matrices.method_22904(0.0, (double)bounds.height, 0.0);
        }
        matrices.method_22909();
        ScissorsHandler.INSTANCE.removeLastScissor();
    }

    private void updateAnimator(float delta) {
        this.offset.update((double)delta);
        if (this.showcase) {
            if (this.nextSwitch == -1L) {
                this.nextSwitch = class_156.method_658();
            }
            if (class_156.method_658() - this.nextSwitch > 1000L) {
                this.nextSwitch = class_156.method_658();
                this.offset.setTo((((Double)this.offset.target()).intValue() + 1) % this.count, ConfigObject.getInstance().isReducedMotion() ? 0L : 500L);
            }
        } else {
            this.offset.setTo(this.supplier.getAsInt() % this.count, ConfigObject.getInstance().isReducedMotion() ? 0L : 500L);
        }
    }
}

