/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Jankson;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonElement;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonNull;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonObject;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonPrimitive;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.api.DeserializationException;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.Modifier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.addon.ConfigAddonRegistry;
import me.shedaniel.rei.api.client.config.entry.EntryStackProvider;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleType;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleTypeRegistry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.gui.config.CheatingMode;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.config.FavoritesConfigManager;
import me.shedaniel.rei.impl.client.config.addon.ConfigAddonRegistryImpl;
import me.shedaniel.rei.impl.client.config.collapsible.CollapsibleConfigManager;
import me.shedaniel.rei.impl.client.config.entries.ConfigAddonsEntry;
import me.shedaniel.rei.impl.client.gui.config.REIConfigScreen;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1269;
import net.minecraft.class_151;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public class ConfigManagerImpl
implements ConfigManager {
    private boolean craftableOnly = false;
    private final Gson gson = new GsonBuilder().create();
    private ConfigObjectImpl object;

    public ConfigManagerImpl() {
        AutoConfig.register(ConfigObjectImpl.class, (definition, configClass) -> new JanksonConfigSerializer(definition, configClass, ConfigManagerImpl.buildJankson(Jankson.builder())));
        InternalLogger.getInstance().info("Config loaded");
        this.saveConfig();
        FavoritesConfigManager.getInstance().syncFrom(this);
        CollapsibleConfigManager.getInstance().syncFrom(this);
    }

    public static Jankson buildJankson(Jankson.Builder builder) {
        builder.registerSerializer(class_2960.class, (location, marshaller) -> new JsonPrimitive((Object)(location == null ? null : location.toString())));
        builder.registerDeserializer(String.class, class_2960.class, (value, marshaller) -> value == null ? null : new class_2960(value));
        builder.registerSerializer(CheatingMode.class, (value, marshaller) -> {
            if (value == CheatingMode.WHEN_CREATIVE) {
                return new JsonPrimitive((Object)"WHEN_CREATIVE");
            }
            return new JsonPrimitive((Object)(value == CheatingMode.ON ? 1 : 0));
        });
        builder.registerDeserializer(Boolean.class, CheatingMode.class, (value, unmarshaller) -> value != false ? CheatingMode.ON : CheatingMode.OFF);
        builder.registerDeserializer(String.class, CheatingMode.class, (value, unmarshaller) -> CheatingMode.valueOf(value.toUpperCase(Locale.ROOT)));
        builder.registerSerializer(class_3675.class_306.class, (value, marshaller) -> new JsonPrimitive((Object)value.method_1441()));
        builder.registerDeserializer(String.class, class_3675.class_306.class, (value, marshaller) -> class_3675.method_15981((String)value));
        builder.registerSerializer(ModifierKeyCode.class, (value, marshaller) -> {
            JsonObject object = new JsonObject();
            object.put("keyCode", (JsonElement)new JsonPrimitive((Object)value.getKeyCode().method_1441()));
            object.put("modifier", (JsonElement)new JsonPrimitive((Object)value.getModifier().getValue()));
            return object;
        });
        builder.registerDeserializer(JsonObject.class, ModifierKeyCode.class, (value, marshaller) -> {
            String code = (String)value.get(String.class, "keyCode");
            if (code.endsWith(".unknown")) {
                return ModifierKeyCode.unknown();
            }
            class_3675.class_306 keyCode = class_3675.method_15981((String)code);
            Modifier modifier = Modifier.of((short)value.getShort("modifier", (short)0));
            return ModifierKeyCode.of((class_3675.class_306)keyCode, (Modifier)modifier);
        });
        builder.registerSerializer(class_2520.class, (value, marshaller) -> marshaller.serialize((Object)value.toString()));
        builder.registerDeserializer(String.class, class_2520.class, (value, marshaller) -> {
            try {
                return class_2522.method_10718((String)value);
            }
            catch (CommandSyntaxException e) {
                throw new DeserializationException((Throwable)e);
            }
        });
        builder.registerSerializer(class_2487.class, (value, marshaller) -> marshaller.serialize((Object)value.toString()));
        builder.registerDeserializer(String.class, class_2487.class, (value, marshaller) -> {
            try {
                return class_2522.method_10718((String)value);
            }
            catch (CommandSyntaxException e) {
                throw new DeserializationException((Throwable)e);
            }
        });
        builder.registerSerializer(EntryStackProvider.class, (stack, marshaller) -> {
            try {
                return marshaller.serialize((Object)stack.save());
            }
            catch (Exception e) {
                e.printStackTrace();
                return JsonNull.INSTANCE;
            }
        });
        builder.registerDeserializer(class_2520.class, EntryStackProvider.class, (value, marshaller) -> EntryStackProvider.defer((class_2487)value));
        builder.registerDeserializer(String.class, EntryStackProvider.class, (value, marshaller) -> {
            try {
                return EntryStackProvider.defer(class_2522.method_10718((String)value));
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
                return EntryStackProvider.ofStack(EntryStack.empty());
            }
        });
        builder.registerSerializer(FilteringRule.class, (value, marshaller) -> {
            try {
                return marshaller.serialize((Object)FilteringRuleType.save(value, new class_2487()));
            }
            catch (Exception e) {
                e.printStackTrace();
                return JsonNull.INSTANCE;
            }
        });
        builder.registerDeserializer(class_2520.class, FilteringRule.class, (value, marshaller) -> {
            try {
                return FilteringRuleType.read((class_2487)value);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
        builder.registerDeserializer(String.class, FilteringRule.class, (value, marshaller) -> {
            try {
                return FilteringRuleType.read(class_2522.method_10718((String)value));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
        builder.registerSerializer(FavoriteEntry.class, (value, marshaller) -> {
            try {
                return marshaller.serialize((Object)value.save(new class_2487()));
            }
            catch (Exception e) {
                e.printStackTrace();
                return JsonNull.INSTANCE;
            }
        });
        builder.registerDeserializer(class_2520.class, FavoriteEntry.class, (value, marshaller) -> FavoriteEntry.readDelegated((class_2487)value));
        builder.registerDeserializer(String.class, FavoriteEntry.class, (value, marshaller) -> {
            try {
                class_2487 tag = class_2522.method_10718((String)value);
                return FavoriteEntry.readDelegated(tag);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
        builder.registerSerializer(CategoryIdentifier.class, (value, marshaller) -> marshaller.serialize((Object)value.toString()));
        builder.registerDeserializer(String.class, CategoryIdentifier.class, (value, marshaller) -> {
            try {
                return CategoryIdentifier.of(value);
            }
            catch (class_151 e) {
                throw new DeserializationException((Throwable)e);
            }
        });
        return builder.build();
    }

    @Override
    public void startReload() {
    }

    public static ConfigManagerImpl getInstance() {
        return (ConfigManagerImpl)ConfigManager.getInstance();
    }

    @Override
    public void saveConfig() {
        for (FilteringRuleType type : FilteringRuleTypeRegistry.getInstance()) {
            if (!type.isSingular() || !this.getConfig().getFilteringRules().stream().noneMatch(filteringRule -> filteringRule.getType().equals(type))) continue;
            this.getConfig().getFilteringRules().add((FilteringRule<?>)type.createNew());
        }
        AutoConfig.getConfigHolder(ConfigObjectImpl.class).registerLoadListener((configHolder, configObject) -> {
            this.object = configObject;
            return class_1269.field_5811;
        });
        AutoConfig.getConfigHolder(ConfigObjectImpl.class).save();
        FavoritesConfigManager.getInstance().saveConfig();
        InternalLogger.getInstance().debug("Config saved");
    }

    @Override
    public ConfigObjectImpl getConfig() {
        if (this.object == null) {
            this.object = (ConfigObjectImpl)AutoConfig.getConfigHolder(ConfigObjectImpl.class).getConfig();
        }
        return this.object;
    }

    @Override
    public boolean isCraftableOnlyEnabled() {
        return this.craftableOnly && this.getConfig().isCraftableFilterEnabled();
    }

    @Override
    public void toggleCraftableOnly() {
        this.craftableOnly = !this.craftableOnly;
    }

    @Override
    public class_437 getConfigScreen(class_437 parent) {
        return new REIConfigScreen(parent);
    }

    private static /* synthetic */ class_437 lambda$getConfigScreen$27(ConfigBuilder builder) {
        ConfigAddonRegistryImpl addonRegistry = (ConfigAddonRegistryImpl)ConfigAddonRegistry.getInstance();
        if (!addonRegistry.getAddons().isEmpty()) {
            builder.getOrCreateCategory((class_2561)new class_2588("config.roughlyenoughitems.basics")).getEntries().add(0, new ConfigAddonsEntry(220));
        }
        return null;
    }
}

