/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.performance;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.gui.widget.DynamicElementListWidget;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import me.shedaniel.rei.impl.client.gui.modules.entries.ToggleMenuEntry;
import me.shedaniel.rei.impl.client.gui.screen.ScreenWithMenu;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;

@Environment(value=EnvType.CLIENT)
public class DisplayRegistryInfoScreen
extends ScreenWithMenu {
    private Runnable onClose;
    private ListWidget list;
    private SortType sortType = SortType.ID;

    public DisplayRegistryInfoScreen(Runnable onClose) {
        super((class_2561)new class_2588("text.rei.display_registry_analysis"));
        this.onClose = onClose;
    }

    public void method_25426() {
        class_5250 backText = new class_2585("\u21a9 ").method_10852((class_2561)new class_2588("gui.back"));
        this.method_37063((class_364)new class_4185(4, 4, class_310.method_1551().field_1772.method_27525((class_5348)backText) + 10, 20, (class_2561)backText, button -> {
            this.onClose.run();
            this.onClose = null;
        }));
        class_2588 text = new class_2588("text.rei.sort");
        Rectangle bounds = new Rectangle(this.field_22789 - 4 - class_310.method_1551().field_1772.method_27525((class_5348)text) - 10, 4, class_310.method_1551().field_1772.method_27525((class_5348)text) + 10, 20);
        this.method_37063((class_364)new class_4185(bounds.x, bounds.y, bounds.width, bounds.height, (class_2561)text, button -> this.setMenu(new Menu(bounds, CollectionUtils.map(SortType.values(), type -> ToggleMenuEntry.of((class_2561)new class_2588("text.rei.sort.by", new Object[]{type.name().toLowerCase(Locale.ROOT)}), () -> false, o -> {
            this.closeMenu();
            this.sortType = type;
            this.method_25423(this.field_22787, this.field_22789, this.field_22790);
        })), false))));
        this.list = new ListWidget();
        this.list.addItem(new EntryImpl((class_2561)new class_2585("Total Displays"), DisplayRegistry.getInstance().displaySize()));
        this.sort(DisplayRegistry.getInstance().getAll().entrySet().stream()).forEach(entry -> this.list.addItem(new EntryImpl((CategoryIdentifier)entry.getKey(), ((List)entry.getValue()).size())));
        this.method_25429((class_364)this.list);
    }

    private Stream<Map.Entry<CategoryIdentifier<?>, List<Display>>> sort(Stream<Map.Entry<CategoryIdentifier<?>, List<Display>>> stream) {
        return switch (this.sortType) {
            default -> throw new IncompatibleClassChangeError();
            case SortType.COUNT -> stream.sorted(Comparator.comparingInt(value -> ((List)value.getValue()).size()).reversed());
            case SortType.ID -> stream.sorted(Comparator.comparing(value -> ((CategoryIdentifier)value.getKey()).toString()));
        };
    }

    @Override
    public void method_25394(class_4587 poses, int mouseX, int mouseY, float delta) {
        this.method_25434(0);
        this.list.method_25394(poses, mouseX, mouseY, delta);
        this.field_22793.method_27517(poses, this.field_22785.method_30937(), (float)this.field_22789 / 2.0f - (float)this.field_22793.method_27525((class_5348)this.field_22785) / 2.0f, 12.0f, -1);
        super.method_25394(poses, mouseX, mouseY, delta);
    }

    private static enum SortType {
        COUNT,
        ID;

    }

    private class ListWidget
    extends DynamicElementListWidget<ListEntry> {
        public ListWidget() {
            super(DisplayRegistryInfoScreen.this.field_22787, DisplayRegistryInfoScreen.this.field_22789, DisplayRegistryInfoScreen.this.field_22790, 30, DisplayRegistryInfoScreen.this.field_22790, class_332.field_22735);
        }

        public int getItemWidth() {
            return this.width;
        }

        public int addItem(ListEntry item) {
            return super.addItem((DynamicEntryListWidget.Entry)item);
        }

        protected int getScrollbarPosition() {
            return this.width - 6;
        }
    }

    public static class EntryImpl
    extends ListEntry {
        private final class_2561 component;
        public final int count;

        public EntryImpl(CategoryIdentifier<?> identifier, int count) {
            this((class_2561)new class_2585(identifier.getIdentifier().toString()), count);
        }

        public EntryImpl(class_2561 component, int count) {
            this.component = component;
            this.count = count;
        }

        public void render(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            class_310.method_1551().field_1772.method_27517(matrices, this.component.method_30937(), (float)x + 4.0f, (float)(y + 6), -1);
            class_5481 rightText = new class_2588("text.rei.display_registry_analysis.displays", new Object[]{this.count}).method_30937();
            class_310.method_1551().field_1772.method_27517(matrices, rightText, (float)x + (float)entryWidth - 6.0f - 8.0f - (float)class_310.method_1551().field_1772.method_30880(rightText), (float)(y + 6), -1);
        }

        public int getItemHeight() {
            return 24;
        }

        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }

        public List<? extends class_6379> narratables() {
            return Collections.emptyList();
        }
    }

    public static abstract class ListEntry
    extends DynamicElementListWidget.ElementEntry<ListEntry> {
    }
}

