/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.basewidgets;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import me.shedaniel.clothconfig2.api.TickableWidget;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.TextField;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import net.minecraft.class_1159;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class TextFieldWidget
extends WidgetWithBounds
implements TickableWidget,
TextField {
    public Function<String, String> stripInvalid = class_155::method_644;
    protected int frame;
    protected boolean editable = true;
    protected int firstCharacterIndex;
    protected int cursorPos;
    protected int highlightPos;
    protected int editableColor = 0xE0E0E0;
    protected int notEditableColor = 0x707070;
    protected TextFormatter formatter = TextFormatter.DEFAULT;
    private Rectangle bounds;
    private String text = "";
    private int maxLength = 32;
    private boolean hasBorder = true;
    private boolean focusUnlocked = true;
    private boolean focused = false;
    private boolean visible = true;
    private boolean selecting = false;
    @Nullable
    private String suggestion;
    @Nullable
    private Consumer<String> responder;
    private Predicate<String> filter = s -> true;

    public TextFieldWidget(Rectangle bounds) {
        this.bounds = bounds;
    }

    public TextFieldWidget(int x, int y, int width, int height) {
        this(new Rectangle(x, y, width, height));
    }

    public String getSuggestion() {
        return this.suggestion;
    }

    public void setSuggestion(String suggestion) {
        this.suggestion = suggestion;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setResponder(Consumer<String> responder) {
        this.responder = responder;
    }

    public void setFormatter(TextFormatter formatter) {
        this.formatter = formatter;
    }

    public void tick() {
        ++this.frame;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        if (this.filter.test(text)) {
            this.text = text.length() > this.maxLength ? text.substring(0, this.maxLength) : text;
            this.onChanged(text);
            this.moveCursorToEnd();
        }
    }

    @Override
    public String getSelectedText() {
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        return this.text.substring(i, j);
    }

    public void setFilter(Predicate<String> filter) {
        this.filter = filter;
    }

    @Override
    public void addText(String text) {
        String result;
        String textFiltered;
        int l;
        int highlightStart = Math.min(this.cursorPos, this.highlightPos);
        int highlightEnd = Math.max(this.cursorPos, this.highlightPos);
        int k = this.maxLength - this.text.length() - (highlightStart - highlightEnd);
        if (k < (l = (textFiltered = this.stripInvalid.apply(text)).length())) {
            textFiltered = textFiltered.substring(0, k);
            l = k;
        }
        if (this.filter.test(result = new StringBuilder(this.text).replace(highlightStart, highlightEnd, textFiltered).toString())) {
            this.text = result;
            this.setCursorPosition(highlightStart + l);
            this.setHighlightPos(this.cursorPos);
            this.onChanged(this.text);
        }
    }

    public void onChanged(String newText) {
        if (this.responder != null) {
            this.responder.accept(newText);
        }
    }

    private void erase(int offset) {
        if (class_437.method_25441()) {
            this.eraseWords(offset);
        } else {
            this.eraseCharacters(offset);
        }
    }

    public void eraseWords(int wordOffset) {
        if (!this.text.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.addText("");
            } else {
                this.eraseCharacters(this.getWordPosition(wordOffset) - this.cursorPos);
            }
        }
    }

    public void eraseCharacters(int characterOffset) {
        if (!this.text.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.addText("");
            } else {
                String string;
                int to;
                int offsetCursorPos = this.getCursorPos(characterOffset);
                int from = Math.min(offsetCursorPos, this.cursorPos);
                if (from != (to = Math.max(offsetCursorPos, this.cursorPos)) && this.filter.test(string = new StringBuilder(this.text).delete(from, to).toString())) {
                    this.text = string;
                    this.moveCursorTo(from);
                }
                this.onChanged(this.text);
            }
        }
    }

    public int getWordPosition(int wordOffset) {
        return this.getWordPosition(wordOffset, this.getCursor());
    }

    public int getWordPosition(int wordOffset, int cursorPosition) {
        return this.getWordPosition(wordOffset, cursorPosition, true);
    }

    public int getWordPosition(int wordOffset, int cursorPosition, boolean skipOverSpaces) {
        int cursor = cursorPosition;
        boolean backwards = wordOffset < 0;
        int absoluteOffset = Math.abs(wordOffset);
        for (int k = 0; k < absoluteOffset; ++k) {
            if (!backwards) {
                int l = this.text.length();
                if ((cursor = this.text.indexOf(32, cursor)) == -1) {
                    cursor = l;
                    continue;
                }
                while (skipOverSpaces && cursor < l && this.text.charAt(cursor) == ' ') {
                    ++cursor;
                }
                continue;
            }
            while (skipOverSpaces && cursor > 0 && this.text.charAt(cursor - 1) == ' ') {
                --cursor;
            }
            while (cursor > 0 && this.text.charAt(cursor - 1) != ' ') {
                --cursor;
            }
        }
        return cursor;
    }

    public void moveCursor(int by) {
        this.moveCursorTo(this.cursorPos + by);
    }

    private int getCursorPos(int i) {
        return class_156.method_27761((String)this.text, (int)this.cursorPos, (int)i);
    }

    @Override
    public void moveCursorTo(int cursor) {
        this.setCursorPosition(cursor);
        if (!this.selecting) {
            this.setHighlightPos(this.cursorPos);
        }
    }

    @Override
    public void moveCursorToStart() {
        this.moveCursorTo(0);
    }

    @Override
    public void moveCursorToEnd() {
        this.moveCursorTo(this.text.length());
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.isVisible() && this.isFocused()) {
            this.selecting = class_437.method_25442();
            if (class_437.method_25439((int)keyCode)) {
                this.moveCursorToEnd();
                this.setHighlightPos(0);
                return true;
            }
            if (class_437.method_25438((int)keyCode)) {
                this.minecraft.field_1774.method_1455(this.getSelectedText());
                return true;
            }
            if (class_437.method_25437((int)keyCode)) {
                if (this.editable) {
                    this.addText(this.minecraft.field_1774.method_1460());
                }
                return true;
            }
            if (class_437.method_25436((int)keyCode)) {
                this.minecraft.field_1774.method_1455(this.getSelectedText());
                if (this.editable) {
                    this.addText("");
                }
                return true;
            }
            switch (keyCode) {
                case 259: {
                    if (this.editable) {
                        this.selecting = false;
                        this.erase(-1);
                        this.selecting = class_437.method_25442();
                    }
                    return true;
                }
                default: {
                    return keyCode != 256;
                }
                case 261: {
                    if (this.editable) {
                        this.selecting = false;
                        this.erase(1);
                        this.selecting = class_437.method_25442();
                    }
                    return true;
                }
                case 262: {
                    if (class_437.method_25441()) {
                        this.moveCursorTo(this.getWordPosition(1));
                    } else {
                        this.moveCursor(1);
                    }
                    return true;
                }
                case 263: {
                    if (class_437.method_25441()) {
                        this.moveCursorTo(this.getWordPosition(-1));
                    } else {
                        this.moveCursor(-1);
                    }
                    return true;
                }
                case 268: {
                    this.moveCursorToStart();
                    return true;
                }
                case 269: 
            }
            this.moveCursorToEnd();
            return true;
        }
        return false;
    }

    public boolean method_25400(char character, int modifiers) {
        if (this.isVisible() && this.isFocused()) {
            if (class_155.method_643((char)character) && (!class_437.method_25441() || class_437.method_25442() || class_437.method_25443() || character != 'a' && character != 'c' && character != 'v')) {
                if (this.editable) {
                    this.addText(Character.toString(character));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public List<Widget> method_25396() {
        return Collections.emptyList();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean hovered;
        if (!this.isVisible()) {
            return false;
        }
        boolean bl = hovered = mouseX >= (double)this.bounds.x && mouseX < (double)(this.bounds.x + this.bounds.width) && mouseY >= (double)this.bounds.y && mouseY < (double)(this.bounds.y + this.bounds.height);
        if (this.focusUnlocked) {
            this.setFocused(hovered);
        }
        if (this.focused && hovered && button == 0) {
            int int_2 = class_3532.method_15357((double)mouseX) - this.bounds.x;
            if (this.hasBorder) {
                int_2 -= 4;
            }
            String string_1 = this.font.method_27523(this.text.substring(this.firstCharacterIndex), this.getWidth());
            this.moveCursorTo(this.font.method_27523(string_1, int_2).length() + this.firstCharacterIndex);
            return true;
        }
        return false;
    }

    public void renderBorder(class_4587 matrices) {
        if (this.hasBorder()) {
            int borderColor = this.containsMouse(TextFieldWidget.mouse()) || this.focused ? -1 : -6250336;
            TextFieldWidget.method_25294((class_4587)matrices, (int)(this.bounds.x - 1), (int)(this.bounds.y - 1), (int)(this.bounds.x + this.bounds.width + 1), (int)(this.bounds.y + this.bounds.height + 1), (int)-16777216);
            TextFieldWidget.method_25294((class_4587)matrices, (int)this.bounds.x, (int)this.bounds.y, (int)(this.bounds.x + this.bounds.width), (int)(this.bounds.y + this.bounds.height), (int)borderColor);
            TextFieldWidget.method_25294((class_4587)matrices, (int)(this.bounds.x + 1), (int)(this.bounds.y + 1), (int)(this.bounds.x + this.bounds.width - 1), (int)(this.bounds.y + this.bounds.height - 1), (int)-16777216);
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.isVisible()) {
            this.renderBorder(matrices);
            int color = this.editable ? this.editableColor : this.notEditableColor;
            int int_4 = this.cursorPos - this.firstCharacterIndex;
            int int_5 = this.highlightPos - this.firstCharacterIndex;
            String textClipped = this.font.method_27523(this.text.substring(this.firstCharacterIndex), this.getWidth());
            boolean boolean_1 = int_4 >= 0 && int_4 <= textClipped.length();
            boolean boolean_2 = this.focused && this.frame / 6 % 2 == 0 && boolean_1;
            int x = this.hasBorder ? this.bounds.x + 4 : this.bounds.x;
            int y = this.hasBorder ? this.bounds.y + (this.bounds.height - 8) / 2 : this.bounds.y;
            int int_8 = x;
            int_5 = Math.min(textClipped.length(), int_5);
            if (!textClipped.isEmpty()) {
                String string_2 = boolean_1 ? textClipped.substring(0, int_4) : textClipped;
                int_8 = this.font.method_27517(matrices, this.formatter.format(this, string_2, this.firstCharacterIndex), (float)x, (float)y, color);
            }
            boolean isCursorInsideText = this.cursorPos < this.text.length() || this.text.length() >= this.getMaxLength();
            int selectionLeft = int_8--;
            if (!boolean_1) {
                selectionLeft = int_4 > 0 ? x + this.bounds.width : x;
            } else if (isCursorInsideText) {
                // empty if block
            }
            --selectionLeft;
            if (!textClipped.isEmpty() && boolean_1 && int_4 < textClipped.length()) {
                this.font.method_27517(matrices, this.formatter.format(this, textClipped.substring(int_4), this.cursorPos), (float)int_8, (float)y, color);
            }
            if (!isCursorInsideText && this.text.isEmpty() && this.suggestion != null) {
                this.renderSuggestion(matrices, x, y);
            }
            if (boolean_2) {
                TextFieldWidget.method_25294((class_4587)matrices, (int)(selectionLeft + 1), (int)y, (int)(selectionLeft + 2), (int)(y + 9), (int)(0xFF000000 | ((color >> 16 & 0xFF) / 4 & 0xFF) << 16 | ((color >> 8 & 0xFF) / 4 & 0xFF) << 8 | (color & 0xFF) / 4 & 0xFF));
                TextFieldWidget.method_25294((class_4587)matrices, (int)selectionLeft, (int)(y - 1), (int)(selectionLeft + 1), (int)(y + 8), (int)(0xFF000000 | color));
            }
            if (int_5 != int_4) {
                int selectionRight = x + this.font.method_1727(textClipped.substring(0, int_5));
                this.renderSelection(matrices, selectionLeft, y - 1, selectionRight - 1, y + 9, color);
            }
        }
    }

    protected void renderSuggestion(class_4587 matrices, int x, int y) {
        this.font.method_1720(matrices, this.font.method_27523(this.suggestion, this.getWidth()), (float)x, (float)y, -8355712);
    }

    protected void renderSelection(class_4587 matrices, int x1, int y1, int x2, int y2, int color) {
        int tmp;
        if (x1 < x2) {
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if (y1 < y2) {
            tmp = y1;
            y1 = y2;
            y2 = tmp;
        }
        if (x2 > this.bounds.x + this.bounds.width) {
            x2 = this.bounds.x + this.bounds.width;
        }
        if (x1 > this.bounds.x + this.bounds.width) {
            x1 = this.bounds.x + this.bounds.width;
        }
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        class_1159 matrix = matrices.method_23760().method_23761();
        RenderSystem.setShader(class_757::method_34540);
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22918(matrix, (float)x1, (float)y2, (float)this.method_25305() + 50.0f).method_1336(r, g, b, 120).method_1344();
        buffer.method_22918(matrix, (float)x2, (float)y2, (float)this.method_25305() + 50.0f).method_1336(r, g, b, 120).method_1344();
        buffer.method_22918(matrix, (float)x2, (float)y1, (float)this.method_25305() + 50.0f).method_1336(r, g, b, 120).method_1344();
        buffer.method_22918(matrix, (float)x1, (float)y1, (float)this.method_25305() + 50.0f).method_1336(r, g, b, 120).method_1344();
        tesselator.method_1350();
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
    }

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        if (this.text.length() > maxLength) {
            this.text = this.text.substring(0, maxLength);
            this.onChanged(this.text);
        }
    }

    @Override
    public int getCursor() {
        return this.cursorPos;
    }

    @Override
    public void setCursorPosition(int cursor) {
        this.cursorPos = class_3532.method_15340((int)cursor, (int)0, (int)this.text.length());
    }

    @Override
    public boolean hasBorder() {
        return this.hasBorder;
    }

    @Override
    public void setHasBorder(boolean hasBorder) {
        this.hasBorder = hasBorder;
    }

    @Override
    public void setEditableColor(int editableColor) {
        this.editableColor = editableColor;
    }

    @Override
    public void setNotEditableColor(int notEditableColor) {
        this.notEditableColor = notEditableColor;
    }

    public boolean method_25407(boolean next) {
        if (this.visible && this.editable) {
            this.setFocused(!this.focused);
            return this.focused;
        }
        return false;
    }

    @Override
    public boolean isFocused() {
        return this.focused;
    }

    @Override
    public void setFocused(boolean focused) {
        if (focused && !this.focused) {
            this.frame = 0;
        }
        this.focused = focused;
    }

    public void setIsEditable(boolean isEditable) {
        this.editable = isEditable;
    }

    public int getWidth() {
        return this.hasBorder() ? this.bounds.width - 8 : this.bounds.width;
    }

    public void setHighlightPos(int highlightPos) {
        int j = this.text.length();
        this.highlightPos = class_3532.method_15340((int)highlightPos, (int)0, (int)j);
        if (this.font != null) {
            if (this.firstCharacterIndex > j) {
                this.firstCharacterIndex = j;
            }
            int width = this.getWidth();
            String clippedText = this.font.method_27523(this.text.substring(this.firstCharacterIndex), width);
            int int_4 = clippedText.length() + this.firstCharacterIndex;
            if (this.highlightPos == this.firstCharacterIndex) {
                this.firstCharacterIndex -= this.font.method_27524(this.text, width, true).length();
            }
            if (this.highlightPos > int_4) {
                this.firstCharacterIndex += this.highlightPos - int_4;
            } else if (this.highlightPos <= this.firstCharacterIndex) {
                this.firstCharacterIndex -= this.firstCharacterIndex - this.highlightPos;
            }
            this.firstCharacterIndex = class_3532.method_15340((int)this.firstCharacterIndex, (int)0, (int)j);
        }
    }

    public void setFocusUnlocked(boolean focusUnlocked) {
        this.focusUnlocked = focusUnlocked;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getCharacterX(int index) {
        return index > this.text.length() ? this.bounds.x : this.bounds.x + this.font.method_1727(this.text.substring(0, index));
    }

    public static interface TextFormatter {
        public static final TextFormatter DEFAULT = (widget, text, index) -> class_5481.method_30747((String)text, (class_2583)class_2583.field_24360);

        public class_5481 format(TextFieldWidget var1, String var2, int var3);
    }
}

