/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.init;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import me.shedaniel.rei.RoughlyEnoughItemsState;
import me.shedaniel.rei.impl.init.PrimitivePlatformAdapter;

public class RoughlyEnoughItemsInitializer {
    public static final String COMPATIBLE_MC_VERSION_LOW = "1.18.2";
    public static final String COMPATIBLE_MC_VERSION_HIGH = "1.19";

    public static void onInitialize() {
        PrimitivePlatformAdapter adapter = PrimitivePlatformAdapter.get();
        RoughlyEnoughItemsState.client = adapter.isClient();
        RoughlyEnoughItemsState.isDev = adapter.isDev();
        String minecraftVersion = adapter.getMinecraftVersion();
        if (minecraftVersion.startsWith("1.") && (adapter.compareVersions(minecraftVersion, COMPATIBLE_MC_VERSION_LOW) < 0 || adapter.compareVersions(minecraftVersion, COMPATIBLE_MC_VERSION_HIGH) >= 0)) {
            RoughlyEnoughItemsState.error("Your current REI version (for >=1.18.2 and <1.19) is not compatible with your current Minecraft version (" + minecraftVersion + ").");
        }
        adapter.checkMods();
        if (RoughlyEnoughItemsState.getErrors().isEmpty()) {
            RoughlyEnoughItemsInitializer.initializeEntryPoint(false, "me.shedaniel.rei.RoughlyEnoughItemsCore");
        }
    }

    public static void onInitializeClient() {
        if (RoughlyEnoughItemsState.getErrors().isEmpty()) {
            RoughlyEnoughItemsInitializer.initializeEntryPoint(true, "me.shedaniel.rei.RoughlyEnoughItemsCoreClient");
            RoughlyEnoughItemsInitializer.initializeEntryPoint(true, "me.shedaniel.rei.REIModMenuEntryPoint");
            RoughlyEnoughItemsInitializer.initializeEntryPoint(true, "me.shedaniel.rei.impl.client.ClientHelperImpl");
            RoughlyEnoughItemsInitializer.initializeEntryPoint(true, "me.shedaniel.rei.impl.client.REIRuntimeImpl");
        }
        RoughlyEnoughItemsInitializer.initializeEntryPoint(true, "me.shedaniel.rei.impl.client.ErrorDisplayer");
    }

    public static void initializeEntryPoint(boolean client, String className) {
        block9: {
            try {
                Class<?> name = Class.forName(className);
                Object instance = name.getConstructor(new Class[0]).newInstance(new Object[0]);
                Method method = null;
                if (client) {
                    if (!PrimitivePlatformAdapter.get().isClient()) break block9;
                    try {
                        method = name.getDeclaredMethod("onInitializeClient", new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (method != null) {
                        MethodHandles.lookup().unreflect(method).bindTo(instance).invoke();
                    }
                    break block9;
                }
                try {
                    method = name.getDeclaredMethod("onInitialize", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (method != null) {
                    MethodHandles.lookup().unreflect(method).bindTo(instance).invoke();
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to initialize REI entry point: " + className, e);
            }
        }
    }
}

