/*
 * Decompiled with CFR 0.152.
 */
package carpetfixes;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import carpet.settings.SettingsManager;
import carpetfixes.CFSettings;
import carpetfixes.helpers.UpdateScheduler;
import carpetfixes.settings.CustomSettingsManager;
import carpetfixes.testing.tests.TestManager;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_155;
import net.minecraft.class_1937;
import net.minecraft.class_2784;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarpetFixesServer
implements CarpetExtension,
ModInitializer {
    private static final SettingsManager carpetFixesSettingsManager;
    public static final Logger LOGGER;
    private static final String MOD_ID = "carpet-fixes";
    private static final String MOD_NAME;
    private static final Version MOD_VERSION;

    public static String modId() {
        return MOD_ID;
    }

    public static String modName() {
        return MOD_NAME;
    }

    public String version() {
        return MOD_VERSION.getFriendlyString();
    }

    public void onInitialize() {
        CarpetServer.manageExtension((CarpetExtension)new CarpetFixesServer());
        if (class_155.field_1125) {
            TestManager.initializeTests();
        }
    }

    public void onGameStarted() {
        carpetFixesSettingsManager.parseSettingsClass(CFSettings.class);
    }

    public void onServerLoaded(MinecraftServer server) {
    }

    public void onServerLoadedWorlds(MinecraftServer minecraftServer) {
        for (class_3218 world : minecraftServer.method_3738()) {
            CFSettings.updateScheduler.put((class_1937)world, new UpdateScheduler(world));
        }
    }

    public void onTick(MinecraftServer server) {
        if (CFSettings.scheduleWorldBorderReset) {
            CFSettings.scheduleWorldBorderReset = false;
            class_2784 worldBorder = server.method_30002().method_8621();
            worldBorder.method_11969(worldBorder.method_11965());
        }
    }

    public SettingsManager customSettingsManager() {
        return carpetFixesSettingsManager;
    }

    public static SettingsManager getCarpetFixesSettingsManager() {
        return carpetFixesSettingsManager;
    }

    static {
        LOGGER = LoggerFactory.getLogger(CarpetFixesServer.class);
        ModMetadata metadata = ((ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow(RuntimeException::new)).getMetadata();
        MOD_NAME = metadata.getName();
        MOD_VERSION = metadata.getVersion();
        carpetFixesSettingsManager = new CustomSettingsManager(MOD_VERSION.getFriendlyString(), MOD_ID, MOD_NAME);
    }
}

