/*
 * Decompiled with CFR 0.152.
 */
package carpetfixes.helpers;

public class FastMath {
    private static final double HYPOT_MAX_MAG = 509.0;
    private static final double HYPOT_FACTOR = 748.0;

    public static int round(float a) {
        return a > 0.0f ? (int)(a + 0.5f) : (int)(a - 0.5f);
    }

    public static long round(double a) {
        return a > 0.0 ? (long)(a + 0.5) : (long)(a - 0.5);
    }

    public static double hypot(double x, double y) {
        double factor;
        x = Math.abs(x);
        if ((y = Math.abs(y)) < x) {
            double a = x;
            x = y;
            y = a;
        } else if (!(y >= x)) {
            return x == Double.POSITIVE_INFINITY ? Double.POSITIVE_INFINITY : Double.NaN;
        }
        if (y - x == y) {
            return y;
        }
        if (y > 509.0) {
            x *= 0.001336898395721925;
            y *= 0.001336898395721925;
            factor = 748.0;
        } else if (x < 0.0019646365422396855) {
            x *= 748.0;
            y *= 748.0;
            factor = 0.001336898395721925;
        } else {
            factor = 1.0;
        }
        return factor * Math.sqrt(x * x + y * y);
    }
}

