/*
 * Decompiled with CFR 0.152.
 */
package carpetfixes.helpers;

import com.google.common.collect.Queues;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

public class UpdateScheduler {
    private final Queue<ScheduledUpdate> currentUpdates = Queues.newArrayDeque();
    private final class_3218 world;

    public UpdateScheduler(class_3218 world) {
        this.world = world;
    }

    public void tick() {
        ScheduledUpdate nextBlockUpdate;
        ArrayDeque tempUpdates = Queues.newArrayDeque();
        tempUpdates.addAll(this.currentUpdates);
        this.currentUpdates.clear();
        while ((nextBlockUpdate = (ScheduledUpdate)tempUpdates.poll()) != null) {
            try {
                this.world.method_8492(nextBlockUpdate.pos, nextBlockUpdate.block, nextBlockUpdate.pos);
            }
            catch (Throwable throwable) {}
        }
    }

    public void addScheduledUpdate(ScheduledUpdate update) {
        if (!this.currentUpdates.contains(update)) {
            this.currentUpdates.add(update);
        }
    }

    public static class ScheduledUpdate {
        private final class_2338 pos;
        private final class_2248 block;

        public ScheduledUpdate(class_2338 pos, class_2248 block) {
            this.pos = pos;
            this.block = block;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof ScheduledUpdate)) return false;
            ScheduledUpdate com = (ScheduledUpdate)o;
            if (!this.pos.equals((Object)com.pos)) return false;
            if (this.block != com.block) return false;
            return true;
        }

        public int hashCode() {
            return this.pos.hashCode();
        }

        public String toString() {
            return this.block.toString() + ": " + this.pos;
        }

        public class_2248 getBlock() {
            return this.block;
        }

        public class_2338 getPos() {
            return this.pos;
        }
    }
}

