/*
 * Decompiled with CFR 0.152.
 */
package carpetfixes.mixins.optimizations;

import carpetfixes.CFSettings;
import carpetfixes.helpers.EventManager;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2609;
import net.minecraft.class_3956;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2609.class})
public class AbstractFurnaceBlockEntity_fastMixin {
    private static Optional<class_1860<class_1263>> lastRecipe = Optional.empty();
    private static Map<class_1792, Integer> cachedFuelTimeMap = null;

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/recipe/RecipeManager;getFirstMatch(Lnet/minecraft/recipe/RecipeType;Lnet/minecraft/inventory/Inventory;Lnet/minecraft/world/World;)Ljava/util/Optional;"))
    private static Optional<class_1860<class_1263>> getFirstMatchAndCache(class_1863 manager, class_3956<class_1860<class_1263>> type, class_1263 inventory, class_1937 world) {
        if (CFSettings.optimizedFurnaces) {
            if (lastRecipe.isPresent() && lastRecipe.get().method_8115(inventory, world)) {
                return lastRecipe;
            }
            lastRecipe = manager.method_8132(type, inventory, world);
            return lastRecipe;
        }
        return manager.method_8132(type, inventory, world);
    }

    @Inject(method={"getCookTime"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getCookTime(class_1937 world, class_3956<? extends class_1874> recipeType, class_1263 inventory, CallbackInfoReturnable<Integer> cir) {
        class_1874 cookingRecipe;
        class_1860<class_1263> class_18602;
        if (CFSettings.optimizedFurnaces && lastRecipe.isPresent() && (class_18602 = lastRecipe.get()) instanceof class_1874 && (cookingRecipe = (class_1874)class_18602).method_8115(inventory, world)) {
            cir.setReturnValue((Object)cookingRecipe.method_8167());
        }
    }

    @Inject(method={"createFuelTimeMap()Ljava/util/Map;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void useCachedFuelTimeMap(CallbackInfoReturnable<Map<class_1792, Integer>> cir) {
        if (cachedFuelTimeMap != null) {
            cir.setReturnValue(cachedFuelTimeMap);
        }
    }

    @Inject(method={"createFuelTimeMap()Ljava/util/Map;"}, at={@At(value="RETURN")})
    private static void cacheFuelTimeMap(CallbackInfoReturnable<Map<class_1792, Integer>> cir) {
        if (CFSettings.optimizedFurnaces && cachedFuelTimeMap == null) {
            cachedFuelTimeMap = (Map)cir.getReturnValue();
        }
    }

    static {
        EventManager.addEventListener(EventManager.CF_Event.DATAPACK_RELOAD, () -> {
            lastRecipe = Optional.empty();
            cachedFuelTimeMap = null;
        });
    }
}

