/*
 * Decompiled with CFR 0.152.
 */
package carpetfixes.mixins.optimizations;

import carpet.CarpetSettings;
import carpetfixes.CFSettings;
import carpetfixes.helpers.Utils;
import java.util.HashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2442;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_4970;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2442.class}, priority=990)
public abstract class PoweredRailBlock_fasterMixin
extends class_2241 {
    @Shadow
    @Final
    public static class_2754<class_2768> field_11365;
    @Shadow
    @Final
    public static class_2746 field_11364;
    class_2442 self = (class_2442)this;
    private static final class_2350[] EAST_WEST_DIR;
    private static final class_2350[] NORTH_SOUTH_DIR;
    private static final int FORCE_PLACE = 82;

    protected PoweredRailBlock_fasterMixin(boolean allowCurves, class_4970.class_2251 settings) {
        super(allowCurves, settings);
    }

    @Shadow
    protected boolean method_10413(class_1937 world, class_2338 pos, class_2680 state, boolean bl, int distance) {
        return false;
    }

    protected boolean isPoweredByOtherRailsFaster(class_1937 world, class_2338 pos, boolean bl, int distance, class_2768 shape, HashMap<class_2338, Boolean> checkedPos) {
        boolean speedCheck;
        class_2680 blockState = world.method_8320(pos);
        boolean bl2 = speedCheck = checkedPos.containsKey(pos) && checkedPos.get(pos) != false;
        if (speedCheck) {
            return world.method_8479(pos) || this.isPoweredByOtherRailsFaster(world, pos, blockState, bl, distance + 1, checkedPos);
        }
        if (blockState.method_27852((class_2248)this)) {
            class_2768 railShape = (class_2768)blockState.method_11654(field_11365);
            if (shape == class_2768.field_12674 && (railShape == class_2768.field_12665 || railShape == class_2768.field_12670 || railShape == class_2768.field_12668) || shape == class_2768.field_12665 && (railShape == class_2768.field_12674 || railShape == class_2768.field_12667 || railShape == class_2768.field_12666)) {
                return false;
            }
            if (((Boolean)blockState.method_11654((class_2769)field_11364)).booleanValue()) {
                return world.method_8479(pos) || this.isPoweredByOtherRailsFaster(world, pos, blockState, bl, distance + 1, checkedPos);
            }
            return false;
        }
        return false;
    }

    protected boolean isPoweredByOtherRailsFaster(class_1937 world, class_2338 pos, class_2680 state, boolean bl, int distance, HashMap<class_2338, Boolean> checkedPos) {
        if (distance >= CarpetSettings.railPowerLimit - 1) {
            return false;
        }
        int i = pos.method_10263();
        int j = pos.method_10264();
        int k = pos.method_10260();
        boolean bl2 = true;
        class_2768 railShape = (class_2768)state.method_11654(field_11365);
        switch (railShape.ordinal()) {
            case 0: {
                if (bl) {
                    ++k;
                    break;
                }
                --k;
                break;
            }
            case 1: {
                if (bl) {
                    --i;
                    break;
                }
                ++i;
                break;
            }
            case 2: {
                if (bl) {
                    --i;
                } else {
                    ++i;
                    ++j;
                    bl2 = false;
                }
                railShape = class_2768.field_12674;
                break;
            }
            case 3: {
                if (bl) {
                    --i;
                    ++j;
                    bl2 = false;
                } else {
                    ++i;
                }
                railShape = class_2768.field_12674;
                break;
            }
            case 4: {
                if (bl) {
                    ++k;
                } else {
                    --k;
                    ++j;
                    bl2 = false;
                }
                railShape = class_2768.field_12665;
                break;
            }
            case 5: {
                if (bl) {
                    ++k;
                    ++j;
                    bl2 = false;
                } else {
                    --k;
                }
                railShape = class_2768.field_12665;
            }
        }
        return this.isPoweredByOtherRailsFaster(world, new class_2338(i, j, k), bl, distance, railShape, checkedPos) || bl2 && this.isPoweredByOtherRailsFaster(world, new class_2338(i, j - 1, k), bl, distance, railShape, checkedPos);
    }

    @Inject(method={"updateBlockState(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/Block;)V"}, at={@At(value="HEAD")}, cancellable=true)
    protected void updateBlockState(class_2680 state, class_1937 world, class_2338 pos, class_2248 neighbor, CallbackInfo ci) {
        if (CFSettings.optimizedPoweredRails) {
            boolean shouldBePowered;
            boolean bl = shouldBePowered = world.method_8479(pos) || this.method_10413(world, pos, state, true, 0) || this.method_10413(world, pos, state, false, 0);
            if (shouldBePowered != (Boolean)state.method_11654((class_2769)field_11364)) {
                class_2768 railShape = (class_2768)state.method_11654(field_11365);
                if (railShape.method_11897()) {
                    world.method_8652(pos, (class_2680)state.method_11657((class_2769)field_11364, (Comparable)Boolean.valueOf(shouldBePowered)), 3);
                    world.method_8508(pos.method_10074(), (class_2248)this.self, class_2350.field_11036);
                    world.method_8508(pos.method_10084(), (class_2248)this.self, class_2350.field_11033);
                } else if (shouldBePowered) {
                    this.powerLane(world, pos, state, railShape);
                } else {
                    this.dePowerLane(world, pos, state, railShape);
                }
            }
            ci.cancel();
        }
    }

    public void powerLane(class_1937 world, class_2338 pos, class_2680 mainState, class_2768 railShape) {
        world.method_8652(pos, (class_2680)mainState.method_11657((class_2769)field_11364, (Comparable)Boolean.valueOf(true)), 82);
        HashMap<class_2338, Boolean> checkedPos = new HashMap<class_2338, Boolean>();
        checkedPos.put(pos, true);
        int[] count = new int[2];
        if (railShape == class_2768.field_12665) {
            for (int i = 0; i < NORTH_SOUTH_DIR.length; ++i) {
                this.setRailPositionsPower(world, pos, checkedPos, count, i, NORTH_SOUTH_DIR[i]);
            }
            this.updateRails(false, world, pos, mainState, count);
        } else if (railShape == class_2768.field_12674) {
            for (int i = 0; i < EAST_WEST_DIR.length; ++i) {
                this.setRailPositionsPower(world, pos, checkedPos, count, i, EAST_WEST_DIR[i]);
            }
            this.updateRails(true, world, pos, mainState, count);
        }
    }

    public void dePowerLane(class_1937 world, class_2338 pos, class_2680 mainState, class_2768 railShape) {
        world.method_8652(pos, (class_2680)mainState.method_11657((class_2769)field_11364, (Comparable)Boolean.valueOf(false)), 82);
        int[] count = new int[2];
        if (railShape == class_2768.field_12665) {
            for (int i = 0; i < NORTH_SOUTH_DIR.length; ++i) {
                this.setRailPositionsDePower(world, pos, count, i, NORTH_SOUTH_DIR[i]);
            }
            this.updateRails(false, world, pos, mainState, count);
        } else if (railShape == class_2768.field_12674) {
            for (int i = 0; i < EAST_WEST_DIR.length; ++i) {
                this.setRailPositionsDePower(world, pos, count, i, EAST_WEST_DIR[i]);
            }
            this.updateRails(true, world, pos, mainState, count);
        }
    }

    private void setRailPositionsPower(class_1937 world, class_2338 pos, HashMap<class_2338, Boolean> checkedPos, int[] count, int i, class_2350 direction) {
        for (int z = 1; z < CarpetSettings.railPowerLimit; ++z) {
            class_2338 newPos = pos.method_10079(direction, z);
            class_2680 state = world.method_8320(newPos);
            if (checkedPos.containsKey(newPos)) {
                if (!checkedPos.get(newPos).booleanValue()) break;
                int n = i;
                count[n] = count[n] + 1;
                continue;
            }
            if (!state.method_27852((class_2248)this) || ((Boolean)state.method_11654((class_2769)field_11364)).booleanValue() || !world.method_8479(newPos) && !this.isPoweredByOtherRailsFaster(world, newPos, state, true, 0, checkedPos) && !this.isPoweredByOtherRailsFaster(world, newPos, state, false, 0, checkedPos)) {
                checkedPos.put(newPos, false);
                break;
            }
            checkedPos.put(newPos, true);
            world.method_8652(newPos, (class_2680)state.method_11657((class_2769)field_11364, (Comparable)Boolean.valueOf(true)), 82);
            int n = i;
            count[n] = count[n] + 1;
        }
    }

    private void setRailPositionsDePower(class_1937 world, class_2338 pos, int[] count, int i, class_2350 direction) {
        class_2338 newPos;
        class_2680 state;
        for (int z = 1; z < CarpetSettings.railPowerLimit && (state = world.method_8320(newPos = pos.method_10079(direction, z))).method_27852((class_2248)this) && ((Boolean)state.method_11654((class_2769)field_11364)).booleanValue() && !world.method_8479(newPos) && !this.method_10413(world, newPos, state, true, 0) && !this.method_10413(world, newPos, state, false, 0); ++z) {
            world.method_8652(newPos, (class_2680)state.method_11657((class_2769)field_11364, (Comparable)Boolean.valueOf(false)), 82);
            int n = i;
            count[n] = count[n] + 1;
        }
    }

    private void shapeUpdateEnd(class_1937 world, class_2338 pos, class_2680 mainState, int endPos, class_2350 direction, int currentPos, class_2338 blockPos) {
        if (currentPos == endPos) {
            class_2338 newPos = pos.method_10079(direction, currentPos + 1);
            Utils.giveShapeUpdate(world, mainState, newPos, pos, direction);
            class_2680 state = world.method_8320(blockPos);
            if (state.method_27852((class_2248)this) && ((class_2768)state.method_11654(field_11365)).method_11897()) {
                Utils.giveShapeUpdate(world, mainState, newPos.method_10084(), pos, direction);
            }
        }
    }

    private void neighborUpdateEnd(class_1937 world, class_2338 pos, int endPos, class_2350 direction, class_2248 block, int currentPos, class_2338 blockPos) {
        if (currentPos == endPos) {
            class_2338 newPos = pos.method_10079(direction, currentPos + 1);
            world.method_8492(newPos, block, pos);
            class_2680 state = world.method_8320(blockPos);
            if (state.method_27852((class_2248)this) && ((class_2768)state.method_11654(field_11365)).method_11897()) {
                world.method_8492(newPos.method_10084(), block, blockPos);
            }
        }
    }

    private void updateRails(boolean eastWest, class_1937 world, class_2338 pos, class_2680 mainState, int[] count) {
        if (eastWest) {
            for (int i = 0; i < EAST_WEST_DIR.length; ++i) {
                class_2338 pos1;
                int c;
                int countAmt = count[i];
                if (i == 1 && countAmt == 0) continue;
                class_2350 dir = EAST_WEST_DIR[i];
                class_2248 block = mainState.method_26204();
                for (c = countAmt; c >= i; --c) {
                    pos1 = pos.method_10079(dir, c);
                    if (c == 0 && count[1] == 0) {
                        world.method_8492(pos1.method_10093(dir.method_10153()), block, pos);
                    }
                    this.neighborUpdateEnd(world, pos, countAmt, dir, block, c, pos1);
                    world.method_8492(pos1.method_10074(), block, pos);
                    world.method_8492(pos1.method_10084(), block, pos);
                    world.method_8492(pos1.method_10095(), block, pos);
                    world.method_8492(pos1.method_10072(), block, pos);
                    class_2338 pos2 = pos.method_10079(dir, c).method_10074();
                    world.method_8492(pos2.method_10074(), block, pos);
                    world.method_8492(pos2.method_10095(), block, pos);
                    world.method_8492(pos2.method_10072(), block, pos);
                    if (c == countAmt) {
                        world.method_8492(pos.method_10079(dir, c + 1).method_10074(), block, pos);
                    }
                    if (c != 0 || count[1] != 0) continue;
                    world.method_8492(pos1.method_10093(dir.method_10153()).method_10074(), block, pos);
                }
                for (c = countAmt; c >= i; --c) {
                    pos1 = pos.method_10079(dir, c);
                    if (c == 0 && count[1] == 0) {
                        Utils.giveShapeUpdate(world, mainState, pos1.method_10093(dir.method_10153()), pos, dir.method_10153());
                    }
                    this.shapeUpdateEnd(world, pos, mainState, countAmt, dir, c, pos1);
                    Utils.giveShapeUpdate(world, mainState, pos1.method_10074(), pos, class_2350.field_11033);
                    Utils.giveShapeUpdate(world, mainState, pos1.method_10084(), pos, class_2350.field_11036);
                    Utils.giveShapeUpdate(world, mainState, pos1.method_10095(), pos, class_2350.field_11043);
                    Utils.giveShapeUpdate(world, mainState, pos1.method_10072(), pos, class_2350.field_11035);
                }
            }
        } else {
            for (int i = 0; i < NORTH_SOUTH_DIR.length; ++i) {
                class_2338 pos1;
                int c;
                int countAmt = count[i];
                if (i == 1 && countAmt == 0) continue;
                class_2350 direction = NORTH_SOUTH_DIR[i];
                class_2248 block = mainState.method_26204();
                for (c = countAmt; c >= i; --c) {
                    pos1 = pos.method_10079(direction, c);
                    world.method_8492(pos1.method_10067(), block, pos);
                    world.method_8492(pos1.method_10078(), block, pos);
                    world.method_8492(pos1.method_10074(), block, pos);
                    world.method_8492(pos1.method_10084(), block, pos);
                    this.neighborUpdateEnd(world, pos, countAmt, direction, block, c, pos1);
                    if (c == 0 && count[1] == 0) {
                        world.method_8492(pos1.method_10093(direction.method_10153()), block, pos);
                    }
                    class_2338 pos2 = pos.method_10079(direction, c).method_10074();
                    world.method_8492(pos2.method_10067(), block, pos);
                    world.method_8492(pos2.method_10078(), block, pos);
                    world.method_8492(pos2.method_10074(), block, pos);
                    if (c == countAmt) {
                        world.method_8492(pos.method_10079(direction, c + 1).method_10074(), block, pos);
                    }
                    if (c != 0 || count[1] != 0) continue;
                    world.method_8492(pos1.method_10093(direction.method_10153()).method_10074(), block, pos);
                }
                for (c = countAmt; c >= i; --c) {
                    pos1 = pos.method_10079(direction, c);
                    Utils.giveShapeUpdate(world, mainState, pos1.method_10067(), pos, class_2350.field_11039);
                    Utils.giveShapeUpdate(world, mainState, pos1.method_10078(), pos, class_2350.field_11034);
                    Utils.giveShapeUpdate(world, mainState, pos1.method_10074(), pos, class_2350.field_11033);
                    Utils.giveShapeUpdate(world, mainState, pos1.method_10084(), pos, class_2350.field_11036);
                    this.shapeUpdateEnd(world, pos, mainState, countAmt, direction, c, pos1);
                    if (c != 0 || count[1] != 0) continue;
                    Utils.giveShapeUpdate(world, mainState, pos1.method_10093(direction.method_10153()), pos, direction.method_10153());
                }
            }
        }
    }

    static {
        EAST_WEST_DIR = new class_2350[]{class_2350.field_11039, class_2350.field_11034};
        NORTH_SOUTH_DIR = new class_2350[]{class_2350.field_11035, class_2350.field_11043};
    }
}

