/*
 * Decompiled with CFR 0.152.
 */
package carpetfixes.settings;

import carpet.settings.Condition;
import carpet.settings.Rule;
import carpet.settings.SettingsManager;
import carpet.settings.Validator;
import carpetfixes.CFSettings;
import carpetfixes.settings.VersionConditions;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class CustomSettingsManager
extends SettingsManager {
    private final String fancyName;

    public CustomSettingsManager(String version, String identifier, String modName) {
        super(version, identifier, modName);
        this.fancyName = modName;
    }

    /*
     * WARNING - void declaration
     */
    public int printAllRulesToLog(String category) {
        PrintStream ps = System.out;
        ps.println("# " + this.fancyName + " Settings");
        for (Field f : CFSettings.class.getDeclaredFields()) {
            String optionString;
            void var12_13;
            Rule rule = f.getAnnotation(Rule.class);
            if (rule == null) continue;
            String defaultAsString = "";
            try {
                defaultAsString = CustomSettingsManager.convertToString(f.get(null));
            }
            catch (IllegalAccessException e2) {
                throw new IllegalStateException(e2);
            }
            boolean isStrict = rule.strict();
            List<String> categories = List.of(rule.category());
            if (category != null && !categories.contains(category)) continue;
            ps.println("## " + (rule.name().isEmpty() ? f.getName() : rule.name()));
            ps.println(rule.desc() + "  ");
            for (String string : List.of(rule.extra())) {
                void var12_17;
                if (string == null) continue;
                if (string.startsWith("[MC-")) {
                    String string2 = "Fixes: " + string;
                }
                ps.println(var12_17.replace("Warning!", "**Warning!**") + "  ");
            }
            Class<?> type = f.getType();
            ps.println("* Type: `" + type.getSimpleName() + "`  ");
            ps.println("* Default value: `" + defaultAsString + "`  ");
            if (rule.options().length > 0) {
                List<String> list = List.of(rule.options());
            } else if (type == Boolean.TYPE) {
                List<String> list = List.of("true", "false");
            } else if (type == String.class && categories.contains("command")) {
                List<String> list = List.of("true", "false", "ops");
            } else if (type.isEnum()) {
                List<String> list = Arrays.stream(type.getEnumConstants()).map(e -> ((Enum)e).name().toLowerCase(Locale.ROOT)).toList();
            } else {
                List list = List.of();
            }
            ArrayList<Validator> validators = new ArrayList<Validator>();
            for (Class v : rule.validate()) {
                validators.add((Validator)this.callConstructor(v));
            }
            if (categories.contains("command")) {
                validators.add((Validator)this.callConstructor(Validator._COMMAND.class));
                if (type == String.class) {
                    isStrict = false;
                    validators.add((Validator)this.callConstructor(Validator._COMMAND_LEVEL_VALIDATOR.class));
                }
            }
            if (isStrict && !var12_13.isEmpty()) {
                if (type == Boolean.TYPE || type == Integer.TYPE || type == Double.TYPE || type == Float.TYPE) {
                    validators.add((Validator)this.callConstructor(Validator._STRICT_IGNORECASE.class));
                } else {
                    validators.add((Validator)this.callConstructor(Validator._STRICT.class));
                }
            }
            if (!(optionString = var12_13.stream().map(s -> "`" + s + "`").collect(Collectors.joining(", "))).isEmpty()) {
                ps.println((isStrict ? "* Required" : "* Suggested") + " options: " + optionString + "  ");
            }
            ps.println("* Categories: " + categories.stream().map(s -> "`" + s.toUpperCase(Locale.ROOT) + "`").collect(Collectors.joining(", ")) + "  ");
            ArrayList<String> conditions = new ArrayList<String>();
            for (Class condition : rule.condition()) {
                try {
                    Constructor constr = condition.getDeclaredConstructor(new Class[0]);
                    constr.setAccessible(true);
                    Object newInstance = constr.newInstance(new Object[0]);
                    if (((Condition)newInstance).isTrue() || !(newInstance instanceof VersionConditions.CustomCondition)) continue;
                    VersionConditions.CustomCondition custom = (VersionConditions.CustomCondition)newInstance;
                    conditions.add(custom.getPredicate());
                }
                catch (ReflectiveOperationException e3) {
                    throw new RuntimeException(e3);
                }
            }
            if (conditions.size() > 0) {
                StringBuilder builder = new StringBuilder();
                int c = 0;
                builder.append("* Limited to: ");
                for (String cond : conditions) {
                    if (c++ != 0) {
                        builder.append(",");
                    }
                    builder.append("`").append(cond).append("`");
                }
                ps.println(builder);
            }
            boolean preamble = false;
            for (Validator validator : validators) {
                if (validator.description() == null) continue;
                if (!preamble) {
                    ps.println("* Additional notes:  ");
                    preamble = true;
                }
                ps.println("  * " + validator.description() + "  ");
            }
        }
        return 1;
    }

    private <T> T callConstructor(Class<T> cls) {
        try {
            Constructor<T> constr = cls.getDeclaredConstructor(new Class[0]);
            constr.setAccessible(true);
            return constr.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static String convertToString(Object value) {
        if (value instanceof Enum) {
            return ((Enum)value).name().toLowerCase(Locale.ROOT);
        }
        return value.toString();
    }
}

