/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.element;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import xaero.map.element.HoveredMapElementHolder;
import xaero.map.element.MapElementMenuHitbox;
import xaero.map.element.MapElementMenuScroll;
import xaero.map.element.MapElementReader;
import xaero.map.element.MapElementRenderHandler;
import xaero.map.element.MapElementRenderProvider;
import xaero.map.element.MapElementRenderer;
import xaero.map.element.MenuHitboxReader;
import xaero.map.element.MenuScrollReader;
import xaero.map.gui.GuiMap;
import xaero.map.misc.Misc;

public abstract class MapElementMenuRenderer<E, C> {
    private static final int MENU_RIGHT_PADDING = 27;
    public static final int MAX_MENU_SIZE = 10;
    public static final int MIN_MENU_SIZE = 2;
    protected final MapElementMenuScroll scrollUp = new MapElementMenuScroll("gui.xaero_wm_up", "\u25b3", 1);
    protected final MapElementMenuScroll scrollDown = new MapElementMenuScroll("gui.xaero_wm_down", "\u25bd", -1);
    protected final MapElementMenuHitbox extraHitbox;
    protected final MenuScrollReader scrollReader = new MenuScrollReader();
    protected final MenuHitboxReader hitboxReader;
    protected final C context;
    protected final MapElementRenderProvider<E, C> provider;
    protected ArrayList<E> filteredElements;
    private class_342 filterField;
    public int menuOffset = 0;
    protected Pattern searchPattern = null;
    protected Pattern searchStartPattern = null;
    protected final class_310 mc;

    protected MapElementMenuRenderer(C context, MapElementRenderProvider<E, C> provider) {
        this.extraHitbox = new MapElementMenuHitbox(-150, 0, 177, 0);
        this.hitboxReader = new MenuHitboxReader();
        this.mc = class_310.method_1551();
        this.context = context;
        this.provider = provider;
    }

    public void onMapInit(GuiMap screen, class_310 mc, int width, int height) {
        String searchText = this.filterField == null ? "" : this.filterField.method_1882();
        this.filterField = new class_342(mc.field_1772, screen.field_22789 - 172, this.menuStartPos(height) + 3 + this.menuSearchPadding(), 150, 20, (class_2561)new class_2588(this.getFilterPlaceholder()));
        this.filterField.method_1852(searchText);
        this.filterField.method_1863(s -> this.updateSearch());
        screen.method_25429(this.filterField);
    }

    public HoveredMapElementHolder<?, ?> renderMenu(class_4587 matrixStack, GuiMap gui, double scale, int width, int height, int mouseX, int mouseY, boolean leftMousePressed, boolean leftMouseClicked, HoveredMapElementHolder<?, ?> oldHovered, class_310 mc) {
        int menuStartPos;
        if (this.filteredElements == null) {
            this.updateFilteredList();
        }
        ArrayList<E> elements = this.filteredElements;
        int menuElementCount = MapElementMenuRenderer.getMenuElementCount(this.menuStartPos(height));
        if (this.menuOffset + menuElementCount > elements.size()) {
            this.menuOffset = elements.size() - menuElementCount;
        }
        if (this.menuOffset < 0) {
            this.menuOffset = 0;
        }
        int offset = this.menuOffset;
        Object viewed = null;
        int yPos = menuStartPos = this.menuStartPos(height);
        int elementCount = MapElementMenuRenderer.getMenuElementCount(yPos);
        this.beforeMenuRender();
        viewed = this.renderMenuElement(matrixStack, this.scrollDown, width, yPos -= 8, mouseX, mouseY, viewed, leftMousePressed, gui, offset > 0, mc);
        yPos -= 8;
        for (int i = offset; i < elements.size(); ++i) {
            viewed = this.renderMenuElement(matrixStack, elements.get(i), width, yPos -= 8, mouseX, mouseY, viewed, leftMousePressed, gui, true, mc);
            yPos -= 8;
            if (i - offset == elementCount - 1) break;
        }
        viewed = this.renderMenuElement(matrixStack, this.scrollUp, width, yPos -= 8, mouseX, mouseY, viewed, leftMousePressed, gui, offset < elements.size() - elementCount, mc);
        yPos -= 8;
        if (viewed != null && leftMouseClicked) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
        }
        if (leftMousePressed && viewed instanceof MapElementMenuScroll) {
            int direction = ((MapElementMenuScroll)viewed).scroll();
            this.menuOffset += direction;
        }
        if (viewed == null) {
            this.extraHitbox.setH(menuStartPos - yPos);
            this.extraHitbox.setY(yPos - menuStartPos);
            viewed = this.renderMenuElement(matrixStack, this.extraHitbox, width, menuStartPos, mouseX, mouseY, viewed, leftMousePressed, gui, true, mc);
        }
        this.afterMenuRender();
        return oldHovered != null && oldHovered.equals(viewed) ? oldHovered : (viewed == null ? null : MapElementRenderHandler.createResult(viewed, this.getAnyRenderer(viewed)));
    }

    protected abstract void beforeMenuRender();

    protected abstract void afterMenuRender();

    public void postMapRender(class_4587 matrixStack, GuiMap gui, int scaledMouseX, int scaledMouseY, int width, int height, float partialTicks) {
        String searchText = this.filterField.method_1882();
        boolean searchFieldPlaceHolder = searchText.isEmpty() && !this.filterField.method_25370();
        boolean invalidRegex = false;
        if (searchFieldPlaceHolder) {
            Misc.setFieldText(this.filterField, class_1074.method_4662((String)this.getFilterPlaceholder(), (Object[])new Object[0]), -11184811);
        } else if (!searchText.isEmpty() && this.searchPattern == null) {
            invalidRegex = true;
        }
        this.filterField.method_25394(matrixStack, scaledMouseX, scaledMouseY, partialTicks);
        if (searchFieldPlaceHolder) {
            Misc.setFieldText(this.filterField, "");
        } else if (invalidRegex) {
            String errorMessage = class_1074.method_4662((String)"gui.xaero_wm_search_invalid_regex", (Object[])new Object[0]);
            class_332.method_25303((class_4587)matrixStack, (class_327)this.mc.field_1772, (String)errorMessage, (int)(width - 176 - this.mc.field_1772.method_1727(errorMessage)), (int)(this.filterField.field_22761 + 6), (int)-43691);
        }
    }

    public static int getMenuElementCount(int menuStartPos) {
        return Math.min(10, Math.max(2, (menuStartPos - 34) / 16 - 2));
    }

    private <O> Object renderMenuElement(class_4587 matrixStack, O element, int width, int yPos, int mouseX, int mouseY, Object viewed, boolean leftMousePressed, class_437 gui, boolean enabled, class_310 mc) {
        boolean hovered;
        MenuScrollReader reader = element == this.scrollDown || element == this.scrollUp ? this.scrollReader : (element == this.extraHitbox ? this.hitboxReader : this.getAnyRenderer(element).getReader());
        int xPos = width - 27;
        boolean bl = hovered = viewed == null && reader.isMouseOverMenuElement(element, xPos, yPos, mouseX, mouseY, mc);
        if (hovered) {
            viewed = element;
        }
        if (element != this.extraHitbox) {
            this.renderMenuElement(reader, element, matrixStack, gui, xPos, yPos, mouseX, mouseY, 1.0, enabled, hovered, mc, leftMousePressed);
        }
        return viewed;
    }

    public <O> void renderMenuElement(MapElementReader<O, ?, ?> reader, O element, class_4587 matrixStack, class_437 gui, int x, int y, int mouseX, int mouseY, double scale, boolean enabled, boolean hovered, class_310 mc, boolean pressed) {
        matrixStack.method_22903();
        if (hovered) {
            matrixStack.method_22904(pressed ? 1.0 : 2.0, 0.0, 0.0);
        }
        matrixStack.method_22904((double)x, (double)y, 0.0);
        matrixStack.method_22905((float)scale, (float)scale, 1.0f);
        matrixStack.method_22904(-4.0, -4.0, 0.0);
        String name = reader.getMenuName(element);
        int len = mc.field_1772.method_1727(name);
        int textX = -3 - len;
        class_332.method_25294((class_4587)matrixStack, (int)(textX - 2 - reader.getMenuTextFillLeftPadding(element)), (int)-2, (int)(textX + len + 2), (int)11, (int)0x77000000);
        mc.field_1772.method_1720(matrixStack, name, (float)textX, 0.0f, enabled ? -1 : -11184811);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        matrixStack.method_22904(4.0, 4.0, 0.0);
        if (element == this.scrollUp || element == this.scrollDown) {
            this.renderScroll((MapElementMenuScroll)element, matrixStack, gui, mouseX, mouseY, scale, enabled, hovered, mc, pressed);
        } else {
            O elementCast = element;
            this.renderInMenu(elementCast, matrixStack, gui, mouseX, mouseY, scale, enabled, hovered, mc, pressed, textX);
        }
        matrixStack.method_22909();
    }

    public void onMapMouseRelease(double par1, double par2, int par3) {
        this.releaseScroll();
    }

    private void releaseScroll() {
        this.scrollUp.onMouseRelease();
        this.scrollDown.onMouseRelease();
    }

    private void renderScroll(MapElementMenuScroll scroll, class_4587 matrixStack, class_437 gui, int mouseX, int mouseY, double scale, boolean enabled, boolean hovered, class_310 mc, boolean pressed) {
        if (enabled && hovered) {
            matrixStack.method_22904(pressed ? 1.0 : 2.0, 0.0, 0.0);
        }
        matrixStack.method_22904(-4.0, -4.0, 0.0);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int color = enabled ? -1 : -11184811;
        mc.field_1772.method_1720(matrixStack, scroll.getIcon(), (float)(5 - mc.field_1772.method_1727(scroll.getIcon()) / 2), 1.0f, color);
        RenderSystem.enableBlend();
    }

    private void updateSearch() {
        String search = this.filterField.method_1882();
        try {
            this.searchPattern = Pattern.compile(search.toLowerCase());
            if (search.length() > 0) {
                this.searchStartPattern = search.charAt(0) == '^' ? this.searchPattern : Pattern.compile("^" + search.toString().toLowerCase());
            } else {
                this.searchStartPattern = null;
                this.searchPattern = null;
            }
        }
        catch (PatternSyntaxException e) {
            this.searchStartPattern = null;
            this.searchPattern = null;
        }
        this.updateFilteredList();
    }

    public boolean charTyped() {
        return this.filterField.method_25370();
    }

    public boolean keyPressed(GuiMap screen, int keyCode) {
        if (screen.method_25399() == this.filterField) {
            if (keyCode == 257) {
                this.filterField.method_1852("");
            }
            return true;
        }
        return false;
    }

    public void mouseScrolled(int direction) {
        this.scroll(direction);
    }

    public void tick() {
        this.filterField.method_1865();
    }

    public void unfocusAll() {
        if (this.filterField != null) {
            this.filterField.method_1876(false);
        }
    }

    public void onMenuClosed() {
        this.menuOffset = 0;
        this.searchPattern = null;
        this.searchStartPattern = null;
        this.updateFilteredList();
        this.filterField = null;
    }

    private void scroll(int direction) {
        this.menuOffset += direction;
    }

    public Pattern getSearchPattern() {
        return this.searchPattern;
    }

    public Pattern getSearchStartPattern() {
        return this.searchStartPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFilteredList() {
        MapElementRenderProvider<E, C> provider = this.provider;
        if (provider == null) {
            this.filteredElements = null;
            return;
        }
        if (this.filteredElements == null) {
            this.filteredElements = new ArrayList();
        } else {
            this.filteredElements.clear();
        }
        Pattern regex = this.searchPattern;
        Pattern regexStartsWith = this.searchStartPattern;
        this.beforeFiltering();
        provider.begin(4, this.context);
        try {
            while (provider.hasNext(4, this.context)) {
                E e = provider.getNext(4, this.context);
                if (regex == null) {
                    this.filteredElements.add(e);
                    continue;
                }
                String filterName = this.getRenderer(e).getReader().getFilterName(e).toLowerCase();
                if (regexStartsWith.matcher(filterName).find()) {
                    this.filteredElements.add(0, e);
                    continue;
                }
                if (!regex.matcher(filterName).find()) continue;
                this.filteredElements.add(e);
            }
        }
        finally {
            provider.end(4, this.context);
        }
    }

    protected <O> MapElementRenderer<? super O, ?, ?> getAnyRenderer(O element) {
        if (element == this.scrollDown || element == this.scrollUp || element == this.extraHitbox) {
            return null;
        }
        return this.getRenderer(element);
    }

    protected abstract MapElementRenderer<? super E, ?, ?> getRenderer(E var1);

    public abstract int menuStartPos(int var1);

    public abstract int menuSearchPadding();

    public abstract void renderInMenu(E var1, class_4587 var2, class_437 var3, int var4, int var5, double var6, boolean var8, boolean var9, class_310 var10, boolean var11, int var12);

    protected abstract String getFilterPlaceholder();

    protected abstract void beforeFiltering();
}

