/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.element;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.lwjgl.opengl.GL11;
import xaero.map.WorldMap;
import xaero.map.element.HoveredMapElementHolder;
import xaero.map.element.MapElementReader;
import xaero.map.element.MapElementRenderProvider;
import xaero.map.element.MapElementRenderer;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.gui.GuiMap;
import xaero.map.mods.SupportMods;

public class MapElementRenderHandler {
    private final List<MapElementRenderer<?, ?, ?>> renderers;
    protected final int location;
    private HoveredMapElementHolder<?, ?> previousHovered;
    private boolean previousHoveredPresent;
    private boolean renderingHovered;
    private Object workingHovered;
    private MapElementRenderer<?, ?, ?> workingHoveredRenderer;

    private MapElementRenderHandler(List<MapElementRenderer<?, ?, ?>> renderers, int location) {
        this.renderers = renderers;
        this.location = location;
    }

    public void add(MapElementRenderer<?, ?, ?> renderer) {
        this.renderers.add(renderer);
    }

    public static <E, C> HoveredMapElementHolder<E, C> createResult(E hovered, MapElementRenderer<?, ?, ?> hoveredRenderer) {
        MapElementRenderer<?, ?, ?> rendererCast = hoveredRenderer;
        return new HoveredMapElementHolder(hovered, rendererCast);
    }

    private <E> MapElementRenderer<E, ?, ?> getRenderer(HoveredMapElementHolder<E, ?> holder) {
        return holder.getRenderer();
    }

    public HoveredMapElementHolder<?, ?> render(GuiMap mapScreen, class_4587 matrixStack, class_4597.class_4598 renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, double cameraX, double cameraZ, int width, int height, double screenSizeBasedScale, double scale, double playerDimDiv, double mouseX, double mouseZ, float brightness, boolean cave, HoveredMapElementHolder<?, ?> oldHovered, class_310 mc, float partialTicks) {
        class_1060 textureManager = mc.method_1531();
        class_327 fontRenderer = mc.field_1772;
        textureManager.method_22813(WorldMap.guiTextures);
        RenderSystem.setShaderTexture((int)0, (class_2960)WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        double baseScale = 1.0 / scale;
        Collections.sort(this.renderers);
        if (this.previousHovered == null) {
            this.previousHovered = oldHovered;
        }
        this.workingHovered = null;
        this.workingHoveredRenderer = null;
        this.previousHoveredPresent = false;
        matrixStack.method_22903();
        matrixStack.method_22904(0.0, 0.0, -980.0);
        matrixStack.method_22905((float)baseScale, (float)baseScale, 1.0f);
        for (MapElementRenderer<?, ?, ?> renderer : this.renderers) {
            this.renderWithRenderer(renderer, mapScreen, matrixStack, renderTypeBuffers, rendererProvider, textureManager, fontRenderer, cameraX, cameraZ, width, height, screenSizeBasedScale, baseScale, scale, playerDimDiv, mouseX, mouseZ, brightness, cave, oldHovered, mc, true, partialTicks, 0, 0);
        }
        if (this.previousHoveredPresent) {
            this.renderHoveredWithRenderer(this.previousHovered, mapScreen, matrixStack, renderTypeBuffers, rendererProvider, textureManager, fontRenderer, cameraX, cameraZ, width, height, screenSizeBasedScale, baseScale, scale, playerDimDiv, mouseX, mouseZ, brightness, cave, mc, true, partialTicks, 0, 0);
        }
        this.previousHoveredPresent = false;
        int indexLimit = 19490;
        for (MapElementRenderer<?, ?, ?> renderer : this.renderers) {
            int elementIndex = 0;
            elementIndex = this.renderWithRenderer(renderer, mapScreen, matrixStack, renderTypeBuffers, rendererProvider, textureManager, fontRenderer, cameraX, cameraZ, width, height, screenSizeBasedScale, baseScale, scale, playerDimDiv, mouseX, mouseZ, brightness, cave, oldHovered, mc, false, partialTicks, elementIndex, indexLimit);
            matrixStack.method_22904(0.0, 0.0, this.getElementIndexDepth(elementIndex, indexLimit));
            if ((indexLimit -= elementIndex) >= 0) continue;
            indexLimit = 0;
        }
        if (this.previousHoveredPresent) {
            this.renderHoveredWithRenderer(this.previousHovered, mapScreen, matrixStack, renderTypeBuffers, rendererProvider, textureManager, fontRenderer, cameraX, cameraZ, width, height, screenSizeBasedScale, baseScale, scale, playerDimDiv, mouseX, mouseZ, brightness, cave, mc, false, partialTicks, 0, indexLimit);
        }
        matrixStack.method_22909();
        textureManager.method_22813(WorldMap.guiTextures);
        RenderSystem.setShaderTexture((int)0, (class_2960)WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        this.previousHovered = this.previousHovered != null && this.previousHovered.is(this.workingHovered) ? this.previousHovered : (this.workingHovered == null ? null : MapElementRenderHandler.createResult(this.workingHovered, this.workingHoveredRenderer));
        return this.previousHovered;
    }

    private <E, C> int renderHoveredWithRenderer(HoveredMapElementHolder<E, C> hoveredHolder, GuiMap mapScreen, class_4587 matrixStack, class_4597.class_4598 renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, class_1060 textureManager, class_327 font, double cameraX, double cameraZ, int width, int height, double screenSizeBasedScale, double baseScale, double scale, double playerDimDiv, double mouseX, double mouseZ, float brightness, boolean cave, class_310 mc, boolean pre, float partialTicks, int elementIndex, int indexLimit) {
        MapElementRenderer<E, C, ?> renderer = hoveredHolder.getRenderer();
        if (!renderer.shouldRenderHovered(pre)) {
            return elementIndex;
        }
        MapElementReader reader = renderer.reader;
        E hoveredCast = hoveredHolder.getElement();
        renderer.beforeRender(this.location, mc, matrixStack, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, screenSizeBasedScale, textureManager, font, renderTypeBuffers, rendererProvider, pre);
        matrixStack.method_22903();
        if (!pre) {
            matrixStack.method_22904(0.0, 0.0, 1.0);
        }
        double rendererDimDiv = renderer.shouldBeDimScaled() ? playerDimDiv : 1.0;
        this.renderingHovered = true;
        if (!reader.isHidden(hoveredCast, renderer.getContext()) && this.transformAndRenderElement(renderer, hoveredCast, true, mapScreen, matrixStack, renderTypeBuffers, rendererProvider, textureManager, font, cameraX, cameraZ, width, height, screenSizeBasedScale, baseScale, scale, rendererDimDiv, mouseX, mouseZ, brightness, cave, mc, pre, partialTicks, elementIndex, indexLimit) && !pre) {
            ++elementIndex;
        }
        this.renderingHovered = false;
        matrixStack.method_22909();
        renderer.afterRender(this.location, mc, matrixStack, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, screenSizeBasedScale, textureManager, font, renderTypeBuffers, rendererProvider, pre);
        return elementIndex;
    }

    private <E, C, R extends MapElementRenderer<E, C, R>> int renderWithRenderer(MapElementRenderer<E, C, R> renderer, GuiMap mapScreen, class_4587 matrixStack, class_4597.class_4598 renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, class_1060 textureManager, class_327 font, double cameraX, double cameraZ, int width, int height, double screenSizeBasedScale, double baseScale, double scale, double playerDimDiv, double mouseX, double mouseZ, float brightness, boolean cave, HoveredMapElementHolder<?, ?> oldHovered, class_310 mc, boolean pre, float partialTicks, int elementIndex, int indexLimit) {
        int location = this.location;
        if (!renderer.shouldRender(location, pre)) {
            return elementIndex;
        }
        MapElementReader reader = renderer.reader;
        MapElementRenderProvider provider = renderer.provider;
        Object context = renderer.context;
        double rendererDimDiv = renderer.shouldBeDimScaled() ? playerDimDiv : 1.0;
        renderer.beforeRender(location, mc, matrixStack, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, screenSizeBasedScale, textureManager, font, renderTypeBuffers, rendererProvider, pre);
        provider.begin(location, context);
        while (provider.hasNext(location, context)) {
            Object e = provider.setupContextAndGetNext(location, context);
            if (e == null || reader.isHidden(e, context) || !reader.isOnScreen(e, cameraX, cameraZ, width, height, scale, screenSizeBasedScale, rendererDimDiv, context, partialTicks) || !this.transformAndRenderElement(renderer, e, false, mapScreen, matrixStack, renderTypeBuffers, rendererProvider, textureManager, font, cameraX, cameraZ, width, height, screenSizeBasedScale, baseScale, scale, rendererDimDiv, mouseX, mouseZ, brightness, cave, mc, pre, partialTicks, elementIndex, indexLimit) || pre) continue;
            ++elementIndex;
        }
        provider.end(location, context);
        renderer.afterRender(location, mc, matrixStack, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, screenSizeBasedScale, textureManager, font, renderTypeBuffers, rendererProvider, pre);
        return elementIndex;
    }

    private <E, C, R extends MapElementRenderer<E, C, R>> boolean transformAndRenderElement(MapElementRenderer<E, C, R> renderer, E e, boolean highlighted, GuiMap mapScreen, class_4587 matrixStack, class_4597.class_4598 renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, class_1060 textureManager, class_327 font, double cameraX, double cameraZ, int width, int height, double screenSizeBasedScale, double baseScale, double scale, double rendererDimDiv, double mouseX, double mouseZ, float brightness, boolean cave, class_310 mc, boolean pre, float partialTicks, int elementIndex, int indexLimit) {
        MapElementReader reader = renderer.reader;
        Object context = renderer.context;
        if (!this.renderingHovered) {
            if (reader.isInteractable(this.location, e) && reader.isHoveredOnMap(this.location, e, mouseX, mouseZ, scale, screenSizeBasedScale, rendererDimDiv, context, partialTicks)) {
                this.workingHovered = e;
                this.workingHoveredRenderer = renderer;
            }
            if (!this.previousHoveredPresent && this.previousHovered != null && this.previousHovered.is(e)) {
                this.previousHoveredPresent = true;
                return false;
            }
        }
        matrixStack.method_22903();
        double offX = (reader.getRenderX(e, context, partialTicks) / rendererDimDiv - cameraX) / baseScale;
        double offZ = (reader.getRenderZ(e, context, partialTicks) / rendererDimDiv - cameraZ) / baseScale;
        long roundedOffX = Math.round(offX);
        long roundedOffZ = Math.round(offZ);
        double partialX = offX - (double)roundedOffX;
        double partialY = offZ - (double)roundedOffZ;
        matrixStack.method_22904((double)roundedOffX, (double)roundedOffZ, 0.0);
        boolean result = false;
        if (pre) {
            renderer.renderElementPre(this.location, e, highlighted, mc, matrixStack, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, screenSizeBasedScale, textureManager, font, renderTypeBuffers, rendererProvider, (float)screenSizeBasedScale, partialX, partialY, cave, partialTicks);
        } else {
            double optionalDepth = this.getElementIndexDepth(elementIndex, indexLimit);
            result = renderer.renderElement(this.location, e, highlighted, mc, matrixStack, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, screenSizeBasedScale, textureManager, font, renderTypeBuffers, rendererProvider, elementIndex, optionalDepth, (float)screenSizeBasedScale, partialX, partialY, cave, partialTicks);
        }
        matrixStack.method_22909();
        return result;
    }

    private double getElementIndexDepth(int elementIndex, int indexLimit) {
        return (double)(elementIndex >= indexLimit ? indexLimit : elementIndex) * 0.1;
    }

    public static final class Builder {
        private Builder() {
        }

        public MapElementRenderHandler build() {
            ArrayList renderers = new ArrayList();
            if (SupportMods.minimap()) {
                renderers.add(SupportMods.xaeroMinimap.getWaypointRenderer());
            }
            renderers.add(WorldMap.trackedPlayerRenderer);
            if (SupportMods.pac()) {
                renderers.add(SupportMods.xaeroPac.getCaimResultElementRenderer());
            }
            return new MapElementRenderHandler(renderers, 3);
        }

        public static Builder begin() {
            return new Builder();
        }
    }
}

