/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.api.util;

import chronosacaria.mcdw.api.util.AbilityHelper;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.damagesource.ElectricShockDamageSource;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class AOEHelper {
    public static List<class_1309> getAoeTargets(class_1309 center, class_1309 attacker, float distance) {
        return center.method_5770().method_8390(class_1309.class, new class_238(center.method_24515()).method_1014((double)distance), nearbyEntity -> AbilityHelper.isAoeTarget(nearbyEntity, attacker, center));
    }

    public static boolean satisfySweepConditions(class_1309 attackingEntity, class_1297 targetEntity, class_1309 collateralEntity, float distanceToCollateral) {
        class_1531 armorStand;
        return collateralEntity != attackingEntity && collateralEntity != targetEntity && !attackingEntity.method_5722((class_1297)collateralEntity) && (!(collateralEntity instanceof class_1531) || !(armorStand = (class_1531)collateralEntity).method_6912()) && attackingEntity.method_5739((class_1297)collateralEntity) < distanceToCollateral;
    }

    public static void pullTowards(class_1297 self, class_1297 target) {
        if (self instanceof class_1657 && ((class_1657)self).method_31549().field_7477) {
            return;
        }
        double motionX = class_3532.method_15350((double)((target.method_23317() - self.method_23317()) * (double)0.15f), (double)-5.0, (double)5.0);
        double motionZ = class_3532.method_15350((double)((target.method_23321() - self.method_23321()) * (double)0.15f), (double)-5.0, (double)5.0);
        class_243 vec3d = new class_243(motionX, 0.0, motionZ);
        self.method_18799(vec3d);
    }

    public static void pullInNearbyEntities(class_1309 user, class_1309 target, float distance) {
        AOEHelper.getAoeTargets(target, user, distance).stream().filter(nearbyEntity -> nearbyEntity != target).forEach(nearbyEntity -> AOEHelper.pullTowards((class_1297)nearbyEntity, (class_1297)target));
    }

    public static void createVisualLightningBoltOnEntity(class_1297 target) {
        class_1937 world = target.method_5770();
        class_1538 lightningEntity = (class_1538)class_1299.field_6112.method_5883(world);
        if (lightningEntity != null) {
            lightningEntity.method_24203(target.method_23317(), target.method_23318(), target.method_23321());
            lightningEntity.method_29498(true);
            world.method_8649((class_1297)lightningEntity);
        }
    }

    public static void electrocute(class_1309 attacker, class_1309 victim, float damageAmount) {
        AOEHelper.createVisualLightningBoltOnEntity((class_1297)victim);
        class_1282 electricShockDamageSource = new ElectricShockDamageSource((class_1297)attacker).method_5515();
        victim.method_5643(electricShockDamageSource, damageAmount);
    }

    public static void electrocuteNearbyEnemies(class_1309 user, float distance, float damageAmount, int limit) {
        CleanlinessHelper.playCenteredSound(user, class_3417.field_14865, class_3419.field_15252, 1.0f, 1.0f);
        CleanlinessHelper.playCenteredSound(user, class_3417.field_14956, class_3419.field_15252, 1.0f, 1.0f);
        for (class_1309 nearbyEntity : AOEHelper.getAoeTargets(user, user, distance)) {
            AOEHelper.electrocute(user, nearbyEntity, damageAmount);
            if (--limit > 0) continue;
            break;
        }
    }

    public static void causeExplosionAttack(class_1309 user, class_1309 target, float damageAmount, float distance) {
        AOEHelper.getAoeTargets(target, user, distance).forEach(nearbyEntity -> nearbyEntity.method_5643(class_1282.method_5512((class_1309)user), damageAmount));
    }

    public static void chainNearbyEntities(class_1309 user, class_1309 target, float distance, int timeMultiplier) {
        class_1293 chained = new class_1293(class_1294.field_5909, 100 * timeMultiplier, 100);
        target.method_6092(chained);
        AOEHelper.getAoeTargets(target, user, distance).stream().filter(nearbyEntity -> nearbyEntity != target).forEach(nearbyEntity -> {
            AOEHelper.pullTowards((class_1297)nearbyEntity, (class_1297)target);
            nearbyEntity.method_6092(chained);
        });
    }

    public static void causeEchoAttack(class_1309 user, class_1309 target, float distance, int echoLevel, float amount) {
        for (class_1309 nearbyEntity : AOEHelper.getAoeTargets(target, user, distance)) {
            if (nearbyEntity == target) continue;
            nearbyEntity.method_5643(class_1282.field_5869, amount);
            if (--echoLevel > 0) continue;
            break;
        }
    }

    public static void causeSwirlingAttack(class_1309 user, class_1309 target, float distance, float amount) {
        AOEHelper.getAoeTargets(target, user, distance).forEach(nearbyEntity -> nearbyEntity.method_5643(class_1282.field_5869, amount * 0.5f));
    }

    public static void causeShockwaveAttack(class_1309 user, class_1309 target, float distance, float amount) {
        AOEHelper.getAoeTargets(target, user, distance).stream().filter(nearbyEntity -> nearbyEntity != target).forEach(nearbyEntity -> nearbyEntity.method_5643(class_1282.field_5869, amount * 0.25f));
    }

    public static void causeSmitingAttack(class_1309 user, class_1309 target, float distance, float amount) {
        AOEHelper.getAoeTargets(target, user, distance).stream().filter(nearbyEntity -> nearbyEntity != target && nearbyEntity.method_5999()).forEach(nearbyEntity -> nearbyEntity.method_5643(class_1282.field_5846, amount * 1.25f));
    }
}

