/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.bases.McdwDagger;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.IMcdwWeaponID;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.items.ItemsInit;
import java.util.EnumMap;
import java.util.HashMap;
import net.minecraft.class_1834;

public enum DaggersID implements IMcdwWeaponID,
IMeleeWeaponID
{
    DAGGER_BACKSTABBER(class_1834.field_8930, 1, -1.7f, "minecraft:diamond"),
    DAGGER_CHILL_GALE_KNIFE(class_1834.field_8930, 2, -2.2f, "minecraft:diamond"),
    DAGGER_DAGGER(class_1834.field_8923, 1, -1.5f, "minecraft:iron_ingot"),
    DAGGER_FANGS_OF_FROST(class_1834.field_8923, 1, -1.5f, "minecraft:iron_ingot"),
    DAGGER_MOON(class_1834.field_8923, 1, -1.5f, "minecraft:iron_ingot"),
    DAGGER_RESOLUTE_TEMPEST_KNIFE(class_1834.field_8923, 2, -2.2f, "minecraft:iron_ingot"),
    DAGGER_SHEAR_DAGGER(class_1834.field_8923, 0, -1.5f, "minecraft:iron_ingot"),
    DAGGER_SWIFT_STRIKER(class_1834.field_22033, 1, -1.7f, "minecraft:netherite_scrap"),
    DAGGER_TEMPEST_KNIFE(class_1834.field_8923, 2, -2.2f, "minecraft:iron_ingot"),
    DAGGER_THE_BEGINNING(class_1834.field_22033, 1, -1.8f, "minecraft:netherite_scrap"),
    DAGGER_THE_END(class_1834.field_22033, 1, -1.8f, "minecraft:netherite_scrap"),
    DAGGER_VOID_TOUCHED_BLADE(class_1834.field_8930, 1, -1.8f, "minecraft:diamond");

    private final class_1834 material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private DaggersID(class_1834 material, int damage, float attackSpeed, String ... repairIngredient) {
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static HashMap<DaggersID, Boolean> getEnabledItems() {
        return Mcdw.CONFIG.mcdwEnableItemsConfig.DAGGERS_ENABLED;
    }

    public static EnumMap<DaggersID, McdwDagger> getItemsEnum() {
        return ItemsInit.DAGGER_ITEMS;
    }

    public static HashMap<DaggersID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.DAGGER_SPAWN_RATES;
    }

    public static HashMap<DaggersID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.daggerStats;
    }

    @Override
    public Boolean isEnabled() {
        return DaggersID.getEnabledItems().get(this);
    }

    public McdwDagger getItem() {
        return DaggersID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return DaggersID.getSpawnRates().get(this);
    }

    public HashMap<DaggersID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.daggerStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return DaggersID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.daggerStats.get(this);
    }

    public class_1834 getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    public McdwDagger makeWeapon() {
        McdwDagger mcdwDagger = new McdwDagger(ItemsInit.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        DaggersID.getItemsEnum().put(this, mcdwDagger);
        return mcdwDagger;
    }
}

