/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.bases.McdwHammer;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.IMcdwWeaponID;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.items.ItemsInit;
import java.util.EnumMap;
import java.util.HashMap;
import net.minecraft.class_1832;
import net.minecraft.class_1834;

public enum HammersID implements IMcdwWeaponID,
IMeleeWeaponID
{
    HAMMER_BONECLUB((class_1832)class_1834.field_8923, 7, -3.2f, "minecraft:bone_block"),
    HAMMER_BONE_CUDGEL((class_1832)class_1834.field_22033, 7, -3.2f, "minecraft:netherite_scrap"),
    HAMMER_FLAIL((class_1832)class_1834.field_8923, 5, -2.8f, "minecraft:iron_ingot"),
    HAMMER_GRAVITY((class_1832)class_1834.field_8930, 6, -3.2f, "minecraft:diamond"),
    HAMMER_GREAT_HAMMER((class_1832)class_1834.field_8923, 6, -3.2f, "minecraft:iron_ingot"),
    HAMMER_MACE((class_1832)class_1834.field_8923, 5, -2.8f, "minecraft:iron_ingot"),
    HAMMER_STORMLANDER((class_1832)class_1834.field_8930, 7, -3.2f, "minecraft:diamond"),
    HAMMER_SUNS_GRACE((class_1832)class_1834.field_8930, 4, -2.8f, "minecraft:diamond");

    private final class_1832 material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private HammersID(class_1832 material, int damage, float attackSpeed, String ... repairIngredient) {
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static HashMap<HammersID, Boolean> getEnabledItems() {
        return Mcdw.CONFIG.mcdwEnableItemsConfig.HAMMERS_ENABLED;
    }

    public static EnumMap<HammersID, McdwHammer> getItemsEnum() {
        return ItemsInit.HAMMER_ITEMS;
    }

    public static HashMap<HammersID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.HAMMER_SPAWN_RATES;
    }

    public static HashMap<HammersID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.hammerStats;
    }

    @Override
    public Boolean isEnabled() {
        return HammersID.getEnabledItems().get(this);
    }

    public McdwHammer getItem() {
        return HammersID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return HammersID.getSpawnRates().get(this);
    }

    public HashMap<HammersID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.hammerStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return HammersID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.hammerStats.get(this);
    }

    @Override
    public class_1832 getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    public McdwHammer makeWeapon() {
        McdwHammer mcdwHammer = new McdwHammer(ItemsInit.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        HammersID.getItemsEnum().put(this, mcdwHammer);
        return mcdwHammer;
    }
}

