/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.mixin;

import chronosacaria.mcdw.api.interfaces.IDualWielding;
import chronosacaria.mcdw.configs.CompatibilityFlags;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements IDualWielding {
    private static final class_2940<Integer> LAST_ATTACKED_OFFHAND_TICKS = class_2945.method_12791(PlayerEntityMixin.class, (class_2941)class_2943.field_13327);

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    public float getOffhandAttackCooldownProgressPerTick() {
        return (float)(1.0 / this.method_26825(class_5134.field_23723) * 20.0);
    }

    @Override
    public float getOffhandAttackCooldownProgress(float baseTime) {
        return class_3532.method_15363((float)(((float)this.getOffhandAttackedTicks() + baseTime) / this.getOffhandAttackCooldownProgressPerTick()), (float)0.0f, (float)1.0f);
    }

    @Override
    public void resetLastAttackedOffhandTicks() {
        this.setOffhandAttackedTicks(0);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getMainHandStack()Lnet/minecraft/item/ItemStack;")})
    public void tick(CallbackInfo ci) {
        if (CompatibilityFlags.noOffhandConflicts) {
            this.setOffhandAttackedTicks(this.getOffhandAttackedTicks() + 1);
        }
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    protected void injectInitDataTracker(CallbackInfo ci) {
        if (CompatibilityFlags.noOffhandConflicts) {
            this.field_6011.method_12784(LAST_ATTACKED_OFFHAND_TICKS, (Object)0);
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    public void injectWriteCustomDataToNbt(class_2487 nbt, CallbackInfo ci) {
        if (CompatibilityFlags.noOffhandConflicts) {
            nbt.method_10569("LastAttackedOffhandTicks", this.getOffhandAttackedTicks());
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="RETURN")})
    public void injectReadCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        if (CompatibilityFlags.noOffhandConflicts) {
            this.setOffhandAttackedTicks(nbt.method_10550("LastAttackedOffhandTicks"));
        }
    }

    @Override
    public int getOffhandAttackedTicks() {
        if (CompatibilityFlags.noOffhandConflicts) {
            return (Integer)this.field_6011.method_12789(LAST_ATTACKED_OFFHAND_TICKS);
        }
        return 0;
    }

    @Override
    public void setOffhandAttackedTicks(int lastAttackedOffhandTicks) {
        if (CompatibilityFlags.noOffhandConflicts && lastAttackedOffhandTicks >= 0) {
            this.field_6011.method_12778(LAST_ATTACKED_OFFHAND_TICKS, (Object)lastAttackedOffhandTicks);
        }
    }
}

