/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.element.render.over;

import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import xaero.common.HudMod;
import xaero.common.minimap.element.render.MinimapElementRendererHandler;
import xaero.hud.minimap.element.render.MinimapElementRenderInfo;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;
import xaero.hud.minimap.element.render.MinimapElementRenderer;
import xaero.hud.minimap.element.render.MinimapElementRendererHandler;

public class MinimapElementOverMapRendererHandler
extends MinimapElementRendererHandler {
    private double ps;
    private double pc;
    private double zoom;
    private int halfViewW;
    private int halfViewH;
    private int specW;
    private int specH;
    private boolean circle;
    private float optionalScale;
    private final double[] partialTranslate;

    protected MinimapElementOverMapRendererHandler(HudMod modMain, List<MinimapElementRenderer<?, ?>> renderers, double[] partialTranslate) {
        super(modMain, renderers, MinimapElementRenderLocation.OVER_MINIMAP, 9800);
        this.partialTranslate = partialTranslate;
    }

    public void prepareRender(double ps, double pc, double zoom, int specW, int specH, int halfViewW, int halfViewH, boolean circle, float minimapScale) {
        this.ps = ps;
        this.pc = pc;
        this.zoom = zoom;
        this.specW = specW;
        this.specH = specH;
        this.halfViewW = halfViewW;
        this.halfViewH = halfViewH;
        this.circle = circle;
        this.optionalScale = minimapScale;
    }

    @Override
    protected <E, RRC, RR extends MinimapElementRenderer<E, RRC>> boolean transformAndRenderForRenderer(E element, double elementX, double elementY, double elementZ, RR renderer, RRC context, int elementIndex, double optionalDepth, MinimapElementRenderInfo renderInfo, class_4587 matrixStack, class_4597.class_4598 vanillaBufferSource) {
        class_243 renderPos = renderInfo.renderPos;
        double offx = elementX - renderPos.field_1352;
        double offy = elementZ - renderPos.field_1350;
        matrixStack.method_22903();
        boolean outOfBounds = MinimapElementOverMapRendererHandler.translatePosition(matrixStack, this.specW, this.specH, this.halfViewW, this.halfViewH, this.ps, this.pc, offx, offy, this.zoom, this.circle, this.partialTranslate);
        boolean result = renderer.renderElement(element, false, outOfBounds, optionalDepth, this.optionalScale, this.partialTranslate[0], this.partialTranslate[1], renderInfo, matrixStack, vanillaBufferSource);
        matrixStack.method_22909();
        return result;
    }

    @Override
    protected void beforeRender(class_4587 matrixStack, MinimapElementRenderInfo renderInfo, class_4597.class_4598 vanillaBufferSource) {
    }

    @Override
    protected void afterRender(class_4587 matrixStack, MinimapElementRenderInfo renderInfo, class_4597.class_4598 vanillaBufferSource) {
    }

    public static boolean translatePosition(class_4587 matrixStack, int specW, int specH, int halfViewW, int halfViewH, double ps, double pc, double offx, double offy, double zoom, boolean circle, double[] partialTranslate) {
        double X;
        boolean outOfBounds = false;
        double Y = (pc * offx + ps * offy) * zoom;
        double borderedX = X = (ps * offx - pc * offy) * zoom;
        double borderedY = Y;
        if (!circle) {
            if (borderedX > (double)specW) {
                borderedX = specW;
                borderedY = Y * (double)specW / X;
                outOfBounds = true;
            } else if (borderedX < (double)(-specW)) {
                borderedX = -specW;
                borderedY = -Y * (double)specW / X;
                outOfBounds = true;
            }
            if (borderedY > (double)specH) {
                borderedY = specH;
                borderedX = X * (double)specH / Y;
                outOfBounds = true;
            } else if (borderedY < (double)(-specH)) {
                borderedY = -specH;
                borderedX = -X * (double)specH / Y;
                outOfBounds = true;
            }
            if (!outOfBounds && (borderedX > (double)halfViewW || borderedX < (double)(-halfViewW) || borderedY > (double)halfViewH || borderedY < (double)(-halfViewH))) {
                outOfBounds = true;
            }
        } else {
            double distSquared = borderedX * borderedX + borderedY * borderedY;
            double maxDistSquared = specW * specW;
            if (distSquared > maxDistSquared) {
                double scaleDown = Math.sqrt(maxDistSquared / distSquared);
                borderedX *= scaleDown;
                borderedY *= scaleDown;
                outOfBounds = true;
            }
            if (!outOfBounds && distSquared > (double)(halfViewW * halfViewW)) {
                outOfBounds = true;
            }
        }
        long roundedX = Math.round(borderedX);
        long roundedY = Math.round(borderedY);
        partialTranslate[0] = borderedX - (double)roundedX;
        partialTranslate[1] = borderedY - (double)roundedY;
        matrixStack.method_22904((double)roundedX, (double)roundedY, 0.0);
        return outOfBounds;
    }

    public static final class Builder
    extends MinimapElementRendererHandler.Builder {
        @Override
        public xaero.common.minimap.element.render.over.MinimapElementOverMapRendererHandler build() {
            return (xaero.common.minimap.element.render.over.MinimapElementOverMapRendererHandler)super.build();
        }

        @Override
        protected xaero.common.minimap.element.render.over.MinimapElementOverMapRendererHandler buildInternally(List<MinimapElementRenderer<?, ?>> renderers) {
            return new xaero.common.minimap.element.render.over.MinimapElementOverMapRendererHandler(HudMod.INSTANCE, renderers, new double[2]);
        }

        @Override
        protected Builder setDefault() {
            super.setDefault();
            return this;
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

