/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_forge.functions;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.natamus.collective_common_forge.data.GlobalVariables;
import com.natamus.collective_common_forge.functions.DataFunctions;
import com.natamus.collective_common_forge.functions.UUIDFunctions;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class HeadFunctions {
    public static ItemStack getPlayerHead(String playername, Integer amount) {
        String nameIdJsonString = DataFunctions.readStringFromURL(GlobalVariables.playerdataurl + playername.toLowerCase());
        if (nameIdJsonString.equals("")) {
            return null;
        }
        try {
            Map nameIdJson = (Map)new Gson().fromJson(nameIdJsonString, new TypeToken<HashMap<String, String>>(){}.getType());
            String headName = (String)nameIdJson.get("name");
            String headUUID = (String)nameIdJson.get("id");
            String profileJsonString = DataFunctions.readStringFromURL(GlobalVariables.skindataurl + headUUID);
            if (profileJsonString.equals("")) {
                return null;
            }
            String[] rawValue = profileJsonString.replaceAll(" ", "").split("value\":\"");
            String texturevalue = rawValue[1].split("\"")[0];
            String d = new String(Base64.getDecoder().decode(texturevalue.getBytes()));
            String texture = Base64.getEncoder().encodeToString(("{\"textures\"" + d.split("\"textures\"")[1]).getBytes());
            String oldid = new UUID(texture.hashCode(), texture.hashCode()).toString();
            return HeadFunctions.getTexturedHead(headName + "'s Head", texture, oldid, 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public static ItemStack getTexturedHead(String headname, String texture, String oldid, Integer amount) {
        ItemStack texturedhead = new ItemStack((ItemLike)Items.f_42680_, amount.intValue());
        List<Integer> intarray = UUIDFunctions.oldIdToIntArray(oldid);
        CompoundTag skullOwner = new CompoundTag();
        skullOwner.m_128408_("Id", intarray);
        CompoundTag properties = new CompoundTag();
        ListTag textures = new ListTag();
        CompoundTag tex = new CompoundTag();
        tex.m_128359_("Value", texture);
        textures.add((Object)tex);
        properties.m_128365_("textures", (Tag)textures);
        skullOwner.m_128365_("Properties", (Tag)properties);
        texturedhead.m_41700_("SkullOwner", (Tag)skullOwner);
        TextComponent tcname = new TextComponent(headname);
        texturedhead.m_41714_((Component)tcname);
        return texturedhead;
    }

    public static boolean hasStandardHead(String mobname) {
        return mobname.equals("creeper") || mobname.equals("zombie") || mobname.equals("skeleton");
    }
}

