/*
 * Decompiled with CFR 0.152.
 */
package carpet.logging;

import carpet.CarpetServer;
import carpet.CarpetSettings;
import carpet.logging.HUDLogger;
import carpet.logging.Logger;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1767;

public class LoggerRegistry {
    private static Map<String, Logger> loggerRegistry = new HashMap<String, Logger>();
    private static Map<String, Map<String, String>> playerSubscriptions = new HashMap<String, Map<String, String>>();
    public static boolean __tnt;
    public static boolean __projectiles;
    public static boolean __fallingBlocks;
    public static boolean __tps;
    public static boolean __counter;
    public static boolean __mobcaps;
    public static boolean __packets;
    public static boolean __pathfinding;
    public static boolean __explosions;
    public static boolean __updateSuppressedCrashes;
    private static Set<String> seenPlayers;

    public static void initLoggers() {
        LoggerRegistry.stopLoggers();
        LoggerRegistry.registerLoggers();
        CarpetServer.registerExtensionLoggers();
    }

    public static void registerLoggers() {
        LoggerRegistry.registerLogger("tnt", Logger.stardardLogger("tnt", "brief", new String[]{"brief", "full"}, true));
        LoggerRegistry.registerLogger("projectiles", Logger.stardardLogger("projectiles", "brief", new String[]{"brief", "full"}));
        LoggerRegistry.registerLogger("fallingBlocks", Logger.stardardLogger("fallingBlocks", "brief", new String[]{"brief", "full"}));
        LoggerRegistry.registerLogger("pathfinding", Logger.stardardLogger("pathfinding", "20", new String[]{"2", "5", "10"}));
        LoggerRegistry.registerLogger("tps", HUDLogger.stardardHUDLogger("tps", null, null));
        LoggerRegistry.registerLogger("packets", HUDLogger.stardardHUDLogger("packets", null, null));
        LoggerRegistry.registerLogger("counter", HUDLogger.stardardHUDLogger("counter", "white", (String[])Arrays.stream(class_1767.values()).map(Object::toString).toArray(String[]::new)));
        LoggerRegistry.registerLogger("mobcaps", HUDLogger.stardardHUDLogger("mobcaps", "dynamic", new String[]{"dynamic", "overworld", "nether", "end"}));
        LoggerRegistry.registerLogger("explosions", Logger.stardardLogger("explosions", "brief", new String[]{"brief", "full"}, true));
        LoggerRegistry.registerLogger("updateSuppressedCrashes", Logger.stardardLogger("updateSuppressedCrashes", null, null));
    }

    public static Logger getLogger(String name) {
        return loggerRegistry.get(name);
    }

    public static Set<String> getLoggerNames() {
        return loggerRegistry.keySet();
    }

    public static void subscribePlayer(String playerName, String logName, String option) {
        if (!playerSubscriptions.containsKey(playerName)) {
            playerSubscriptions.put(playerName, new HashMap());
        }
        Logger log = loggerRegistry.get(logName);
        if (option == null) {
            option = log.getDefault();
        }
        playerSubscriptions.get(playerName).put(logName, option);
        log.addPlayer(playerName, option);
    }

    public static void unsubscribePlayer(String playerName, String logName) {
        if (playerSubscriptions.containsKey(playerName)) {
            Map<String, String> subscriptions = playerSubscriptions.get(playerName);
            subscriptions.remove(logName);
            loggerRegistry.get(logName).removePlayer(playerName);
            if (subscriptions.size() == 0) {
                playerSubscriptions.remove(playerName);
            }
        }
    }

    public static boolean togglePlayerSubscription(String playerName, String logName) {
        if (playerSubscriptions.containsKey(playerName) && playerSubscriptions.get(playerName).containsKey(logName)) {
            LoggerRegistry.unsubscribePlayer(playerName, logName);
            return false;
        }
        LoggerRegistry.subscribePlayer(playerName, logName, null);
        return true;
    }

    public static Map<String, String> getPlayerSubscriptions(String playerName) {
        if (playerSubscriptions.containsKey(playerName)) {
            return playerSubscriptions.get(playerName);
        }
        return null;
    }

    protected static void setAccess(Logger logger) {
        String name = logger.getLogName();
        boolean value = logger.hasOnlineSubscribers();
        try {
            Field f = logger.getField();
            f.setBoolean(null, value);
        }
        catch (IllegalAccessException e) {
            CarpetSettings.LOG.error("Cannot change logger quick access field");
        }
    }

    public static void registerLogger(String name, Logger logger) {
        loggerRegistry.put(name, logger);
        LoggerRegistry.setAccess(logger);
    }

    public static void stopLoggers() {
        for (Logger log : loggerRegistry.values()) {
            log.serverStopped();
        }
        seenPlayers.clear();
        loggerRegistry.clear();
        playerSubscriptions.clear();
    }

    public static void playerConnected(class_1657 player) {
        boolean firstTime = false;
        if (!seenPlayers.contains(player.method_5477().getString())) {
            seenPlayers.add(player.method_5477().getString());
            firstTime = true;
        }
        for (Logger log : loggerRegistry.values()) {
            log.onPlayerConnect(player, firstTime);
        }
    }

    public static void playerDisconnected(class_1657 player) {
        for (Logger log : loggerRegistry.values()) {
            log.onPlayerDisconnect(player);
        }
    }

    static {
        seenPlayers = new HashSet<String>();
    }
}

