/*
 * Decompiled with CFR 0.152.
 */
package carpet.network;

import carpet.CarpetServer;
import carpet.CarpetSettings;
import carpet.helpers.TickSpeed;
import carpet.network.CarpetClient;
import carpet.script.utils.SnoopyCommandSource;
import carpet.settings.ParsedRule;
import carpet.settings.SettingsManager;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_3222;

public class ServerNetworkHandler {
    private static Map<class_3222, String> remoteCarpetPlayers = new HashMap<class_3222, String>();
    private static Set<class_3222> validCarpetPlayers = new HashSet<class_3222>();
    private static Map<String, BiConsumer<class_3222, class_2520>> dataHandlers = new HashMap<String, BiConsumer<class_3222, class_2520>>(){
        {
            this.put("clientCommand", (p, t) -> ServerNetworkHandler.handleClientCommand(p, (class_2487)t));
        }
    };

    public static void handleData(class_2540 data, class_3222 player) {
        if (data != null) {
            int id = data.method_10816();
            if (id == 420) {
                ServerNetworkHandler.onHello(player, data);
            }
            if (id == 1) {
                ServerNetworkHandler.onClientData(player, data);
            }
        }
    }

    public static void onPlayerJoin(class_3222 playerEntity) {
        if (!playerEntity.field_13987.field_14127.method_10756()) {
            playerEntity.field_13987.method_14364((class_2596)new class_2658(CarpetClient.CARPET_CHANNEL, new class_2540(Unpooled.buffer()).method_10804(69).method_10814("1.4.69+v220331")));
        } else {
            validCarpetPlayers.add(playerEntity);
        }
    }

    public static void onHello(class_3222 playerEntity, class_2540 packetData) {
        validCarpetPlayers.add(playerEntity);
        String clientVersion = packetData.method_10800(64);
        remoteCarpetPlayers.put(playerEntity, clientVersion);
        if (clientVersion.equals("1.4.69+v220331")) {
            CarpetSettings.LOG.info("Player " + playerEntity.method_5477().getString() + " joined with a matching carpet client");
        } else {
            CarpetSettings.LOG.warn("Player " + playerEntity.method_5477().getString() + " joined with another carpet version: " + clientVersion);
        }
        DataBuilder data = DataBuilder.create().withTickRate().withFrozenState().withTickPlayerActiveTimeout();
        CarpetServer.settingsManager.getRules().forEach(data::withRule);
        CarpetServer.extensions.forEach(e -> {
            SettingsManager eManager = e.customSettingsManager();
            if (eManager != null) {
                eManager.getRules().forEach(data::withRule);
            }
        });
        playerEntity.field_13987.method_14364((class_2596)new class_2658(CarpetClient.CARPET_CHANNEL, data.build()));
    }

    private static void handleClientCommand(class_3222 player, class_2487 commandData) {
        String command = commandData.method_10558("command");
        String id = commandData.method_10558("id");
        ArrayList<class_2561> output = new ArrayList<class_2561>();
        class_2561[] error = new class_2561[]{null};
        int resultCode = -1;
        if (player.method_5682() == null) {
            error[0] = new class_2585("No Server");
        } else {
            resultCode = player.method_5682().method_3734().method_9249((class_2168)new SnoopyCommandSource(player, error, output), command);
        }
        class_2487 result = new class_2487();
        result.method_10582("id", id);
        result.method_10569("code", resultCode);
        if (error[0] != null) {
            result.method_10582("error", error[0].method_10851());
        }
        class_2499 outputResult = new class_2499();
        for (class_2561 line : output) {
            outputResult.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)line)));
        }
        if (!output.isEmpty()) {
            result.method_10566("output", (class_2520)outputResult);
        }
        player.field_13987.method_14364((class_2596)new class_2658(CarpetClient.CARPET_CHANNEL, DataBuilder.create().withCustomNbt("clientCommand", (class_2520)result).build()));
    }

    private static void onClientData(class_3222 player, class_2540 data) {
        class_2487 compound = data.method_10798();
        if (compound == null) {
            return;
        }
        for (String key : compound.method_10541()) {
            if (dataHandlers.containsKey(key)) {
                dataHandlers.get(key).accept(player, compound.method_10580(key));
                continue;
            }
            CarpetSettings.LOG.warn("Unknown carpet client data: " + key);
        }
    }

    public static void updateRuleWithConnectedClients(ParsedRule<?> rule) {
        if (CarpetSettings.superSecretSetting) {
            return;
        }
        for (class_3222 player : remoteCarpetPlayers.keySet()) {
            player.field_13987.method_14364((class_2596)new class_2658(CarpetClient.CARPET_CHANNEL, DataBuilder.create().withRule(rule).build()));
        }
    }

    public static void updateTickSpeedToConnectedPlayers() {
        if (CarpetSettings.superSecretSetting) {
            return;
        }
        for (class_3222 player : remoteCarpetPlayers.keySet()) {
            player.field_13987.method_14364((class_2596)new class_2658(CarpetClient.CARPET_CHANNEL, DataBuilder.create().withTickRate().build()));
        }
    }

    public static void updateFrozenStateToConnectedPlayers() {
        if (CarpetSettings.superSecretSetting) {
            return;
        }
        for (class_3222 player : remoteCarpetPlayers.keySet()) {
            player.field_13987.method_14364((class_2596)new class_2658(CarpetClient.CARPET_CHANNEL, DataBuilder.create().withFrozenState().build()));
        }
    }

    public static void updateSuperHotStateToConnectedPlayers() {
        if (CarpetSettings.superSecretSetting) {
            return;
        }
        for (class_3222 player : remoteCarpetPlayers.keySet()) {
            player.field_13987.method_14364((class_2596)new class_2658(CarpetClient.CARPET_CHANNEL, DataBuilder.create().withSuperHotState().build()));
        }
    }

    public static void updateTickPlayerActiveTimeoutToConnectedPlayers() {
        if (CarpetSettings.superSecretSetting) {
            return;
        }
        for (class_3222 player : remoteCarpetPlayers.keySet()) {
            player.field_13987.method_14364((class_2596)new class_2658(CarpetClient.CARPET_CHANNEL, DataBuilder.create().withTickPlayerActiveTimeout().build()));
        }
    }

    public static void broadcastCustomCommand(String command, class_2520 data) {
        if (CarpetSettings.superSecretSetting) {
            return;
        }
        for (class_3222 player : validCarpetPlayers) {
            player.field_13987.method_14364((class_2596)new class_2658(CarpetClient.CARPET_CHANNEL, DataBuilder.create().withCustomNbt(command, data).build()));
        }
    }

    public static void sendCustomCommand(class_3222 player, String command, class_2520 data) {
        if (ServerNetworkHandler.isValidCarpetPlayer(player)) {
            player.field_13987.method_14364((class_2596)new class_2658(CarpetClient.CARPET_CHANNEL, DataBuilder.create().withCustomNbt(command, data).build()));
        }
    }

    public static void onPlayerLoggedOut(class_3222 player) {
        validCarpetPlayers.remove(player);
        if (!player.field_13987.field_14127.method_10756()) {
            remoteCarpetPlayers.remove(player);
        }
    }

    public static void close() {
        remoteCarpetPlayers.clear();
        validCarpetPlayers.clear();
    }

    public static boolean isValidCarpetPlayer(class_3222 player) {
        if (CarpetSettings.superSecretSetting) {
            return false;
        }
        return validCarpetPlayers.contains(player);
    }

    public static String getPlayerStatus(class_3222 player) {
        if (remoteCarpetPlayers.containsKey(player)) {
            return "carpet " + remoteCarpetPlayers.get(player);
        }
        if (validCarpetPlayers.contains(player)) {
            return "carpet 1.4.69+v220331";
        }
        return "vanilla";
    }

    private static class DataBuilder {
        private class_2487 tag = new class_2487();

        private static DataBuilder create() {
            return new DataBuilder();
        }

        private DataBuilder() {
        }

        private DataBuilder withTickRate() {
            this.tag.method_10548("TickRate", TickSpeed.tickrate);
            return this;
        }

        private DataBuilder withFrozenState() {
            class_2487 tickingState = new class_2487();
            tickingState.method_10556("is_paused", TickSpeed.isPaused());
            tickingState.method_10556("deepFreeze", TickSpeed.deeplyFrozen());
            this.tag.method_10566("TickingState", (class_2520)tickingState);
            return this;
        }

        private DataBuilder withSuperHotState() {
            this.tag.method_10556("SuperHotState", TickSpeed.is_superHot);
            return this;
        }

        private DataBuilder withTickPlayerActiveTimeout() {
            this.tag.method_10569("TickPlayerActiveTimeout", TickSpeed.player_active_timeout);
            return this;
        }

        private DataBuilder withRule(ParsedRule<?> rule) {
            class_2487 rules = (class_2487)this.tag.method_10580("Rules");
            if (rules == null) {
                rules = new class_2487();
                this.tag.method_10566("Rules", (class_2520)rules);
            }
            String identifier = rule.settingsManager.getIdentifier();
            Object key = rule.name;
            while (rules.method_10545((String)key)) {
                key = (String)key + "2";
            }
            class_2487 ruleNBT = new class_2487();
            ruleNBT.method_10582("Value", rule.getAsString());
            ruleNBT.method_10582("Manager", identifier);
            ruleNBT.method_10582("Rule", rule.name);
            rules.method_10566((String)key, (class_2520)ruleNBT);
            return this;
        }

        public DataBuilder withCustomNbt(String key, class_2520 value) {
            this.tag.method_10566(key, value);
            return this;
        }

        private class_2540 build() {
            class_2540 packetBuf = new class_2540(Unpooled.buffer());
            packetBuf.method_10804(1);
            packetBuf.method_10794(this.tag);
            return packetBuf;
        }
    }
}

