/*
 * Decompiled with CFR 0.152.
 */
package carpet.script;

import carpet.script.CarpetScriptServer;
import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.LazyValue;
import carpet.script.Tokenizer;
import carpet.script.bundled.Module;
import carpet.script.exception.ExpressionException;
import carpet.script.exception.IntegrityException;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.FunctionValue;
import carpet.script.value.Value;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScriptHost {
    public static Map<Value, Value> systemGlobals = new ConcurrentHashMap<Value, Value>();
    private static final Map<Long, Random> randomizers = new Long2ObjectOpenHashMap();
    public static Thread mainThread = null;
    private final Map<Value, ThreadPoolExecutor> executorServices = new HashMap<Value, ThreadPoolExecutor>();
    private final Map<Value, Object> locks = new ConcurrentHashMap<Value, Object>();
    protected boolean inTermination = false;
    public boolean strict;
    private final Set<String> deprecations = new HashSet<String>();
    protected final Map<String, ScriptHost> userHosts = new Object2ObjectOpenHashMap();
    private Map<Module, ModuleData> moduleData = new HashMap<Module, ModuleData>();
    private Map<String, Module> modules = new HashMap<String, Module>();
    protected ScriptHost parent;
    protected boolean perUser;
    public String user;
    public final Module main;
    public ErrorSnooper errorSnooper = null;
    public static final Logger DEPRECATION_LOG = LoggerFactory.getLogger((String)"Scarpet Deprecation Warnings");

    public Random getRandom(long aLong) {
        if (randomizers.size() > 65536) {
            randomizers.clear();
        }
        return randomizers.computeIfAbsent(aLong, Random::new);
    }

    public boolean resetRandom(long aLong) {
        return randomizers.remove(aLong) != null;
    }

    public String getName() {
        return this.main == null ? null : this.main.getName();
    }

    protected ScriptHost(Module code, boolean perUser, ScriptHost parent) {
        this.parent = parent;
        this.main = code;
        this.perUser = perUser;
        this.user = null;
        this.strict = false;
        ModuleData moduleData = new ModuleData(code);
        this.initializeModuleGlobals(moduleData);
        this.moduleData.put(code, moduleData);
        this.modules.put(code == null ? null : code.getName(), code);
        mainThread = Thread.currentThread();
    }

    void initializeModuleGlobals(ModuleData md) {
    }

    public void importModule(Context c, String moduleName) {
        if (this.modules.containsKey(moduleName.toLowerCase(Locale.ROOT))) {
            return;
        }
        Module module = this.getModuleOrLibraryByName(moduleName);
        if (this.modules.containsKey(module.getName())) {
            return;
        }
        this.modules.put(module.getName(), module);
        ModuleData data = new ModuleData(module);
        this.initializeModuleGlobals(data);
        this.moduleData.put(module, data);
        this.runModuleCode(c, module);
    }

    public void importNames(Context c, Module targetModule, String sourceModuleName, List<String> identifiers) {
        if (!this.moduleData.containsKey(targetModule)) {
            throw new InternalExpressionException("Cannot import to module that doesn't exist");
        }
        Module source = this.modules.get(sourceModuleName);
        ModuleData sourceData = this.moduleData.get(source);
        ModuleData targetData = this.moduleData.get(targetModule);
        if (sourceData == null || targetData == null) {
            throw new InternalExpressionException("Cannot import from module that is not imported");
        }
        for (String identifier : identifiers) {
            if (sourceData.globalFunctions.containsKey(identifier)) {
                targetData.functionImports.put(identifier, sourceData);
                continue;
            }
            if (sourceData.globalVariables.containsKey(identifier)) {
                targetData.globalsImports.put(identifier, sourceData);
                continue;
            }
            targetData.futureImports.put(identifier, sourceData);
        }
    }

    public Stream<String> availableImports(String moduleName) {
        Module source = this.modules.get(moduleName);
        ModuleData sourceData = this.moduleData.get(source);
        if (sourceData == null) {
            throw new InternalExpressionException("Cannot import from module that is not imported");
        }
        return Stream.concat(this.globalVariableNames(source, s -> s.startsWith("global_")), this.globalFunctionNames(source, s -> true)).distinct().sorted();
    }

    protected abstract Module getModuleOrLibraryByName(String var1);

    protected abstract void runModuleCode(Context var1, Module var2);

    public FunctionValue getFunction(String name) {
        return this.getFunction(this.main, name);
    }

    public FunctionValue getAssertFunction(Module module, String name) {
        FunctionValue ret = this.getFunction(module, name);
        if (ret == null) {
            if (module == this.main) {
                throw new InternalExpressionException("Function '" + name + "' is not defined yet");
            }
            throw new InternalExpressionException("Function '" + name + "' is not defined nor visible by its name in the imported module '" + module.getName() + "'");
        }
        return ret;
    }

    private FunctionValue getFunction(Module module, String name) {
        ModuleData local = this.getModuleData(module);
        FunctionValue ret = local.globalFunctions.get(name);
        if (ret != null) {
            return ret;
        }
        ModuleData target = local.functionImports.get(name);
        if (target != null && (ret = target.globalFunctions.get(name)) != null) {
            return ret;
        }
        target = local.futureImports.get(name);
        if (target == null) {
            return null;
        }
        if ((target = this.findModuleDataFromFunctionImports(name, target, 0)) == null) {
            return null;
        }
        local.futureImports.remove(name);
        local.functionImports.put(name, target);
        return target.globalFunctions.get(name);
    }

    private ModuleData findModuleDataFromFunctionImports(String name, ModuleData source, int ttl) {
        if (ttl > 64) {
            throw new InternalExpressionException("Cannot import " + name + ", either your imports are too deep or too loopy");
        }
        if (source.globalFunctions.containsKey(name)) {
            return source;
        }
        if (source.functionImports.containsKey(name)) {
            return this.findModuleDataFromFunctionImports(name, source.functionImports.get(name), ttl + 1);
        }
        if (source.futureImports.containsKey(name)) {
            return this.findModuleDataFromFunctionImports(name, source.futureImports.get(name), ttl + 1);
        }
        return null;
    }

    public LazyValue getGlobalVariable(String name) {
        return this.getGlobalVariable(this.main, name);
    }

    public LazyValue getGlobalVariable(Module module, String name) {
        ModuleData local = this.getModuleData(module);
        LazyValue ret = local.globalVariables.get(name);
        if (ret != null) {
            return ret;
        }
        ModuleData target = local.globalsImports.get(name);
        if (target != null && (ret = target.globalVariables.get(name)) != null) {
            return ret;
        }
        target = local.futureImports.get(name);
        if (target == null) {
            return null;
        }
        if ((target = this.findModuleDataFromGlobalImports(name, target, 0)) == null) {
            return null;
        }
        local.futureImports.remove(name);
        local.globalsImports.put(name, target);
        return target.globalVariables.get(name);
    }

    private ModuleData findModuleDataFromGlobalImports(String name, ModuleData source, int ttl) {
        if (ttl > 64) {
            throw new InternalExpressionException("Cannot import " + name + ", either your imports are too deep or too loopy");
        }
        if (source.globalVariables.containsKey(name)) {
            return source;
        }
        if (source.globalsImports.containsKey(name)) {
            return this.findModuleDataFromGlobalImports(name, source.globalsImports.get(name), ttl + 1);
        }
        if (source.futureImports.containsKey(name)) {
            return this.findModuleDataFromGlobalImports(name, source.futureImports.get(name), ttl + 1);
        }
        return null;
    }

    public void delFunctionWithPrefix(Module module, String prefix) {
        ModuleData data = this.getModuleData(module);
        data.globalFunctions.entrySet().removeIf(e -> ((String)e.getKey()).startsWith(prefix));
        data.functionImports.entrySet().removeIf(e -> ((String)e.getKey()).startsWith(prefix));
    }

    public void delFunction(Module module, String funName) {
        ModuleData data = this.getModuleData(module);
        data.globalFunctions.remove(funName);
        data.functionImports.remove(funName);
    }

    public void delGlobalVariableWithPrefix(Module module, String prefix) {
        ModuleData data = this.getModuleData(module);
        data.globalVariables.entrySet().removeIf(e -> ((String)e.getKey()).startsWith(prefix));
        data.globalsImports.entrySet().removeIf(e -> ((String)e.getKey()).startsWith(prefix));
    }

    public void delGlobalVariable(Module module, String varName) {
        ModuleData data = this.getModuleData(module);
        data.globalFunctions.remove(varName);
        data.functionImports.remove(varName);
    }

    private ModuleData getModuleData(Module module) {
        ModuleData data = this.moduleData.get(module);
        if (data == null) {
            throw new IntegrityException("Module structure changed for the app. Did you reload the app with tasks running?");
        }
        return data;
    }

    protected void assertAppIntegrity(Module module) {
        this.getModuleData(module);
    }

    public void addUserDefinedFunction(Context ctx, Module module, String name, FunctionValue fun) {
        this.getModuleData((Module)module).globalFunctions.put(name, fun);
    }

    public void setGlobalVariable(Module module, String name, LazyValue lv) {
        this.getModuleData((Module)module).globalVariables.put(name, lv);
    }

    public Stream<String> globalVariableNames(Module module, Predicate<String> predicate) {
        return Stream.concat(Stream.concat(this.getModuleData((Module)module).globalVariables.keySet().stream(), this.getModuleData((Module)module).globalsImports.keySet().stream()), this.getModuleData((Module)module).futureImports.keySet().stream().filter(s -> s.startsWith("global_"))).filter(predicate);
    }

    public Stream<String> globalFunctionNames(Module module, Predicate<String> predicate) {
        return Stream.concat(Stream.concat(this.getModuleData((Module)module).globalFunctions.keySet().stream(), this.getModuleData((Module)module).functionImports.keySet().stream()), this.getModuleData((Module)module).futureImports.keySet().stream().filter(s -> !s.startsWith("global_"))).filter(predicate);
    }

    public ScriptHost retrieveForExecution(String user) {
        if (!this.perUser) {
            return this;
        }
        ScriptHost oldUserHost = this.userHosts.get(user);
        if (oldUserHost != null) {
            return oldUserHost;
        }
        ScriptHost userHost = this.duplicate();
        userHost.user = user;
        this.setupUserHost(userHost);
        this.userHosts.put(user, userHost);
        return userHost;
    }

    protected void setupUserHost(ScriptHost host) {
        host.modules.putAll(this.modules);
        this.moduleData.forEach((key, value) -> host.moduleData.put((Module)key, new ModuleData((Module)key, (ModuleData)value)));
        host.moduleData.forEach((module, data) -> data.setImportsBasedOn(host, this.moduleData.get(data.parent)));
    }

    public synchronized void handleExpressionException(String msg, ExpressionException exc) {
        System.out.println(msg + ": " + exc);
    }

    protected abstract ScriptHost duplicate();

    public Object getLock(Value name) {
        return this.locks.computeIfAbsent(name, n -> new Object());
    }

    public ThreadPoolExecutor getExecutor(Value pool) {
        if (this.inTermination) {
            return null;
        }
        return this.executorServices.computeIfAbsent(pool, v -> (ThreadPoolExecutor)Executors.newCachedThreadPool());
    }

    public int taskCount() {
        return this.executorServices.values().stream().map(ThreadPoolExecutor::getActiveCount).reduce(0, Integer::sum);
    }

    public int taskCount(Value pool) {
        if (this.executorServices.containsKey(pool)) {
            return this.executorServices.get(pool).getActiveCount();
        }
        return 0;
    }

    public void onClose() {
        this.inTermination = true;
        this.executorServices.values().forEach(ThreadPoolExecutor::shutdown);
        for (ScriptHost uh : this.userHosts.values()) {
            uh.onClose();
        }
        if (this.taskCount() > 0) {
            this.executorServices.values().forEach(e -> {
                ExecutorService stopper = Executors.newSingleThreadExecutor();
                stopper.submit(() -> {
                    try {
                        if (!e.awaitTermination(1500L, TimeUnit.MILLISECONDS)) {
                            e.shutdownNow();
                            if (!e.awaitTermination(1500L, TimeUnit.MILLISECONDS)) {
                                CarpetScriptServer.LOG.error("Failed to stop app's thread");
                            }
                        }
                    }
                    catch (InterruptedException ie) {
                        e.shutdownNow();
                        Thread.currentThread().interrupt();
                    }
                    stopper.shutdown();
                    stopper.shutdownNow();
                });
            });
        }
    }

    public void setPerPlayer(boolean isPerUser) {
        this.perUser = isPerUser;
    }

    public boolean isPerUser() {
        return this.perUser;
    }

    public Set<String> getUserList() {
        return this.userHosts.keySet();
    }

    public void resetErrorSnooper() {
        this.errorSnooper = null;
    }

    public boolean issueDeprecation(String feature) {
        if (this.deprecations.contains(feature)) {
            return false;
        }
        this.deprecations.add(feature);
        DEPRECATION_LOG.warn("'" + feature + "' is deprecated and soon will be removed. Please consult the docs for their replacement");
        return true;
    }

    @FunctionalInterface
    public static interface ErrorSnooper {
        public List<String> apply(Expression var1, Tokenizer.Token var2, Context var3, String var4);
    }

    public static class ModuleData {
        Module parent;
        public Map<String, FunctionValue> globalFunctions = new Object2ObjectOpenHashMap();
        public Map<String, LazyValue> globalVariables = new Object2ObjectOpenHashMap();
        public Map<String, ModuleData> functionImports = new Object2ObjectOpenHashMap();
        public Map<String, ModuleData> globalsImports = new Object2ObjectOpenHashMap();
        public Map<String, ModuleData> futureImports = new Object2ObjectOpenHashMap();

        public ModuleData(Module parent, ModuleData other) {
            this.parent = parent;
            this.globalFunctions.putAll(other.globalFunctions);
            other.globalVariables.forEach((key, value) -> {
                Value var = value.evalValue(null);
                Value copy = var.deepcopy();
                copy.boundVariable = var.boundVariable;
                this.globalVariables.put((String)key, (c, t) -> copy);
            });
        }

        public void setImportsBasedOn(ScriptHost host, ModuleData other) {
            other.functionImports.forEach((name, targetData) -> this.functionImports.put((String)name, host.moduleData.get(targetData.parent)));
            other.globalsImports.forEach((name, targetData) -> this.globalsImports.put((String)name, host.moduleData.get(targetData.parent)));
            other.futureImports.forEach((name, targetData) -> this.futureImports.put((String)name, host.moduleData.get(targetData.parent)));
        }

        public ModuleData(Module parent) {
            this.parent = parent;
        }
    }
}

