/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.annotation;

import carpet.CarpetServer;
import carpet.script.annotation.ValueConverter;
import carpet.script.value.EntityValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.NumericValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public final class SimpleTypeConverter<T extends Value, R>
implements ValueConverter<R> {
    private static final Map<Class<?>, SimpleTypeConverter<? extends Value, ?>> byResult = new HashMap();
    private final Function<T, R> converter;
    private final Class<T> valueClass;
    private final String typeName;

    public SimpleTypeConverter(Class<T> inputType, Function<T, R> converter, String typeName) {
        this.converter = converter;
        this.valueClass = inputType;
        this.typeName = typeName;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    static <R> SimpleTypeConverter<Value, R> get(Class<R> outputType) {
        return byResult.get(outputType);
    }

    @Override
    public R convert(Value value) {
        return this.valueClass.isInstance(value) ? (R)this.converter.apply(value) : null;
    }

    public static <T extends Value, R> void registerType(Class<T> requiredInputType, Class<R> outputType, Function<T, R> converter, String typeName) {
        SimpleTypeConverter<T, R> type = new SimpleTypeConverter<T, R>(requiredInputType, converter, typeName);
        byResult.put(outputType, type);
    }

    static {
        SimpleTypeConverter.registerType(Value.class, class_3222.class, val -> EntityValue.getPlayerByValue(CarpetServer.minecraft_server, val), "online player");
        SimpleTypeConverter.registerType(EntityValue.class, class_1297.class, EntityValue::getEntity, "entity");
        SimpleTypeConverter.registerType(Value.class, class_1937.class, val -> ValueConversions.dimFromValue(val, CarpetServer.minecraft_server), "dimension");
        SimpleTypeConverter.registerType(Value.class, class_2561.class, FormattedTextValue::getTextByValue, "text");
        SimpleTypeConverter.registerType(Value.class, String.class, Value::getString, "string");
        SimpleTypeConverter.registerType(NumericValue.class, Long.class, NumericValue::getLong, "number");
        SimpleTypeConverter.registerType(NumericValue.class, Double.class, NumericValue::getDouble, "number");
        SimpleTypeConverter.registerType(NumericValue.class, Integer.class, NumericValue::getInt, "number");
        SimpleTypeConverter.registerType(Value.class, Boolean.class, Value::getBoolean, "boolean");
    }
}

