/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.language;

import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.LazyValue;
import carpet.script.Tokenizer;
import carpet.script.argument.FunctionArgument;
import carpet.script.exception.ExitStatement;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.BooleanValue;
import carpet.script.value.NumericValue;
import carpet.script.value.ThreadValue;
import carpet.script.value.Value;

public class Threading {
    public static void apply(Expression expression) {
        expression.addFunctionWithDelegation("task", -1, false, false, (c, t, expr, tok, lv) -> {
            if (lv.size() == 0) {
                throw new InternalExpressionException("'task' requires at least function to call as a parameter");
            }
            FunctionArgument functionArgument = FunctionArgument.findIn(c, expression.module, lv, 0, false, true);
            ThreadValue thread = new ThreadValue(Value.NULL, functionArgument.function, (Expression)expr, (Tokenizer.Token)tok, (Context)c, functionArgument.checkedArgs());
            Thread.yield();
            return thread;
        });
        expression.addFunctionWithDelegation("task_thread", -1, false, false, (c, t, expr, tok, lv) -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'task' requires at least function to call as a parameter");
            }
            Value queue = (Value)lv.get(0);
            FunctionArgument functionArgument = FunctionArgument.findIn(c, expression.module, lv, 1, false, true);
            ThreadValue thread = new ThreadValue(queue, functionArgument.function, (Expression)expr, (Tokenizer.Token)tok, (Context)c, functionArgument.checkedArgs());
            Thread.yield();
            return thread;
        });
        expression.addContextFunction("task_count", -1, (c, t, lv) -> lv.size() > 0 ? new NumericValue(c.host.taskCount((Value)lv.get(0))) : new NumericValue(c.host.taskCount()));
        expression.addUnaryFunction("task_value", v -> {
            if (!(v instanceof ThreadValue)) {
                throw new InternalExpressionException("'task_value' could only be used with a task value");
            }
            return ((ThreadValue)v).getValue();
        });
        expression.addUnaryFunction("task_join", v -> {
            if (!(v instanceof ThreadValue)) {
                throw new InternalExpressionException("'task_join' could only be used with a task value");
            }
            return ((ThreadValue)v).join();
        });
        expression.addLazyFunction("task_dock", 1, (c, t, lv) -> (LazyValue)lv.get(0));
        expression.addUnaryFunction("task_completed", v -> {
            if (!(v instanceof ThreadValue)) {
                throw new InternalExpressionException("'task_completed' could only be used with a task value");
            }
            return BooleanValue.of(((ThreadValue)v).isFinished());
        });
        expression.addLazyFunction("synchronize", (c, t, lv) -> {
            if (lv.size() == 0) {
                throw new InternalExpressionException("'synchronize' require at least an expression to synchronize");
            }
            Value lockValue = Value.NULL;
            int ind = 0;
            if (lv.size() == 2) {
                lockValue = ((LazyValue)lv.get(0)).evalValue((Context)c);
                ind = 1;
            }
            Object object = c.host.getLock(lockValue);
            synchronized (object) {
                Value ret = ((LazyValue)lv.get(ind)).evalValue((Context)c, (Context.Type)((Object)t));
                return (_c, _t) -> ret;
            }
        });
        expression.addLazyFunction("sleep", (c, t, lv) -> {
            long time = lv.isEmpty() ? 0L : NumericValue.asNumber(((LazyValue)lv.get(0)).evalValue((Context)c)).getLong();
            boolean interrupted = false;
            try {
                if (Thread.interrupted()) {
                    interrupted = true;
                }
                if (time > 0L) {
                    Thread.sleep(time);
                }
                Thread.yield();
            }
            catch (InterruptedException ignored) {
                interrupted = true;
            }
            if (interrupted) {
                Value exceptionally = Value.NULL;
                if (lv.size() > 1) {
                    exceptionally = ((LazyValue)lv.get(1)).evalValue((Context)c);
                }
                throw new ExitStatement(exceptionally);
            }
            return (cc, tt) -> new NumericValue(time);
        });
    }
}

