/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import carpet.utils.Messenger;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;

public class CarpetProfiler {
    private static final Map<String, Long> SECTION_STATS = new HashMap<String, Long>();
    private static final Object2LongMap<Pair<class_1937, Object>> ENTITY_TIMES = new Object2LongOpenHashMap();
    private static final Object2LongMap<Pair<class_1937, Object>> ENTITY_COUNT = new Object2LongOpenHashMap();
    private static class_2168 currentRequester = null;
    public static int tick_health_requested = 0;
    private static int tick_health_elapsed = 0;
    private static TYPE test_type = TYPE.NONE;
    private static long current_tick_start = 0L;
    private static final String[] GENERAL_SECTIONS = new String[]{"Network", "Autosave", "Async Tasks", "Datapacks", "Carpet"};
    private static final String[] SCARPET_SECTIONS = new String[]{"Scarpet run", "Scarpet events", "Scarpet schedule", "Scarpet command", "Scarpet load", "Scarpet app data", "Scarpet client"};
    private static final String[] SECTIONS = new String[]{"Spawning and Random Ticks", "Ticket Manager", "Unloading", "Blocks", "Entities", "Block Entities", "Entities (Client)", "Block Entities (Client)", "Village", "Environment"};

    public static void prepare_tick_report(class_2168 source, int ticks) {
        SECTION_STATS.clear();
        ENTITY_COUNT.clear();
        ENTITY_TIMES.clear();
        test_type = TYPE.GENERAL;
        SECTION_STATS.put("tick", 0L);
        for (String section : GENERAL_SECTIONS) {
            SECTION_STATS.put(section, 0L);
        }
        for (String section : SCARPET_SECTIONS) {
            SECTION_STATS.put(section, 0L);
        }
        for (class_5321 level : source.method_9211().method_29435()) {
            for (String section : SECTIONS) {
                SECTION_STATS.put(level.method_29177() + "." + section, 0L);
            }
        }
        tick_health_elapsed = ticks;
        tick_health_requested = ticks;
        current_tick_start = 0L;
        currentRequester = source;
    }

    public static void prepare_entity_report(class_2168 source, int ticks) {
        SECTION_STATS.clear();
        SECTION_STATS.put("tick", 0L);
        ENTITY_COUNT.clear();
        ENTITY_TIMES.clear();
        test_type = TYPE.ENTITY;
        tick_health_elapsed = ticks;
        tick_health_requested = ticks;
        current_tick_start = 0L;
        currentRequester = source;
    }

    public static ProfilerToken start_section(class_1937 world, String name, TYPE type) {
        if ((long)tick_health_requested == 0L || test_type != TYPE.GENERAL || current_tick_start == 0L) {
            return null;
        }
        return new ProfilerToken(type, name, world);
    }

    public static ProfilerToken start_entity_section(class_1937 world, class_1297 e, TYPE type) {
        if ((long)tick_health_requested == 0L || test_type != TYPE.ENTITY || current_tick_start == 0L) {
            return null;
        }
        return new ProfilerToken(type, e.method_5864(), world);
    }

    public static ProfilerToken start_block_entity_section(class_1937 world, class_2586 be, TYPE type) {
        if ((long)tick_health_requested == 0L || test_type != TYPE.ENTITY || current_tick_start == 0L) {
            return null;
        }
        return new ProfilerToken(type, be.method_11017(), world);
    }

    public static void end_current_section(ProfilerToken tok) {
        if ((long)tick_health_requested == 0L || test_type != TYPE.GENERAL || current_tick_start == 0L || tok == null) {
            return;
        }
        long end_time = System.nanoTime();
        if (tok.type == TYPE.GENERAL) {
            class_1937 world = tok.world;
            String current_section = world == null ? (String)tok.section : String.format("%s.%s%s", world.method_27983().method_29177(), tok.section, world.field_9236 ? " (Client)" : "");
            SECTION_STATS.put(current_section, SECTION_STATS.getOrDefault(current_section, 0L) + end_time - tok.start);
        }
    }

    public static void end_current_entity_section(ProfilerToken tok) {
        if ((long)tick_health_requested == 0L || test_type != TYPE.ENTITY || current_tick_start == 0L || tok == null) {
            return;
        }
        long end_time = System.nanoTime();
        Pair section = Pair.of((Object)tok.world, (Object)tok.section);
        ENTITY_TIMES.put((Object)section, ENTITY_TIMES.getOrDefault((Object)section, 0L) + end_time - tok.start);
        ENTITY_COUNT.put((Object)section, ENTITY_COUNT.getOrDefault((Object)section, 0L) + 1L);
    }

    public static void start_tick_profiling() {
        current_tick_start = System.nanoTime();
    }

    public static void end_tick_profiling(MinecraftServer server) {
        if (current_tick_start == 0L) {
            return;
        }
        SECTION_STATS.put("tick", SECTION_STATS.get("tick") + System.nanoTime() - current_tick_start);
        if (--tick_health_elapsed <= 0) {
            CarpetProfiler.finalize_tick_report(server);
        }
    }

    public static void finalize_tick_report(MinecraftServer server) {
        if (test_type == TYPE.GENERAL) {
            CarpetProfiler.finalize_tick_report_for_time(server);
        }
        if (test_type == TYPE.ENTITY) {
            CarpetProfiler.finalize_tick_report_for_entities(server);
        }
        CarpetProfiler.cleanup_tick_report();
    }

    public static void cleanup_tick_report() {
        SECTION_STATS.clear();
        SECTION_STATS.put("tick", 0L);
        ENTITY_TIMES.clear();
        ENTITY_COUNT.clear();
        test_type = TYPE.NONE;
        tick_health_elapsed = 0;
        tick_health_requested = 0;
        current_tick_start = 0L;
        currentRequester = null;
    }

    public static void finalize_tick_report_for_time(MinecraftServer server) {
        double amount;
        if (currentRequester == null) {
            return;
        }
        long total_tick_time = SECTION_STATS.get("tick");
        double divider = 1.0 / (double)tick_health_requested / 1000000.0;
        Messenger.m(currentRequester, "w ");
        Messenger.m(currentRequester, "wb Average tick time: ", String.format("yb %.3fms", divider * (double)total_tick_time));
        long accumulated = 0L;
        for (String section : GENERAL_SECTIONS) {
            amount = divider * (double)SECTION_STATS.get(section).longValue();
            if (!(amount > 0.01)) continue;
            accumulated += SECTION_STATS.get(section).longValue();
            Messenger.m(currentRequester, "w " + section + ": ", String.format("y %.3fms", amount));
        }
        for (String section : SCARPET_SECTIONS) {
            amount = divider * (double)SECTION_STATS.get(section).longValue();
            if (!(amount > 0.01)) continue;
            Messenger.m(currentRequester, "gi " + section + ": ", String.format("di %.3fms", amount));
        }
        for (class_5321 dim : server.method_29435()) {
            double amount2;
            class_2960 dimensionId = dim.method_29177();
            boolean hasSomethin = false;
            for (String section : SECTIONS) {
                amount2 = divider * (double)SECTION_STATS.getOrDefault(dimensionId + "." + section, 0L).longValue();
                if (!(amount2 > 0.01)) continue;
                hasSomethin = true;
                break;
            }
            if (!hasSomethin) continue;
            Messenger.m(currentRequester, "wb " + (dimensionId.method_12836().equals("minecraft") ? dimensionId.method_12832() : dimensionId.toString()) + ":");
            for (String section : SECTIONS) {
                amount2 = divider * (double)SECTION_STATS.getOrDefault(dimensionId + "." + section, 0L).longValue();
                if (!(amount2 > 0.01)) continue;
                boolean cli = section.endsWith("(Client)");
                if (!cli) {
                    accumulated += SECTION_STATS.get(dimensionId + "." + section).longValue();
                }
                Messenger.m(currentRequester, String.format("%s - %s: ", cli ? "gi" : "w", section), String.format("%s %.3fms", cli ? "di" : "y", amount2));
            }
        }
        long rest = total_tick_time - accumulated;
        Messenger.m(currentRequester, String.format("gi The Rest, whatever that might be: %.3fms", divider * (double)rest));
    }

    private static String sectionName(Pair<class_1937, Object> section) {
        class_2960 dimkey;
        Object name;
        class_2960 id = section.getValue() instanceof class_1299 ? class_2378.field_11145.method_10221((Object)((class_1299)section.getValue())) : class_2378.field_11137.method_10221((Object)((class_2591)section.getValue()));
        Object object = name = "minecraft".equals(id.method_12836()) ? id.method_12832() : id.toString();
        if (((class_1937)section.getKey()).field_9236) {
            name = (String)name + " (client)";
        }
        String dim = "minecraft".equals((dimkey = ((class_1937)section.getKey()).method_27983().method_29177()).method_12836()) ? dimkey.method_12832() : dimkey.toString();
        return (String)name + " in " + dim;
    }

    public static void finalize_tick_report_for_entities(MinecraftServer server) {
        boolean cli;
        Pair section;
        if (currentRequester == null) {
            return;
        }
        long total_tick_time = SECTION_STATS.get("tick");
        double divider = 1.0 / (double)tick_health_requested / 1000000.0;
        double divider_1 = 1.0 / (double)(tick_health_requested - 1) / 1000000.0;
        Messenger.m(currentRequester, "w ");
        Messenger.m(currentRequester, "wb Average tick time: ", String.format("yb %.3fms", divider * (double)total_tick_time));
        SECTION_STATS.remove("tick");
        Messenger.m(currentRequester, "wb Top 10 counts:");
        int total = 0;
        for (Object2LongMap.Entry sectionEntry : ENTITY_COUNT.object2LongEntrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).collect(Collectors.toList())) {
            if (++total > 10) break;
            section = (Pair)sectionEntry.getKey();
            cli = ((class_1937)section.getKey()).field_9236;
            Messenger.m(currentRequester, String.format("%s - %s: ", cli ? "gi" : "w", CarpetProfiler.sectionName((Pair<class_1937, Object>)section)), String.format("%s %.1f", cli ? "di" : "y", 1.0 * (double)sectionEntry.getLongValue() / (double)(tick_health_requested - (cli ? 1 : 0))));
        }
        Messenger.m(currentRequester, "wb Top 10 CPU hogs:");
        total = 0;
        for (Object2LongMap.Entry sectionEntry : ENTITY_TIMES.object2LongEntrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).collect(Collectors.toList())) {
            if (++total > 10) break;
            section = (Pair)sectionEntry.getKey();
            cli = ((class_1937)section.getKey()).field_9236;
            Messenger.m(currentRequester, String.format("%s - %s: ", cli ? "gi" : "w", CarpetProfiler.sectionName((Pair<class_1937, Object>)section)), String.format("%s %.2fms", cli ? "di" : "y", (cli ? divider : divider_1) * (double)sectionEntry.getLongValue()));
        }
    }

    public static enum TYPE {
        NONE,
        GENERAL,
        ENTITY,
        TILEENTITY;

    }

    public record ProfilerToken(TYPE type, Object section, long start, class_1937 world) {
        public ProfilerToken(TYPE type, Object section, class_1937 world) {
            this(type, section, System.nanoTime(), world);
        }
    }
}

